/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final Consumer<Packet<?>> j;
    private final BiConsumer<Packet<?>, List<UUID>> k;
    private final VecDeltaCodec l = new VecDeltaCodec();
    private byte m;
    private byte n;
    private byte o;
    private Vec3D p;
    private int q;
    private int r;
    private List<Entity> s = ImmutableList.of();
    private boolean t;
    private boolean u;
    @Nullable
    private List<DataWatcher.c<?>> v;
    private final Set<ServerPlayerConnection> trackedPlayers;
    private boolean forceStateResync;

    public EntityTrackerEntry(WorldServer level, Entity entity, int updateInterval, boolean trackDelta, Consumer<Packet<?>> broadcast, BiConsumer<Packet<?>, List<UUID>> broadcastWithIgnore, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.f = level;
        this.j = broadcast;
        this.g = entity;
        this.h = updateInterval;
        this.i = trackDelta;
        this.k = broadcastWithIgnore;
        this.l.e(entity.du());
        this.p = entity.dy();
        this.m = MathHelper.g(entity.dL());
        this.n = MathHelper.g(entity.dN());
        this.o = MathHelper.g(entity.cA());
        this.u = entity.aH();
        this.v = entity.ar().c();
    }

    public void onPlayerAdd() {
        this.forceStateResync = true;
    }

    public void a() {
        Entity player;
        List<Entity> passengers;
        if (this.g.moonrise$isHardColliding()) {
            this.r = 9999;
        }
        if (!(passengers = this.g.cY()).equals(this.s)) {
            List<UUID> list = this.a(passengers).map(Entity::cG).toList();
            this.k.accept(new PacketPlayOutMount(this.g), list);
            Entity entity = this.g;
            if (entity instanceof EntityPlayer) {
                player = (EntityPlayer)entity;
                ((EntityPlayer)player).f.b(new PacketPlayOutMount(this.g));
            }
            this.s = passengers;
        }
        if (!this.trackedPlayers.isEmpty() && (player = this.g) instanceof EntityItemFrame) {
            MapId mapId;
            WorldMap savedData;
            EntityItemFrame itemFrame = (EntityItemFrame)player;
            ItemStack item = itemFrame.v();
            if (this.f.paperConfig().maps.itemFrameCursorUpdateInterval > 0 && this.q % this.f.paperConfig().maps.itemFrameCursorUpdateInterval == 0 && item.h() instanceof ItemWorldMap && (savedData = ItemWorldMap.a(mapId = itemFrame.cachedMapId, (World)this.f)) != null) {
                for (ServerPlayerConnection serverPlayerConnection : this.trackedPlayers) {
                    EntityPlayer serverPlayer = serverPlayerConnection.o();
                    savedData.a(serverPlayer, item);
                    Packet<?> updatePacket = savedData.a(mapId, serverPlayer);
                    if (updatePacket == null) continue;
                    serverPlayer.f.b(updatePacket);
                }
            }
            this.g();
        }
        if (this.forceStateResync || this.q % this.h == 0 || this.g.ar || this.g.ar().a()) {
            boolean flag;
            byte b2 = MathHelper.g(this.g.dL());
            byte b1 = MathHelper.g(this.g.dN());
            boolean bl = flag = Math.abs(b2 - this.m) >= 1 || Math.abs(b1 - this.n) >= 1;
            if (this.g.bY()) {
                if (flag) {
                    this.j.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ao(), b2, b1, this.g.aH()));
                    this.m = b2;
                    this.n = b1;
                }
                this.l.e(this.g.du());
                this.g();
                this.t = true;
            } else {
                EntityMinecartAbstract abstractMinecart;
                MinecartBehavior minecartBehavior;
                Entity entity = this.g;
                if (entity instanceof EntityMinecartAbstract && (minecartBehavior = (abstractMinecart = (EntityMinecartAbstract)entity).f()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior newMinecartBehavior = (NewMinecartBehavior)minecartBehavior;
                    this.a(newMinecartBehavior, b2, b1, flag);
                } else {
                    Vec3D deltaMovement;
                    double d2;
                    boolean flag5;
                    ++this.r;
                    Vec3D vec3D = this.g.du();
                    Vec3D base = this.l.b;
                    double vec3_dx = vec3D.d - base.d;
                    double vec3_dy = vec3D.e - base.e;
                    double vec3_dz = vec3D.f - base.f;
                    boolean flag1 = vec3_dx * vec3_dx + vec3_dy * vec3_dy + vec3_dz * vec3_dz >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> packet = null;
                    boolean flag2 = flag1 || this.q % 60 == 0;
                    boolean flag3 = false;
                    boolean flag4 = false;
                    long l2 = this.l.a(vec3D);
                    long l1 = this.l.b(vec3D);
                    long l22 = this.l.c(vec3D);
                    boolean bl2 = flag5 = l2 < -32768L || l2 > 32767L || l1 < -32768L || l1 > 32767L || l22 < -32768L || l22 > 32767L;
                    if (this.forceStateResync || flag5 || this.r > 400 || this.t || this.u != this.g.aH()) {
                        this.u = this.g.aH();
                        this.r = 0;
                        packet = ClientboundEntityPositionSyncPacket.a(this.g);
                        flag3 = true;
                        flag4 = true;
                    } else if (!(flag2 && flag || this.g instanceof EntityArrow)) {
                        if (flag2) {
                            packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.ao(), (short)l2, (short)l1, (short)l22, this.g.aH());
                            flag3 = true;
                        } else if (flag) {
                            packet = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ao(), b2, b1, this.g.aH());
                            flag4 = true;
                        }
                    } else {
                        packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.ao(), (short)l2, (short)l1, (short)l22, b2, b1, this.g.aH());
                        flag3 = true;
                        flag4 = true;
                    }
                    if ((this.g.ar || this.i || this.g instanceof EntityLiving && ((EntityLiving)this.g).fJ()) && ((d2 = (deltaMovement = this.g.dy()).g(this.p)) > 1.0E-7 || d2 > 0.0 && deltaMovement.h() == 0.0)) {
                        this.p = deltaMovement;
                        Entity entity2 = this.g;
                        if (entity2 instanceof EntityFireball) {
                            EntityFireball abstractHurtingProjectile = (EntityFireball)entity2;
                            this.j.accept(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.g.ao(), this.p), new ClientboundProjectilePowerPacket(abstractHurtingProjectile.ao(), abstractHurtingProjectile.c))));
                        } else {
                            this.j.accept(new PacketPlayOutEntityVelocity(this.g.ao(), this.p));
                        }
                    }
                    if (packet != null) {
                        this.j.accept(packet);
                    }
                    this.g();
                    if (flag3) {
                        this.l.e(vec3D);
                    }
                    if (flag4) {
                        this.m = b2;
                        this.n = b1;
                    }
                    this.t = false;
                }
            }
            byte b22 = MathHelper.g(this.g.cA());
            if (Math.abs(b22 - this.o) >= 1) {
                this.j.accept(new PacketPlayOutEntityHeadRotation(this.g, b22));
                this.o = b22;
            }
            this.g.ar = false;
            this.forceStateResync = false;
        }
        ++this.q;
        if (this.g.T) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Vector velocity;
                Player player2 = (Player)this.g.getBukkitEntity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player2, (velocity = player2.getVelocity()).clone());
                if (!event.callEvent()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player2.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.g.T = false;
            this.a(new PacketPlayOutEntityVelocity(this.g));
        }
    }

    private Stream<Entity> a(List<Entity> entities) {
        return Streams.concat((Stream[])new Stream[]{this.s.stream().filter(entity -> !entities.contains(entity)), entities.stream().filter(entity -> !this.s.contains(entity))});
    }

    private void a(NewMinecartBehavior behavior, byte yRot, byte xRot, boolean dirty) {
        this.g();
        if (behavior.e.isEmpty()) {
            boolean flag1;
            Vec3D deltaMovement = this.g.dy();
            double d2 = deltaMovement.g(this.p);
            Vec3D vec3 = this.g.du();
            boolean flag = this.l.d(vec3).h() >= 7.62939453125E-6;
            boolean bl = flag1 = flag || this.q % 60 == 0;
            if (flag1 || dirty || d2 > 1.0E-7) {
                this.j.accept(new ClientboundMoveMinecartPacket(this.g.ao(), List.of(new NewMinecartBehavior.a(this.g.dt(), this.g.dy(), this.g.dL(), this.g.dN(), 1.0f))));
            }
        } else {
            this.j.accept(new ClientboundMoveMinecartPacket(this.g.ao(), List.copyOf(behavior.e)));
            behavior.e.clear();
        }
        this.m = yRot;
        this.n = xRot;
        this.l.e(this.g.dt());
    }

    public void a(EntityPlayer player) {
        this.g.e(player);
        player.f.b(new PacketPlayOutEntityDestroy(this.g.ao()));
    }

    public void b(EntityPlayer player) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        this.a(player, list::add);
        player.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.g.d(player);
    }

    public void a(EntityPlayer player, Consumer<Packet<PacketListenerPlayOut>> consumer) {
        Leashable leashable;
        Entity entity;
        if (this.g.dQ()) {
            return;
        }
        Packet<PacketListenerPlayOut> addEntityPacket = this.g.a(this);
        consumer.accept(addEntityPacket);
        if (this.v != null) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.g.ao(), this.v));
        }
        boolean flag = this.i;
        if (this.g instanceof EntityLiving) {
            Collection<AttributeModifiable> syncableAttributes = ((EntityLiving)this.g).fa().c();
            if (this.g.ao() == player.ao()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(syncableAttributes, false);
            }
            if (!syncableAttributes.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.g.ao(), syncableAttributes));
            }
            if (((EntityLiving)this.g).fJ()) {
                flag = true;
            }
        }
        if (flag && !(this.g instanceof EntityLiving)) {
            consumer.accept(new PacketPlayOutEntityVelocity(this.g.ao(), this.p));
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                ItemStack itemBySlot = livingEntity.a(equipmentSlot);
                if (itemBySlot.f()) continue;
                list.add(Pair.of((Object)equipmentSlot, (Object)itemBySlot.v()));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.g.ao(), list, true));
            }
            ((EntityLiving)this.g).G();
        }
        if (!this.g.cY().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.bY()) {
            consumer.accept(new PacketPlayOutMount(this.g.dk()));
        }
        if ((entity = this.g) instanceof Leashable && (leashable = (Leashable)((Object)entity)).Q_()) {
            consumer.accept(new PacketPlayOutAttachEntity(this.g, leashable.B()));
        }
    }

    public Vec3D b() {
        return this.l.a();
    }

    public Vec3D c() {
        return this.p;
    }

    public float d() {
        return MathHelper.a(this.n);
    }

    public float e() {
        return MathHelper.a(this.m);
    }

    public float f() {
        return MathHelper.a(this.o);
    }

    private void g() {
        DataWatcher entityData = this.g.ar();
        List<DataWatcher.c<?>> list = entityData.b();
        if (list != null) {
            this.v = entityData.c();
            this.a(new PacketPlayOutEntityMetadata(this.g.ao(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> attributesToSync = ((EntityLiving)this.g).fa().a();
            if (!attributesToSync.isEmpty()) {
                Entity entity = this.g;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.getBukkitEntity().injectScaledMaxHealth(attributesToSync, false);
                }
                this.a(new PacketPlayOutUpdateAttributes(this.g.ao(), attributesToSync));
            }
            attributesToSync.clear();
        }
    }

    private void a(Packet<?> packet) {
        this.j.accept(packet);
        if (this.g instanceof EntityPlayer) {
            ((EntityPlayer)this.g).f.b(packet);
        }
    }
}

