/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemChunkMap;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap,
ChunkSystemChunkMap {
    private static final ChunkResult<List<IChunkAccess>> f = ChunkResult.a("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> g = CompletableFuture.completedFuture(f);
    private static final byte h = -1;
    private static final byte i = 0;
    private static final byte j = 1;
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 200;
    private static final int m = 20;
    private static final int n = 10000;
    private static final int o = 128;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final WorldServer t;
    private final LightEngineThreaded u;
    private final IAsyncTaskHandler<Runnable> v;
    private final RandomState w;
    private final ChunkGeneratorStructureState x;
    private final Supplier<WorldPersistentData> y;
    private final TicketStorage z;
    private final VillagePlace A;
    public final LongSet B = new LongOpenHashSet();
    private boolean C;
    public final WorldLoadListener F;
    private final ChunkStatusUpdateListener G;
    public final a H;
    public final AtomicInteger I = new AtomicInteger();
    private final String J;
    private final PlayerMap K = new PlayerMap();
    public final Int2ObjectMap<EntityTracker> L = new Int2ObjectOpenHashMap();
    private final Long2ByteMap M = new Long2ByteOpenHashMap();
    public int R;
    public final WorldGenContext S;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public final void moonrise$writeFinishCallback(ChunkCoordIntPair pos) throws IOException {
        this.e(pos);
    }

    public PlayerChunkMap(WorldServer level, Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper, StructureTemplateManager structureManager, Executor dispatcher, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess lightChunk, ChunkGenerator generator, WorldLoadListener progressListener, ChunkStatusUpdateListener chunkStatusListener, Supplier<WorldPersistentData> overworldDataStorage, TicketStorage ticketStorage, int serverViewDistance, boolean sync) {
        super(new RegionStorageInfo(levelStorageAccess.f(), level.aj(), "chunk"), levelStorageAccess.a(level.aj()).resolve("region"), fixerUpper, sync);
        Path dimensionPath = levelStorageAccess.a(level.aj());
        this.J = dimensionPath.getFileName().toString();
        this.t = level;
        IRegistryCustom registryAccess = level.J_();
        long seed = level.E();
        ChunkGenerator randomGenerator = generator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)randomGenerator;
            this.w = RandomState.a(noiseBasedChunkGenerator.h().a(), registryAccess.f(Registries.aY), seed);
        } else {
            this.w = RandomState.a(GeneratorSettingBase.e(), registryAccess.f(Registries.aY), seed);
        }
        this.x = generator.createState(registryAccess.f(Registries.bd), this.w, seed, level.spigotConfig);
        this.v = mainThreadExecutor;
        ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(dispatcher, "worldgen");
        this.F = progressListener;
        this.G = chunkStatusListener;
        ConsecutiveExecutor consecutiveExecutor1 = new ConsecutiveExecutor(dispatcher, "light");
        this.u = new LightEngineThreaded(lightChunk, this, this.t.F_().g(), consecutiveExecutor1, null);
        this.H = new a(ticketStorage, dispatcher, mainThreadExecutor);
        this.y = overworldDataStorage;
        this.z = ticketStorage;
        this.A = new VillagePlace(new RegionStorageInfo(levelStorageAccess.f(), level.aj(), "poi"), dimensionPath.resolve("poi"), fixerUpper, sync, registryAccess, level.p(), level);
        this.a(serverViewDistance);
        this.S = new WorldGenContext(level, generator, structureManager, this.u, null, this::f);
    }

    private void f(ChunkCoordIntPair chunkPos) {
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.t.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.an().f().ordinal();
        ReferenceList<EntityPlayer> inRange = this.t.moonrise$getNearbyPlayers().getPlayers(entity.dx(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = index;
            backingSet[i2].mobCounts[n2] = backingSet[i2].mobCounts[n2] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, EnumCreatureType mobCategory) {
        if (!this.t.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<EntityPlayer> inRange = this.t.moonrise$getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        EntityPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = idx;
            backingSet[i2].mobBackoffCounts[n2] = backingSet[i2].mobBackoffCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer player, EnumCreatureType mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    protected ChunkGenerator a() {
        return this.S.b();
    }

    protected ChunkGeneratorStructureState b() {
        return this.x;
    }

    protected RandomState c() {
        return this.w;
    }

    boolean a(EntityPlayer player, int x2, int z2) {
        return this.t.moonrise$getPlayerChunkLoader().isChunkSent(player, x2, z2);
    }

    private boolean b(EntityPlayer player, int x2, int z2) {
        return this.t.moonrise$getPlayerChunkLoader().isChunkSent(player, x2, z2, true);
    }

    protected LightEngineThreaded d() {
        return this.u;
    }

    @Nullable
    protected PlayerChunk a(long chunkPos) {
        NewChunkHolder holder = this.t.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public PlayerChunk b(long chunkPos) {
        NewChunkHolder holder = this.t.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier c(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    public String a(ChunkCoordIntPair pos) {
        PlayerChunk visibleChunkIfPresent = this.b(pos.a());
        if (visibleChunkIfPresent == null) {
            return "null";
        }
        String string = visibleChunkIfPresent.j() + "\n";
        ChunkStatus latestStatus = visibleChunkIfPresent.u();
        IChunkAccess latestChunk = visibleChunkIfPresent.p();
        if (latestStatus != null) {
            string = string + "St: \u00a7" + latestStatus.b() + String.valueOf(latestStatus) + "\u00a7r\n";
        }
        if (latestChunk != null) {
            string = string + "Ch: \u00a7" + latestChunk.n().b() + String.valueOf(latestChunk.n()) + "\u00a7r\n";
        }
        FullChunkStatus fullStatus = visibleChunkIfPresent.s();
        string = string + "\u00a7" + fullStatus.ordinal() + String.valueOf((Object)fullStatus);
        return string + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<IChunkAccess>>> a(PlayerChunk chunkHolder, int range, IntFunction<ChunkStatus> statusGetter) {
        throw new UnsupportedOperationException();
    }

    public ReportedException a(IllegalStateException exception, String details) {
        StringBuilder stringBuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = chunk -> chunk.t().forEach(pair -> {
            ChunkStatus chunkStatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completableFuture = (CompletableFuture)pair.getSecond();
            if (completableFuture != null && completableFuture.isDone() && completableFuture.join() == null) {
                stringBuilder.append(chunk.r()).append(" - status: ").append(chunkStatus).append(" future: ").append(completableFuture).append(System.lineSeparator());
            }
        });
        stringBuilder.append("Updating:").append(System.lineSeparator());
        PlatformHooks.get().getUpdatingChunkHolders(this.t).forEach(consumer);
        stringBuilder.append("Visible:").append(System.lineSeparator());
        PlatformHooks.get().getVisibleChunkHolders(this.t).forEach(consumer);
        CrashReport crashReport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk loading");
        crashReportCategory.a("Details", details);
        crashReportCategory.a("Futures", stringBuilder);
        return new ReportedException(crashReport);
    }

    public CompletableFuture<ChunkResult<Chunk>> a(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    PlayerChunk a(long chunkPos, int newLevel, @Nullable PlayerChunk holder, int oldLevel) {
        throw new UnsupportedOperationException();
    }

    private void a(ChunkCoordIntPair chunkPos, IntSupplier queueLevelGetter, int ticketLevel, IntConsumer queueLevelSetter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void a(boolean flush) {
        this.t.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void a(BooleanSupplier hasMoreTime) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("poi");
        this.A.a(hasMoreTime);
        profilerFiller.b("chunk_unload");
        if (!this.t.v()) {
            this.b(hasMoreTime);
        }
        profilerFiller.c();
    }

    public boolean e() {
        throw new UnsupportedOperationException();
    }

    private void b(BooleanSupplier hasMoreTime) {
        this.t.moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        this.t.moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    private void c(BooleanSupplier hasMoreTime) {
        throw new UnsupportedOperationException();
    }

    private void a(long chunkPos, PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    protected boolean f() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<IChunkAccess> g(ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    private IChunkAccess a(Throwable exception, ChunkCoordIntPair chunkPos) {
        boolean flag1;
        Throwable throwable;
        Throwable throwable2;
        if (exception instanceof CompletionException) {
            CompletionException completionException = (CompletionException)exception;
            v0 = completionException.getCause();
        } else {
            v0 = throwable2 = exception;
        }
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)throwable2;
            throwable = reportedException.getCause();
        } else {
            throwable = throwable2;
        }
        Throwable throwable1 = throwable;
        boolean flag = throwable1 instanceof Error;
        boolean bl = flag1 = throwable1 instanceof IOException || throwable1 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.t.p().a(throwable1, this.q(), chunkPos);
            return this.h(chunkPos);
        }
        CrashReport crashReport = CrashReport.a(exception, "Exception loading chunk");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk being loaded");
        crashReportCategory.a("pos", chunkPos);
        this.i(chunkPos);
        throw new ReportedException(crashReport);
    }

    private IChunkAccess h(ChunkCoordIntPair chunkPos) {
        this.i(chunkPos);
        return new ProtoChunk(chunkPos, ChunkConverter.a, this.t, this.t.J_().f(Registries.aG), null);
    }

    private void i(ChunkCoordIntPair chunkPos) {
        this.M.put(chunkPos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair chunkPos, ChunkType chunkType) {
        return this.M.put(chunkPos.a(), (byte)(chunkType == ChunkType.a ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder d(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void a(GenerationChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(GenerationChunkHolder chunk, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkGenerationTask a(ChunkStatus targetStatus, ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private void a(ChunkGenerationTask task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void g() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> b(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    private void a(PlayerChunk chunkHolder, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<Chunk>> c(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    public int h() {
        return this.I.get();
    }

    private boolean a(PlayerChunk chunk, long gametime) {
        throw new UnsupportedOperationException();
    }

    public boolean a(IChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean j(ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    public void a(int viewDistance) {
        int clamped = MathHelper.a(viewDistance, 2, MoonriseConstants.MAX_VIEW_DISTANCE);
        if (clamped == this.R) {
            return;
        }
        this.R = clamped;
        this.t.moonrise$getPlayerChunkLoader().setLoadDistance(this.R + 1);
    }

    int b(EntityPlayer player) {
        return PlatformHooks.get().getSendViewDistance(player);
    }

    private void a(EntityPlayer player, ChunkCoordIntPair chunkPos) {
        throw new UnsupportedOperationException();
    }

    private static void a(EntityPlayer player, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
    }

    @Override
    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair pos) {
        CompletableFuture<Optional<NBTTagCompound>> ret = new CompletableFuture<Optional<NBTTagCompound>>();
        MoonriseRegionFileIO.loadDataAsync(this.t, pos.h, pos.i, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (data, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(Optional.ofNullable(data));
            }
        }, false);
        return ret;
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, Supplier<NBTTagCompound> tag) {
        MoonriseRegionFileIO.scheduleSave(this.t, pos.h, pos.i, tag.get(), MoonriseRegionFileIO.RegionFileType.CHUNK_DATA);
        return null;
    }

    @Override
    public void o() {
        MoonriseRegionFileIO.flush(this.t);
    }

    @Nullable
    public Chunk e(long chunkPos) {
        PlayerChunk visibleChunkIfPresent = this.b(chunkPos);
        return visibleChunkIfPresent == null ? null : visibleChunkIfPresent.e();
    }

    public int i() {
        return PlatformHooks.get().getVisibleChunkHolderCount(this.t);
    }

    public ChunkMapDistance j() {
        return this.H;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable(PlatformHooks.get().getVisibleChunkHolders(this.t));
    }

    void a(Writer writer) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("z").a("level").a("in_memory").a("status").a("full_status").a("accessible_ready").a("ticking_ready").a("entity_ticking_ready").a("ticket").a("spawning").a("block_entity_count").a("ticking_ticket").a("ticking_level").a("block_ticks").a("fluid_ticks").a(writer);
        for (PlayerChunk entry : PlatformHooks.get().getVisibleChunkHolders(this.t)) {
            long longKey = entry.d.a();
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longKey);
            PlayerChunk chunkHolder = entry;
            Optional<IChunkAccess> optional = Optional.ofNullable(chunkHolder.p());
            Optional<Object> optional1 = optional.flatMap(chunk -> chunk instanceof Chunk ? Optional.of((Chunk)chunk) : Optional.empty());
            csvOutput.a(chunkPos.h, chunkPos.i, chunkHolder.j(), optional.isPresent(), optional.map(IChunkAccess::n).orElse(null), optional1.map(Chunk::F).orElse(null), PlayerChunkMap.a(chunkHolder.c()), PlayerChunkMap.a(chunkHolder.a()), PlayerChunkMap.a(chunkHolder.b()), this.z.b(longKey, false), this.b(chunkPos), optional1.map(chunk -> chunk.I().size()).orElse(0), this.z.b(longKey, true), this.H.a(longKey, true), optional1.map(chunk -> chunk.q().a()).orElse(0), optional1.map(chunk -> chunk.r().a()).orElse(0));
        }
    }

    private static String a(CompletableFuture<ChunkResult<Chunk>> future) {
        try {
            ChunkResult chunkResult = future.getNow(null);
            if (chunkResult != null) {
                return chunkResult.a() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException var2) {
            return "failed " + var2.getCause().getMessage();
        }
        catch (CancellationException var3) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> k(ChunkCoordIntPair pos) {
        return this.d(pos).thenApplyAsync(optional -> optional.map(tag -> this.upgradeChunkTag((NBTTagCompound)tag, pos)), SystemUtils.h().a("upgradeChunk"));
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound tag, ChunkCoordIntPair pos) {
        return this.upgradeChunkTag(this.t.getTypeKey(), this.y, tag, this.a().c(), pos, this.t);
    }

    private boolean isChunkNearPlayer(PlayerChunkMap chunkMap, ChunkCoordIntPair chunkPos, Chunk levelChunk) {
        ChunkData chunkData = levelChunk.moonrise$getChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        ReferenceList<EntityPlayer> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            double blockRange;
            PlayerNaturallySpawnCreaturesEvent event = raw[i2].playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled() || !chunkMap.playerIsCloseEnoughForSpawning(raw[i2], chunkPos, blockRange = (double)((event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4)))) continue;
            return true;
        }
        return false;
    }

    void a(List<Chunk> output) {
        ReferenceList<Chunk> tickingChunks = this.t.moonrise$getPlayerTickingChunks();
        Chunk[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        Objects.checkFromToIndex(0, size, raw.length);
        for (int i2 = 0; i2 < size; ++i2) {
            Chunk levelChunk = raw[i2];
            if (!this.isChunkNearPlayer(this, levelChunk.f(), levelChunk)) continue;
            output.add(levelChunk);
        }
    }

    void a(Consumer<Chunk> action) {
        this.H.a(chunkPos -> {
            Chunk tickingChunk;
            PlayerChunk chunkHolder = this.b(chunkPos);
            if (chunkHolder != null && (tickingChunk = chunkHolder.d()) != null) {
                action.accept(tickingChunk);
            }
        });
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        return this.anyPlayerCloseEnoughForSpawning(chunkPos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkPos, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, reducedRange);
    }

    private boolean l(ChunkCoordIntPair chunkPos) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, false);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkCoordIntPair chunkPos, boolean reducedRange) {
        ReferenceList<EntityPlayer> players = this.t.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer serverPlayer = raw[i2];
            double blockRange = 16384.0;
            if (reducedRange) {
                PlayerNaturallySpawnCreaturesEvent event = serverPlayer.playerNaturallySpawnedEvent;
                if (event == null || event.isCancelled()) continue;
                blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
            }
            if (!this.playerIsCloseEnoughForSpawning(serverPlayer, chunkPos, blockRange)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> c(ChunkCoordIntPair chunkPos) {
        ReferenceList<EntityPlayer> players = this.t.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return new ArrayList<EntityPlayer>();
        }
        ArrayList<EntityPlayer> ret = null;
        EntityPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i2 = 0; i2 < len; ++i2) {
            EntityPlayer player = raw[i2];
            if (!this.playerIsCloseEnoughForSpawning(player, chunkPos, 16384.0)) continue;
            if (ret == null) {
                ret = new ArrayList(len - i2);
                ret.add(player);
                continue;
            }
            ret.add(player);
        }
        return ret == null ? new ArrayList<EntityPlayer>() : ret;
    }

    public boolean playerIsCloseEnoughForSpawning(EntityPlayer player, ChunkCoordIntPair chunkPos, double range) {
        if (player.ak()) {
            return false;
        }
        double d2 = PlayerChunkMap.a(chunkPos, player.dt());
        return d2 < range;
    }

    private static double a(ChunkCoordIntPair chunkPos, Vec3D pos) {
        double d2 = SectionPosition.a(chunkPos.h, 8);
        double d1 = SectionPosition.a(chunkPos.i, 8);
        double d22 = d2 - pos.d;
        double d3 = d1 - pos.f;
        return d22 * d22 + d3 * d3;
    }

    private boolean c(EntityPlayer player) {
        return player.ak() && !this.t.O().c(GameRules.s);
    }

    void a(EntityPlayer player, boolean track) {
        boolean flag = this.c(player);
        boolean flag1 = this.K.d(player);
        if (track) {
            this.K.a(player, flag);
            this.d(player);
            if (!flag) {
                this.H.a(SectionPosition.a(player), player);
                this.H.moonrise$addPlayer(player, SectionPosition.a(player));
            }
            player.a(ChunkTrackingView.a);
            PlatformHooks.get().addPlayerToDistanceMaps(this.t, player);
        } else {
            SectionPosition lastSectionPos = player.T();
            this.K.a(player);
            if (!flag1) {
                this.H.b(lastSectionPos, player);
                this.H.moonrise$removePlayer(player, SectionPosition.a(player));
            }
            PlatformHooks.get().removePlayerFromDistanceMaps(this.t, player);
        }
    }

    private void d(EntityPlayer player) {
        SectionPosition sectionPos = SectionPosition.a(player);
        player.a(sectionPos);
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        SectionPosition lastSectionPos = player.T();
        SectionPosition sectionPos = SectionPosition.a(player);
        boolean flag = this.K.e(player);
        boolean flag1 = this.c(player);
        boolean bl = flag2 = lastSectionPos.s() != sectionPos.s();
        if (flag2 || flag != flag1) {
            this.d(player);
            this.H.moonrise$updatePlayer(player, lastSectionPos, sectionPos, flag, flag1);
            if (!flag) {
                this.H.b(lastSectionPos, player);
            }
            if (!flag1) {
                this.H.a(sectionPos, player);
            }
            if (!flag && flag1) {
                this.K.b(player);
            }
            if (flag && !flag1) {
                this.K.c(player);
            }
        }
        PlatformHooks.get().updateMaps(this.t, player);
    }

    private void e(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void a(EntityPlayer player, ChunkTrackingView chunkTrackingView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair pos, boolean boundaryOnly) {
        PlayerChunk holder = this.b(pos.a());
        if (holder == null) {
            return new ArrayList<EntityPlayer>();
        }
        return holder.moonrise$getPlayers(boundaryOnly);
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.dV() != this.t || this.L.containsKey(entity.ao())) {
            k.error("Illegal ChunkMap::addEntity for world " + this.t.getWorld().getName() + ": " + String.valueOf(entity) + (this.L.containsKey(entity.ao()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> type = entity.an();
            int i2 = type.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int updateInterval = type.p();
                if (this.L.containsKey(entity.ao())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker trackedEntity = new EntityTracker(entity, i2, updateInterval, type.q());
                this.L.put(entity.ao(), (Object)trackedEntity);
                if (entity.moonrise$getTrackedEntity() != null) {
                    throw new IllegalStateException("Entity is already tracked");
                }
                entity.moonrise$setTrackedEntity(trackedEntity);
                trackedEntity.a(this.t.z());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    this.a(serverPlayer, true);
                    for (EntityTracker trackedEntity1 : this.L.values()) {
                        if (trackedEntity1.c == serverPlayer) continue;
                        trackedEntity1.b(serverPlayer);
                    }
                }
            }
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity) {
        EntityTracker trackedEntity1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            this.a(serverPlayer, false);
            for (EntityTracker trackedEntity : this.L.values()) {
                trackedEntity.a(serverPlayer);
            }
        }
        if ((trackedEntity1 = (EntityTracker)this.L.remove(entity.ao())) != null) {
            trackedEntity1.a();
        }
        entity.moonrise$setTrackedEntity(null);
    }

    private void newTrackerTick() {
        ServerEntityLookup entityLookup = (ServerEntityLookup)this.t.moonrise$getEntityLookup();
        ReferenceList<net.minecraft.world.entity.Entity> trackerEntities = entityLookup.trackerEntities;
        net.minecraft.world.entity.Entity[] trackerEntitiesRaw = trackerEntities.getRawDataUnchecked();
        int len = trackerEntities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = trackerEntitiesRaw[i2];
            EntityTracker tracker = entity.moonrise$getTrackedEntity();
            if (tracker == null) continue;
            tracker.moonrise$tick(entity.moonrise$getChunkData().nearbyPlayers);
            if (!tracker.moonrise$hasPlayers() && !entity.moonrise$getChunkStatus().a(FullChunkStatus.d)) continue;
            tracker.b.a();
        }
    }

    protected void l() {
        this.newTrackerTick();
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker trackedEntity = (EntityTracker)this.L.get(entity.ao());
        if (trackedEntity != null) {
            trackedEntity.a(packet);
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker trackedEntity = (EntityTracker)this.L.get(entity.ao());
        if (trackedEntity != null) {
            trackedEntity.b(packet);
        }
    }

    public void b(List<IChunkAccess> chunks) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess chunkAccess : chunks) {
            Chunk levelChunk;
            ChunkCoordIntPair pos = chunkAccess.f();
            Chunk levelChunk1 = chunkAccess instanceof Chunk ? (levelChunk = (Chunk)chunkAccess) : this.t.d(pos.h, pos.i);
            for (EntityPlayer serverPlayer : this.a(pos, false)) {
                map.computeIfAbsent(serverPlayer, serverPlayer1 -> new ArrayList()).add(levelChunk1);
            }
        }
        map.forEach((serverPlayer1, list) -> serverPlayer1.f.b(ClientboundChunksBiomesPacket.a(list)));
    }

    protected VillagePlace m() {
        return this.A;
    }

    public String n() {
        return this.J;
    }

    void a(ChunkCoordIntPair chunkPos, FullChunkStatus fullChunkStatus) {
        this.G.onChunkStatusChange(chunkPos, fullChunkStatus);
    }

    public void a(ChunkCoordIntPair chunkPos, int range) {
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class a
    extends ChunkMapDistance
    implements ChunkSystemDistanceManager {
        protected a(TicketStorage ticketStorage, Executor dispatcher, Executor mainThreadExecutor) {
            super(ticketStorage, dispatcher, mainThreadExecutor);
        }

        @Override
        public final PlayerChunkMap moonrise$getChunkMap() {
            return PlayerChunkMap.this;
        }

        @Override
        protected boolean a(long chunkPos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected PlayerChunk b(long chunkPos) {
            return PlayerChunkMap.this.a(chunkPos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long chunkPos, int newLevel, @Nullable PlayerChunk holder, int oldLevel) {
            return PlayerChunkMap.this.a(chunkPos, newLevel, holder, oldLevel);
        }
    }

    public class EntityTracker
    implements EntityTrackerTrackedEntity {
        public final EntityTrackerEntry b;
        final net.minecraft.world.entity.Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        private long lastChunkUpdate = -1L;
        private NearbyPlayers.TrackedChunk lastTrackedChunk;

        @Override
        public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
            EntityPlayer player;
            if (chunk == null) {
                this.moonrise$clearPlayers();
                return;
            }
            ReferenceList<EntityPlayer> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
            if (players == null) {
                this.moonrise$clearPlayers();
                return;
            }
            long lastChunkUpdate = this.lastChunkUpdate;
            long currChunkUpdate = chunk.getUpdateCount();
            NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
            this.lastChunkUpdate = currChunkUpdate;
            this.lastTrackedChunk = chunk;
            EntityPlayer[] playersRaw = players.getRawDataUnchecked();
            int len = players.size();
            for (int i2 = 0; i2 < len; ++i2) {
                player = playersRaw[i2];
                this.b(player);
            }
            if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
                for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                    player = conn.o();
                    if (players.contains(player)) continue;
                    this.a(player);
                }
            }
        }

        @Override
        public final void moonrise$removeNonTickThreadPlayers() {
            boolean foundToRemove = false;
            for (ServerPlayerConnection conn : this.f) {
                if (TickThread.isTickThreadFor(conn.o())) continue;
                foundToRemove = true;
                break;
            }
            if (!foundToRemove) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.o();
                if (TickThread.isTickThreadFor(player)) continue;
                this.a(player);
            }
        }

        @Override
        public final void moonrise$clearPlayers() {
            this.lastChunkUpdate = -1L;
            this.lastTrackedChunk = null;
            if (this.f.isEmpty()) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.f)) {
                EntityPlayer player = conn.o();
                this.a(player);
            }
        }

        @Override
        public final boolean moonrise$hasPlayers() {
            return !this.f.isEmpty();
        }

        public EntityTracker(net.minecraft.world.entity.Entity entity, int range, int updateInterval, boolean trackDelta) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.t, entity, updateInterval, trackDelta, this::a, this::a, this.f);
            this.c = entity;
            this.d = range;
            this.e = SectionPosition.a(entity);
        }

        public boolean equals(Object other) {
            return other instanceof EntityTracker && ((EntityTracker)other).c.ao() == this.c.ao();
        }

        public int hashCode() {
            return this.c.ao();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                serverPlayerConnection.b(packet);
            }
        }

        public void a(Packet<?> packet, List<UUID> ignoredPlayers) {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                if (ignoredPlayers.contains(serverPlayerConnection.o().cG())) continue;
                serverPlayerConnection.b(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).f.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverPlayerConnection : this.f) {
                this.b.a(serverPlayerConnection.o());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.f)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double rangeY;
                boolean flag;
                double vec3_dx = player.dA() - this.c.dA();
                double vec3_dz = player.dG() - this.c.dG();
                int playerViewDistance = PlayerChunkMap.this.b(player);
                double d1 = vec3_dx * vec3_dx + vec3_dz * vec3_dz;
                double d2 = Math.min(this.b(), playerViewDistance * 16);
                double d22 = d2 * d2;
                boolean bl = flag = d1 <= d22;
                if (flag && PlayerChunkMap.this.t.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)PlayerChunkMap.this.t.paperConfig().entities.trackingRangeY.get(this.c, -1)) != -1.0) {
                    double vec3_dy = player.dC() - this.c.dC();
                    flag = vec3_dy * vec3_dy <= rangeY * rangeY;
                }
                boolean bl2 = flag = flag && this.c.a(player) && PlayerChunkMap.this.a(player, this.c.dx().h, this.c.dx().i);
                if (flag && !player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.f)) {
                        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent()) {
                            this.b.b(player);
                        }
                        this.b.onPlayerAdd();
                    }
                } else if (this.f.remove(player.f)) {
                    this.b.a(player);
                }
            }
        }

        private int a(int trackingDistance) {
            return PlayerChunkMap.this.t.p().b(trackingDistance);
        }

        private int b() {
            net.minecraft.world.entity.Entity entity = this.c;
            int range = this.d;
            if (entity.cY() == ImmutableList.of()) {
                return this.a(range);
            }
            List passengers = (List)entity.dc();
            int len = passengers.size();
            for (int i2 = 0; i2 < len; ++i2) {
                net.minecraft.world.entity.Entity passenger = (net.minecraft.world.entity.Entity)passengers.get(i2);
                range = Math.max(range, PlatformHooks.get().modifyEntityTrackingRange(passenger, passenger.an().o() << 4));
            }
            return this.a(range);
        }

        public void a(List<EntityPlayer> playersList) {
            for (EntityPlayer serverPlayer : playersList) {
                this.b(serverPlayer);
            }
        }
    }
}

