/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.util.TraceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> b;
    private final IChunkAccess c;
    private final WorldServer d;
    private final long e;
    private final WorldData f;
    private final RandomSource h;
    private final DimensionManager i;
    private final TickListWorldGen<Block> j = new TickListWorldGen(blockPos -> this.z((BlockPosition)blockPos).q());
    private final TickListWorldGen<FluidType> k = new TickListWorldGen(blockPos -> this.z((BlockPosition)blockPos).r());
    private final BiomeManager l;
    private final ChunkStep m;
    @Nullable
    private Supplier<String> n;
    private final AtomicLong o = new AtomicLong();
    private static final MinecraftKey p = MinecraftKey.b("worldgen_region_random");
    private boolean hasSetFarWarned = false;

    @Override
    public int a(EnumSkyBlock lightLayer, BlockPosition blockPos) {
        IChunkAccess chunk = this.a(blockPos.u() >> 4, blockPos.w() >> 4);
        if (!chunk.x()) {
            return 0;
        }
        return this.B_().a(lightLayer).b(blockPos);
    }

    @Override
    public int b(BlockPosition blockPos, int subtract) {
        IChunkAccess chunk = this.a(blockPos.u() >> 4, blockPos.w() >> 4);
        if (!chunk.x()) {
            return 0;
        }
        return this.B_().a(blockPos, subtract);
    }

    public RegionLimitedWorldAccess(WorldServer level, StaticCache2D<GenerationChunkHolder> cache, ChunkStep generatingStep, IChunkAccess center) {
        this.m = generatingStep;
        this.b = cache;
        this.c = center;
        this.d = level;
        this.e = level.E();
        this.f = level.C_();
        this.h = level.m().i().a(p).a(this.c.f().l());
        this.i = level.F_();
        this.l = new BiomeManager(this, BiomeManager.a(this.e));
    }

    public boolean a(ChunkCoordIntPair pos, int radius) {
        return this.d.m().a.b(pos, radius);
    }

    public ChunkCoordIntPair b() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> currentlyGenerating) {
        this.n = currentlyGenerating;
    }

    @Override
    public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        GenerationChunkHolder generationChunkHolder;
        ChunkStatus chunkStatus1;
        int chessboardDistance = this.c.f().e(x2, z2);
        ChunkStatus chunkStatus2 = chunkStatus1 = chessboardDistance >= this.m.b().b() ? null : this.m.b().a(chessboardDistance);
        if (chunkStatus1 != null) {
            IChunkAccess chunkIfPresentUnchecked;
            generationChunkHolder = this.b.a(x2, z2);
            if (chunkStatus.c(chunkStatus1) && (chunkIfPresentUnchecked = generationChunkHolder.a(chunkStatus1)) != null) {
                return chunkIfPresentUnchecked;
            }
        } else {
            generationChunkHolder = null;
        }
        CrashReport crashReport = CrashReport.a(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Chunk request details");
        crashReportCategory.a("Requested chunk", String.format(Locale.ROOT, "%d, %d", x2, z2));
        crashReportCategory.a("Generating status", () -> this.m.a().f());
        crashReportCategory.a("Requested status", chunkStatus::f);
        crashReportCategory.a("Actual status", () -> generationChunkHolder == null ? "[out of cache bounds]" : generationChunkHolder.q().f());
        crashReportCategory.a("Maximum allowed status", () -> chunkStatus1 == null ? "null" : chunkStatus1.f());
        crashReportCategory.a("Dependencies", this.m.b()::toString);
        crashReportCategory.a("Requested distance", chessboardDistance);
        crashReportCategory.a("Generating chunk", this.c.f()::toString);
        throw new ReportedException(crashReport);
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        int chessboardDistance = this.c.f().e(chunkX, chunkZ);
        return chessboardDistance < this.m.b().b();
    }

    @Override
    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return this.a(x2, z2, ChunkStatus.n, false);
    }

    @Override
    @Nullable
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.a_(pos);
    }

    @Override
    @Nullable
    public final Fluid getFluidIfLoaded(BlockPosition pos) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.b_(pos);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w())).a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.z(pos).b_(pos);
    }

    @Override
    @Nullable
    public EntityHuman a(double x2, double y2, double z2, double distance, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int D_() {
        return 0;
    }

    @Override
    public BiomeManager H_() {
        return this.l;
    }

    @Override
    public Holder<BiomeBase> a(int x2, int y2, int z2) {
        return this.d.a(x2, y2, z2);
    }

    @Override
    public float a(EnumDirection direction, boolean shade) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine B_() {
        return this.d.B_();
    }

    @Override
    public boolean a(BlockPosition pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        IBlockData blockState = this.a_(pos);
        if (blockState.l()) {
            return false;
        }
        if (dropBlock) {
            a.warn("Potential async entity add during worldgen", new Throwable());
        }
        return this.a(pos, Blocks.a.m(), 3, recursionLeft);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess chunk = this.z(pos);
        TileEntity blockEntity = chunk.c_(pos);
        if (blockEntity != null) {
            return blockEntity;
        }
        NBTTagCompound blockEntityNbt = chunk.f(pos);
        IBlockData blockState = chunk.a_(pos);
        if (blockEntityNbt != null) {
            if ("DUMMY".equals(blockEntityNbt.b("id", ""))) {
                if (!blockState.x()) {
                    return null;
                }
                blockEntity = ((ITileEntity)((Object)blockState.b())).a(pos, blockState);
            } else {
                blockEntity = TileEntity.a(pos, blockState, blockEntityNbt, this.d.J_());
            }
            if (blockEntity != null) {
                chunk.a(blockEntity);
                return blockEntity;
            }
        }
        if (blockState.x()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    @Override
    public boolean f_(BlockPosition pos) {
        int sectionPosX = SectionPosition.a(pos.u());
        int sectionPosZ = SectionPosition.a(pos.w());
        ChunkCoordIntPair center = this.b();
        int abs = Math.abs(center.h - sectionPosX);
        int abs1 = Math.abs(center.i - sectionPosZ);
        if (abs <= this.m.d() && abs1 <= this.m.d()) {
            LevelHeightAccessor heightAccessorForGeneration;
            return !this.c.A() || !(heightAccessorForGeneration = this.c.B()).e(pos.v());
        }
        if (!this.hasSetFarWarned) {
            SystemUtils.b("Detected setBlock in a far chunk [" + sectionPosX + ", " + sectionPosZ + "], pos: " + String.valueOf(pos) + ", status: " + String.valueOf(this.m.a()) + (String)(this.n == null ? "" : ", currently generating: " + this.n.get()));
            this.hasSetFarWarned = true;
            if (this.p() != null && this.p().isDebugging()) {
                TraceUtil.dumpTraceForThread("far setBlock call");
            }
        }
        return false;
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int recursionLeft) {
        IBlockData blockState;
        if (!this.f_(pos)) {
            return false;
        }
        IChunkAccess chunk = this.z(pos);
        IBlockData previousBlockState = blockState = chunk.a(pos, state, flags);
        if (blockState != null) {
            this.d.a(pos, blockState, state);
        }
        if (state.x()) {
            if (chunk.n().d() == ChunkType.b) {
                TileEntity blockEntity = ((ITileEntity)((Object)state.b())).a(pos, state);
                if (blockEntity != null) {
                    chunk.a(blockEntity);
                } else {
                    chunk.d(pos);
                }
            } else {
                if (previousBlockState != null && !Objects.equals(previousBlockState.b(), state.b())) {
                    chunk.d(pos);
                }
                NBTTagCompound compoundTag = new NBTTagCompound();
                compoundTag.a("x", pos.u());
                compoundTag.a("y", pos.v());
                compoundTag.a("z", pos.w());
                compoundTag.a("id", "DUMMY");
                chunk.a(compoundTag);
            }
        } else if (blockState != null && blockState.x()) {
            chunk.d(pos);
        }
        if (state.l(this, pos) && (flags & 0x10) == 0) {
            this.f(pos);
        }
        return true;
    }

    private void f(BlockPosition pos) {
        this.z(pos).e(pos);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int sectionPosX = SectionPosition.a(entity.dz());
        int sectionPosZ = SectionPosition.a(entity.dF());
        this.a(sectionPosX, sectionPosZ).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition pos, boolean isMoving) {
        return this.a(pos, Blocks.a.m(), 3);
    }

    @Override
    public WorldBorder E_() {
        return this.d.E_();
    }

    @Override
    public boolean A_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer a() {
        return this.d;
    }

    @Override
    public IRegistryCustom J_() {
        return this.d.J_();
    }

    @Override
    public FeatureFlagSet K() {
        return this.d.K();
    }

    @Override
    public WorldData C_() {
        return this.f;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        if (!this.b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.d.an(), this.d.af(), 0L, this.d.as());
    }

    @Override
    @Nullable
    public MinecraftServer p() {
        return this.d.p();
    }

    @Override
    public IChunkProvider S() {
        return this.d.m();
    }

    @Override
    public long E() {
        return this.e;
    }

    @Override
    public LevelTickAccess<Block> U() {
        return this.j;
    }

    @Override
    public LevelTickAccess<FluidType> T() {
        return this.k;
    }

    @Override
    public int P() {
        return this.d.P();
    }

    @Override
    public RandomSource G_() {
        return this.h;
    }

    @Override
    public int a(HeightMap.Type heightmapType, int x2, int z2) {
        return this.a(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmapType, x2 & 0xF, z2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable Entity entity, BlockPosition pos, SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    @Override
    public void a(ParticleParam particleData, double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed) {
    }

    @Override
    public void a(@Nullable Entity entity, int type, BlockPosition pos, int data) {
    }

    @Override
    public void a(Holder<GameEvent> gameEvent, Vec3D pos, GameEvent.a context) {
    }

    @Override
    public DimensionManager F_() {
        return this.i;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(pos));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entityTypeTest, AxisAlignedBB bounds, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> z() {
        return Collections.emptyList();
    }

    @Override
    public int K_() {
        return this.d.K_();
    }

    @Override
    public int L_() {
        return this.d.L_();
    }

    @Override
    public long I_() {
        return this.o.getAndIncrement();
    }
}

