/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.DummyFileAttributes;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.linkfs.PathContents;

class LinkFSPath
implements Path {
    private static final BasicFileAttributes a = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    };
    private static final BasicFileAttributes b = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }
    };
    private static final Comparator<LinkFSPath> c = Comparator.comparing(LinkFSPath::n);
    private final String d;
    private final LinkFileSystem e;
    @Nullable
    private final LinkFSPath f;
    @Nullable
    private List<String> g;
    @Nullable
    private String h;
    private final PathContents i;

    public LinkFSPath(LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent, PathContents pathContents) {
        this.e = fileSystem;
        this.d = name;
        this.f = parent;
        this.i = pathContents;
    }

    private LinkFSPath a(@Nullable LinkFSPath parent, String name) {
        return new LinkFSPath(this.e, name, parent, PathContents.b);
    }

    public LinkFileSystem a() {
        return this.e;
    }

    @Override
    public boolean isAbsolute() {
        return this.i != PathContents.b;
    }

    @Override
    public File toFile() {
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.b) {
            PathContents.b fileContents = (PathContents.b)pathContents;
            return fileContents.a().toFile();
        }
        throw new UnsupportedOperationException("Path " + this.n() + " does not represent file");
    }

    @Nullable
    public LinkFSPath b() {
        return this.isAbsolute() ? this.e.b() : null;
    }

    public LinkFSPath c() {
        return this.a(null, this.d);
    }

    @Nullable
    public LinkFSPath d() {
        return this.f;
    }

    @Override
    public int getNameCount() {
        return this.l().size();
    }

    private List<String> l() {
        if (this.d.isEmpty()) {
            return List.of();
        }
        if (this.g == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.f != null) {
                builder.addAll(this.f.l());
            }
            builder.add((Object)this.d);
            this.g = builder.build();
        }
        return this.g;
    }

    public LinkFSPath a(int index) {
        List<String> list = this.l();
        if (index >= 0 && index < list.size()) {
            return this.a(null, list.get(index));
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    public LinkFSPath a(int start, int end) {
        List<String> list = this.l();
        if (start >= 0 && end <= list.size() && start < end) {
            LinkFSPath linkFsPath = null;
            for (int i2 = start; i2 < end; ++i2) {
                linkFsPath = this.a(linkFsPath, list.get(i2));
            }
            return linkFsPath;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean startsWith(Path path) {
        if (path.isAbsolute() != this.isAbsolute()) {
            return false;
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFsPath = (LinkFSPath)path;
            if (linkFsPath.e != this.e) {
                return false;
            }
            List<String> list = this.l();
            List<String> list1 = linkFsPath.l();
            int size = list1.size();
            if (size > list.size()) {
                return false;
            }
            for (int i2 = 0; i2 < size; ++i2) {
                if (list1.get(i2).equals(list.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path path) {
        if (path.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFsPath = (LinkFSPath)path;
            if (linkFsPath.e != this.e) {
                return false;
            }
            List<String> list = this.l();
            List<String> list1 = linkFsPath.l();
            int size = list1.size();
            int i2 = list.size() - size;
            if (i2 < 0) {
                return false;
            }
            for (int i1 = size - 1; i1 >= 0; --i1) {
                if (list1.get(i1).equals(list.get(i2 + i1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LinkFSPath e() {
        return this;
    }

    public LinkFSPath a(Path path) {
        LinkFSPath linkFsPath = this.c(path);
        return path.isAbsolute() ? linkFsPath : this.a(linkFsPath.l());
    }

    private LinkFSPath a(List<String> names) {
        LinkFSPath linkFsPath = this;
        for (String string : names) {
            linkFsPath = linkFsPath.a(string);
        }
        return linkFsPath;
    }

    LinkFSPath a(String name) {
        if (LinkFSPath.a(this.i)) {
            return new LinkFSPath(this.e, name, this, this.i);
        }
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.a) {
            PathContents.a directoryContents = (PathContents.a)pathContents;
            LinkFSPath linkFsPath = directoryContents.a().get(name);
            return linkFsPath != null ? linkFsPath : new LinkFSPath(this.e, name, this, PathContents.a);
        }
        if (this.i instanceof PathContents.b) {
            return new LinkFSPath(this.e, name, this, PathContents.a);
        }
        throw new AssertionError((Object)"All content types should be already handled");
    }

    private static boolean a(PathContents pathContents) {
        return pathContents == PathContents.a || pathContents == PathContents.b;
    }

    public LinkFSPath b(Path path) {
        LinkFSPath linkFsPath = this.c(path);
        if (this.isAbsolute() != linkFsPath.isAbsolute()) {
            throw new IllegalArgumentException("absolute mismatch");
        }
        List<String> list = this.l();
        List<String> list1 = linkFsPath.l();
        if (list.size() >= list1.size()) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).equals(list1.get(i2))) continue;
            throw new IllegalArgumentException();
        }
        return linkFsPath.a(list.size(), list1.size());
    }

    @Override
    public URI toUri() {
        try {
            return new URI("x-mc-link", this.e.a().name(), this.n(), null);
        }
        catch (URISyntaxException var2) {
            throw new AssertionError("Failed to create URI", var2);
        }
    }

    public LinkFSPath f() {
        return this.isAbsolute() ? this : this.e.b().a(this);
    }

    public LinkFSPath a(LinkOption ... options) {
        return this.f();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path other) {
        LinkFSPath linkFsPath = this.c(other);
        return c.compare(this, linkFsPath);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LinkFSPath) {
            LinkFSPath linkFsPath = (LinkFSPath)other;
            if (this.e != linkFsPath.e) {
                return false;
            }
            boolean hasRealContents = this.m();
            if (hasRealContents != linkFsPath.m()) {
                return false;
            }
            return hasRealContents ? this.i == linkFsPath.i : Objects.equals(this.f, linkFsPath.f) && Objects.equals(this.d, linkFsPath.d);
        }
        return false;
    }

    private boolean m() {
        return !LinkFSPath.a(this.i);
    }

    @Override
    public int hashCode() {
        return this.m() ? this.i.hashCode() : this.d.hashCode();
    }

    @Override
    public String toString() {
        return this.n();
    }

    private String n() {
        if (this.h == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isAbsolute()) {
                stringBuilder.append("/");
            }
            Joiner.on((String)"/").appendTo(stringBuilder, this.l());
            this.h = stringBuilder.toString();
        }
        return this.h;
    }

    private LinkFSPath c(@Nullable Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFsPath = (LinkFSPath)path;
            if (linkFsPath.e == this.e) {
                return linkFsPath;
            }
        }
        throw new ProviderMismatchException();
    }

    public boolean g() {
        return this.m();
    }

    @Nullable
    public Path h() {
        Path path;
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.b) {
            PathContents.b fileContents = (PathContents.b)pathContents;
            path = fileContents.a();
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public PathContents.a i() {
        PathContents.a directoryContents;
        PathContents pathContents = this.i;
        return pathContents instanceof PathContents.a ? (directoryContents = (PathContents.a)pathContents) : null;
    }

    public BasicFileAttributeView j() {
        return new BasicFileAttributeView(){

            @Override
            public String name() {
                return "basic";
            }

            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return LinkFSPath.this.k();
            }

            @Override
            public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    public BasicFileAttributes k() throws IOException {
        if (this.i instanceof PathContents.a) {
            return a;
        }
        if (this.i instanceof PathContents.b) {
            return b;
        }
        throw new NoSuchFileException(this.n());
    }
}

