/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger a = LogUtils.getLogger();
    private final PackLocationInfo b;
    public final c c;
    private final a d;
    private final PackSelectionConfig e;

    @Nullable
    public static ResourcePackLoader a(PackLocationInfo location, c resources, EnumResourcePackType packType, PackSelectionConfig selectionConfig) {
        int packVersion = SharedConstants.b().a(packType);
        a packMetadata = ResourcePackLoader.a(location, resources, packVersion);
        return packMetadata != null ? new ResourcePackLoader(location, resources, packMetadata, selectionConfig) : null;
    }

    public ResourcePackLoader(PackLocationInfo location, c resources, a metadata, PackSelectionConfig selectionConfig) {
        this.b = location;
        this.c = resources;
        this.d = metadata;
        this.e = selectionConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a a(PackLocationInfo location, c resources, int version) {
        try (IResourcePack packResources = resources.a(location);){
            ResourcePackInfo packMetadataSection = packResources.a(ResourcePackInfo.b);
            if (packMetadataSection == null) {
                a.warn("Missing metadata in pack {}", (Object)location.a());
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection featureFlagsMetadataSection = packResources.a(FeatureFlagsMetadataSection.a);
            FeatureFlagSet featureFlagSet = featureFlagsMetadataSection != null ? featureFlagsMetadataSection.a() : FeatureFlagSet.a();
            InclusiveRange<Integer> declaredPackVersions = ResourcePackLoader.a(location.a(), packMetadataSection);
            EnumResourcePackVersion packCompatibility = EnumResourcePackVersion.a(declaredPackVersions, version);
            OverlayMetadataSection overlayMetadataSection = packResources.a(OverlayMetadataSection.a);
            List<String> list = overlayMetadataSection != null ? overlayMetadataSection.a(version) : List.of();
            a var11 = new a(packMetadataSection.a(), packCompatibility, featureFlagSet, list);
            return var11;
        }
        catch (Exception var14) {
            a.warn("Failed to read pack {} metadata", (Object)location.a(), (Object)var14);
            return null;
        }
    }

    private static InclusiveRange<Integer> a(String id, ResourcePackInfo metadata) {
        int packFormat = metadata.b();
        if (metadata.c().isEmpty()) {
            return new InclusiveRange<Integer>(packFormat);
        }
        InclusiveRange<Integer> inclusiveRange = metadata.c().get();
        if (!inclusiveRange.a(packFormat)) {
            a.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{id, inclusiveRange, packFormat, packFormat});
            return new InclusiveRange<Integer>(packFormat);
        }
        return inclusiveRange;
    }

    public PackLocationInfo a() {
        return this.b;
    }

    public IChatBaseComponent b() {
        return this.b.b();
    }

    public IChatBaseComponent c() {
        return this.d.a();
    }

    public IChatBaseComponent a(boolean green) {
        return this.b.a(green, this.d.a);
    }

    public EnumResourcePackVersion d() {
        return this.d.b();
    }

    public FeatureFlagSet e() {
        return this.d.c();
    }

    public IResourcePack f() {
        return this.c.a(this.b, this.d);
    }

    public String g() {
        return this.b.a();
    }

    public PackSelectionConfig h() {
        return this.e;
    }

    public boolean i() {
        return this.e.a();
    }

    public boolean j() {
        return this.e.c();
    }

    public Position k() {
        return this.e.b();
    }

    public PackSource l() {
        return this.b.c();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ResourcePackLoader)) return false;
        ResourcePackLoader pack = (ResourcePackLoader)other;
        if (!this.b.equals(pack.b)) return false;
        return true;
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public static interface c {
        public IResourcePack a(PackLocationInfo var1);

        public IResourcePack a(PackLocationInfo var1, a var2);
    }

    public record a(IChatBaseComponent a, EnumResourcePackVersion b, FeatureFlagSet c, List<String> d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position a = new Position();
        public static final /* enum */ Position b = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String name) {
            return Enum.valueOf(Position.class, name);
        }

        public <T> int a(List<T> list, T element, Function<T, PackSelectionConfig> packFactory, boolean flipPosition) {
            PackSelectionConfig packSelectionConfig;
            int i2;
            Position position;
            Position position2 = position = flipPosition ? this.a() : this;
            if (position == b) {
                PackSelectionConfig packSelectionConfig2;
                int i3;
                for (i3 = 0; i3 < list.size() && (packSelectionConfig2 = packFactory.apply(list.get(i3))).c() && packSelectionConfig2.b() == this; ++i3) {
                }
                list.add(i3, element);
                return i3;
            }
            for (i2 = list.size() - 1; i2 >= 0 && (packSelectionConfig = packFactory.apply(list.get(i2))).c() && packSelectionConfig.b() == this; --i2) {
            }
            list.add(i2 + 1, element);
            return i2 + 1;
        }

        public Position a() {
            return this == a ? b : a;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{a, b};
        }

        static {
            c = Position.b();
        }
    }
}

