/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger a = LogUtils.getLogger();
    private final Stopwatch b = Stopwatch.createUnstarted();

    public static IReloadable a(IResourceManager resourceManager, List<IReloadListener> listeners, Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> alsoWaitedFor) {
        ReloadableProfiled profiledReloadInstance = new ReloadableProfiled(listeners);
        profiledReloadInstance.b(backgroundExecutor, gameExecutor, resourceManager, listeners, (preperationBarrier, resourceManager1, listener, backgroundExecutor1, gameExecutor1) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong1 = new AtomicLong();
            AtomicLong atomicLong2 = new AtomicLong();
            AtomicLong atomicLong3 = new AtomicLong();
            CompletableFuture<Void> completableFuture = listener.reload(preperationBarrier, resourceManager1, ReloadableProfiled.a(backgroundExecutor1, atomicLong, atomicLong1, listener.getName()), ReloadableProfiled.a(gameExecutor1, atomicLong2, atomicLong3, listener.getName()));
            return completableFuture.thenApplyAsync(_void -> {
                a.debug("Finished reloading {}", (Object)listener.getName());
                return new a(listener.getName(), atomicLong, atomicLong1, atomicLong2, atomicLong3);
            }, gameExecutor);
        }, alsoWaitedFor);
        return profiledReloadInstance;
    }

    private ReloadableProfiled(List<IReloadListener> preparingListeners) {
        super(preparingListeners);
        this.b.start();
    }

    @Override
    protected CompletableFuture<List<a>> a(Executor backgroundExecutor, Executor gameExectutor, IResourceManager resourceManager, List<IReloadListener> listeners, Reloadable.a<a> stateFactory, CompletableFuture<?> alsoWaitedFor) {
        return super.a(backgroundExecutor, gameExectutor, resourceManager, listeners, stateFactory, alsoWaitedFor).thenApplyAsync(this::a, gameExectutor);
    }

    private static Executor a(Executor executor, AtomicLong timeTaken, AtomicLong timesRun, String name) {
        return runnable -> executor.execute(() -> {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(name);
            long nanos = SystemUtils.d();
            runnable.run();
            timeTaken.addAndGet(SystemUtils.d() - nanos);
            timesRun.incrementAndGet();
            profilerFiller.c();
        });
    }

    private List<a> a(List<a> datapoints) {
        this.b.stop();
        long l2 = 0L;
        a.info("Resource reload finished after {} ms", (Object)this.b.elapsed(TimeUnit.MILLISECONDS));
        for (a state : datapoints) {
            long l1 = TimeUnit.NANOSECONDS.toMillis(state.b.get());
            long l22 = state.c.get();
            long l3 = TimeUnit.NANOSECONDS.toMillis(state.d.get());
            long l4 = state.e.get();
            long l5 = l1 + l3;
            long l6 = l22 + l4;
            String string = state.a;
            a.info("{} took approximately {} tasks/{} ms ({} tasks/{} ms preparing, {} tasks/{} ms applying)", new Object[]{string, l6, l5, l22, l1, l4, l3});
            l2 += l3;
        }
        a.info("Total blocking time: {} ms", (Object)l2);
        return datapoints;
    }

    public record a(String a, AtomicLong b, AtomicLong c, AtomicLong d, AtomicLong e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

