/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;

public class GameProfileBanEntry
extends ExpirableListEntry<GameProfile> {
    public GameProfileBanEntry(@Nullable GameProfile user) {
        this(user, (Date)null, (String)null, (Date)null, (String)null);
    }

    public GameProfileBanEntry(@Nullable GameProfile profile, @Nullable Date created, @Nullable String source, @Nullable Date expires, @Nullable String reason) {
        super(profile, created, source, expires, reason);
    }

    public GameProfileBanEntry(JsonObject entryData) {
        super(GameProfileBanEntry.b(entryData), entryData);
    }

    @Override
    protected void a(JsonObject data) {
        if (this.g() != null) {
            data.addProperty("uuid", ((GameProfile)this.g()).getId().toString());
            data.addProperty("name", ((GameProfile)this.g()).getName());
            super.a(data);
        }
    }

    @Override
    public IChatBaseComponent e() {
        GameProfile gameProfile = (GameProfile)this.g();
        return gameProfile != null ? IChatBaseComponent.b(gameProfile.getName()) : IChatBaseComponent.c("commands.banlist.entry.unknown");
    }

    @Nullable
    private static GameProfile b(JsonObject json) {
        UUID uuid = null;
        String name = null;
        if (json.has("uuid")) {
            String asString = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(asString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (json.has("name")) {
            name = json.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }
}

