/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JsonList<K, V extends JsonListEntry<K>> {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = new GsonBuilder().setPrettyPrinting().create();
    private final File c;
    private final Map<String, V> d = Maps.newConcurrentMap();

    public JsonList(File file) {
        this.c = file;
    }

    public File b() {
        return this.c;
    }

    public void a(V entry) {
        this.d.put(this.a((K)((JsonListEntry)entry).g()), entry);
        try {
            this.e();
        }
        catch (IOException var3) {
            a.warn("Could not save the list after adding a user.", (Throwable)var3);
        }
    }

    @Nullable
    public V b(K obj) {
        return (V)this.d.computeIfPresent(this.a(obj), (k2, v2) -> v2.f() ? null : v2);
    }

    public void c(K user) {
        this.d.remove(this.a(user));
        try {
            this.e();
        }
        catch (IOException var3) {
            a.warn("Could not save the list after removing a user.", (Throwable)var3);
        }
    }

    public void b(JsonListEntry<K> entry) {
        this.c(entry.g());
    }

    public String[] a() {
        return this.d.keySet().toArray(new String[0]);
    }

    public boolean c() {
        return this.d.isEmpty();
    }

    protected String a(K obj) {
        return obj.toString();
    }

    protected boolean d(K entry) {
        this.g();
        return this.d.containsKey(this.a(entry));
    }

    private void g() {
        this.d.values().removeIf(JsonListEntry::f);
    }

    protected abstract JsonListEntry<K> a(JsonObject var1);

    public Collection<V> d() {
        return this.d.values();
    }

    public void e() throws IOException {
        this.g();
        JsonArray jsonArray = new JsonArray();
        this.d.values().stream().map(storedEntry -> SystemUtils.a(new JsonObject(), storedEntry::a)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter writer = Files.newWriter((File)this.c, (Charset)StandardCharsets.UTF_8);){
            b.toJson((JsonElement)jsonArray, b.newJsonWriter((Writer)writer));
        }
    }

    public void f() throws IOException {
        if (this.c.exists()) {
            try (BufferedReader reader = Files.newReader((File)this.c, (Charset)StandardCharsets.UTF_8);){
                this.d.clear();
                JsonArray jsonArray = (JsonArray)b.fromJson((Reader)reader, JsonArray.class);
                if (jsonArray == null) {
                    return;
                }
                for (JsonElement jsonElement : jsonArray) {
                    JsonObject jsonObject = ChatDeserializer.m(jsonElement, "entry");
                    JsonListEntry<K> storedUserEntry = this.a(jsonObject);
                    if (storedUserEntry.g() == null) continue;
                    this.d.put(this.a(storedUserEntry.g()), storedUserEntry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                File backup = new File(String.valueOf(this.c) + ".backup");
                a.warn("Unable to read file {}, backing it up to {} and creating new copy.", new Object[]{this.c, backup, ex});
                this.c.renameTo(backup);
                this.c.delete();
            }
        }
    }
}

