/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class NameReferencingFileConverter {
    static final Logger e = LogUtils.getLogger();
    public static final File a = new File("banned-ips.txt");
    public static final File b = new File("banned-players.txt");
    public static final File c = new File("ops.txt");
    public static final File d = new File("white-list.txt");

    static List<String> a(File inFile, Map<String, String[]> read) throws IOException {
        List lines = Files.readLines((File)inFile, (Charset)StandardCharsets.UTF_8);
        for (String string : lines) {
            if ((string = string.trim()).startsWith("#") || string.length() < 1) continue;
            String[] parts = string.split("\\|");
            read.put(parts[0].toLowerCase(Locale.ROOT), parts);
        }
        return lines;
    }

    private static void a(MinecraftServer server, Collection<String> names, ProfileLookupCallback callback) {
        String[] strings = (String[])names.stream().filter(name -> !UtilColor.b(name)).toArray(String[]::new);
        if (server.aa() || GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            server.as().findProfilesByNames(strings, callback);
        } else {
            for (String string : strings) {
                callback.onProfileLookupSucceeded(UUIDUtil.b(string));
            }
        }
    }

    public static boolean a(final MinecraftServer server) {
        final GameProfileBanList userBanList = new GameProfileBanList(PlayerList.a);
        if (b.exists() && b.isFile()) {
            if (userBanList.b().exists()) {
                try {
                    userBanList.f();
                }
                catch (IOException var6) {
                    e.warn("Could not load existing file {}", (Object)userBanList.b().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(b, map);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.at().a(gameProfile);
                        String[] strings = (String[])map.get(gameProfile.getName().toLowerCase(Locale.ROOT));
                        if (strings == null) {
                            e.warn("Could not convert user banlist entry for {}", (Object)gameProfile.getName());
                            throw new FileConversionException("Profile not in the conversionlist");
                        }
                        Date date = strings.length > 1 ? NameReferencingFileConverter.a(strings[1], null) : null;
                        String string = strings.length > 2 ? strings[2] : null;
                        Date date1 = strings.length > 3 ? NameReferencingFileConverter.a(strings[3], null) : null;
                        String string1 = strings.length > 4 ? strings[4] : null;
                        userBanList.a(new GameProfileBanEntry(gameProfile, date, string, date1, string1));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        e.warn("Could not lookup user banlist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, map.keySet(), profileLookupCallback);
                userBanList.e();
                NameReferencingFileConverter.b(b);
                return true;
            }
            catch (IOException var4) {
                e.warn("Could not read old user banlist to convert it!", (Throwable)var4);
                return false;
            }
            catch (FileConversionException var5) {
                e.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    public static boolean b(MinecraftServer server) {
        IpBanList ipBanList = new IpBanList(PlayerList.b);
        if (a.exists() && a.isFile()) {
            if (ipBanList.b().exists()) {
                try {
                    ipBanList.f();
                }
                catch (IOException var11) {
                    e.warn("Could not load existing file {}", (Object)ipBanList.b().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.a(a, map);
                for (String string : map.keySet()) {
                    String[] strings = (String[])map.get(string);
                    Date date = strings.length > 1 ? NameReferencingFileConverter.a(strings[1], null) : null;
                    String string1 = strings.length > 2 ? strings[2] : null;
                    Date date1 = strings.length > 3 ? NameReferencingFileConverter.a(strings[3], null) : null;
                    String string2 = strings.length > 4 ? strings[4] : null;
                    ipBanList.a(new IpBanEntry(string, date, string1, date1, string2));
                }
                ipBanList.e();
                NameReferencingFileConverter.b(a);
                return true;
            }
            catch (IOException var10) {
                e.warn("Could not parse old ip banlist to convert it!", (Throwable)var10);
                return false;
            }
        }
        return true;
    }

    public static boolean c(final MinecraftServer server) {
        final OpList serverOpList = new OpList(PlayerList.c);
        if (c.exists() && c.isFile()) {
            if (serverOpList.b().exists()) {
                try {
                    serverOpList.f();
                }
                catch (IOException var6) {
                    e.warn("Could not load existing file {}", (Object)serverOpList.b().getName());
                }
            }
            try {
                List lines = Files.readLines((File)c, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.at().a(gameProfile);
                        serverOpList.a(new OpListEntry(gameProfile, server.k(), false));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        e.warn("Could not lookup oplist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, lines, profileLookupCallback);
                serverOpList.e();
                NameReferencingFileConverter.b(c);
                return true;
            }
            catch (IOException var4) {
                e.warn("Could not read old oplist to convert it!", (Throwable)var4);
                return false;
            }
            catch (FileConversionException var5) {
                e.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    public static boolean d(final MinecraftServer server) {
        final WhiteList userWhiteList = new WhiteList(PlayerList.d);
        if (d.exists() && d.isFile()) {
            if (userWhiteList.b().exists()) {
                try {
                    userWhiteList.f();
                }
                catch (IOException var6) {
                    e.warn("Could not load existing file {}", (Object)userWhiteList.b().getName());
                }
            }
            try {
                List lines = Files.readLines((File)d, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.at().a(gameProfile);
                        userWhiteList.add(new WhiteListEntry(gameProfile));
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + profileName + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.a(server, lines, profileLookupCallback);
                userWhiteList.e();
                NameReferencingFileConverter.b(d);
                return true;
            }
            catch (IOException var4) {
                e.warn("Could not read old whitelist to convert it!", (Throwable)var4);
                return false;
            }
            catch (FileConversionException var5) {
                e.error("Conversion failed, please try again later", (Throwable)var5);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID a(final MinecraftServer server, String username) {
        if (!UtilColor.b(username) && username.length() <= 16) {
            Optional<UUID> optional = server.at().a(username).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!server.U() && server.aa()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.at().a(gameProfile);
                        list.add(gameProfile);
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        e.warn("Could not lookup user whitelist entry for {}", (Object)profileName, (Object)exception);
                    }
                };
                NameReferencingFileConverter.a(server, Lists.newArrayList((Object[])new String[]{username}), profileLookupCallback);
                return !list.isEmpty() ? ((GameProfile)list.get(0)).getId() : null;
            }
            return UUIDUtil.a(username);
        }
        try {
            return UUID.fromString(username);
        }
        catch (IllegalArgumentException var5) {
            return null;
        }
    }

    public static boolean a(final DedicatedServer server) {
        final File worldPlayersDirectory = NameReferencingFileConverter.g(server);
        final File file = new File(worldPlayersDirectory.getParentFile(), "playerdata");
        final File file1 = new File(worldPlayersDirectory.getParentFile(), "unknownplayers");
        if (worldPlayersDirectory.exists() && worldPlayersDirectory.isDirectory()) {
            File[] files = worldPlayersDirectory.listFiles();
            ArrayList list = Lists.newArrayList();
            for (File file2 : files) {
                String sub;
                String name = file2.getName();
                if (!name.toLowerCase(Locale.ROOT).endsWith(".dat") || (sub = name.substring(0, name.length() - ".dat".length())).isEmpty()) continue;
                list.add(sub);
            }
            try {
                Object[] strings = list.toArray(new String[list.size()]);
                ProfileLookupCallback profileLookupCallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$strings;
                    {
                        this.val$strings = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameProfile) {
                        server.at().a(gameProfile);
                        UUID id = gameProfile.getId();
                        this.a(file, this.a(gameProfile.getName()), id.toString());
                    }

                    public void onProfileLookupFailed(String profileName, Exception exception) {
                        e.warn("Could not lookup user uuid for {}", (Object)profileName, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + profileName + " from backend systems", exception);
                        }
                        String fileNameForProfile = this.a(profileName);
                        this.a(file1, fileNameForProfile, fileNameForProfile);
                    }

                    private void a(File file3, String oldFileName, String newFileName) {
                        File file4 = new File(worldPlayersDirectory, oldFileName + ".dat");
                        File file5 = new File(file3, newFileName + ".dat");
                        NBTTagCompound root = null;
                        try {
                            root = NBTCompressedStreamTools.a(new FileInputStream(file4), NBTReadLimiter.a());
                        }
                        catch (Exception exception) {
                            StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                            exception.printStackTrace();
                            ServerInternalException.reportInternalException((Throwable)exception);
                        }
                        if (root != null) {
                            if (!root.b("bukkit")) {
                                root.a("bukkit", new NBTTagCompound());
                            }
                            NBTTagCompound data = root.n("bukkit");
                            data.a("lastKnownName", oldFileName);
                            try {
                                NBTCompressedStreamTools.a(root, new FileOutputStream(file1));
                            }
                            catch (Exception exception) {
                                StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                                exception.printStackTrace();
                                ServerInternalException.reportInternalException((Throwable)exception);
                            }
                        }
                        NameReferencingFileConverter.a(file3);
                        if (!file4.renameTo(file5)) {
                            throw new FileConversionException("Could not convert file for " + oldFileName);
                        }
                    }

                    private String a(String profileName) {
                        String string = null;
                        for (String string1 : this.val$strings) {
                            if (string1 == null || !string1.equalsIgnoreCase(profileName)) continue;
                            string = string1;
                            break;
                        }
                        if (string == null) {
                            throw new FileConversionException("Could not find the filename for " + profileName + " anymore");
                        }
                        return string;
                    }
                };
                NameReferencingFileConverter.a(server, Lists.newArrayList((Object[])strings), profileLookupCallback);
                return true;
            }
            catch (FileConversionException var12) {
                e.error("Conversion failed, please try again later", (Throwable)var12);
                return false;
            }
        }
        return true;
    }

    static void a(File dir) {
        if (dir.exists() ? !dir.isDirectory() : !dir.mkdirs()) {
            throw new FileConversionException("Can't create directory " + dir.getName() + " in world save directory.");
        }
    }

    public static boolean e(MinecraftServer server) {
        boolean flag = NameReferencingFileConverter.a();
        return flag && NameReferencingFileConverter.f(server);
    }

    private static boolean a() {
        boolean flag = false;
        if (b.exists() && b.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (a.exists() && a.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (c.exists() && c.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (d.exists() && d.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        e.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        e.warn("** please remove the following files and restart the server:");
        if (flag) {
            e.warn("* {}", (Object)b.getName());
        }
        if (flag1) {
            e.warn("* {}", (Object)a.getName());
        }
        if (flag2) {
            e.warn("* {}", (Object)c.getName());
        }
        if (flag3) {
            e.warn("* {}", (Object)d.getName());
        }
        return false;
    }

    private static boolean f(MinecraftServer server) {
        File worldPlayersDirectory = NameReferencingFileConverter.g(server);
        if (!worldPlayersDirectory.exists() || !worldPlayersDirectory.isDirectory() || worldPlayersDirectory.list().length <= 0 && worldPlayersDirectory.delete()) {
            return true;
        }
        e.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
        e.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
        e.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)worldPlayersDirectory.getPath());
        return false;
    }

    private static File g(MinecraftServer server) {
        return server.a(SavedFile.d).toFile();
    }

    private static void b(File convertedFile) {
        File file = new File(convertedFile.getName() + ".converted");
        convertedFile.renameTo(file);
    }

    static Date a(String input, Date defaultValue) {
        Date date;
        try {
            date = ExpirableListEntry.a.parse(input);
        }
        catch (ParseException var4) {
            date = defaultValue;
        }
        return date;
    }

    static class FileConversionException
    extends RuntimeException {
        FileConversionException(String message, Throwable cause) {
            super(message, cause);
        }

        FileConversionException(String message) {
            super(message);
        }
    }
}

