/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class UserCache {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 1000;
    private static final int c = 1;
    private static boolean d;
    private final Map<String, UserCacheEntry> e = Maps.newConcurrentMap();
    private final Map<UUID, UserCacheEntry> f = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> g = Maps.newConcurrentMap();
    private final GameProfileRepository h;
    private final Gson i = new GsonBuilder().create();
    private final File j;
    private final AtomicLong k = new AtomicLong();
    @Nullable
    private Executor l;
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public UserCache(GameProfileRepository profileRepository, File file) {
        this.h = profileRepository;
        this.j = file;
        Lists.reverse(this.b()).forEach(this::a);
    }

    private void a(UserCacheEntry profile) {
        try {
            this.stateLock.lock();
            GameProfile profile1 = profile.a();
            profile.a(this.e());
            this.e.put(profile1.getName().toLowerCase(Locale.ROOT), profile);
            this.f.put(profile1.getId(), profile);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static Optional<GameProfile> a(GameProfileRepository profileRepo, String name) {
        if (!UtilColor.f(name)) {
            return UserCache.c(name);
        }
        boolean shouldLookup = !StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode();
        Optional<GameProfile> optional = shouldLookup ? profileRepo.findProfileByName(name) : Optional.empty();
        return optional.isEmpty() ? UserCache.c(name) : optional;
    }

    private static Optional<GameProfile> c(String profileName) {
        return UserCache.d() ? Optional.empty() : Optional.of(UUIDUtil.b(profileName));
    }

    public static void a(boolean onlineMode) {
        d = onlineMode;
    }

    private static boolean d() {
        return GlobalConfiguration.get().proxies.isProxyOnlineMode();
    }

    public void a(GameProfile gameProfile) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(2, 1);
        Date time = instance.getTime();
        UserCacheEntry gameProfileInfo = new UserCacheEntry(gameProfile, time);
        this.a(gameProfileInfo);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
    }

    private long e() {
        return this.k.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GameProfile getProfileIfCached(String name) {
        try {
            this.stateLock.lock();
            UserCacheEntry entry = this.e.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                GameProfile gameProfile = null;
                return gameProfile;
            }
            entry.a(this.e());
            GameProfile gameProfile = entry.a();
            return gameProfile;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> a(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<GameProfile> optional;
            this.stateLock.lock();
            UserCacheEntry gameProfileInfo = this.e.get(string);
            boolean flag = false;
            if (gameProfileInfo != null && new Date().getTime() >= gameProfileInfo.b.getTime()) {
                this.f.remove(gameProfileInfo.a().getId());
                this.e.remove(gameProfileInfo.a().getName().toLowerCase(Locale.ROOT));
                flag = true;
                gameProfileInfo = null;
            }
            if (gameProfileInfo != null) {
                gameProfileInfo.a(this.e());
                optional = Optional.of(gameProfileInfo.a());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional = UserCache.a(this.h, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional.isPresent()) {
                    this.a(optional.get());
                    flag = false;
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<GameProfile> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    public CompletableFuture<Optional<GameProfile>> b(String name) {
        if (this.l == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completableFuture = this.g.get(name);
        if (completableFuture != null) {
            return completableFuture;
        }
        CompletionStage completableFuture1 = CompletableFuture.supplyAsync(() -> this.a(name), SystemUtils.PROFILE_EXECUTOR).whenCompleteAsync((gameProfile, exception) -> this.g.remove(name), this.l);
        this.g.put(name, (CompletableFuture<Optional<GameProfile>>)completableFuture1);
        return completableFuture1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> a(UUID uuid) {
        try {
            this.stateLock.lock();
            UserCacheEntry gameProfileInfo = this.f.get(uuid);
            if (gameProfileInfo == null) {
                Optional<GameProfile> optional = Optional.empty();
                return optional;
            }
            gameProfileInfo.a(this.e());
            Optional<GameProfile> optional = Optional.of(gameProfileInfo.a());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void a(Executor exectutor) {
        this.l = exectutor;
    }

    public void a() {
        this.l = null;
    }

    private static DateFormat f() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UserCacheEntry> b() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader = Files.newReader((File)this.j, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.i.fromJson((Reader)reader, JsonArray.class);
            if (jsonArray != null) {
                DateFormat dateFormat = UserCache.f();
                jsonArray.forEach(json -> UserCache.a(json, dateFormat).ifPresent(list::add));
                ArrayList arrayList = list;
                return arrayList;
            }
            ArrayList var9 = list;
            return var9;
        }
        catch (FileNotFoundException var9) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            a.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
            this.j.delete();
            return list;
        }
        catch (JsonParseException | IOException var8) {
            a.warn("Failed to load profile cache {}", (Object)this.j, (Object)var8);
        }
        return list;
    }

    public void save(boolean asyncSave) {
        JsonArray jsonArray = new JsonArray();
        DateFormat dateFormat = UserCache.f();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(info -> jsonArray.add(UserCache.a(info, dateFormat)));
        String string = this.i.toJson((JsonElement)jsonArray);
        Runnable save = () -> {
            try (BufferedWriter writer = Files.newWriter((File)this.j, (Charset)StandardCharsets.UTF_8);){
                writer.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<UserCacheEntry> a(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<UserCacheEntry> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<UserCacheEntry> list = this.f.values().stream().sorted(Comparator.comparing(UserCacheEntry::c).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement a(UserCacheEntry profileInfo, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", profileInfo.a().getName());
        jsonObject.addProperty("uuid", profileInfo.a().getId().toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(profileInfo.b()));
        return jsonObject;
    }

    private static Optional<UserCacheEntry> a(JsonElement json, DateFormat dateFormat) {
        if (json.isJsonObject()) {
            JsonObject asJsonObject = json.getAsJsonObject();
            JsonElement jsonElement = asJsonObject.get("name");
            JsonElement jsonElement1 = asJsonObject.get("uuid");
            JsonElement jsonElement2 = asJsonObject.get("expiresOn");
            if (jsonElement != null && jsonElement1 != null) {
                String asString = jsonElement1.getAsString();
                String asString1 = jsonElement.getAsString();
                Date date = null;
                if (jsonElement2 != null) {
                    try {
                        date = dateFormat.parse(jsonElement2.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (asString1 != null && asString != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(asString);
                    }
                    catch (Throwable var11) {
                        return Optional.empty();
                    }
                    return Optional.of(new UserCacheEntry(new GameProfile(uuid, asString1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static class UserCacheEntry {
        private final GameProfile a;
        final Date b;
        private volatile long c;

        UserCacheEntry(GameProfile profile, Date expirationDate) {
            this.a = profile;
            this.b = expirationDate;
        }

        public GameProfile a() {
            return this.a;
        }

        public Date b() {
            return this.b;
        }

        public void a(long lastAccess) {
            this.c = lastAccess;
        }

        public long c() {
            return this.c;
        }
    }
}

