/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<PacketDataSerializer, RecipeBookSettings> a = StreamCodec.a(RecipeBookSettings::b, RecipeBookSettings::a);
    private static final Map<RecipeBookType, Pair<String, String>> b = ImmutableMap.of((Object)((Object)RecipeBookType.a), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.b), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.c), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.d), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, a> c;

    private RecipeBookSettings(Map<RecipeBookType, a> states) {
        this.c = states;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, a>(RecipeBookType.class));
    }

    private a c(RecipeBookType type) {
        return this.c.getOrDefault((Object)type, net.minecraft.stats.RecipeBookSettings$a.a);
    }

    private void a(RecipeBookType type, UnaryOperator<a> updater) {
        this.c.compute(type, (recipeBookType, typeSettings) -> {
            if (typeSettings == null) {
                typeSettings = net.minecraft.stats.RecipeBookSettings$a.a;
            }
            if ((typeSettings = (a)updater.apply((a)typeSettings)).equals(net.minecraft.stats.RecipeBookSettings$a.a)) {
                typeSettings = null;
            }
            return typeSettings;
        });
    }

    public boolean a(RecipeBookType bookType) {
        return this.c((RecipeBookType)bookType).b;
    }

    public void a(RecipeBookType bookType, boolean _open) {
        this.a(bookType, settings -> settings.a(_open));
    }

    public boolean b(RecipeBookType bookType) {
        return this.c((RecipeBookType)bookType).c;
    }

    public void b(RecipeBookType bookType, boolean filtering) {
        this.a(bookType, settings -> settings.b(filtering));
    }

    private static RecipeBookSettings a(PacketDataSerializer buffer) {
        EnumMap<RecipeBookType, a> map = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean _boolean = buffer.readBoolean();
            boolean _boolean1 = buffer.readBoolean();
            if (!_boolean && !_boolean1) continue;
            map.put(recipeBookType, new a(_boolean, _boolean1));
        }
        return new RecipeBookSettings(map);
    }

    private void b(PacketDataSerializer buffer) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            a typeSettings = this.c.getOrDefault((Object)recipeBookType, net.minecraft.stats.RecipeBookSettings$a.a);
            buffer.a(typeSettings.b);
            buffer.a(typeSettings.c);
        }
    }

    public static RecipeBookSettings a(NBTTagCompound tag) {
        EnumMap<RecipeBookType, a> map = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        b.forEach((type, settings) -> {
            boolean booleanOr = tag.b((String)settings.getFirst(), net.minecraft.stats.RecipeBookSettings$a.a.a());
            boolean booleanOr1 = tag.b((String)settings.getSecond(), net.minecraft.stats.RecipeBookSettings$a.a.b());
            if (booleanOr || booleanOr1) {
                map.put((RecipeBookType)((Object)type), new a(booleanOr, booleanOr1));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void b(NBTTagCompound tag) {
        b.forEach((type, settings) -> {
            a typeSettings = this.c.getOrDefault(type, net.minecraft.stats.RecipeBookSettings$a.a);
            tag.a((String)settings.getFirst(), typeSettings.b);
            tag.a((String)settings.getSecond(), typeSettings.c);
        });
    }

    public RecipeBookSettings a() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, a>(this.c));
    }

    public void a(RecipeBookSettings other) {
        this.c.clear();
        this.c.putAll(other.c);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RecipeBookSettings && this.c.equals(((RecipeBookSettings)other).c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    static final class a
    extends Record {
        private final boolean b;
        private final boolean c;
        public static final a a = new a(false, false);

        a(boolean open, boolean filtering) {
            this.b = open;
            this.c = filtering;
        }

        @Override
        public String toString() {
            return "[open=" + this.b + ", filtering=" + this.c + "]";
        }

        public a a(boolean _open) {
            return new a(_open, this.c);
        }

        public a b(boolean filtering) {
            return new a(this.b, filtering);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "open;filtering", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "open;filtering", "b", "c"}, this, o2);
        }

        public boolean a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }
}

