/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.primitives.Longs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.CryptographyException;

public class MinecraftEncryption {
    private static final String h = "AES";
    private static final int i = 128;
    private static final String j = "RSA";
    private static final int k = 1024;
    private static final String l = "ISO_8859_1";
    private static final String m = "SHA-1";
    public static final String a = "SHA256withRSA";
    public static final int b = 256;
    private static final String n = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String o = "-----END RSA PRIVATE KEY-----";
    public static final String c = "-----BEGIN RSA PUBLIC KEY-----";
    private static final String p = "-----END RSA PUBLIC KEY-----";
    public static final String d = "\n";
    public static final Base64.Encoder e = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
    public static final Codec<PublicKey> f = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)MinecraftEncryption.b(string));
        }
        catch (CryptographyException var2) {
            return DataResult.error(var2::getMessage);
        }
    }, MinecraftEncryption::a);
    public static final Codec<PrivateKey> g = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)MinecraftEncryption.a(string));
        }
        catch (CryptographyException var2) {
            return DataResult.error(var2::getMessage);
        }
    }, MinecraftEncryption::a);

    public static SecretKey a() throws CryptographyException {
        try {
            KeyGenerator instance = KeyGenerator.getInstance(h);
            instance.init(128);
            return instance.generateKey();
        }
        catch (Exception var1) {
            throw new CryptographyException(var1);
        }
    }

    public static KeyPair b() throws CryptographyException {
        try {
            KeyPairGenerator instance = KeyPairGenerator.getInstance(j);
            instance.initialize(1024);
            return instance.generateKeyPair();
        }
        catch (Exception var1) {
            throw new CryptographyException(var1);
        }
    }

    public static byte[] a(String serverId, PublicKey publicKey, SecretKey secretKey) throws CryptographyException {
        try {
            return MinecraftEncryption.a(serverId.getBytes(l), secretKey.getEncoded(), publicKey.getEncoded());
        }
        catch (Exception var4) {
            throw new CryptographyException(var4);
        }
    }

    private static byte[] a(byte[] ... data) throws Exception {
        MessageDigest instance = MessageDigest.getInstance(m);
        for (byte[] bytes : data) {
            instance.update(bytes);
        }
        return instance.digest();
    }

    private static <T extends Key> T a(String keyBase64, String header, String footer, a<T> keyFunction) throws CryptographyException {
        int index = keyBase64.indexOf(header);
        if (index != -1) {
            int index1 = keyBase64.indexOf(footer, index += header.length());
            keyBase64 = keyBase64.substring(index, index1 + 1);
        }
        try {
            return keyFunction.apply(Base64.getMimeDecoder().decode(keyBase64));
        }
        catch (IllegalArgumentException var6) {
            throw new CryptographyException(var6);
        }
    }

    public static PrivateKey a(String keyBase64) throws CryptographyException {
        return MinecraftEncryption.a(keyBase64, n, o, MinecraftEncryption::b);
    }

    public static PublicKey b(String keyBase64) throws CryptographyException {
        return MinecraftEncryption.a(keyBase64, c, p, MinecraftEncryption::a);
    }

    public static String a(PublicKey key) {
        if (!j.equals(key.getAlgorithm())) {
            throw new IllegalArgumentException("Public key must be RSA");
        }
        return "-----BEGIN RSA PUBLIC KEY-----\n" + e.encodeToString(key.getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
    }

    public static String a(PrivateKey key) {
        if (!j.equals(key.getAlgorithm())) {
            throw new IllegalArgumentException("Private key must be RSA");
        }
        return "-----BEGIN RSA PRIVATE KEY-----\n" + e.encodeToString(key.getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
    }

    private static PrivateKey b(byte[] keyBytes) throws CryptographyException {
        try {
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory instance = KeyFactory.getInstance(j);
            return instance.generatePrivate(encodedKeySpec);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    public static PublicKey a(byte[] encodedKey) throws CryptographyException {
        try {
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory instance = KeyFactory.getInstance(j);
            return instance.generatePublic(encodedKeySpec);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    public static SecretKey a(PrivateKey key, byte[] secretKeyEncrypted) throws CryptographyException {
        byte[] bytes = MinecraftEncryption.b(key, secretKeyEncrypted);
        try {
            return new SecretKeySpec(bytes, h);
        }
        catch (Exception var4) {
            throw new CryptographyException(var4);
        }
    }

    public static byte[] a(Key key, byte[] data) throws CryptographyException {
        return MinecraftEncryption.a(1, key, data);
    }

    public static byte[] b(Key key, byte[] data) throws CryptographyException {
        return MinecraftEncryption.a(2, key, data);
    }

    private static byte[] a(int opMode, Key key, byte[] data) throws CryptographyException {
        try {
            return MinecraftEncryption.a(opMode, key.getAlgorithm(), key).doFinal(data);
        }
        catch (Exception var4) {
            throw new CryptographyException(var4);
        }
    }

    private static Cipher a(int opMode, String transformation, Key key) throws Exception {
        Cipher instance = Cipher.getInstance(transformation);
        instance.init(opMode, key);
        return instance;
    }

    public static Cipher a(int opMode, Key key) throws CryptographyException {
        try {
            Cipher instance = Cipher.getInstance("AES/CFB8/NoPadding");
            instance.init(opMode, key, new IvParameterSpec(key.getEncoded()));
            return instance;
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    static interface a<T extends Key> {
        public T apply(byte[] var1) throws CryptographyException;
    }

    public static class c {
        private static final SecureRandom a = new SecureRandom();

        public static long a() {
            return a.nextLong();
        }
    }

    public record b(long b, byte[] c) {
        private final long b;
        private final byte[] c;
        public static final b a = new b(0L, ByteArrays.EMPTY_ARRAY);

        public b(PacketDataSerializer buffer) {
            this(buffer.readLong(), buffer.b());
        }

        public boolean a() {
            return this.c.length > 0;
        }

        public static void a(PacketDataSerializer buffer, b signaturePair) {
            buffer.b(signaturePair.b);
            buffer.a(signaturePair.c);
        }

        public byte[] b() {
            return Longs.toByteArray((long)this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "salt;signature", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "salt;signature", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "salt;signature", "b", "c"}, this, o2);
        }

        public long c() {
            return this.b;
        }

        public byte[] d() {
            return this.c;
        }
    }
}

