/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.CrashReportSystemDetails;
import org.slf4j.Logger;

public class NativeModuleLister {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 65535;
    private static final int c = 1033;
    private static final int d = -65536;
    private static final int e = 0x4B00000;

    public static List<a> a() {
        if (!Platform.isWindows()) {
            return ImmutableList.of();
        }
        int i2 = Kernel32.INSTANCE.GetCurrentProcessId();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tlhelp32.MODULEENTRY32W moduleentry32w : Kernel32Util.getModules((int)i2)) {
            String string = moduleentry32w.szModule();
            Optional<b> optional = NativeModuleLister.a(moduleentry32w.szExePath());
            builder.add((Object)new a(string, optional));
        }
        return builder.build();
    }

    private static Optional<b> a(String filename) {
        try {
            IntByReference intByReference = new IntByReference();
            int i2 = Version.INSTANCE.GetFileVersionInfoSize(filename, intByReference);
            if (i2 == 0) {
                int lastError = Native.getLastError();
                if (lastError != 1813 && lastError != 1812) {
                    throw new Win32Exception(lastError);
                }
                return Optional.empty();
            }
            Memory pointer = new Memory((long)i2);
            if (!Version.INSTANCE.GetFileVersionInfo(filename, 0, i2, (Pointer)pointer)) {
                throw new Win32Exception(Native.getLastError());
            }
            IntByReference intByReference1 = new IntByReference();
            Pointer pointer1 = NativeModuleLister.a((Pointer)pointer, "\\VarFileInfo\\Translation", intByReference1);
            int[] intArray = pointer1.getIntArray(0L, intByReference1.getValue() / 4);
            OptionalInt optionalInt = NativeModuleLister.a(intArray);
            if (optionalInt.isEmpty()) {
                return Optional.empty();
            }
            int asInt = optionalInt.getAsInt();
            int i1 = asInt & 0xFFFF;
            int i22 = (asInt & 0xFFFF0000) >> 16;
            String string = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("FileDescription", i1, i22), intByReference1);
            String string1 = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("CompanyName", i1, i22), intByReference1);
            String string2 = NativeModuleLister.b((Pointer)pointer, NativeModuleLister.a("FileVersion", i1, i22), intByReference1);
            return Optional.of(new b(string, string2, string1));
        }
        catch (Exception var14) {
            a.info("Failed to find module info for {}", (Object)filename, (Object)var14);
            return Optional.empty();
        }
    }

    private static String a(String key, int lang, int codepage) {
        return String.format(Locale.ROOT, "\\StringFileInfo\\%04x%04x\\%s", lang, codepage, key);
    }

    private static OptionalInt a(int[] versionValue) {
        OptionalInt optionalInt = OptionalInt.empty();
        for (int i2 : versionValue) {
            if ((i2 & 0xFFFF0000) == 0x4B00000 && (i2 & 0xFFFF) == 1033) {
                return OptionalInt.of(i2);
            }
            optionalInt = OptionalInt.of(i2);
        }
        return optionalInt;
    }

    private static Pointer a(Pointer block, String subBlock, IntByReference size) {
        PointerByReference pointerByReference = new PointerByReference();
        if (!Version.INSTANCE.VerQueryValue(block, subBlock, pointerByReference, size)) {
            throw new UnsupportedOperationException("Can't get version value " + subBlock);
        }
        return pointerByReference.getValue();
    }

    private static String b(Pointer block, String subBlock, IntByReference size) {
        try {
            Pointer pointer = NativeModuleLister.a(block, subBlock, size);
            byte[] byteArray = pointer.getByteArray(0L, (size.getValue() - 1) * 2);
            return new String(byteArray, StandardCharsets.UTF_16LE);
        }
        catch (Exception var5) {
            return "";
        }
    }

    public static void a(CrashReportSystemDetails crashSection) {
        crashSection.a("Modules", () -> NativeModuleLister.a().stream().sorted(Comparator.comparing(nativeModuleInfo -> nativeModuleInfo.a)).map(nativeModuleInfo -> "\n\t\t" + String.valueOf(nativeModuleInfo)).collect(Collectors.joining()));
    }

    public static class a {
        public final String a;
        public final Optional<b> b;

        public a(String name, Optional<b> version) {
            this.a = name;
            this.b = version;
        }

        public String toString() {
            return this.b.map(nativeModuleVersion -> this.a + ":" + String.valueOf(nativeModuleVersion)).orElse(this.a);
        }
    }

    public static class b {
        public final String a;
        public final String b;
        public final String c;

        public b(String description, String version, String company) {
            this.a = description;
            this.b = version;
            this.c = company;
        }

        public String toString() {
            return this.a + ":" + this.b + ":" + this.c;
        }
    }
}

