/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.function.Consumer;

public class StaticCache2D<T> {
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final Object[] e;

    public static <T> StaticCache2D<T> a(int centerX, int centerZ, int size, a<T> initializer) {
        int i2 = centerX - size;
        int i1 = centerZ - size;
        int i22 = 2 * size + 1;
        return new StaticCache2D<T>(i2, i1, i22, i22, initializer);
    }

    private StaticCache2D(int minX, int minZ, int sizeX, int sizeZ, a<T> initializer) {
        this.a = minX;
        this.b = minZ;
        this.c = sizeX;
        this.d = sizeZ;
        this.e = new Object[this.c * this.d];
        for (int i2 = minX; i2 < minX + sizeX; ++i2) {
            for (int i1 = minZ; i1 < minZ + sizeZ; ++i1) {
                this.e[this.c((int)i2, (int)i1)] = initializer.get(i2, i1);
            }
        }
    }

    public void a(Consumer<T> action) {
        for (Object object : this.e) {
            action.accept(object);
        }
    }

    public T a(int x2, int z2) {
        if (!this.b(x2, z2)) {
            throw new IllegalArgumentException("Requested out of range value (" + x2 + "," + z2 + ") from " + String.valueOf(this));
        }
        return (T)this.e[this.c(x2, z2)];
    }

    public boolean b(int x2, int z2) {
        int i2 = x2 - this.a;
        int i1 = z2 - this.b;
        return i2 >= 0 && i2 < this.c && i1 >= 0 && i1 < this.d;
    }

    public String toString() {
        return String.format(Locale.ROOT, "StaticCache2D[%d, %d, %d, %d]", this.a, this.b, this.a + this.c, this.b + this.d);
    }

    private int c(int x2, int z2) {
        int i2 = x2 - this.a;
        int i1 = z2 - this.b;
        return i2 * this.d + i1;
    }

    @FunctionalInterface
    public static interface a<T> {
        public T get(int var1, int var2);
    }
}

