/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudDurationScaleFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudPotionFix;
import net.minecraft.util.datafix.fixes.AttributeIdPrefixFix;
import net.minecraft.util.datafix.fixes.AttributeModifierIdFix;
import net.minecraft.util.datafix.fixes.BannerEntityCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.BeehiveFieldRenameFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockEntityFurnaceBurnTimeFix;
import net.minecraft.util.datafix.fixes.BlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.BlockPosFormatAndRenamesFix;
import net.minecraft.util.datafix.fixes.BlockPropertyRenameAndFix;
import net.minecraft.util.datafix.fixes.BoatSplitFix;
import net.minecraft.util.datafix.fixes.CarvingStepRemoveFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChestedHorsesInventoryZeroIndexingFix;
import net.minecraft.util.datafix.fixes.ChunkConverterPalette;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteLightFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkTicketUnpackPosFix;
import net.minecraft.util.datafix.fixes.ContainerBlockEntityLockPredicateFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.CustomModelDataExpandFix;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterAdvancement;
import net.minecraft.util.datafix.fixes.DataConverterAdvancementBase;
import net.minecraft.util.datafix.fixes.DataConverterArmorStand;
import net.minecraft.util.datafix.fixes.DataConverterAttributes;
import net.minecraft.util.datafix.fixes.DataConverterBanner;
import net.minecraft.util.datafix.fixes.DataConverterBannerColour;
import net.minecraft.util.datafix.fixes.DataConverterBedBlock;
import net.minecraft.util.datafix.fixes.DataConverterBedItem;
import net.minecraft.util.datafix.fixes.DataConverterBiome;
import net.minecraft.util.datafix.fixes.DataConverterBitStorageAlign;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterBlockName;
import net.minecraft.util.datafix.fixes.DataConverterBlockRename;
import net.minecraft.util.datafix.fixes.DataConverterCatType;
import net.minecraft.util.datafix.fixes.DataConverterChunkLightRemove;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus2;
import net.minecraft.util.datafix.fixes.DataConverterChunkStructuresTemplateRename;
import net.minecraft.util.datafix.fixes.DataConverterColorlessShulkerEntity;
import net.minecraft.util.datafix.fixes.DataConverterCoral;
import net.minecraft.util.datafix.fixes.DataConverterCoralFan;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameEntity;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameItem;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameTile;
import net.minecraft.util.datafix.fixes.DataConverterDropChances;
import net.minecraft.util.datafix.fixes.DataConverterDye;
import net.minecraft.util.datafix.fixes.DataConverterEntity;
import net.minecraft.util.datafix.fixes.DataConverterEntityBlockState;
import net.minecraft.util.datafix.fixes.DataConverterEntityCatSplit;
import net.minecraft.util.datafix.fixes.DataConverterEntityCodSalmon;
import net.minecraft.util.datafix.fixes.DataConverterEntityProjectileOwner;
import net.minecraft.util.datafix.fixes.DataConverterEntityPufferfish;
import net.minecraft.util.datafix.fixes.DataConverterEntityRavagerRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityShulkerRotation;
import net.minecraft.util.datafix.fixes.DataConverterEntityTippedArrow;
import net.minecraft.util.datafix.fixes.DataConverterEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterEntityZombifiedPiglinRename;
import net.minecraft.util.datafix.fixes.DataConverterEquipment;
import net.minecraft.util.datafix.fixes.DataConverterFlatten;
import net.minecraft.util.datafix.fixes.DataConverterFlattenSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterFlattenState;
import net.minecraft.util.datafix.fixes.DataConverterFurnaceRecipesUsed;
import net.minecraft.util.datafix.fixes.DataConverterGossip;
import net.minecraft.util.datafix.fixes.DataConverterGuardian;
import net.minecraft.util.datafix.fixes.DataConverterHanging;
import net.minecraft.util.datafix.fixes.DataConverterHealth;
import net.minecraft.util.datafix.fixes.DataConverterHeightmapRenaming;
import net.minecraft.util.datafix.fixes.DataConverterHorse;
import net.minecraft.util.datafix.fixes.DataConverterIglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.DataConverterItemFrame;
import net.minecraft.util.datafix.fixes.DataConverterItemLoreComponentize;
import net.minecraft.util.datafix.fixes.DataConverterItemName;
import net.minecraft.util.datafix.fixes.DataConverterItemStackEnchantment;
import net.minecraft.util.datafix.fixes.DataConverterItemStackUUID;
import net.minecraft.util.datafix.fixes.DataConverterJigsawProperties;
import net.minecraft.util.datafix.fixes.DataConverterJigsawRotation;
import net.minecraft.util.datafix.fixes.DataConverterJukeBox;
import net.minecraft.util.datafix.fixes.DataConverterKeybind;
import net.minecraft.util.datafix.fixes.DataConverterKeybind2;
import net.minecraft.util.datafix.fixes.DataConverterLang;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterLeavesBiome;
import net.minecraft.util.datafix.fixes.DataConverterLevelDataGeneratorOptions;
import net.minecraft.util.datafix.fixes.DataConverterMap;
import net.minecraft.util.datafix.fixes.DataConverterMapId;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterMemoryExpiry;
import net.minecraft.util.datafix.fixes.DataConverterMinecart;
import net.minecraft.util.datafix.fixes.DataConverterMiscUUID;
import net.minecraft.util.datafix.fixes.DataConverterMissingDimension;
import net.minecraft.util.datafix.fixes.DataConverterMobSpawner;
import net.minecraft.util.datafix.fixes.DataConverterNewVillage;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveRenderType;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerBlockEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerRename;
import net.minecraft.util.datafix.fixes.DataConverterOptionsAddTextBackground;
import net.minecraft.util.datafix.fixes.DataConverterPOI;
import net.minecraft.util.datafix.fixes.DataConverterPOIRebuild;
import net.minecraft.util.datafix.fixes.DataConverterPainting;
import net.minecraft.util.datafix.fixes.DataConverterPiston;
import net.minecraft.util.datafix.fixes.DataConverterPlayerUUID;
import net.minecraft.util.datafix.fixes.DataConverterPotionId;
import net.minecraft.util.datafix.fixes.DataConverterPotionWater;
import net.minecraft.util.datafix.fixes.DataConverterProtoChunk;
import net.minecraft.util.datafix.fixes.DataConverterRecipeRename;
import net.minecraft.util.datafix.fixes.DataConverterRecipes;
import net.minecraft.util.datafix.fixes.DataConverterRedstoneConnections;
import net.minecraft.util.datafix.fixes.DataConverterRemoveGolemGossip;
import net.minecraft.util.datafix.fixes.DataConverterRiding;
import net.minecraft.util.datafix.fixes.DataConverterSaddle;
import net.minecraft.util.datafix.fixes.DataConverterSavedDataUUID;
import net.minecraft.util.datafix.fixes.DataConverterSettingRename;
import net.minecraft.util.datafix.fixes.DataConverterShoulderEntity;
import net.minecraft.util.datafix.fixes.DataConverterShulker;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxBlock;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxItem;
import net.minecraft.util.datafix.fixes.DataConverterSkeleton;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterStatistic;
import net.minecraft.util.datafix.fixes.DataConverterStriderGravity;
import net.minecraft.util.datafix.fixes.DataConverterStructureReference;
import net.minecraft.util.datafix.fixes.DataConverterTileEntity;
import net.minecraft.util.datafix.fixes.DataConverterTrappedChest;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUID;
import net.minecraft.util.datafix.fixes.DataConverterVBO;
import net.minecraft.util.datafix.fixes.DataConverterVillagerFollowRange;
import net.minecraft.util.datafix.fixes.DataConverterVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DataConverterVillagerProfession;
import net.minecraft.util.datafix.fixes.DataConverterVillagerTrade;
import net.minecraft.util.datafix.fixes.DataConverterWallProperty;
import net.minecraft.util.datafix.fixes.DataConverterWolf;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettings;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.fixes.DataConverterZombie;
import net.minecraft.util.datafix.fixes.DataConverterZombieType;
import net.minecraft.util.datafix.fixes.DataConverterZombieVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DecoratedPotFieldRenameFix;
import net.minecraft.util.datafix.fixes.DropChancesFormatFix;
import net.minecraft.util.datafix.fixes.DropInvalidSignDataFix;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EmptyItemInHotbarFix;
import net.minecraft.util.datafix.fixes.EmptyItemInVillagerTradeFix;
import net.minecraft.util.datafix.fixes.EntityAttributeBaseValueFix;
import net.minecraft.util.datafix.fixes.EntityBrushableBlockFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityFallDistanceFloatToDoubleFix;
import net.minecraft.util.datafix.fixes.EntityFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntitySalmonSizeFix;
import net.minecraft.util.datafix.fixes.EntitySpawnerItemVariantComponentFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.EquipmentFormatFix;
import net.minecraft.util.datafix.fixes.EquippableAssetRenameFix;
import net.minecraft.util.datafix.fixes.FeatureFlagRemoveFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.FireResistantToDamageResistantComponentFix;
import net.minecraft.util.datafix.fixes.FixProjectileStoredItem;
import net.minecraft.util.datafix.fixes.FixWolfHealth;
import net.minecraft.util.datafix.fixes.FoodToConsumableFix;
import net.minecraft.util.datafix.fixes.ForcedChunkToTicketFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.HorseBodyArmorItemFix;
import net.minecraft.util.datafix.fixes.InlineBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.InvalidBlockEntityLockFix;
import net.minecraft.util.datafix.fixes.InvalidLockComponentFix;
import net.minecraft.util.datafix.fixes.ItemRemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.ItemStackCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.JukeboxTicksSinceSongStartedFix;
import net.minecraft.util.datafix.fixes.LegacyDragonFightFix;
import net.minecraft.util.datafix.fixes.LegacyHoverEventFix;
import net.minecraft.util.datafix.fixes.LevelLegacyWorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.LockComponentPredicateFix;
import net.minecraft.util.datafix.fixes.LodestoneCompassComponentFix;
import net.minecraft.util.datafix.fixes.MapBannerBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.MobEffectIdFix;
import net.minecraft.util.datafix.fixes.NamedEntityConvertUncheckedFix;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRarityFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsMenuBlurrinessFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.ParticleUnflatteningFix;
import net.minecraft.util.datafix.fixes.PlayerEquipmentFix;
import net.minecraft.util.datafix.fixes.PlayerHeadBlockProfileFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.PrimedTntBlockStateFixer;
import net.minecraft.util.datafix.fixes.ProjectileStoredWeaponFix;
import net.minecraft.util.datafix.fixes.RaidRenamesDataFix;
import net.minecraft.util.datafix.fixes.RandomSequenceSettingsFix;
import net.minecraft.util.datafix.fixes.RemapChunkStatusFix;
import net.minecraft.util.datafix.fixes.RemoveEmptyItemInBrushableBlockFix;
import net.minecraft.util.datafix.fixes.RenameEnchantmentsFix;
import net.minecraft.util.datafix.fixes.SaddleEquipmentSlotFix;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplayNameFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplaySlotFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TextComponentHoverAndClickEventFix;
import net.minecraft.util.datafix.fixes.TextComponentStrictJsonFix;
import net.minecraft.util.datafix.fixes.TextComponentStringifiedFlagsFix;
import net.minecraft.util.datafix.fixes.ThrownPotionSplitFix;
import net.minecraft.util.datafix.fixes.TippedArrowPotionToItemFix;
import net.minecraft.util.datafix.fixes.TooltipDisplayComponentFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix;
import net.minecraft.util.datafix.fixes.UnflattenTextComponentFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.VillagerSetCanPickUpLootFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV102;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1022;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV106;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV107;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1125;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV135;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV143;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_1;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_2;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_3;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_4;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_5;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_6;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1460;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1466;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1470;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1481;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1483;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1486;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1510;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1800;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1801;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1904;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1906;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1909;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1920;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1928;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1929;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1931;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2502;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2505;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2509;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2519;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2522;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2551;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2568;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV700;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV701;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV702;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV703;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV704;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV705;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV808;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;
import net.minecraft.util.datafix.schemas.V1458;
import net.minecraft.util.datafix.schemas.V1488;
import net.minecraft.util.datafix.schemas.V1925;
import net.minecraft.util.datafix.schemas.V2511_1;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;
import net.minecraft.util.datafix.schemas.V3438;
import net.minecraft.util.datafix.schemas.V3439;
import net.minecraft.util.datafix.schemas.V3448;
import net.minecraft.util.datafix.schemas.V3682;
import net.minecraft.util.datafix.schemas.V3683;
import net.minecraft.util.datafix.schemas.V3685;
import net.minecraft.util.datafix.schemas.V3689;
import net.minecraft.util.datafix.schemas.V3799;
import net.minecraft.util.datafix.schemas.V3807;
import net.minecraft.util.datafix.schemas.V3808;
import net.minecraft.util.datafix.schemas.V3808_1;
import net.minecraft.util.datafix.schemas.V3808_2;
import net.minecraft.util.datafix.schemas.V3813;
import net.minecraft.util.datafix.schemas.V3816;
import net.minecraft.util.datafix.schemas.V3818;
import net.minecraft.util.datafix.schemas.V3818_3;
import net.minecraft.util.datafix.schemas.V3818_4;
import net.minecraft.util.datafix.schemas.V3818_5;
import net.minecraft.util.datafix.schemas.V3825;
import net.minecraft.util.datafix.schemas.V3938;
import net.minecraft.util.datafix.schemas.V4059;
import net.minecraft.util.datafix.schemas.V4067;
import net.minecraft.util.datafix.schemas.V4070;
import net.minecraft.util.datafix.schemas.V4071;
import net.minecraft.util.datafix.schemas.V4290;
import net.minecraft.util.datafix.schemas.V4292;
import net.minecraft.util.datafix.schemas.V4300;
import net.minecraft.util.datafix.schemas.V4301;
import net.minecraft.util.datafix.schemas.V4302;
import net.minecraft.util.datafix.schemas.V4306;
import net.minecraft.util.datafix.schemas.V4307;
import net.minecraft.util.datafix.schemas.V4312;

public class DataConverterRegistry {
    private static final BiFunction<Integer, Schema, Schema> b = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> c = DataConverterSchemaNamed::new;
    private static final DataFixerBuilder.Result d = DataConverterRegistry.b();
    public static final int a = 4295;

    private DataConverterRegistry() {
    }

    public static DataFixer a() {
        return d.fixer();
    }

    private static DataFixerBuilder.Result b() {
        DataFixerBuilder dataFixerBuilder = new DataFixerBuilder(SharedConstants.b().d().c());
        DataConverterRegistry.a(dataFixerBuilder);
        return dataFixerBuilder.build();
    }

    public static CompletableFuture<?> a(Set<DSL.TypeReference> references) {
        if (references.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return d.optimize(references, singleThreadExecutor);
    }

    /*
     * WARNING - void declaration
     */
    private static void a(DataFixerBuilder builder) {
        void schema262;
        void schema261;
        void schema260;
        void schema259;
        void schema258;
        void schema257;
        void schema256;
        void schema255;
        void schema254;
        void schema253;
        void schema252;
        void schema251;
        void schema250;
        void schema249;
        void schema248;
        void schema247;
        builder.addSchema(99, DataConverterSchemaV99::new);
        Schema schema = builder.addSchema(100, DataConverterSchemaV100::new);
        builder.addFixer(new DataConverterEquipment(schema));
        Schema schema1 = builder.addSchema(101, b);
        builder.addFixer(new VillagerSetCanPickUpLootFix(schema1));
        Schema schema2 = builder.addSchema(102, DataConverterSchemaV102::new);
        builder.addFixer(new DataConverterMaterialId(schema2, true));
        builder.addFixer(new DataConverterPotionId(schema2, false));
        Schema schema3 = builder.addSchema(105, b);
        builder.addFixer(new DataConverterSpawnEgg(schema3, true));
        Schema schema4 = builder.addSchema(106, DataConverterSchemaV106::new);
        builder.addFixer(new DataConverterMobSpawner(schema4, true));
        Schema schema5 = builder.addSchema(107, DataConverterSchemaV107::new);
        builder.addFixer(new DataConverterMinecart(schema5));
        Schema schema6 = builder.addSchema(108, b);
        builder.addFixer(new DataConverterUUID(schema6, true));
        Schema schema7 = builder.addSchema(109, b);
        builder.addFixer(new DataConverterHealth(schema7, true));
        Schema schema8 = builder.addSchema(110, b);
        builder.addFixer(new DataConverterSaddle(schema8, true));
        Schema schema9 = builder.addSchema(111, b);
        builder.addFixer(new DataConverterHanging(schema9, true));
        Schema schema10 = builder.addSchema(113, b);
        builder.addFixer(new DataConverterDropChances(schema10, true));
        Schema schema11 = builder.addSchema(135, DataConverterSchemaV135::new);
        builder.addFixer(new DataConverterRiding(schema11, true));
        Schema schema12 = builder.addSchema(143, DataConverterSchemaV143::new);
        builder.addFixer(new DataConverterEntityTippedArrow(schema12, true));
        Schema schema13 = builder.addSchema(147, b);
        builder.addFixer(new DataConverterArmorStand(schema13, true));
        Schema schema14 = builder.addSchema(165, b);
        builder.addFixer(new TextComponentStrictJsonFix(schema14));
        Schema schema15 = builder.addSchema(501, DataConverterSchemaV501::new);
        builder.addFixer(new DataConverterAddChoices(schema15, "Add 1.10 entities fix", DataConverterTypes.D));
        Schema schema16 = builder.addSchema(502, b);
        builder.addFixer(DataConverterItemName.a(schema16, "cooked_fished item renamer", (String string) -> Objects.equals(DataConverterSchemaNamed.a(string), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : string));
        builder.addFixer(new DataConverterZombie(schema16, false));
        Schema schema17 = builder.addSchema(505, b);
        builder.addFixer(new DataConverterVBO(schema17, false));
        Schema schema18 = builder.addSchema(700, DataConverterSchemaV700::new);
        builder.addFixer(new DataConverterGuardian(schema18, true));
        Schema schema19 = builder.addSchema(701, DataConverterSchemaV701::new);
        builder.addFixer(new DataConverterSkeleton(schema19, true));
        Schema schema20 = builder.addSchema(702, DataConverterSchemaV702::new);
        builder.addFixer(new DataConverterZombieType(schema20));
        Schema schema21 = builder.addSchema(703, DataConverterSchemaV703::new);
        builder.addFixer(new DataConverterHorse(schema21, true));
        Schema schema22 = builder.addSchema(704, DataConverterSchemaV704::new);
        builder.addFixer(new DataConverterTileEntity(schema22, true));
        Schema schema23 = builder.addSchema(705, DataConverterSchemaV705::new);
        builder.addFixer(new DataConverterEntity(schema23, true));
        Schema schema24 = builder.addSchema(804, c);
        builder.addFixer(new DataConverterBanner(schema24, true));
        Schema schema25 = builder.addSchema(806, c);
        builder.addFixer(new DataConverterPotionWater(schema25, false));
        Schema schema26 = builder.addSchema(808, DataConverterSchemaV808::new);
        builder.addFixer(new DataConverterAddChoices(schema26, "added shulker box", DataConverterTypes.s));
        Schema schema27 = builder.addSchema(808, 1, c);
        builder.addFixer(new DataConverterShulker(schema27, false));
        Schema schema28 = builder.addSchema(813, c);
        builder.addFixer(new DataConverterShulkerBoxItem(schema28, false));
        builder.addFixer(new DataConverterShulkerBoxBlock(schema28, false));
        Schema schema29 = builder.addSchema(816, c);
        builder.addFixer(new DataConverterLang(schema29, false));
        Schema schema30 = builder.addSchema(820, c);
        builder.addFixer(DataConverterItemName.a(schema30, "totem item renamer", DataConverterRegistry.a("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema31 = builder.addSchema(1022, DataConverterSchemaV1022::new);
        builder.addFixer(new DataConverterShoulderEntity(schema31, "added shoulder entities to players", DataConverterTypes.b));
        Schema schema32 = builder.addSchema(1125, DataConverterSchemaV1125::new);
        builder.addFixer(new DataConverterBedBlock(schema32, true));
        builder.addFixer(new DataConverterBedItem(schema32, false));
        Schema schema33 = builder.addSchema(1344, c);
        builder.addFixer(new DataConverterKeybind(schema33, false));
        Schema schema34 = builder.addSchema(1446, c);
        builder.addFixer(new DataConverterKeybind2(schema34, false));
        Schema schema35 = builder.addSchema(1450, c);
        builder.addFixer(new DataConverterFlattenState(schema35, false));
        Schema schema36 = builder.addSchema(1451, DataConverterSchemaV1451::new);
        builder.addFixer(new DataConverterAddChoices(schema36, "AddTrappedChestFix", DataConverterTypes.s));
        Schema schema37 = builder.addSchema(1451, 1, DataConverterSchemaV1451_1::new);
        builder.addFixer(new ChunkConverterPalette(schema37, true));
        Schema schema38 = builder.addSchema(1451, 2, DataConverterSchemaV1451_2::new);
        builder.addFixer(new DataConverterPiston(schema38, true));
        Schema schema39 = builder.addSchema(1451, 3, DataConverterSchemaV1451_3::new);
        builder.addFixer(new DataConverterEntityBlockState(schema39, true));
        builder.addFixer(new DataConverterMap(schema39, false));
        Schema schema40 = builder.addSchema(1451, 4, DataConverterSchemaV1451_4::new);
        builder.addFixer(new DataConverterBlockName(schema40, true));
        builder.addFixer(new DataConverterFlatten(schema40, false));
        Schema schema41 = builder.addSchema(1451, 5, DataConverterSchemaV1451_5::new);
        builder.addFixer(new ItemRemoveBlockEntityTagFix(schema41, false, Set.of("minecraft:noteblock", "minecraft:flower_pot", "minecraft:dandelion", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:allium", "minecraft:azure_bluet", "minecraft:red_tulip", "minecraft:orange_tulip", "minecraft:white_tulip", "minecraft:pink_tulip", "minecraft:oxeye_daisy", "minecraft:cactus", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:oak_sapling", "minecraft:spruce_sapling", "minecraft:birch_sapling", "minecraft:jungle_sapling", "minecraft:acacia_sapling", "minecraft:dark_oak_sapling", "minecraft:dead_bush", "minecraft:fern")));
        builder.addFixer(new DataConverterAddChoices(schema41, "RemoveNoteBlockFlowerPotFix", DataConverterTypes.s));
        builder.addFixer(new DataConverterFlattenSpawnEgg(schema41, false, "minecraft:spawn_egg"));
        builder.addFixer(new DataConverterWolf(schema41, false));
        builder.addFixer(new DataConverterBannerColour(schema41, false));
        builder.addFixer(new DataConverterWorldGenSettings(schema41, false));
        Schema schema42 = builder.addSchema(1451, 6, DataConverterSchemaV1451_6::new);
        builder.addFixer(new DataConverterStatistic(schema42, true));
        builder.addFixer(new DataConverterJukeBox(schema42, false));
        Schema schema43 = builder.addSchema(1451, 7, c);
        builder.addFixer(new DataConverterVillagerTrade(schema43));
        Schema schema44 = builder.addSchema(1456, c);
        builder.addFixer(new DataConverterItemFrame(schema44, false));
        Schema schema45 = builder.addSchema(1458, V1458::new);
        builder.addFixer(new DataFix(schema45, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(DataConverterTypes.b), typed -> typed.update(DSL.remainderFinder(), dynamic -> DataConverterCustomNameEntity.a(dynamic.getOps(), dynamic.get("CustomName").asString(""), "minecraft:player")));
            }
        });
        builder.addFixer(new DataConverterCustomNameEntity(schema45));
        builder.addFixer(new DataConverterCustomNameItem(schema45));
        builder.addFixer(new DataConverterCustomNameTile(schema45));
        Schema schema46 = builder.addSchema(1460, DataConverterSchemaV1460::new);
        builder.addFixer(new DataConverterPainting(schema46, false));
        Schema schema47 = builder.addSchema(1466, DataConverterSchemaV1466::new);
        builder.addFixer(new DataConverterAddChoices(schema47, "Add DUMMY block entity", DataConverterTypes.s));
        builder.addFixer(new DataConverterProtoChunk(schema47, true));
        Schema schema48 = builder.addSchema(1470, DataConverterSchemaV1470::new);
        builder.addFixer(new DataConverterAddChoices(schema48, "Add 1.13 entities fix", DataConverterTypes.D));
        Schema schema49 = builder.addSchema(1474, c);
        builder.addFixer(new DataConverterColorlessShulkerEntity(schema49, false));
        builder.addFixer(DataConverterBlockRename.a(schema49, "Colorless shulker block fixer", (String string) -> Objects.equals(DataConverterSchemaNamed.a(string), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : string));
        builder.addFixer(DataConverterItemName.a(schema49, "Colorless shulker item fixer", (String string) -> Objects.equals(DataConverterSchemaNamed.a(string), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : string));
        Schema schema50 = builder.addSchema(1475, c);
        builder.addFixer(DataConverterBlockRename.a(schema50, "Flowing fixer", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema51 = builder.addSchema(1480, c);
        builder.addFixer(DataConverterBlockRename.a(schema51, "Rename coral blocks", DataConverterRegistry.b(DataConverterCoral.a)));
        builder.addFixer(DataConverterItemName.a(schema51, "Rename coral items", DataConverterRegistry.b(DataConverterCoral.a)));
        Schema schema52 = builder.addSchema(1481, DataConverterSchemaV1481::new);
        builder.addFixer(new DataConverterAddChoices(schema52, "Add conduit", DataConverterTypes.s));
        Schema schema53 = builder.addSchema(1483, DataConverterSchemaV1483::new);
        builder.addFixer(new DataConverterEntityPufferfish(schema53, true));
        builder.addFixer(DataConverterItemName.a(schema53, "Rename pufferfish egg item", DataConverterRegistry.b(DataConverterEntityPufferfish.a)));
        Schema schema54 = builder.addSchema(1484, c);
        builder.addFixer(DataConverterItemName.a(schema54, "Rename seagrass items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(DataConverterBlockRename.a(schema54, "Rename seagrass blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        builder.addFixer(new DataConverterHeightmapRenaming(schema54, false));
        Schema schema55 = builder.addSchema(1486, DataConverterSchemaV1486::new);
        builder.addFixer(new DataConverterEntityCodSalmon(schema55, true));
        builder.addFixer(DataConverterItemName.a(schema55, "Rename cod/salmon egg items", DataConverterRegistry.b(DataConverterEntityCodSalmon.b)));
        Schema schema56 = builder.addSchema(1487, c);
        builder.addFixer(DataConverterItemName.a(schema56, "Rename prismarine_brick(s)_* blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        builder.addFixer(DataConverterBlockRename.a(schema56, "Rename prismarine_brick(s)_* items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema57 = builder.addSchema(1488, V1488::new);
        builder.addFixer(DataConverterBlockRename.a(schema57, "Rename kelp/kelptop", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        builder.addFixer(DataConverterItemName.a(schema57, "Rename kelptop", DataConverterRegistry.a("minecraft:kelp_top", "minecraft:kelp")));
        builder.addFixer(new NamedEntityWriteReadFix(schema57, true, "Command block block entity custom name fix", DataConverterTypes.s, "minecraft:command_block"){

            @Override
            protected <T> Dynamic<T> a(Dynamic<T> tag) {
                return DataConverterCustomNameTile.a(tag);
            }
        });
        builder.addFixer(new DataFix(schema57, false){

            protected TypeRewriteRule makeRule() {
                Type type = this.getInputSchema().getType(DataConverterTypes.D);
                OpticFinder opticFinder = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
                OpticFinder opticFinder1 = type.findField("CustomName");
                OpticFinder opticFinder2 = DSL.typeFinder((Type)this.getInputSchema().getType(DataConverterTypes.z));
                return this.fixTypeEverywhereTyped("Command block minecart custom name fix", type, typed -> {
                    String string = typed.getOptional(opticFinder).orElse("");
                    return !"minecraft:commandblock_minecart".equals(string) ? typed : typed.updateTyped(opticFinder1, typed1 -> typed1.update(opticFinder2, pair -> pair.mapSecond(LegacyComponentDataFixUtils::a)));
                });
            }
        });
        builder.addFixer(new DataConverterIglooMetadataRemoval(schema57, false));
        Schema schema58 = builder.addSchema(1490, c);
        builder.addFixer(DataConverterBlockRename.a(schema58, "Rename melon_block", DataConverterRegistry.a("minecraft:melon_block", "minecraft:melon")));
        builder.addFixer(DataConverterItemName.a(schema58, "Rename melon_block/melon/speckled_melon", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema59 = builder.addSchema(1492, c);
        builder.addFixer(new DataConverterChunkStructuresTemplateRename(schema59, false));
        Schema schema60 = builder.addSchema(1494, c);
        builder.addFixer(new DataConverterItemStackEnchantment(schema60, false));
        Schema schema61 = builder.addSchema(1496, c);
        builder.addFixer(new DataConverterLeaves(schema61, false));
        Schema schema62 = builder.addSchema(1500, c);
        builder.addFixer(new DataConverterBlockEntityKeepPacked(schema62, false));
        Schema schema63 = builder.addSchema(1501, c);
        builder.addFixer(new DataConverterAdvancement(schema63, false));
        Schema schema64 = builder.addSchema(1502, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema64, "Recipes fix", DataConverterTypes.L, DataConverterRegistry.b(DataConverterRecipes.a)));
        Schema schema65 = builder.addSchema(1506, c);
        builder.addFixer(new DataConverterLevelDataGeneratorOptions(schema65, false));
        Schema schema66 = builder.addSchema(1510, DataConverterSchemaV1510::new);
        builder.addFixer(DataConverterBlockRename.a(schema66, "Block renamening fix", DataConverterRegistry.b(DataConverterEntityRename.b)));
        builder.addFixer(DataConverterItemName.a(schema66, "Item renamening fix", DataConverterRegistry.b(DataConverterEntityRename.c)));
        builder.addFixer(new NamespacedTypeRenameFix(schema66, "Recipes renamening fix", DataConverterTypes.L, DataConverterRegistry.b(DataConverterRecipeRename.a)));
        builder.addFixer(new DataConverterEntityRename(schema66, true));
        builder.addFixer(new StatsRenameFix(schema66, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema67 = builder.addSchema(1514, c);
        builder.addFixer(new ScoreboardDisplayNameFix(schema67, "ObjectiveDisplayNameFix", DataConverterTypes.J));
        builder.addFixer(new ScoreboardDisplayNameFix(schema67, "TeamDisplayNameFix", DataConverterTypes.K));
        builder.addFixer(new DataConverterObjectiveRenderType(schema67));
        Schema schema68 = builder.addSchema(1515, c);
        builder.addFixer(DataConverterBlockRename.a(schema68, "Rename coral fan blocks", DataConverterRegistry.b(DataConverterCoralFan.a)));
        Schema schema69 = builder.addSchema(1624, c);
        builder.addFixer(new DataConverterTrappedChest(schema69, false));
        Schema schema70 = builder.addSchema(1800, DataConverterSchemaV1800::new);
        builder.addFixer(new DataConverterAddChoices(schema70, "Added 1.14 mobs fix", DataConverterTypes.D));
        builder.addFixer(DataConverterItemName.a(schema70, "Rename dye items", DataConverterRegistry.b(DataConverterDye.a)));
        Schema schema71 = builder.addSchema(1801, DataConverterSchemaV1801::new);
        builder.addFixer(new DataConverterAddChoices(schema71, "Added Illager Beast", DataConverterTypes.D));
        Schema schema72 = builder.addSchema(1802, c);
        builder.addFixer(DataConverterBlockRename.a(schema72, "Rename sign blocks & stone slabs", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        builder.addFixer(DataConverterItemName.a(schema72, "Rename sign item & stone slabs", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema73 = builder.addSchema(1803, c);
        builder.addFixer(new DataConverterItemLoreComponentize(schema73));
        Schema schema74 = builder.addSchema(1904, DataConverterSchemaV1904::new);
        builder.addFixer(new DataConverterAddChoices(schema74, "Added Cats", DataConverterTypes.D));
        builder.addFixer(new DataConverterEntityCatSplit(schema74, false));
        Schema schema75 = builder.addSchema(1905, c);
        builder.addFixer(new DataConverterChunkStatus(schema75, false));
        Schema schema76 = builder.addSchema(1906, DataConverterSchemaV1906::new);
        builder.addFixer(new DataConverterAddChoices(schema76, "Add POI Blocks", DataConverterTypes.s));
        Schema schema77 = builder.addSchema(1909, DataConverterSchemaV1909::new);
        builder.addFixer(new DataConverterAddChoices(schema77, "Add jigsaw", DataConverterTypes.s));
        Schema schema78 = builder.addSchema(1911, c);
        builder.addFixer(new DataConverterChunkStatus2(schema78, false));
        Schema schema79 = builder.addSchema(1914, c);
        builder.addFixer(new WeaponSmithChestLootTableFix(schema79, false));
        Schema schema80 = builder.addSchema(1917, c);
        builder.addFixer(new DataConverterCatType(schema80, false));
        Schema schema81 = builder.addSchema(1918, c);
        builder.addFixer(new DataConverterVillagerProfession(schema81, "minecraft:villager"));
        builder.addFixer(new DataConverterVillagerProfession(schema81, "minecraft:zombie_villager"));
        Schema schema82 = builder.addSchema(1920, DataConverterSchemaV1920::new);
        builder.addFixer(new DataConverterNewVillage(schema82, false));
        builder.addFixer(new DataConverterAddChoices(schema82, "Add campfire", DataConverterTypes.s));
        Schema schema83 = builder.addSchema(1925, V1925::new);
        builder.addFixer(new DataConverterMapId(schema83));
        Schema schema84 = builder.addSchema(1928, DataConverterSchemaV1928::new);
        builder.addFixer(new DataConverterEntityRavagerRename(schema84, true));
        builder.addFixer(DataConverterItemName.a(schema84, "Rename ravager egg item", DataConverterRegistry.b(DataConverterEntityRavagerRename.a)));
        Schema schema85 = builder.addSchema(1929, DataConverterSchemaV1929::new);
        builder.addFixer(new DataConverterAddChoices(schema85, "Add Wandering Trader and Trader Llama", DataConverterTypes.D));
        Schema schema86 = builder.addSchema(1931, DataConverterSchemaV1931::new);
        builder.addFixer(new DataConverterAddChoices(schema86, "Added Fox", DataConverterTypes.D));
        Schema schema87 = builder.addSchema(1936, c);
        builder.addFixer(new DataConverterOptionsAddTextBackground(schema87, false));
        Schema schema88 = builder.addSchema(1946, c);
        builder.addFixer(new DataConverterPOI(schema88, false));
        Schema schema89 = builder.addSchema(1948, c);
        builder.addFixer(new DataConverterOminousBannerRename(schema89));
        Schema schema90 = builder.addSchema(1953, c);
        builder.addFixer(new DataConverterOminousBannerBlockEntityRename(schema90, false));
        Schema schema91 = builder.addSchema(1955, c);
        builder.addFixer(new DataConverterVillagerLevelXp(schema91, false));
        builder.addFixer(new DataConverterZombieVillagerLevelXp(schema91, false));
        Schema schema92 = builder.addSchema(1961, c);
        builder.addFixer(new DataConverterChunkLightRemove(schema92, false));
        Schema schema93 = builder.addSchema(1963, c);
        builder.addFixer(new DataConverterRemoveGolemGossip(schema93, false));
        Schema schema94 = builder.addSchema(2100, DataConverterSchemaV2100::new);
        builder.addFixer(new DataConverterAddChoices(schema94, "Added Bee and Bee Stinger", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema94, "Add beehive", DataConverterTypes.s));
        builder.addFixer(new NamespacedTypeRenameFix(schema94, "Rename sugar recipe", DataConverterTypes.L, DataConverterRegistry.a("minecraft:sugar", "minecraft:sugar_from_sugar_cane")));
        builder.addFixer(new DataConverterAdvancementBase(schema94, false, "Rename sugar recipe advancement", DataConverterRegistry.a("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema95 = builder.addSchema(2202, c);
        builder.addFixer(new DataConverterLeavesBiome(schema95, false));
        Schema schema96 = builder.addSchema(2209, c);
        UnaryOperator<String> unaryOperator = DataConverterRegistry.a("minecraft:bee_hive", "minecraft:beehive");
        builder.addFixer(DataConverterItemName.a(schema96, "Rename bee_hive item to beehive", unaryOperator));
        builder.addFixer(new PoiTypeRenameFix(schema96, "Rename bee_hive poi to beehive", unaryOperator));
        builder.addFixer(DataConverterBlockRename.a(schema96, "Rename bee_hive block to beehive", unaryOperator));
        Schema schema97 = builder.addSchema(2211, c);
        builder.addFixer(new DataConverterStructureReference(schema97, false));
        Schema schema98 = builder.addSchema(2218, c);
        builder.addFixer(new DataConverterPOIRebuild(schema98, false));
        Schema schema99 = builder.addSchema(2501, DataConverterSchemaV2501::new);
        builder.addFixer(new DataConverterFurnaceRecipesUsed(schema99, true));
        Schema schema100 = builder.addSchema(2502, DataConverterSchemaV2502::new);
        builder.addFixer(new DataConverterAddChoices(schema100, "Added Hoglin", DataConverterTypes.D));
        Schema schema101 = builder.addSchema(2503, c);
        builder.addFixer(new DataConverterWallProperty(schema101, false));
        builder.addFixer(new DataConverterAdvancementBase(schema101, false, "Composter category change", DataConverterRegistry.a("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema102 = builder.addSchema(2505, DataConverterSchemaV2505::new);
        builder.addFixer(new DataConverterAddChoices(schema102, "Added Piglin", DataConverterTypes.D));
        builder.addFixer(new DataConverterMemoryExpiry(schema102, "minecraft:villager"));
        Schema schema103 = builder.addSchema(2508, c);
        builder.addFixer(DataConverterItemName.a(schema103, "Renamed fungi items to fungus", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        builder.addFixer(DataConverterBlockRename.a(schema103, "Renamed fungi blocks to fungus", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema104 = builder.addSchema(2509, DataConverterSchemaV2509::new);
        builder.addFixer(new DataConverterEntityZombifiedPiglinRename(schema104));
        builder.addFixer(DataConverterItemName.a(schema104, "Rename zombie pigman egg item", DataConverterRegistry.b(DataConverterEntityZombifiedPiglinRename.a)));
        Schema schema105 = builder.addSchema(2511, c);
        builder.addFixer(new DataConverterEntityProjectileOwner(schema105));
        Schema schema106 = builder.addSchema(2511, 1, V2511_1::new);
        builder.addFixer(new NamedEntityConvertUncheckedFix(schema106, "SplashPotionItemFieldRenameFix", DataConverterTypes.D, "minecraft:potion"));
        Schema schema107 = builder.addSchema(2514, c);
        builder.addFixer(new DataConverterEntityUUID(schema107));
        builder.addFixer(new DataConverterBlockEntityUUID(schema107));
        builder.addFixer(new DataConverterPlayerUUID(schema107));
        builder.addFixer(new DataConverterMiscUUID(schema107));
        builder.addFixer(new DataConverterSavedDataUUID(schema107));
        builder.addFixer(new DataConverterItemStackUUID(schema107));
        Schema schema108 = builder.addSchema(2516, c);
        builder.addFixer(new DataConverterGossip(schema108, "minecraft:villager"));
        builder.addFixer(new DataConverterGossip(schema108, "minecraft:zombie_villager"));
        Schema schema109 = builder.addSchema(2518, c);
        builder.addFixer(new DataConverterJigsawProperties(schema109, false));
        builder.addFixer(new DataConverterJigsawRotation(schema109));
        Schema schema110 = builder.addSchema(2519, DataConverterSchemaV2519::new);
        builder.addFixer(new DataConverterAddChoices(schema110, "Added Strider", DataConverterTypes.D));
        Schema schema111 = builder.addSchema(2522, DataConverterSchemaV2522::new);
        builder.addFixer(new DataConverterAddChoices(schema111, "Added Zoglin", DataConverterTypes.D));
        Schema schema112 = builder.addSchema(2523, c);
        builder.addFixer(new DataConverterAttributes(schema112, "Attribute renames", DataConverterRegistry.a((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"minecraft:generic.max_health").put((Object)"Max Health", (Object)"minecraft:generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"minecraft:horse.jump_strength").put((Object)"Jump Strength", (Object)"minecraft:horse.jump_strength").put((Object)"generic.followRange", (Object)"minecraft:generic.follow_range").put((Object)"Follow Range", (Object)"minecraft:generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"minecraft:generic.movement_speed").put((Object)"Movement Speed", (Object)"minecraft:generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"minecraft:generic.flying_speed").put((Object)"Flying Speed", (Object)"minecraft:generic.flying_speed").put((Object)"generic.attackDamage", (Object)"minecraft:generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"minecraft:generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"minecraft:generic.attack_speed").put((Object)"generic.armorToughness", (Object)"minecraft:generic.armor_toughness").build())));
        Schema schema113 = builder.addSchema(2527, c);
        builder.addFixer(new DataConverterBitStorageAlign(schema113));
        Schema schema114 = builder.addSchema(2528, c);
        builder.addFixer(DataConverterItemName.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        builder.addFixer(DataConverterBlockRename.a(schema114, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema115 = builder.addSchema(2529, c);
        builder.addFixer(new DataConverterStriderGravity(schema115, false));
        Schema schema116 = builder.addSchema(2531, c);
        builder.addFixer(new DataConverterRedstoneConnections(schema116));
        Schema schema117 = builder.addSchema(2533, c);
        builder.addFixer(new DataConverterVillagerFollowRange(schema117));
        Schema schema118 = builder.addSchema(2535, c);
        builder.addFixer(new DataConverterEntityShulkerRotation(schema118));
        Schema schema119 = builder.addSchema(2538, c);
        builder.addFixer(new LevelLegacyWorldGenSettingsFix(schema119));
        Schema schema120 = builder.addSchema(2550, c);
        builder.addFixer(new DataConverterWorldGenSettingsBuilding(schema120));
        Schema schema121 = builder.addSchema(2551, DataConverterSchemaV2551::new);
        builder.addFixer(new DataConverterShoulderEntity(schema121, "add types to WorldGenData", DataConverterTypes.O));
        Schema schema122 = builder.addSchema(2552, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema122, "Nether biome rename", DataConverterTypes.M, DataConverterRegistry.a("minecraft:nether", "minecraft:nether_wastes")));
        Schema schema123 = builder.addSchema(2553, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema123, "Biomes fix", DataConverterTypes.M, DataConverterRegistry.b(DataConverterBiome.a)));
        Schema schema124 = builder.addSchema(2558, c);
        builder.addFixer(new DataConverterMissingDimension(schema124, false));
        builder.addFixer(new DataConverterSettingRename(schema124, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema125 = builder.addSchema(2568, DataConverterSchemaV2568::new);
        builder.addFixer(new DataConverterAddChoices(schema125, "Added Piglin Brute", DataConverterTypes.D));
        Schema schema126 = builder.addSchema(2571, V2571::new);
        builder.addFixer(new DataConverterAddChoices(schema126, "Added Goat", DataConverterTypes.D));
        Schema schema127 = builder.addSchema(2679, c);
        builder.addFixer(new CauldronRenameFix(schema127, false));
        Schema schema128 = builder.addSchema(2680, c);
        builder.addFixer(DataConverterItemName.a(schema128, "Renamed grass path item to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        builder.addFixer(DataConverterBlockRename.a(schema128, "Renamed grass path block to dirt path", DataConverterRegistry.a("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema129 = builder.addSchema(2684, V2684::new);
        builder.addFixer(new DataConverterAddChoices(schema129, "Added Sculk Sensor", DataConverterTypes.s));
        Schema schema130 = builder.addSchema(2686, V2686::new);
        builder.addFixer(new DataConverterAddChoices(schema130, "Added Axolotl", DataConverterTypes.D));
        Schema schema131 = builder.addSchema(2688, V2688::new);
        builder.addFixer(new DataConverterAddChoices(schema131, "Added Glow Squid", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema131, "Added Glow Item Frame", DataConverterTypes.D));
        Schema schema132 = builder.addSchema(2690, c);
        ImmutableMap map = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        builder.addFixer(DataConverterItemName.a(schema132, "Renamed copper block items to new oxidized terms", DataConverterRegistry.b((Map<String, String>)map)));
        builder.addFixer(DataConverterBlockRename.a(schema132, "Renamed copper blocks to new oxidized terms", DataConverterRegistry.b((Map<String, String>)map)));
        Schema schema133 = builder.addSchema(2691, c);
        ImmutableMap map1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        builder.addFixer(DataConverterItemName.a(schema133, "Rename copper item suffixes", DataConverterRegistry.b((Map<String, String>)map1)));
        builder.addFixer(DataConverterBlockRename.a(schema133, "Rename copper blocks suffixes", DataConverterRegistry.b((Map<String, String>)map1)));
        Schema schema134 = builder.addSchema(2693, c);
        builder.addFixer(new AddFlagIfNotPresentFix(schema134, DataConverterTypes.O, "has_increased_height_already", false));
        Schema schema135 = builder.addSchema(2696, c);
        ImmutableMap map2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        builder.addFixer(DataConverterItemName.a(schema135, "Renamed grimstone block items to deepslate", DataConverterRegistry.b((Map<String, String>)map2)));
        builder.addFixer(DataConverterBlockRename.a(schema135, "Renamed grimstone blocks to deepslate", DataConverterRegistry.b((Map<String, String>)map2)));
        Schema schema136 = builder.addSchema(2700, c);
        builder.addFixer(DataConverterBlockRename.a(schema136, "Renamed cave vines blocks", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema137 = builder.addSchema(2701, c);
        builder.addFixer(new SavedDataFeaturePoolElementFix(schema137));
        Schema schema138 = builder.addSchema(2702, c);
        builder.addFixer(new AbstractArrowPickupFix(schema138));
        Schema schema139 = builder.addSchema(2704, V2704::new);
        builder.addFixer(new DataConverterAddChoices(schema139, "Added Goat", DataConverterTypes.D));
        Schema schema140 = builder.addSchema(2707, V2707::new);
        builder.addFixer(new DataConverterAddChoices(schema140, "Added Marker", DataConverterTypes.D));
        builder.addFixer(new AddFlagIfNotPresentFix(schema140, DataConverterTypes.O, "has_increased_height_already", true));
        Schema schema141 = builder.addSchema(2710, c);
        builder.addFixer(new StatsRenameFix(schema141, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema142 = builder.addSchema(2717, c);
        builder.addFixer(DataConverterItemName.a(schema142, "Rename azalea_leaves_flowers", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        builder.addFixer(DataConverterBlockRename.a(schema142, "Rename azalea_leaves_flowers items", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema143 = builder.addSchema(2825, c);
        builder.addFixer(new AddFlagIfNotPresentFix(schema143, DataConverterTypes.O, "has_increased_height_already", false));
        Schema schema144 = builder.addSchema(2831, V2831::new);
        builder.addFixer(new SpawnerDataFix(schema144));
        Schema schema145 = builder.addSchema(2832, V2832::new);
        builder.addFixer(new WorldGenSettingsHeightAndBiomeFix(schema145));
        builder.addFixer(new ChunkHeightAndBiomeFix(schema145));
        Schema schema146 = builder.addSchema(2833, c);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema146));
        Schema schema147 = builder.addSchema(2838, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema147, "Caves and Cliffs biome renames", DataConverterTypes.M, DataConverterRegistry.b(CavesAndCliffsRenames.a)));
        Schema schema148 = builder.addSchema(2841, c);
        builder.addFixer(new ChunkProtoTickListFix(schema148));
        Schema schema149 = builder.addSchema(2842, V2842::new);
        builder.addFixer(new ChunkRenamesFix(schema149));
        Schema schema150 = builder.addSchema(2843, c);
        builder.addFixer(new OverreachingTickFix(schema150));
        builder.addFixer(new NamespacedTypeRenameFix(schema150, "Remove Deep Warm Ocean", DataConverterTypes.M, DataConverterRegistry.a("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema151 = builder.addSchema(2846, c);
        builder.addFixer(new DataConverterAdvancementBase(schema151, false, "Rename some C&C part 2 advancements", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema152 = builder.addSchema(2852, c);
        builder.addFixer(new WorldGenSettingsDisallowOldCustomWorldsFix(schema152));
        Schema schema153 = builder.addSchema(2967, c);
        builder.addFixer(new StructureSettingsFlattenFix(schema153));
        Schema schema154 = builder.addSchema(2970, c);
        builder.addFixer(new StructuresBecomeConfiguredFix(schema154));
        Schema schema155 = builder.addSchema(3076, V3076::new);
        builder.addFixer(new DataConverterAddChoices(schema155, "Added Sculk Catalyst", DataConverterTypes.s));
        Schema schema156 = builder.addSchema(3077, c);
        builder.addFixer(new ChunkDeleteIgnoredLightDataFix(schema156));
        Schema schema157 = builder.addSchema(3078, V3078::new);
        builder.addFixer(new DataConverterAddChoices(schema157, "Added Frog", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema157, "Added Tadpole", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema157, "Added Sculk Shrieker", DataConverterTypes.s));
        Schema schema158 = builder.addSchema(3081, V3081::new);
        builder.addFixer(new DataConverterAddChoices(schema158, "Added Warden", DataConverterTypes.D));
        Schema schema159 = builder.addSchema(3082, V3082::new);
        builder.addFixer(new DataConverterAddChoices(schema159, "Added Chest Boat", DataConverterTypes.D));
        Schema schema160 = builder.addSchema(3083, V3083::new);
        builder.addFixer(new DataConverterAddChoices(schema160, "Added Allay", DataConverterTypes.D));
        Schema schema161 = builder.addSchema(3084, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema161, "game_event_renames_3084", DataConverterTypes.G, DataConverterRegistry.b((Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build())));
        Schema schema162 = builder.addSchema(3086, c);
        builder.addFixer(new EntityVariantFix(schema162, "Change cat variant type", DataConverterTypes.D, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T map5) -> {
            map5.defaultReturnValue((Object)"minecraft:tabby");
            map5.put(0, (Object)"minecraft:tabby");
            map5.put(1, (Object)"minecraft:black");
            map5.put(2, (Object)"minecraft:red");
            map5.put(3, (Object)"minecraft:siamese");
            map5.put(4, (Object)"minecraft:british");
            map5.put(5, (Object)"minecraft:calico");
            map5.put(6, (Object)"minecraft:persian");
            map5.put(7, (Object)"minecraft:ragdoll");
            map5.put(8, (Object)"minecraft:white");
            map5.put(9, (Object)"minecraft:jellie");
            map5.put(10, (Object)"minecraft:all_black");
        })).get(arg_0)));
        ImmutableMap map3 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        builder.addFixer(new CriteriaRenameFix(schema162, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", string -> (String)map3.getOrDefault(string, string)));
        Schema schema163 = builder.addSchema(3087, c);
        builder.addFixer(new EntityVariantFix(schema163, "Change frog variant type", DataConverterTypes.D, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T map5) -> {
            map5.put(0, (Object)"minecraft:temperate");
            map5.put(1, (Object)"minecraft:warm");
            map5.put(2, (Object)"minecraft:cold");
        })).get(arg_0)));
        Schema schema164 = builder.addSchema(3090, c);
        builder.addFixer(new EntityFieldsRenameFix(schema164, "EntityPaintingFieldsRenameFix", "minecraft:painting", Map.of("Motive", "variant", "Facing", "facing")));
        Schema schema165 = builder.addSchema(3093, c);
        builder.addFixer(new EntityGoatMissingStateFix(schema165));
        Schema schema166 = builder.addSchema(3094, c);
        builder.addFixer(new GoatHornIdFix(schema166));
        Schema schema167 = builder.addSchema(3097, c);
        builder.addFixer(new FilteredBooksFix(schema167));
        builder.addFixer(new FilteredSignsFix(schema167));
        Map<String, String> map4 = Map.of("minecraft:british", "minecraft:british_shorthair");
        builder.addFixer(new VariantRenameFix(schema167, "Rename british shorthair", DataConverterTypes.D, "minecraft:cat", map4));
        builder.addFixer(new CriteriaRenameFix(schema167, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", string -> map4.getOrDefault(string, (String)string)));
        builder.addFixer(new PoiTypeRemoveFix(schema167, "Remove unpopulated villager PoI types", Set.of("minecraft:unemployed", "minecraft:nitwit")::contains));
        Schema schema168 = builder.addSchema(3108, c);
        builder.addFixer(new BlendingDataRemoveFromNetherEndFix(schema168));
        Schema schema169 = builder.addSchema(3201, c);
        builder.addFixer(new OptionsProgrammerArtFix(schema169));
        Schema schema170 = builder.addSchema(3202, V3202::new);
        builder.addFixer(new DataConverterAddChoices(schema170, "Added Hanging Sign", DataConverterTypes.s));
        Schema schema171 = builder.addSchema(3203, V3203::new);
        builder.addFixer(new DataConverterAddChoices(schema171, "Added Camel", DataConverterTypes.D));
        Schema schema172 = builder.addSchema(3204, V3204::new);
        builder.addFixer(new DataConverterAddChoices(schema172, "Added Chiseled Bookshelf", DataConverterTypes.s));
        Schema schema173 = builder.addSchema(3209, c);
        builder.addFixer(new DataConverterFlattenSpawnEgg(schema173, false, "minecraft:pig_spawn_egg"));
        Schema schema174 = builder.addSchema(3214, c);
        builder.addFixer(new OptionsAmbientOcclusionFix(schema174));
        Schema schema175 = builder.addSchema(3319, c);
        builder.addFixer(new OptionsAccessibilityOnboardFix(schema175));
        Schema schema176 = builder.addSchema(3322, c);
        builder.addFixer(new EffectDurationFix(schema176));
        Schema schema177 = builder.addSchema(3325, V3325::new);
        builder.addFixer(new DataConverterAddChoices(schema177, "Added displays", DataConverterTypes.D));
        Schema schema178 = builder.addSchema(3326, V3326::new);
        builder.addFixer(new DataConverterAddChoices(schema178, "Added Sniffer", DataConverterTypes.D));
        Schema schema179 = builder.addSchema(3327, V3327::new);
        builder.addFixer(new DataConverterAddChoices(schema179, "Archaeology", DataConverterTypes.s));
        Schema schema180 = builder.addSchema(3328, V3328::new);
        builder.addFixer(new DataConverterAddChoices(schema180, "Added interaction", DataConverterTypes.D));
        Schema schema181 = builder.addSchema(3438, V3438::new);
        builder.addFixer(BlockEntityRenameFix.a(schema181, "Rename Suspicious Sand to Brushable Block", DataConverterRegistry.a("minecraft:suspicious_sand", "minecraft:brushable_block")));
        builder.addFixer(new EntityBrushableBlockFieldsRenameFix(schema181));
        builder.addFixer(DataConverterItemName.a(schema181, "Pottery shard renaming", DataConverterRegistry.b((Map<String, String>)ImmutableMap.of((Object)"minecraft:pottery_shard_archer", (Object)"minecraft:archer_pottery_shard", (Object)"minecraft:pottery_shard_prize", (Object)"minecraft:prize_pottery_shard", (Object)"minecraft:pottery_shard_arms_up", (Object)"minecraft:arms_up_pottery_shard", (Object)"minecraft:pottery_shard_skull", (Object)"minecraft:skull_pottery_shard"))));
        builder.addFixer(new DataConverterAddChoices(schema181, "Added calibrated sculk sensor", DataConverterTypes.s));
        Schema schema182 = builder.addSchema(3439, V3439::new);
        builder.addFixer(new BlockEntitySignDoubleSidedEditableTextFix(schema182, "Updated sign text format for Signs", "minecraft:sign"));
        builder.addFixer(new BlockEntitySignDoubleSidedEditableTextFix(schema182, "Updated sign text format for Hanging Signs", "minecraft:hanging_sign"));
        Schema schema183 = builder.addSchema(3440, c);
        builder.addFixer(new NamespacedTypeRenameFix(schema183, "Replace experimental 1.20 overworld", DataConverterTypes.N, DataConverterRegistry.a("minecraft:overworld_update_1_20", "minecraft:overworld")));
        builder.addFixer(new FeatureFlagRemoveFix(schema183, "Remove 1.20 feature toggle", Set.of("minecraft:update_1_20")));
        Schema schema184 = builder.addSchema(3447, c);
        builder.addFixer(DataConverterItemName.a(schema184, "Pottery shard item renaming to Pottery sherd", DataConverterRegistry.b(Stream.of("minecraft:angler_pottery_shard", "minecraft:archer_pottery_shard", "minecraft:arms_up_pottery_shard", "minecraft:blade_pottery_shard", "minecraft:brewer_pottery_shard", "minecraft:burn_pottery_shard", "minecraft:danger_pottery_shard", "minecraft:explorer_pottery_shard", "minecraft:friend_pottery_shard", "minecraft:heart_pottery_shard", "minecraft:heartbreak_pottery_shard", "minecraft:howl_pottery_shard", "minecraft:miner_pottery_shard", "minecraft:mourner_pottery_shard", "minecraft:plenty_pottery_shard", "minecraft:prize_pottery_shard", "minecraft:sheaf_pottery_shard", "minecraft:shelter_pottery_shard", "minecraft:skull_pottery_shard", "minecraft:snort_pottery_shard").collect(Collectors.toMap(Function.identity(), string -> string.replace("_pottery_shard", "_pottery_sherd"))))));
        Schema schema185 = builder.addSchema(3448, V3448::new);
        builder.addFixer(new DecoratedPotFieldRenameFix(schema185));
        Schema schema186 = builder.addSchema(3450, c);
        builder.addFixer(new RemapChunkStatusFix(schema186, "Remove liquid_carvers and heightmap chunk statuses", DataConverterRegistry.b(Map.of("minecraft:liquid_carvers", "minecraft:carvers", "minecraft:heightmaps", "minecraft:spawn"))));
        Schema schema187 = builder.addSchema(3451, c);
        builder.addFixer(new ChunkDeleteLightFix(schema187));
        Schema schema188 = builder.addSchema(3459, c);
        builder.addFixer(new LegacyDragonFightFix(schema188));
        Schema schema189 = builder.addSchema(3564, c);
        builder.addFixer(new DropInvalidSignDataFix(schema189, "minecraft:sign"));
        builder.addFixer(new DropInvalidSignDataFix(schema189, "minecraft:hanging_sign"));
        Schema schema190 = builder.addSchema(3565, c);
        builder.addFixer(new RandomSequenceSettingsFix(schema190));
        Schema schema191 = builder.addSchema(3566, c);
        builder.addFixer(new ScoreboardDisplaySlotFix(schema191));
        Schema schema192 = builder.addSchema(3568, c);
        builder.addFixer(new MobEffectIdFix(schema192));
        Schema schema193 = builder.addSchema(3682, V3682::new);
        builder.addFixer(new DataConverterAddChoices(schema193, "Added Crafter", DataConverterTypes.s));
        Schema schema194 = builder.addSchema(3683, V3683::new);
        builder.addFixer(new PrimedTntBlockStateFixer(schema194));
        Schema schema195 = builder.addSchema(3685, V3685::new);
        builder.addFixer(new FixProjectileStoredItem(schema195));
        Schema schema196 = builder.addSchema(3689, V3689::new);
        builder.addFixer(new DataConverterAddChoices(schema196, "Added Breeze", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema196, "Added Trial Spawner", DataConverterTypes.s));
        Schema schema197 = builder.addSchema(3692, c);
        UnaryOperator<String> unaryOperator1 = DataConverterRegistry.b(Map.of("minecraft:grass", "minecraft:short_grass"));
        builder.addFixer(DataConverterBlockRename.a(schema197, "Rename grass block to short_grass", unaryOperator1));
        builder.addFixer(DataConverterItemName.a(schema197, "Rename grass item to short_grass", unaryOperator1));
        Schema schema198 = builder.addSchema(3799, V3799::new);
        builder.addFixer(new DataConverterAddChoices(schema198, "Added Armadillo", DataConverterTypes.D));
        Schema schema199 = builder.addSchema(3800, c);
        UnaryOperator<String> unaryOperator2 = DataConverterRegistry.b(Map.of("minecraft:scute", "minecraft:turtle_scute"));
        builder.addFixer(DataConverterItemName.a(schema199, "Rename scute item to turtle_scute", unaryOperator2));
        Schema schema200 = builder.addSchema(3803, c);
        builder.addFixer(new RenameEnchantmentsFix(schema200, "Rename sweeping enchant to sweeping_edge", Map.of("minecraft:sweeping", "minecraft:sweeping_edge")));
        Schema schema201 = builder.addSchema(3807, V3807::new);
        builder.addFixer(new DataConverterAddChoices(schema201, "Added Vault", DataConverterTypes.s));
        Schema schema202 = builder.addSchema(3807, 1, c);
        builder.addFixer(new MapBannerBlockPosFormatFix(schema202));
        Schema schema203 = builder.addSchema(3808, V3808::new);
        builder.addFixer(new HorseBodyArmorItemFix(schema203, "minecraft:horse", "ArmorItem", true));
        Schema schema204 = builder.addSchema(3808, 1, V3808_1::new);
        builder.addFixer(new HorseBodyArmorItemFix(schema204, "minecraft:llama", "DecorItem", false));
        Schema schema205 = builder.addSchema(3808, 2, V3808_2::new);
        builder.addFixer(new HorseBodyArmorItemFix(schema205, "minecraft:trader_llama", "DecorItem", false));
        Schema schema206 = builder.addSchema(3809, c);
        builder.addFixer(new ChestedHorsesInventoryZeroIndexingFix(schema206));
        Schema schema207 = builder.addSchema(3812, c);
        builder.addFixer(new FixWolfHealth(schema207));
        Schema schema208 = builder.addSchema(3813, V3813::new);
        builder.addFixer(new BlockPosFormatAndRenamesFix(schema208));
        Schema schema209 = builder.addSchema(3814, c);
        builder.addFixer(new DataConverterAttributes(schema209, "Rename jump strength attribute", DataConverterRegistry.a("minecraft:horse.jump_strength", "minecraft:generic.jump_strength")));
        Schema schema210 = builder.addSchema(3816, V3816::new);
        builder.addFixer(new DataConverterAddChoices(schema210, "Added Bogged", DataConverterTypes.D));
        Schema schema211 = builder.addSchema(3818, V3818::new);
        builder.addFixer(new BeehiveFieldRenameFix(schema211));
        builder.addFixer(new EmptyItemInHotbarFix(schema211));
        Schema schema212 = builder.addSchema(3818, 1, c);
        builder.addFixer(new BannerPatternFormatFix(schema212));
        Schema schema213 = builder.addSchema(3818, 2, c);
        builder.addFixer(new TippedArrowPotionToItemFix(schema213));
        Schema schema214 = builder.addSchema(3818, 3, V3818_3::new);
        builder.addFixer(new DataConverterShoulderEntity(schema214, "Inject data component types", DataConverterTypes.w));
        Schema schema215 = builder.addSchema(3818, 4, V3818_4::new);
        builder.addFixer(new ParticleUnflatteningFix(schema215));
        Schema schema216 = builder.addSchema(3818, 5, V3818_5::new);
        builder.addFixer(new ItemStackComponentizationFix(schema216));
        Schema schema217 = builder.addSchema(3818, 6, c);
        builder.addFixer(new AreaEffectCloudPotionFix(schema217));
        Schema schema218 = builder.addSchema(3820, c);
        builder.addFixer(new PlayerHeadBlockProfileFix(schema218));
        builder.addFixer(new LodestoneCompassComponentFix(schema218));
        Schema schema219 = builder.addSchema(3825, V3825::new);
        builder.addFixer(new ItemStackCustomNameToOverrideComponentFix(schema219));
        builder.addFixer(new BannerEntityCustomNameToOverrideComponentFix(schema219));
        builder.addFixer(new TrialSpawnerConfigFix(schema219));
        builder.addFixer(new DataConverterAddChoices(schema219, "Added Ominous Item Spawner", DataConverterTypes.D));
        Schema schema220 = builder.addSchema(3828, c);
        builder.addFixer(new EmptyItemInVillagerTradeFix(schema220));
        Schema schema221 = builder.addSchema(3833, c);
        builder.addFixer(new RemoveEmptyItemInBrushableBlockFix(schema221));
        Schema schema222 = builder.addSchema(3938, V3938::new);
        builder.addFixer(new ProjectileStoredWeaponFix(schema222));
        Schema schema223 = builder.addSchema(3939, c);
        builder.addFixer(new FeatureFlagRemoveFix(schema223, "Remove 1.21 feature toggle", Set.of("minecraft:update_1_21")));
        Schema schema224 = builder.addSchema(3943, c);
        builder.addFixer(new OptionsMenuBlurrinessFix(schema224));
        Schema schema225 = builder.addSchema(3945, c);
        builder.addFixer(new AttributeModifierIdFix(schema225));
        builder.addFixer(new JukeboxTicksSinceSongStartedFix(schema225));
        Schema schema226 = builder.addSchema(4054, c);
        builder.addFixer(new OminousBannerRarityFix(schema226));
        Schema schema227 = builder.addSchema(4055, c);
        builder.addFixer(new AttributeIdPrefixFix(schema227));
        Schema schema228 = builder.addSchema(4057, c);
        builder.addFixer(new CarvingStepRemoveFix(schema228));
        Schema schema229 = builder.addSchema(4059, V4059::new);
        builder.addFixer(new FoodToConsumableFix(schema229));
        Schema schema230 = builder.addSchema(4061, c);
        builder.addFixer(new TrialSpawnerConfigInRegistryFix(schema230));
        Schema schema231 = builder.addSchema(4064, c);
        builder.addFixer(new FireResistantToDamageResistantComponentFix(schema231));
        Schema schema232 = builder.addSchema(4067, V4067::new);
        builder.addFixer(new BoatSplitFix(schema232));
        builder.addFixer(new FeatureFlagRemoveFix(schema232, "Remove Bundle experimental feature flag", Set.of("minecraft:bundle")));
        Schema schema233 = builder.addSchema(4068, c);
        builder.addFixer(new LockComponentPredicateFix(schema233));
        builder.addFixer(new ContainerBlockEntityLockPredicateFix(schema233));
        Schema schema234 = builder.addSchema(4070, V4070::new);
        builder.addFixer(new DataConverterAddChoices(schema234, "Added Pale Oak Boat and Pale Oak Chest Boat", DataConverterTypes.D));
        Schema schema235 = builder.addSchema(4071, V4071::new);
        builder.addFixer(new DataConverterAddChoices(schema235, "Added Creaking", DataConverterTypes.D));
        builder.addFixer(new DataConverterAddChoices(schema235, "Added Creaking Heart", DataConverterTypes.s));
        Schema schema236 = builder.addSchema(4081, c);
        builder.addFixer(new EntitySalmonSizeFix(schema236));
        Schema schema237 = builder.addSchema(4173, c);
        builder.addFixer(new EntityFieldsRenameFix(schema237, "Rename TNT Minecart fuse", "minecraft:tnt_minecart", Map.of("TNTFuse", "fuse")));
        Schema schema238 = builder.addSchema(4175, c);
        builder.addFixer(new EquippableAssetRenameFix(schema238));
        builder.addFixer(new CustomModelDataExpandFix(schema238));
        Schema schema239 = builder.addSchema(4176, c);
        builder.addFixer(new InvalidBlockEntityLockFix(schema239));
        builder.addFixer(new InvalidLockComponentFix(schema239));
        Schema schema240 = builder.addSchema(4180, c);
        builder.addFixer(new FeatureFlagRemoveFix(schema240, "Remove Winter Drop toggle", Set.of("minecraft:winter_drop")));
        Schema schema241 = builder.addSchema(4181, c);
        builder.addFixer(new BlockEntityFurnaceBurnTimeFix(schema241, "minecraft:furnace"));
        builder.addFixer(new BlockEntityFurnaceBurnTimeFix(schema241, "minecraft:smoker"));
        builder.addFixer(new BlockEntityFurnaceBurnTimeFix(schema241, "minecraft:blast_furnace"));
        Schema schema242 = builder.addSchema(4187, c);
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Villager follow range fix undo", "minecraft:villager", "minecraft:follow_range", d2 -> d2 == 48.0 ? 16.0 : d2));
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Bee follow range fix", "minecraft:bee", "minecraft:follow_range", d2 -> d2 == 48.0 ? 16.0 : d2));
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Allay follow range fix", "minecraft:allay", "minecraft:follow_range", d2 -> d2 == 48.0 ? 16.0 : d2));
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Llama follow range fix", "minecraft:llama", "minecraft:follow_range", d2 -> d2 == 40.0 ? 16.0 : d2));
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Piglin Brute follow range fix", "minecraft:piglin_brute", "minecraft:follow_range", d2 -> d2 == 16.0 ? 12.0 : d2));
        builder.addFixer(new EntityAttributeBaseValueFix(schema242, "Warden follow range fix", "minecraft:warden", "minecraft:follow_range", d2 -> d2 == 16.0 ? 24.0 : d2));
        Schema schema243 = builder.addSchema(4290, V4290::new);
        builder.addFixer(new UnflattenTextComponentFix(schema243));
        Schema schema244 = builder.addSchema(4291, c);
        builder.addFixer(new LegacyHoverEventFix(schema244));
        builder.addFixer(new TextComponentStringifiedFlagsFix(schema244));
        Schema schema245 = builder.addSchema(4292, V4292::new);
        builder.addFixer(new TextComponentHoverAndClickEventFix(schema245));
        Schema schema246 = builder.addSchema(4293, c);
        builder.addFixer(new DropChancesFormatFix(schema246));
        Schema schema263 = builder.addSchema(4294, c);
        builder.addFixer(new BlockPropertyRenameAndFix((Schema)schema247, "CreakingHeartBlockStateFix", "minecraft:creaking_heart", "active", "creaking_heart_state", string -> string.equals("true") ? "awake" : "uprooted"));
        Schema schema264 = builder.addSchema(4295, c);
        builder.addFixer(new BlendingDataFix((Schema)schema248));
        Schema schema265 = builder.addSchema(4296, c);
        builder.addFixer(new AreaEffectCloudDurationScaleFix((Schema)schema249));
        Schema schema266 = builder.addSchema(4297, c);
        builder.addFixer(new ForcedChunkToTicketFix((Schema)schema250));
        Schema schema267 = builder.addSchema(4299, c);
        builder.addFixer(new EntitySpawnerItemVariantComponentFix((Schema)schema251));
        Schema schema268 = builder.addSchema(4300, V4300::new);
        builder.addFixer(new SaddleEquipmentSlotFix((Schema)schema252));
        Schema schema269 = builder.addSchema(4301, V4301::new);
        builder.addFixer(new EquipmentFormatFix((Schema)schema253));
        Schema schema270 = builder.addSchema(4302, V4302::new);
        builder.addFixer(new DataConverterAddChoices((Schema)schema254, "Added Test and Test Instance Block Entities", DataConverterTypes.s));
        Schema schema271 = builder.addSchema(4303, c);
        builder.addFixer(new EntityFallDistanceFloatToDoubleFix((Schema)schema255, DataConverterTypes.D));
        builder.addFixer(new EntityFallDistanceFloatToDoubleFix((Schema)schema255, DataConverterTypes.b));
        Schema schema272 = builder.addSchema(4305, c);
        builder.addFixer(new BlockPropertyRenameAndFix((Schema)schema256, "rename test block mode", "minecraft:test_block", "test_block_mode", "mode", string -> string));
        Schema schema273 = builder.addSchema(4306, V4306::new);
        builder.addFixer(new ThrownPotionSplitFix((Schema)schema257));
        Schema schema274 = builder.addSchema(4307, V4307::new);
        builder.addFixer(new TooltipDisplayComponentFix((Schema)schema258));
        Schema schema275 = builder.addSchema(4309, c);
        builder.addFixer(new RaidRenamesDataFix((Schema)schema259));
        builder.addFixer(new ChunkTicketUnpackPosFix((Schema)schema259));
        Schema schema276 = builder.addSchema(4311, c);
        builder.addFixer(new DataConverterAdvancementBase((Schema)schema260, false, "Use lodestone category change", DataConverterRegistry.a("minecraft:nether/use_lodestone", "minecraft:adventure/use_lodestone")));
        Schema schema277 = builder.addSchema(4312, V4312::new);
        builder.addFixer(new PlayerEquipmentFix((Schema)schema261));
        Schema schema278 = builder.addSchema(4314, c);
        builder.addFixer(new InlineBlockPosFormatFix((Schema)schema262));
    }

    private static UnaryOperator<String> a(Map<String, String> renameMap) {
        return string -> renameMap.getOrDefault(string, (String)string);
    }

    private static UnaryOperator<String> b(Map<String, String> renameMap) {
        return string -> renameMap.getOrDefault(DataConverterSchemaNamed.a(string), (String)string);
    }

    private static UnaryOperator<String> a(String oldName, String newName) {
        return string -> Objects.equals(DataConverterSchemaNamed.a(string), oldName) ? newName : string;
    }
}

