/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class BannerEntityCustomNameToOverrideComponentFix
extends DataFix {
    public BannerEntityCustomNameToOverrideComponentFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.s);
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.s);
        OpticFinder opticFinder = type.findField("CustomName");
        OpticFinder opticFinder1 = DSL.typeFinder((Type)this.getInputSchema().getType(DataConverterTypes.z));
        return this.fixTypeEverywhereTyped("Banner entity custom_name to item_name component fix", type, typed -> {
            Object first = ((Pair)typed.get(taggedChoiceType.finder())).getFirst();
            return first.equals("minecraft:banner") ? this.a((Typed<?>)typed, (OpticFinder<Pair<String, String>>)opticFinder1, (OpticFinder<?>)opticFinder) : typed;
        });
    }

    private Typed<?> a(Typed<?> data, OpticFinder<Pair<String, String>> textComponentTypeOptic, OpticFinder<?> customNameOptic) {
        Optional optional = data.getOptionalTyped(customNameOptic).flatMap(typed -> typed.getOptional(textComponentTypeOptic).map(Pair::getSecond));
        boolean isPresent = optional.flatMap(LegacyComponentDataFixUtils::d).filter(string -> string.equals("block.minecraft.ominous_banner")).isPresent();
        return isPresent ? SystemUtils.a(data, data.getType(), dynamic -> {
            Dynamic dynamic1 = dynamic.createMap(Map.of(dynamic.createString("minecraft:item_name"), dynamic.createString((String)optional.get()), dynamic.createString("minecraft:hide_additional_tooltip"), dynamic.emptyMap()));
            return dynamic.set("components", dynamic1).remove("CustomName");
        }) : data;
    }
}

