/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class ChunkRenamesFix
extends DataFix {
    public ChunkRenamesFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder1 = opticFinder.type().findField("Structures");
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.c);
        Type type2 = type1.findFieldType("structures");
        return this.fixTypeEverywhereTyped("Chunk Renames; purge Level-tag", type, type1, typed -> {
            Typed typed1 = typed.getTyped(opticFinder);
            Typed<?> typed2 = ChunkRenamesFix.a(typed1);
            typed2 = typed2.set(DSL.remainderFinder(), ChunkRenamesFix.a(typed, (Dynamic)((Object)((Object)typed1.get(DSL.remainderFinder())))));
            typed2 = ChunkRenamesFix.a(typed2, "TileEntities", "block_entities");
            typed2 = ChunkRenamesFix.a(typed2, "TileTicks", "block_ticks");
            typed2 = ChunkRenamesFix.a(typed2, "Entities", "entities");
            typed2 = ChunkRenamesFix.a(typed2, "Sections", "sections");
            typed2 = typed2.updateTyped(opticFinder1, type2, typed3 -> ChunkRenamesFix.a(typed3, "Starts", "starts"));
            typed2 = ChunkRenamesFix.a(typed2, "Structures", "structures");
            return typed2.update(DSL.remainderFinder(), dynamic -> dynamic.remove("Level"));
        });
    }

    private static Typed<?> a(Typed<?> typed, String oldName, String newName) {
        return ChunkRenamesFix.a(typed, oldName, newName, typed.getType().findFieldType(oldName)).update(DSL.remainderFinder(), dynamic -> dynamic.remove(oldName));
    }

    private static <A> Typed<?> a(Typed<?> typed, String oldName, String newName, Type<A> type) {
        Type type1 = DSL.optional((Type)DSL.field((String)oldName, type));
        Type type2 = DSL.optional((Type)DSL.field((String)newName, type));
        return typed.update(type1.finder(), type2, Function.identity());
    }

    private static <A> Typed<Pair<String, A>> a(Typed<A> typed) {
        return new Typed(DSL.named((String)"chunk", (Type)typed.getType()), typed.getOps(), (Object)Pair.of((Object)"chunk", (Object)typed.getValue()));
    }

    private static <T> Dynamic<T> a(Typed<?> typed, Dynamic<T> dynamic) {
        DynamicOps ops = dynamic.getOps();
        Dynamic dynamic1 = ((Dynamic)((Object)typed.get(DSL.remainderFinder()))).convert(ops);
        DataResult dataResult = ops.getMap(dynamic.getValue()).flatMap(mapLike -> ops.mergeToMap(dynamic1.getValue(), mapLike));
        return dataResult.result().map(object -> new Dynamic<Object>(ops, object)).orElse(dynamic);
    }
}

