/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterCustomNameTile
extends DataFix {
    private static final Set<String> a = Set.of("minecraft:beacon", "minecraft:banner", "minecraft:brewing_stand", "minecraft:chest", "minecraft:trapped_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:enchanting_table", "minecraft:furnace", "minecraft:hopper", "minecraft:shulker_box");

    public DataConverterCustomNameTile(Schema outputSchema) {
        super(outputSchema, true);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
        Type type = this.getInputSchema().getType(DataConverterTypes.s);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.s);
        Type<?> type2 = ExtraDataFixUtils.a(type, type, type1);
        return this.fixTypeEverywhereTyped("BlockEntityCustomNameToComponentFix", type, type1, typed -> {
            Optional optional = typed.getOptional(opticFinder);
            return optional.isPresent() && !a.contains(optional.get()) ? ExtraDataFixUtils.a(type1, typed) : SystemUtils.a(ExtraDataFixUtils.a(type2, typed), type1, DataConverterCustomNameTile::a);
        });
    }

    public static <T> Dynamic<T> a(Dynamic<T> tag) {
        String string = tag.get("CustomName").asString("");
        return string.isEmpty() ? tag.remove("CustomName") : tag.set("CustomName", LegacyComponentDataFixUtils.a(tag.getOps(), string));
    }
}

