/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterDropChances
extends DataFix {
    private static final Codec<List<Float>> a = Codec.FLOAT.listOf();

    public DataConverterDropChances(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityRedundantChanceTagsFix", this.getInputSchema().getType(DataConverterTypes.D), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            if (DataConverterDropChances.a(dynamic.get("HandDropChances"), 2)) {
                dynamic = dynamic.remove("HandDropChances");
            }
            if (DataConverterDropChances.a(dynamic.get("ArmorDropChances"), 4)) {
                dynamic = dynamic.remove("ArmorDropChances");
            }
            return dynamic;
        }));
    }

    private static boolean a(OptionalDynamic<?> list, int size) {
        return list.flatMap(arg_0 -> a.parse(arg_0)).map(list1 -> list1.size() == size && list1.stream().allMatch(_float -> _float.floatValue() == 0.0f)).result().orElse(false);
    }
}

