/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class DataConverterEntityRenameAbstract
extends DataFix {
    private final String a;

    public DataConverterEntityRenameAbstract(String name, Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
        this.a = name;
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.D);
        TaggedChoice.TaggedChoiceType taggedChoiceType1 = this.getOutputSchema().findChoiceType(DataConverterTypes.D);
        Type type = DSL.named((String)DataConverterTypes.B.typeName(), DataConverterSchemaNamed.a());
        if (!Objects.equals(this.getOutputSchema().getType(DataConverterTypes.B), type)) {
            throw new IllegalStateException("Entity name type is not what was expected.");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere(this.a, (Type)taggedChoiceType, (Type)taggedChoiceType1, dynamicOps -> pair -> pair.mapFirst(string -> {
            String string1 = this.a((String)string);
            Type type1 = (Type)taggedChoiceType.types().get(string);
            Type type2 = (Type)taggedChoiceType1.types().get(string1);
            if (!type2.equals((Object)type1, true, true)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Dynamic type check failed: %s not equal to %s", type2, type1));
            }
            return string1;
        })), (TypeRewriteRule)this.fixTypeEverywhere(this.a + " for entity name", type, dynamicOps -> pair -> pair.mapSecond(this::a)));
    }

    protected abstract String a(String var1);
}

