/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterEquipment
extends DataFix {
    public DataConverterEquipment(Schema outputSchema) {
        super(outputSchema, true);
    }

    public TypeRewriteRule makeRule() {
        return this.a(this.getInputSchema().getTypeRaw(DataConverterTypes.t), this.getOutputSchema().getTypeRaw(DataConverterTypes.t));
    }

    private <ItemStackOld, ItemStackNew> TypeRewriteRule a(Type<ItemStackOld> oldItemStackType, Type<ItemStackNew> newItemStackType) {
        Type type = DSL.named((String)DataConverterTypes.A.typeName(), (Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(oldItemStackType))));
        Type type1 = DSL.named((String)DataConverterTypes.A.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(newItemStackType))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(newItemStackType))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", newItemStackType)), (Type)DSL.optional((Type)DSL.field((String)"saddle", newItemStackType))));
        if (!type.equals((Object)this.getInputSchema().getType(DataConverterTypes.A))) {
            throw new IllegalStateException("Input entity_equipment type does not match expected");
        }
        if (!type1.equals((Object)this.getOutputSchema().getType(DataConverterTypes.A))) {
            throw new IllegalStateException("Output entity_equipment type does not match expected");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix - drop chances", this.getInputSchema().getType(DataConverterTypes.D), typed -> typed.update(DSL.remainderFinder(), DataConverterEquipment::a)), (TypeRewriteRule)this.fixTypeEverywhere("EntityEquipmentToArmorAndHandFix - equipment", type, type1, dynamicOps -> {
            Object first = ((Pair)newItemStackType.read(new Dynamic(dynamicOps).emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
            Either either = Either.right(DSL.unit());
            return pair -> pair.mapSecond(either1 -> {
                List list = either1.map(Function.identity(), unit -> List.of());
                Either<Object, Object> either2 = Either.right(DSL.unit());
                Either<Object, Object> either3 = Either.right(DSL.unit());
                if (!list.isEmpty()) {
                    either2 = Either.left(Lists.newArrayList((Object[])new Object[]{list.getFirst(), first}));
                }
                if (list.size() > 1) {
                    ArrayList list1 = Lists.newArrayList((Object[])new Object[]{first, first, first, first});
                    for (int i2 = 1; i2 < Math.min(list.size(), 5); ++i2) {
                        list1.set(i2 - 1, list.get(i2));
                    }
                    either3 = Either.left(list1);
                }
                return Pair.of(either3, (Object)Pair.of(either2, (Object)Pair.of((Object)either, (Object)either)));
            });
        }));
    }

    private static Dynamic<?> a(Dynamic<?> data) {
        Optional optional = data.get("DropChances").asStreamOpt().result();
        data = data.remove("DropChances");
        if (optional.isPresent()) {
            Iterator iterator = Stream.concat(((Stream)optional.get()).map(dynamic -> Float.valueOf(dynamic.asFloat(0.0f))), Stream.generate(() -> Float.valueOf(0.0f))).iterator();
            float f2 = ((Float)iterator.next()).floatValue();
            if (data.get("HandDropChances").result().isEmpty()) {
                data = data.set("HandDropChances", data.createList(Stream.of(Float.valueOf(f2), Float.valueOf(0.0f)).map(arg_0 -> data.createFloat(arg_0))));
            }
            if (data.get("ArmorDropChances").result().isEmpty()) {
                data = data.set("ArmorDropChances", data.createList(Stream.of((Float)iterator.next(), (Float)iterator.next(), (Float)iterator.next(), (Float)iterator.next()).map(arg_0 -> data.createFloat(arg_0))));
            }
        }
        return data;
    }
}

