/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.FieldFinder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.CompoundList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterMissingDimension
extends DataFix {
    public DataConverterMissingDimension(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected static <A> Type<Pair<A, Dynamic<?>>> a(String name, Type<A> element) {
        return DSL.and((Type)DSL.field((String)name, element), (Type)DSL.remainderType());
    }

    protected static <A> Type<Pair<Either<A, Unit>, Dynamic<?>>> b(String name, Type<A> element) {
        return DSL.and((Type)DSL.optional((Type)DSL.field((String)name, element)), (Type)DSL.remainderType());
    }

    protected static <A1, A2> Type<Pair<Either<A1, Unit>, Pair<Either<A2, Unit>, Dynamic<?>>>> a(String name1, Type<A1> element1, String name2, Type<A2> element2) {
        return DSL.and((Type)DSL.optional((Type)DSL.field((String)name1, element1)), (Type)DSL.optional((Type)DSL.field((String)name2, element2)), (Type)DSL.remainderType());
    }

    protected TypeRewriteRule makeRule() {
        Schema inputSchema = this.getInputSchema();
        Type type = DSL.taggedChoiceType((String)"type", (Type)DSL.string(), (Map)ImmutableMap.of((Object)"minecraft:debug", (Object)DSL.remainderType(), (Object)"minecraft:flat", DataConverterMissingDimension.a(inputSchema), (Object)"minecraft:noise", DataConverterMissingDimension.a("biome_source", DSL.taggedChoiceType((String)"type", (Type)DSL.string(), (Map)ImmutableMap.of((Object)"minecraft:fixed", DataConverterMissingDimension.a("biome", inputSchema.getType(DataConverterTypes.M)), (Object)"minecraft:multi_noise", (Object)DSL.list(DataConverterMissingDimension.a("biome", inputSchema.getType(DataConverterTypes.M))), (Object)"minecraft:checkerboard", DataConverterMissingDimension.a("biomes", DSL.list((Type)inputSchema.getType(DataConverterTypes.M))), (Object)"minecraft:vanilla_layered", (Object)DSL.remainderType(), (Object)"minecraft:the_end", (Object)DSL.remainderType())), "settings", DSL.or((Type)DSL.string(), DataConverterMissingDimension.a("default_block", inputSchema.getType(DataConverterTypes.E), "default_fluid", inputSchema.getType(DataConverterTypes.E))))));
        CompoundList.CompoundListType compoundListType = DSL.compoundList(DataConverterSchemaNamed.a(), DataConverterMissingDimension.a("generator", type));
        Type type1 = DSL.and((Type)compoundListType, (Type)DSL.remainderType());
        Type type2 = inputSchema.getType(DataConverterTypes.O);
        FieldFinder fieldFinder = new FieldFinder("dimensions", type1);
        if (!type2.findFieldType("dimensions").equals((Object)type1)) {
            throw new IllegalStateException();
        }
        OpticFinder opticFinder = compoundListType.finder();
        return this.fixTypeEverywhereTyped("MissingDimensionFix", type2, typed -> typed.updateTyped((OpticFinder)fieldFinder, typed1 -> typed1.updateTyped(opticFinder, typed2 -> {
            if (!(typed2.getValue() instanceof List)) {
                throw new IllegalStateException("List exptected");
            }
            if (((List)typed2.getValue()).isEmpty()) {
                Dynamic dynamic = (Dynamic)((Object)((Object)((Object)((Object)typed.get(DSL.remainderFinder())))));
                Dynamic dynamic1 = this.a(dynamic);
                return (Typed)DataFixUtils.orElse(compoundListType.readTyped(dynamic1).result().map(Pair::getFirst), (Object)typed2);
            }
            return typed2;
        })));
    }

    protected static Type<? extends Pair<? extends Either<? extends Pair<? extends Either<?, Unit>, ? extends Pair<? extends Either<? extends List<? extends Pair<? extends Either<?, Unit>, Dynamic<?>>>, Unit>, Dynamic<?>>>, Unit>, Dynamic<?>>> a(Schema schema) {
        return DataConverterMissingDimension.b("settings", DataConverterMissingDimension.a("biome", schema.getType(DataConverterTypes.M), "layers", DSL.list(DataConverterMissingDimension.b("block", schema.getType(DataConverterTypes.E)))));
    }

    private <T> Dynamic<T> a(Dynamic<T> dynamic) {
        long _long = dynamic.get("seed").asLong(0L);
        return new Dynamic<T>(dynamic.getOps(), DataConverterWorldGenSettingsBuilding.a(dynamic, _long, DataConverterWorldGenSettingsBuilding.a(dynamic, _long), false));
    }
}

