/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterEntityName;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterZombieType
extends DataConverterEntityName {
    private final Supplier<Type<?>> b = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(DataConverterTypes.D, "ZombieVillager"));

    public DataConverterZombieType(Schema outputSchema) {
        super("EntityZombieSplitFix", outputSchema, true);
    }

    @Override
    protected Pair<String, Typed<?>> a(String entityName, Typed<?> typed) {
        String string;
        if (!entityName.equals("Zombie")) {
            return Pair.of((Object)entityName, typed);
        }
        Dynamic dynamic = (Dynamic)((Object)typed.getOptional(DSL.remainderFinder()).orElseThrow());
        int _int = dynamic.get("ZombieType").asInt(0);
        return Pair.of((Object)string, (Object)(switch (_int) {
            case 1, 2, 3, 4, 5 -> {
                string = "ZombieVillager";
                yield this.a(typed, _int - 1);
            }
            case 6 -> {
                string = "Husk";
                yield typed;
            }
            default -> {
                string = "Zombie";
                yield typed;
            }
        }).update(DSL.remainderFinder(), dynamic1 -> dynamic1.remove("ZombieType")));
    }

    private Typed<?> a(Typed<?> typed, int profession) {
        return SystemUtils.a(typed, this.b.get(), dynamic -> dynamic.set("Profession", dynamic.createInt(profession)));
    }
}

