/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class EntitySpawnerItemVariantComponentFix
extends DataFix {
    public EntitySpawnerItemVariantComponentFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public final TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.F.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder1 = type.findField("components");
        return this.fixTypeEverywhereTyped("ItemStack bucket_entity_data variants to separate components", type, typed -> {
            String string;
            return switch (string = typed.getOptional(opticFinder).map(Pair::getSecond).orElse("")) {
                case "minecraft:salmon_bucket" -> typed.updateTyped(opticFinder1, EntitySpawnerItemVariantComponentFix::c);
                case "minecraft:axolotl_bucket" -> typed.updateTyped(opticFinder1, EntitySpawnerItemVariantComponentFix::b);
                case "minecraft:tropical_fish_bucket" -> typed.updateTyped(opticFinder1, EntitySpawnerItemVariantComponentFix::a);
                case "minecraft:painting" -> typed.updateTyped(opticFinder1, typed1 -> SystemUtils.a(typed1, typed1.getType(), EntitySpawnerItemVariantComponentFix::a));
                default -> typed;
            };
        });
    }

    private static String a(int variant) {
        return ExtraDataFixUtils.a(variant >> 16 & 0xFF);
    }

    private static String b(int variant) {
        return ExtraDataFixUtils.a(variant >> 24 & 0xFF);
    }

    private static String c(int variant) {
        return switch (variant & 0xFFFF) {
            case 1 -> "flopper";
            case 256 -> "sunstreak";
            case 257 -> "stripey";
            case 512 -> "snooper";
            case 513 -> "glitter";
            case 768 -> "dasher";
            case 769 -> "blockfish";
            case 1024 -> "brinely";
            case 1025 -> "betty";
            case 1280 -> "spotty";
            case 1281 -> "clayfish";
            default -> "kob";
        };
    }

    private static <T> Dynamic<T> a(Dynamic<T> data, Dynamic<T> entityData) {
        Optional optional = entityData.get("BucketVariantTag").asNumber().result();
        if (optional.isEmpty()) {
            return data;
        }
        int i2 = ((Number)optional.get()).intValue();
        String pattern = EntitySpawnerItemVariantComponentFix.c(i2);
        String baseColor = EntitySpawnerItemVariantComponentFix.a(i2);
        String patternColor = EntitySpawnerItemVariantComponentFix.b(i2);
        return data.update("minecraft:bucket_entity_data", dynamic -> dynamic.remove("BucketVariantTag")).set("minecraft:tropical_fish/pattern", data.createString(pattern)).set("minecraft:tropical_fish/base_color", data.createString(baseColor)).set("minecraft:tropical_fish/pattern_color", data.createString(patternColor));
    }

    private static <T> Dynamic<T> b(Dynamic<T> data, Dynamic<T> entityData) {
        Optional optional = entityData.get("Variant").asNumber().result();
        if (optional.isEmpty()) {
            return data;
        }
        String string = switch (((Number)optional.get()).intValue()) {
            case 1 -> "wild";
            case 2 -> "gold";
            case 3 -> "cyan";
            case 4 -> "blue";
            default -> "lucy";
        };
        return data.update("minecraft:bucket_entity_data", dynamic -> dynamic.remove("Variant")).set("minecraft:axolotl/variant", data.createString(string));
    }

    private static <T> Dynamic<T> c(Dynamic<T> data, Dynamic<T> entityData) {
        Optional optional = entityData.get("type").result();
        return optional.isEmpty() ? data : data.update("minecraft:bucket_entity_data", dynamic -> dynamic.remove("type")).set("minecraft:salmon/size", (Dynamic)((Object)optional.get()));
    }

    private static <T> Dynamic<T> a(Dynamic<T> data) {
        Optional optional = data.get("minecraft:entity_data").result();
        if (optional.isEmpty()) {
            return data;
        }
        if (((Dynamic)((Object)optional.get())).get("id").asString().result().filter(string -> string.equals("minecraft:painting")).isEmpty()) {
            return data;
        }
        Optional optional1 = ((Dynamic)((Object)optional.get())).get("variant").result();
        Dynamic dynamic = ((Dynamic)((Object)optional.get())).remove("variant");
        data = dynamic.remove("id").equals((Object)dynamic.emptyMap()) ? data.remove("minecraft:entity_data") : data.set("minecraft:entity_data", dynamic);
        if (optional1.isPresent()) {
            data = data.set("minecraft:painting/variant", (Dynamic)((Object)optional1.get()));
        }
        return data;
    }

    @FunctionalInterface
    static interface a
    extends Function<Typed<?>, Typed<?>> {
        @Override
        default public Typed<?> apply(Typed<?> data) {
            return data.update(DSL.remainderFinder(), this::fixRemainder);
        }

        default public <T> Dynamic<T> fixRemainder(Dynamic<T> data) {
            return data.get("minecraft:bucket_entity_data").result().map(dynamic -> this.fixRemainder(data, (Dynamic)((Object)dynamic))).orElse(data);
        }

        public <T> Dynamic<T> fixRemainder(Dynamic<T> var1, Dynamic<T> var2);
    }
}

