/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class FixProjectileStoredItem
extends DataFix {
    private static final String a = "minecraft:empty";

    public FixProjectileStoredItem(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.D);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.D);
        return this.fixTypeEverywhereTyped("Fix AbstractArrow item type", type, type1, ExtraDataFixUtils.a(this.a("minecraft:trident", FixProjectileStoredItem::c), this.a("minecraft:arrow", FixProjectileStoredItem::a), this.a("minecraft:spectral_arrow", FixProjectileStoredItem::b)));
    }

    private Function<Typed<?>, Typed<?>> a(String itemId, a<?> fixer) {
        Type choiceType = this.getInputSchema().getChoiceType(DataConverterTypes.D, itemId);
        Type choiceType1 = this.getOutputSchema().getChoiceType(DataConverterTypes.D, itemId);
        return FixProjectileStoredItem.a(itemId, fixer, choiceType, choiceType1);
    }

    private static <T> Function<Typed<?>, Typed<?>> a(String itemId, a<?> fixer, Type<?> oldType, Type<T> newType) {
        OpticFinder opticFinder = DSL.namedChoice((String)itemId, oldType);
        return typed -> typed.updateTyped(opticFinder, newType, typed1 -> fixer.fix((Typed<?>)typed1, newType));
    }

    private static <T> Typed<T> a(Typed<?> typed, Type<T> newType) {
        return SystemUtils.a(typed, newType, dynamic -> dynamic.set("item", FixProjectileStoredItem.a(dynamic, FixProjectileStoredItem.a(dynamic))));
    }

    private static String a(Dynamic<?> arrowTag) {
        return arrowTag.get("Potion").asString(a).equals(a) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static <T> Typed<T> b(Typed<?> typed, Type<T> newType) {
        return SystemUtils.a(typed, newType, dynamic -> dynamic.set("item", FixProjectileStoredItem.a(dynamic, "minecraft:spectral_arrow")));
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, String itemId) {
        return dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("id")), (Object)((Object)dynamic.createString(itemId)), (Object)((Object)dynamic.createString("Count")), (Object)((Object)dynamic.createInt(1))));
    }

    private static <T> Typed<T> c(Typed<?> typed, Type<T> newType) {
        return new Typed(newType, typed.getOps(), typed.getValue());
    }

    static interface a<F> {
        public Typed<F> fix(Typed<?> var1, Type<F> var2);
    }
}

