/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class InlineBlockPosFormatFix
extends DataFix {
    public InlineBlockPosFormatFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder<?> opticFinder = this.a("minecraft:vex");
        OpticFinder<?> opticFinder1 = this.a("minecraft:phantom");
        OpticFinder<?> opticFinder2 = this.a("minecraft:turtle");
        List<OpticFinder<?>> list = List.of(this.a("minecraft:item_frame"), this.a("minecraft:glow_item_frame"), this.a("minecraft:painting"), this.a("minecraft:leash_knot"));
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - player", this.getInputSchema().getType(DataConverterTypes.b), typed -> typed.update(DSL.remainderFinder(), this::a)), (TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - entity", this.getInputSchema().getType(DataConverterTypes.D), typed -> {
            typed = typed.update(DSL.remainderFinder(), this::b).updateTyped(opticFinder, typed1 -> typed1.update(DSL.remainderFinder(), this::c)).updateTyped(opticFinder1, typed1 -> typed1.update(DSL.remainderFinder(), this::d)).updateTyped(opticFinder2, typed1 -> typed1.update(DSL.remainderFinder(), this::e));
            for (OpticFinder opticFinder3 : list) {
                typed = typed.updateTyped(opticFinder3, typed1 -> typed1.update(DSL.remainderFinder(), this::f));
            }
            return typed;
        }));
    }

    private OpticFinder<?> a(String entityName) {
        return DSL.namedChoice((String)entityName, (Type)this.getInputSchema().getChoiceType(DataConverterTypes.D, entityName));
    }

    private Dynamic<?> a(Dynamic<?> data) {
        Optional optional3;
        data = this.b(data);
        Optional optional = data.get("SpawnX").asNumber().result();
        Optional optional1 = data.get("SpawnY").asNumber().result();
        Optional optional2 = data.get("SpawnZ").asNumber().result();
        if (optional.isPresent() && optional1.isPresent() && optional2.isPresent()) {
            Dynamic<?> dynamic = data.createMap(Map.of(data.createString("pos"), ExtraDataFixUtils.a(data, ((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue())));
            dynamic = Dynamic.copyField(data, "SpawnAngle", dynamic, "angle");
            dynamic = Dynamic.copyField(data, "SpawnDimension", dynamic, "dimension");
            dynamic = Dynamic.copyField(data, "SpawnForced", dynamic, "forced");
            data = data.remove("SpawnX").remove("SpawnY").remove("SpawnZ").remove("SpawnAngle").remove("SpawnDimension").remove("SpawnForced");
            data = data.set("respawn", dynamic);
        }
        if ((optional3 = data.get("enteredNetherPosition").result()).isPresent()) {
            data = data.remove("enteredNetherPosition").set("entered_nether_pos", data.createList(Stream.of(data.createDouble(((Dynamic)((Object)optional3.get())).get("x").asDouble(0.0)), data.createDouble(((Dynamic)((Object)optional3.get())).get("y").asDouble(0.0)), data.createDouble(((Dynamic)((Object)optional3.get())).get("z").asDouble(0.0)))));
        }
        return data;
    }

    private Dynamic<?> b(Dynamic<?> data) {
        return ExtraDataFixUtils.a(data, "SleepingX", "SleepingY", "SleepingZ", "sleeping_pos");
    }

    private Dynamic<?> c(Dynamic<?> data) {
        return ExtraDataFixUtils.a(data.renameField("LifeTicks", "life_ticks"), "BoundX", "BoundY", "BoundZ", "bound_pos");
    }

    private Dynamic<?> d(Dynamic<?> data) {
        return ExtraDataFixUtils.a(data.renameField("Size", "size"), "AX", "AY", "AZ", "anchor_pos");
    }

    private Dynamic<?> e(Dynamic<?> data) {
        data = data.remove("TravelPosX").remove("TravelPosY").remove("TravelPosZ");
        data = ExtraDataFixUtils.a(data, "HomePosX", "HomePosY", "HomePosZ", "home_pos");
        return data.renameField("HasEgg", "has_egg");
    }

    private Dynamic<?> f(Dynamic<?> data) {
        return ExtraDataFixUtils.a(data, "TileX", "TileY", "TileZ", "block_pos");
    }
}

