/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 8;
    private static final int e = 16;
    private static final int f = 32;
    private static final int g = 64;
    private static final int h = 128;
    private static final Set<String> i = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> j = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> k = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> l = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter m = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    private static void a(a itemStackData, Dynamic<?> tag) {
        int _int = itemStackData.a("HideFlags").asInt(0);
        itemStackData.a("Damage", "minecraft:damage", tag.createInt(0));
        itemStackData.a("RepairCost", "minecraft:repair_cost", tag.createInt(0));
        itemStackData.a("CustomModelData", "minecraft:custom_model_data");
        itemStackData.a("BlockStateTag").result().ifPresent(dynamic2 -> itemStackData.a("minecraft:block_state", ItemStackComponentizationFix.b(dynamic2)));
        itemStackData.a("EntityTag", "minecraft:entity_data");
        itemStackData.a("BlockEntityTag", false, dynamic2 -> {
            String string = DataConverterSchemaNamed.a(dynamic2.get("id").asString(""));
            Dynamic dynamic3 = (dynamic2 = ItemStackComponentizationFix.a(itemStackData, dynamic2, string)).remove("id");
            return dynamic3.equals((Object)dynamic2.emptyMap()) ? dynamic3 : dynamic2;
        });
        itemStackData.a("BlockEntityTag", "minecraft:block_entity_data");
        if (itemStackData.a("Unbreakable").asBoolean(false)) {
            Dynamic dynamic = tag.emptyMap();
            if ((_int & 4) != 0) {
                dynamic = dynamic.set("show_in_tooltip", tag.createBoolean(false));
            }
            itemStackData.a("minecraft:unbreakable", dynamic);
        }
        ItemStackComponentizationFix.a(itemStackData, tag, "Enchantments", "minecraft:enchantments", (_int & 1) != 0);
        if (itemStackData.b("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.a(itemStackData, tag, "StoredEnchantments", "minecraft:stored_enchantments", (_int & 0x20) != 0);
        }
        itemStackData.a("display", false, dynamic2 -> ItemStackComponentizationFix.a(itemStackData, dynamic2, _int));
        ItemStackComponentizationFix.b(itemStackData, tag, _int);
        ItemStackComponentizationFix.c(itemStackData, tag, _int);
        Optional optional = itemStackData.a("Trim").result();
        if (optional.isPresent()) {
            Dynamic dynamic1 = (Dynamic)((Object)optional.get());
            if ((_int & 0x80) != 0) {
                dynamic1 = dynamic1.set("show_in_tooltip", dynamic1.createBoolean(false));
            }
            itemStackData.a("minecraft:trim", dynamic1);
        }
        if ((_int & 0x20) != 0) {
            itemStackData.a("minecraft:hide_additional_tooltip", tag.emptyMap());
        }
        if (itemStackData.b("minecraft:crossbow")) {
            itemStackData.a("Charged");
            itemStackData.a("ChargedProjectiles", "minecraft:charged_projectiles", tag.createList(Stream.empty()));
        }
        if (itemStackData.b("minecraft:bundle")) {
            itemStackData.a("Items", "minecraft:bundle_contents", tag.createList(Stream.empty()));
        }
        if (itemStackData.b("minecraft:filled_map")) {
            itemStackData.a("map", "minecraft:map_id");
            Map<Dynamic, Dynamic> map = itemStackData.a("Decorations").asStream().map(ItemStackComponentizationFix::e).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (dynamic2, dynamic3) -> dynamic2));
            if (!map.isEmpty()) {
                itemStackData.a("minecraft:map_decorations", tag.createMap(map));
            }
        }
        if (itemStackData.a(i)) {
            ItemStackComponentizationFix.b(itemStackData, tag);
        }
        if (itemStackData.b("minecraft:writable_book")) {
            ItemStackComponentizationFix.c(itemStackData, tag);
        }
        if (itemStackData.b("minecraft:written_book")) {
            ItemStackComponentizationFix.d(itemStackData, tag);
        }
        if (itemStackData.b("minecraft:suspicious_stew")) {
            itemStackData.a("effects", "minecraft:suspicious_stew_effects");
        }
        if (itemStackData.b("minecraft:debug_stick")) {
            itemStackData.a("DebugProperty", "minecraft:debug_stick_state");
        }
        if (itemStackData.a(j)) {
            ItemStackComponentizationFix.f(itemStackData, tag);
        }
        if (itemStackData.b("minecraft:goat_horn")) {
            itemStackData.a("instrument", "minecraft:instrument");
        }
        if (itemStackData.b("minecraft:knowledge_book")) {
            itemStackData.a("Recipes", "minecraft:recipes");
        }
        if (itemStackData.b("minecraft:compass")) {
            ItemStackComponentizationFix.g(itemStackData, tag);
        }
        if (itemStackData.b("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.b(itemStackData);
        }
        if (itemStackData.b("minecraft:firework_star")) {
            ItemStackComponentizationFix.a(itemStackData);
        }
        if (itemStackData.b("minecraft:player_head")) {
            itemStackData.a("SkullOwner").result().ifPresent(dynamic2 -> itemStackData.a("minecraft:profile", ItemStackComponentizationFix.a(dynamic2)));
        }
    }

    private static Dynamic<?> b(Dynamic<?> tag) {
        return (Dynamic)((Object)DataFixUtils.orElse(tag.asMapOpt().result().map(stream -> stream.collect(Collectors.toMap(Pair::getFirst, pair -> {
            Optional optional;
            String string = ((Dynamic)((Object)((Object)((Object)pair.getFirst())))).asString("");
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)pair.getSecond())));
            if (l.contains(string) && (optional = dynamic.asBoolean().result()).isPresent()) {
                return dynamic.createString(String.valueOf(optional.get()));
            }
            optional = dynamic.asNumber().result();
            return optional.isPresent() ? dynamic.createString(((Number)optional.get()).toString()) : dynamic;
        }))).map(arg_0 -> tag.createMap(arg_0)), tag));
    }

    private static Dynamic<?> a(a itemStackData, Dynamic<?> tag, int hideFlags) {
        Optional optional1;
        boolean flag;
        itemStackData.a("minecraft:custom_name", tag.get("Name"));
        itemStackData.a("minecraft:lore", tag.get("Lore"));
        Optional<Integer> optional = tag.get("color").asNumber().result().map(Number::intValue);
        boolean bl = flag = (hideFlags & 0x40) != 0;
        if (optional.isPresent() || flag) {
            Dynamic dynamic = tag.emptyMap().set("rgb", tag.createInt(optional.orElse(10511680)));
            if (flag) {
                dynamic = dynamic.set("show_in_tooltip", tag.createBoolean(false));
            }
            itemStackData.a("minecraft:dyed_color", dynamic);
        }
        if ((optional1 = tag.get("LocName").asString().result()).isPresent()) {
            itemStackData.a("minecraft:item_name", LegacyComponentDataFixUtils.b(tag.getOps(), (String)optional1.get()));
        }
        if (itemStackData.b("minecraft:filled_map")) {
            itemStackData.a("minecraft:map_color", tag.get("MapColor"));
            tag = tag.remove("MapColor");
        }
        return tag.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static <T> Dynamic<T> a(a itemStackData, Dynamic<T> tag, String entityId) {
        itemStackData.a("minecraft:lock", tag.get("Lock"));
        tag = tag.remove("Lock");
        Optional optional = tag.get("LootTable").result();
        if (optional.isPresent()) {
            Dynamic dynamic = tag.emptyMap().set("loot_table", (Dynamic)((Object)optional.get()));
            long _long = tag.get("LootTableSeed").asLong(0L);
            if (_long != 0L) {
                dynamic = dynamic.set("seed", tag.createLong(_long));
            }
            itemStackData.a("minecraft:container_loot", dynamic);
            tag = tag.remove("LootTable").remove("LootTableSeed");
        }
        return switch (entityId) {
            case "minecraft:skull" -> {
                itemStackData.a("minecraft:note_block_sound", tag.get("note_block_sound"));
                yield tag.remove("note_block_sound");
            }
            case "minecraft:decorated_pot" -> {
                itemStackData.a("minecraft:pot_decorations", tag.get("sherds"));
                Optional optional1 = tag.get("item").result();
                if (optional1.isPresent()) {
                    itemStackData.a("minecraft:container", tag.createList(Stream.of(tag.emptyMap().set("slot", tag.createInt(0)).set("item", (Dynamic)((Object)optional1.get())))));
                }
                yield tag.remove("sherds").remove("item");
            }
            case "minecraft:banner" -> {
                itemStackData.a("minecraft:banner_patterns", tag.get("patterns"));
                Optional optional1 = tag.get("Base").asNumber().result();
                if (optional1.isPresent()) {
                    itemStackData.a("minecraft:base_color", tag.createString(ExtraDataFixUtils.a(((Number)optional1.get()).intValue())));
                }
                yield tag.remove("patterns").remove("Base");
            }
            case "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter" -> {
                List list = tag.get("Items").asList(dynamic1 -> dynamic1.emptyMap().set("slot", dynamic1.createInt(dynamic1.get("Slot").asByte((byte)0) & 0xFF)).set("item", dynamic1.remove("Slot")));
                if (!list.isEmpty()) {
                    itemStackData.a("minecraft:container", tag.createList(list.stream()));
                }
                yield tag.remove("Items");
            }
            case "minecraft:beehive" -> {
                itemStackData.a("minecraft:bees", tag.get("bees"));
                yield tag.remove("bees");
            }
            default -> tag;
        };
    }

    private static void a(a itemStackData, Dynamic<?> tag, String key, String component, boolean hideEnchantments) {
        OptionalDynamic<?> optionalDynamic = itemStackData.a(key);
        List list = optionalDynamic.asList(Function.identity()).stream().flatMap(dynamic2 -> ItemStackComponentizationFix.c(dynamic2).stream()).toList();
        if (!list.isEmpty() || hideEnchantments) {
            Dynamic dynamic = tag.emptyMap();
            Dynamic dynamic1 = tag.emptyMap();
            for (Pair pair : list) {
                dynamic1 = dynamic1.set((String)pair.getFirst(), tag.createInt((Integer)pair.getSecond()));
            }
            dynamic = dynamic.set("levels", dynamic1);
            if (hideEnchantments) {
                dynamic = dynamic.set("show_in_tooltip", tag.createBoolean(false));
            }
            itemStackData.a(component, dynamic);
        }
        if (optionalDynamic.result().isPresent() && list.isEmpty()) {
            itemStackData.a("minecraft:enchantment_glint_override", tag.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> c(Dynamic<?> enchantmentTag) {
        return enchantmentTag.get("id").asString().apply2stable((string, number) -> Pair.of((Object)string, (Object)MathHelper.a(number.intValue(), 0, 255)), enchantmentTag.get("lvl").asNumber()).result();
    }

    private static void b(a itemStackData, Dynamic<?> tag, int hideFlags) {
        ItemStackComponentizationFix.b(itemStackData, tag, "CanDestroy", "minecraft:can_break", (hideFlags & 8) != 0);
        ItemStackComponentizationFix.b(itemStackData, tag, "CanPlaceOn", "minecraft:can_place_on", (hideFlags & 0x10) != 0);
    }

    private static void b(a itemStackData, Dynamic<?> tag, String key, String component, boolean hide) {
        Optional optional = itemStackData.a(key).result();
        if (!optional.isEmpty()) {
            Dynamic dynamic = tag.emptyMap().set("predicates", tag.createList(((Dynamic)((Object)optional.get())).asStream().map(dynamic1 -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic1.asString().map(string -> ItemStackComponentizationFix.a(dynamic1, string)).result(), (Object)dynamic1))))));
            if (hide) {
                dynamic = dynamic.set("show_in_tooltip", tag.createBoolean(false));
            }
            itemStackData.a(component, dynamic);
        }
    }

    private static Dynamic<?> a(Dynamic<?> tag, String blockId) {
        int index = blockId.indexOf(91);
        int index1 = blockId.indexOf(123);
        int len = blockId.length();
        if (index != -1) {
            len = index;
        }
        if (index1 != -1) {
            len = Math.min(len, index1);
        }
        String sub = blockId.substring(0, len);
        Dynamic dynamic = tag.emptyMap().set("blocks", tag.createString(sub.trim()));
        int index2 = blockId.indexOf(93);
        if (index != -1 && index2 != -1) {
            Dynamic dynamic1 = tag.emptyMap();
            for (String string : m.split((CharSequence)blockId.substring(index + 1, index2))) {
                int index3 = string.indexOf(61);
                if (index3 == -1) continue;
                String trimmed = string.substring(0, index3).trim();
                String trimmed1 = string.substring(index3 + 1).trim();
                dynamic1 = dynamic1.set(trimmed, tag.createString(trimmed1));
            }
            dynamic = dynamic.set("state", dynamic1);
        }
        int index4 = blockId.indexOf(125);
        if (index1 != -1 && index4 != -1) {
            dynamic = dynamic.set("nbt", tag.createString(blockId.substring(index1, index4 + 1)));
        }
        return dynamic;
    }

    private static void c(a itemStackData, Dynamic<?> tag, int hideFlags) {
        OptionalDynamic<?> optionalDynamic = itemStackData.a("AttributeModifiers");
        if (!optionalDynamic.result().isEmpty()) {
            boolean flag = (hideFlags & 2) != 0;
            List list = optionalDynamic.asList(ItemStackComponentizationFix::d);
            Dynamic dynamic = tag.emptyMap().set("modifiers", tag.createList(list.stream()));
            if (flag) {
                dynamic = dynamic.set("show_in_tooltip", tag.createBoolean(false));
            }
            itemStackData.a("minecraft:attribute_modifiers", dynamic);
        }
    }

    private static Dynamic<?> d(Dynamic<?> tag) {
        Dynamic<Object> dynamic = tag.emptyMap().set("name", tag.createString("")).set("amount", tag.createDouble(0.0)).set("operation", tag.createString("add_value"));
        dynamic = Dynamic.copyField(tag, "AttributeName", dynamic, "type");
        dynamic = Dynamic.copyField(tag, "Slot", dynamic, "slot");
        dynamic = Dynamic.copyField(tag, "UUID", dynamic, "uuid");
        dynamic = Dynamic.copyField(tag, "Name", dynamic, "name");
        dynamic = Dynamic.copyField(tag, "Amount", dynamic, "amount");
        return Dynamic.copyAndFixField(tag, "Operation", dynamic, "operation", dynamic1 -> dynamic1.createString(switch (dynamic1.asInt(0)) {
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
            default -> "add_value";
        }));
    }

    private static Pair<Dynamic<?>, Dynamic<?>> e(Dynamic<?> tag) {
        Dynamic dynamic = (Dynamic)((Object)DataFixUtils.orElseGet((Optional)tag.get("id").result(), () -> tag.createString("")));
        Dynamic dynamic1 = tag.emptyMap().set("type", tag.createString(ItemStackComponentizationFix.a(tag.get("type").asInt(0)))).set("x", tag.createDouble(tag.get("x").asDouble(0.0))).set("z", tag.createDouble(tag.get("z").asDouble(0.0))).set("rotation", tag.createFloat((float)tag.get("rot").asDouble(0.0)));
        return Pair.of((Object)((Object)dynamic), dynamic1);
    }

    private static String a(int decorationType) {
        return switch (decorationType) {
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
            default -> "player";
        };
    }

    private static void b(a itemStackData, Dynamic<?> tag) {
        Dynamic<?> dynamic = tag.emptyMap();
        Optional<String> optional = itemStackData.a("Potion").asString().result().filter(string -> !string.equals("minecraft:empty"));
        if (optional.isPresent()) {
            dynamic = dynamic.set("potion", tag.createString(optional.get()));
        }
        dynamic = itemStackData.a("CustomPotionColor", dynamic, "custom_color");
        if (!(dynamic = itemStackData.a("custom_potion_effects", dynamic, "custom_effects")).equals((Object)tag.emptyMap())) {
            itemStackData.a("minecraft:potion_contents", dynamic);
        }
    }

    private static void c(a itemStackData, Dynamic<?> tag) {
        Dynamic<?> dynamic = ItemStackComponentizationFix.e(itemStackData, tag);
        if (dynamic != null) {
            itemStackData.a("minecraft:writable_book_content", tag.emptyMap().set("pages", dynamic));
        }
    }

    private static void d(a itemStackData, Dynamic<?> tag) {
        Dynamic<?> dynamic = ItemStackComponentizationFix.e(itemStackData, tag);
        String string = itemStackData.a("title").asString("");
        Optional optional = itemStackData.a("filtered_title").asString().result();
        Dynamic<Object> dynamic1 = tag.emptyMap();
        dynamic1 = dynamic1.set("title", ItemStackComponentizationFix.a(tag, string, optional));
        dynamic1 = itemStackData.a("author", dynamic1, "author");
        dynamic1 = itemStackData.a("resolved", dynamic1, "resolved");
        dynamic1 = itemStackData.a("generation", dynamic1, "generation");
        if (dynamic != null) {
            dynamic1 = dynamic1.set("pages", dynamic);
        }
        itemStackData.a("minecraft:written_book_content", dynamic1);
    }

    @Nullable
    private static Dynamic<?> e(a itemStackData, Dynamic<?> tag) {
        List list = itemStackData.a("pages").asList(dynamic -> dynamic.asString(""));
        Map map = itemStackData.a("filtered_pages").asMap(dynamic -> dynamic.asString("0"), dynamic -> dynamic.asString(""));
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list1 = new ArrayList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            String string1 = (String)map.get(String.valueOf(i2));
            list1.add(ItemStackComponentizationFix.a(tag, string, Optional.ofNullable(string1)));
        }
        return tag.createList(list1.stream());
    }

    private static Dynamic<?> a(Dynamic<?> tag, String unfilteredText, Optional<String> filteredText) {
        Dynamic dynamic = tag.emptyMap().set("raw", tag.createString(unfilteredText));
        if (filteredText.isPresent()) {
            dynamic = dynamic.set("filtered", tag.createString(filteredText.get()));
        }
        return dynamic;
    }

    private static void f(a itemStackData, Dynamic<?> tag) {
        Dynamic<?> dynamic = tag.emptyMap();
        for (String string : k) {
            dynamic = itemStackData.a(string, dynamic, string);
        }
        if (!dynamic.equals((Object)tag.emptyMap())) {
            itemStackData.a("minecraft:bucket_entity_data", dynamic);
        }
    }

    private static void g(a itemStackData, Dynamic<?> tag) {
        Optional optional = itemStackData.a("LodestonePos").result();
        Optional optional1 = itemStackData.a("LodestoneDimension").result();
        if (!optional.isEmpty() || !optional1.isEmpty()) {
            boolean _boolean = itemStackData.a("LodestoneTracked").asBoolean(true);
            Dynamic dynamic = tag.emptyMap();
            if (optional.isPresent() && optional1.isPresent()) {
                dynamic = dynamic.set("target", tag.emptyMap().set("pos", (Dynamic)((Object)optional.get())).set("dimension", (Dynamic)((Object)optional1.get())));
            }
            if (!_boolean) {
                dynamic = dynamic.set("tracked", tag.createBoolean(false));
            }
            itemStackData.a("minecraft:lodestone_tracker", dynamic);
        }
    }

    private static void a(a itemStackData) {
        itemStackData.a("Explosion", true, dynamic -> {
            itemStackData.a("minecraft:firework_explosion", ItemStackComponentizationFix.f(dynamic));
            return dynamic.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void b(a itemStackData) {
        itemStackData.a("Fireworks", true, dynamic -> {
            Stream<Dynamic> stream = dynamic.get("Explosions").asStream().map(ItemStackComponentizationFix::f);
            int _int = dynamic.get("Flight").asInt(0);
            itemStackData.a("minecraft:fireworks", dynamic.emptyMap().set("explosions", dynamic.createList(stream)).set("flight_duration", dynamic.createByte((byte)_int)));
            return dynamic.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> f(Dynamic<?> tag) {
        tag = tag.set("shape", tag.createString(switch (tag.get("Type").asInt(0)) {
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
            default -> "small_ball";
        })).remove("Type");
        tag = tag.renameField("Colors", "colors");
        tag = tag.renameField("FadeColors", "fade_colors");
        tag = tag.renameField("Trail", "has_trail");
        return tag.renameField("Flicker", "has_twinkle");
    }

    public static Dynamic<?> a(Dynamic<?> tag) {
        Optional optional = tag.asString().result();
        if (optional.isPresent()) {
            return ItemStackComponentizationFix.a((String)optional.get()) ? tag.emptyMap().set("name", tag.createString((String)optional.get())) : tag.emptyMap();
        }
        String string = tag.get("Name").asString("");
        Optional optional1 = tag.get("Id").result();
        Dynamic<?> dynamic = ItemStackComponentizationFix.a(tag.get("Properties"));
        Dynamic dynamic1 = tag.emptyMap();
        if (ItemStackComponentizationFix.a(string)) {
            dynamic1 = dynamic1.set("name", tag.createString(string));
        }
        if (optional1.isPresent()) {
            dynamic1 = dynamic1.set("id", (Dynamic)((Object)optional1.get()));
        }
        if (dynamic != null) {
            dynamic1 = dynamic1.set("properties", dynamic);
        }
        return dynamic1;
    }

    private static boolean a(String name) {
        return name.length() <= 16 && name.chars().filter(i2 -> i2 <= 32 || i2 >= 127).findAny().isEmpty();
    }

    @Nullable
    private static Dynamic<?> a(OptionalDynamic<?> tag) {
        Map map = tag.asMap(dynamic -> dynamic.asString(""), dynamic -> dynamic.asList(dynamic1 -> {
            String string = dynamic1.get("Value").asString("");
            Optional optional = dynamic1.get("Signature").asString().result();
            return Pair.of((Object)string, (Object)optional);
        }));
        return map.isEmpty() ? null : tag.createList(map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(pair -> {
            Dynamic dynamic = tag.emptyMap().set("name", tag.createString((String)entry.getKey())).set("value", tag.createString((String)pair.getFirst()));
            Optional optional = (Optional)pair.getSecond();
            return optional.isPresent() ? dynamic.set("signature", tag.createString((String)optional.get())) : dynamic;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(DataConverterTypes.t), this.getOutputSchema().getType(DataConverterTypes.t), dynamic -> {
            Optional<Dynamic> optional = net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(dynamic).map(itemStackData -> {
                ItemStackComponentizationFix.a(itemStackData, itemStackData.e);
                return itemStackData.a();
            });
            return (Dynamic)((Object)((Object)DataFixUtils.orElse(optional, (Object)dynamic)));
        });
    }

    static class a {
        private final String a;
        private final int b;
        private Dynamic<?> c;
        private final Dynamic<?> d;
        Dynamic<?> e;

        private a(String item, int count, Dynamic<?> nbt) {
            this.a = DataConverterSchemaNamed.a(item);
            this.b = count;
            this.c = nbt.emptyMap();
            this.e = nbt.get("tag").orElseEmptyMap();
            this.d = nbt.remove("tag");
        }

        public static Optional<a> a(Dynamic<?> tag) {
            return tag.get("id").asString().apply2stable((string, number) -> new a((String)string, number.intValue(), tag.remove("id").remove("Count")), tag.get("Count").asNumber()).result();
        }

        public OptionalDynamic<?> a(String key) {
            OptionalDynamic<?> optionalDynamic = this.e.get(key);
            this.e = this.e.remove(key);
            return optionalDynamic;
        }

        public void a(String component, Dynamic<?> value) {
            this.c = this.c.set(component, value);
        }

        public void a(String component, OptionalDynamic<?> value) {
            value.result().ifPresent(dynamic -> {
                this.c = this.c.set(component, (Dynamic<?>)((Object)dynamic));
            });
        }

        public Dynamic<?> a(String oldKey, Dynamic<?> tag, String newKey) {
            Optional optional = this.a(oldKey).result();
            return optional.isPresent() ? tag.set(newKey, (Dynamic)((Object)optional.get())) : tag;
        }

        public void a(String key, String component, Dynamic<?> tag) {
            Optional optional = this.a(key).result();
            if (optional.isPresent() && !((Dynamic)((Object)optional.get())).equals(tag)) {
                this.a(component, (Dynamic)((Object)optional.get()));
            }
        }

        public void a(String key, String component) {
            this.a(key).result().ifPresent(dynamic -> this.a(component, (Dynamic<?>)((Object)dynamic)));
        }

        public void a(String key, boolean skipIfEmpty, UnaryOperator<Dynamic<?>> fixer) {
            OptionalDynamic<?> optionalDynamic = this.e.get(key);
            if (!skipIfEmpty || !optionalDynamic.result().isEmpty()) {
                Dynamic dynamic = optionalDynamic.orElseEmptyMap();
                this.e = (dynamic = (Dynamic)((Object)fixer.apply(dynamic))).equals((Object)dynamic.emptyMap()) ? this.e.remove(key) : this.e.set(key, dynamic);
            }
        }

        public Dynamic<?> a() {
            Dynamic dynamic = this.e.emptyMap().set("id", this.e.createString(this.a)).set("count", this.e.createInt(this.b));
            if (!this.e.equals((Object)this.e.emptyMap())) {
                this.c = this.c.set("minecraft:custom_data", this.e);
            }
            if (!this.c.equals((Object)this.e.emptyMap())) {
                dynamic = dynamic.set("components", this.c);
            }
            return net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(dynamic, this.d);
        }

        private static <T> Dynamic<T> a(Dynamic<T> tag, Dynamic<?> remainder) {
            DynamicOps ops = tag.getOps();
            return ops.getMap(tag.getValue()).flatMap(mapLike -> ops.mergeToMap(remainder.convert(ops).getValue(), mapLike)).map(object -> new Dynamic<Object>(ops, object)).result().orElse(tag);
        }

        public boolean b(String item) {
            return this.a.equals(item);
        }

        public boolean a(Set<String> items) {
            return items.contains(this.a);
        }

        public boolean c(String component) {
            return this.c.get(component).result().isPresent();
        }
    }
}

