/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Hook;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.slf4j.Logger;

public class DataConverterSchemaV99
extends Schema {
    private static final Logger c = LogUtils.getLogger();
    static final Map<String, String> d = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        map.put("minecraft:furnace", "Furnace");
        map.put("minecraft:lit_furnace", "Furnace");
        map.put("minecraft:chest", "Chest");
        map.put("minecraft:trapped_chest", "Chest");
        map.put("minecraft:ender_chest", "EnderChest");
        map.put("minecraft:jukebox", "RecordPlayer");
        map.put("minecraft:dispenser", "Trap");
        map.put("minecraft:dropper", "Dropper");
        map.put("minecraft:sign", "Sign");
        map.put("minecraft:mob_spawner", "MobSpawner");
        map.put("minecraft:noteblock", "Music");
        map.put("minecraft:brewing_stand", "Cauldron");
        map.put("minecraft:enhanting_table", "EnchantTable");
        map.put("minecraft:command_block", "CommandBlock");
        map.put("minecraft:beacon", "Beacon");
        map.put("minecraft:skull", "Skull");
        map.put("minecraft:daylight_detector", "DLDetector");
        map.put("minecraft:hopper", "Hopper");
        map.put("minecraft:banner", "Banner");
        map.put("minecraft:flower_pot", "FlowerPot");
        map.put("minecraft:repeating_command_block", "CommandBlock");
        map.put("minecraft:chain_command_block", "CommandBlock");
        map.put("minecraft:standing_sign", "Sign");
        map.put("minecraft:wall_sign", "Sign");
        map.put("minecraft:piston_head", "Piston");
        map.put("minecraft:daylight_detector_inverted", "DLDetector");
        map.put("minecraft:unpowered_comparator", "Comparator");
        map.put("minecraft:powered_comparator", "Comparator");
        map.put("minecraft:wall_banner", "Banner");
        map.put("minecraft:standing_banner", "Banner");
        map.put("minecraft:structure_block", "Structure");
        map.put("minecraft:end_portal", "Airportal");
        map.put("minecraft:end_gateway", "EndGateway");
        map.put("minecraft:shield", "Banner");
    });
    public static final Map<String, String> a = Map.of("minecraft:armor_stand", "ArmorStand", "minecraft:painting", "Painting");
    protected static final Hook.HookFunction b = new Hook.HookFunction(){

        public <T> T apply(DynamicOps<T> ops, T value) {
            return DataConverterSchemaV99.a(new Dynamic<T>(ops, value), d, a);
        }
    };

    public DataConverterSchemaV99(int versionKey, Schema parent) {
        super(versionKey, parent);
    }

    protected static void a(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
        schema.register(map, name, () -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.E.in(schema)));
    }

    protected static void b(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
        schema.register(map, name, () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema)));
    }

    protected static void c(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
        schema.register(map, name, () -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
    }

    public Map<String, Supplier<TypeTemplate>> registerEntities(Schema schema) {
        HashMap map = Maps.newHashMap();
        schema.register((Map)map, "Item", string -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.t.in(schema)));
        schema.registerSimple((Map)map, "XPOrb");
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "ThrownEgg");
        schema.registerSimple((Map)map, "LeashKnot");
        schema.registerSimple((Map)map, "Painting");
        schema.register((Map)map, "Arrow", string -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.E.in(schema)));
        schema.register((Map)map, "TippedArrow", string -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.E.in(schema)));
        schema.register((Map)map, "SpectralArrow", string -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.E.in(schema)));
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "Snowball");
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "Fireball");
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "SmallFireball");
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "ThrownEnderpearl");
        schema.registerSimple((Map)map, "EyeOfEnderSignal");
        schema.register((Map)map, "ThrownPotion", string -> DSL.optionalFields((String)"inTile", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"Potion", (TypeTemplate)DataConverterTypes.t.in(schema)));
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "ThrownExpBottle");
        schema.register((Map)map, "ItemFrame", string -> DSL.optionalFields((String)"Item", (TypeTemplate)DataConverterTypes.t.in(schema)));
        DataConverterSchemaV99.a(schema, (Map<String, Supplier<TypeTemplate>>)map, "WitherSkull");
        schema.registerSimple((Map)map, "PrimedTnt");
        schema.register((Map)map, "FallingSand", string -> DSL.optionalFields((String)"Block", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"TileEntityData", (TypeTemplate)DataConverterTypes.s.in(schema)));
        schema.register((Map)map, "FireworksRocketEntity", string -> DSL.optionalFields((String)"FireworksItem", (TypeTemplate)DataConverterTypes.t.in(schema)));
        schema.registerSimple((Map)map, "Boat");
        schema.register((Map)map, "Minecart", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
        DataConverterSchemaV99.b(schema, (Map<String, Supplier<TypeTemplate>>)map, "MinecartRideable");
        schema.register((Map)map, "MinecartChest", string -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
        DataConverterSchemaV99.b(schema, (Map<String, Supplier<TypeTemplate>>)map, "MinecartFurnace");
        DataConverterSchemaV99.b(schema, (Map<String, Supplier<TypeTemplate>>)map, "MinecartTNT");
        schema.register((Map)map, "MinecartSpawner", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema), (TypeTemplate)DataConverterTypes.H.in(schema)));
        schema.register((Map)map, "MinecartHopper", string -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
        schema.register((Map)map, "MinecartCommandBlock", () -> DSL.optionalFields((String)"DisplayTile", (TypeTemplate)DataConverterTypes.E.in(schema), (String)"LastOutput", (TypeTemplate)DataConverterTypes.z.in(schema)));
        schema.registerSimple((Map)map, "ArmorStand");
        schema.registerSimple((Map)map, "Creeper");
        schema.registerSimple((Map)map, "Skeleton");
        schema.registerSimple((Map)map, "Spider");
        schema.registerSimple((Map)map, "Giant");
        schema.registerSimple((Map)map, "Zombie");
        schema.registerSimple((Map)map, "Slime");
        schema.registerSimple((Map)map, "Ghast");
        schema.registerSimple((Map)map, "PigZombie");
        schema.register((Map)map, "Enderman", string -> DSL.optionalFields((String)"carried", (TypeTemplate)DataConverterTypes.E.in(schema)));
        schema.registerSimple((Map)map, "CaveSpider");
        schema.registerSimple((Map)map, "Silverfish");
        schema.registerSimple((Map)map, "Blaze");
        schema.registerSimple((Map)map, "LavaSlime");
        schema.registerSimple((Map)map, "EnderDragon");
        schema.registerSimple((Map)map, "WitherBoss");
        schema.registerSimple((Map)map, "Bat");
        schema.registerSimple((Map)map, "Witch");
        schema.registerSimple((Map)map, "Endermite");
        schema.registerSimple((Map)map, "Guardian");
        schema.registerSimple((Map)map, "Pig");
        schema.registerSimple((Map)map, "Sheep");
        schema.registerSimple((Map)map, "Cow");
        schema.registerSimple((Map)map, "Chicken");
        schema.registerSimple((Map)map, "Squid");
        schema.registerSimple((Map)map, "Wolf");
        schema.registerSimple((Map)map, "MushroomCow");
        schema.registerSimple((Map)map, "SnowMan");
        schema.registerSimple((Map)map, "Ozelot");
        schema.registerSimple((Map)map, "VillagerGolem");
        schema.register((Map)map, "EntityHorse", string -> DSL.optionalFields((String)"Items", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema)), (String)"ArmorItem", (TypeTemplate)DataConverterTypes.t.in(schema), (String)"SaddleItem", (TypeTemplate)DataConverterTypes.t.in(schema)));
        schema.registerSimple((Map)map, "Rabbit");
        schema.register((Map)map, "Villager", string -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema)), (String)"Offers", (TypeTemplate)DSL.optionalFields((String)"Recipes", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.x.in(schema)))));
        schema.registerSimple((Map)map, "EnderCrystal");
        schema.register((Map)map, "AreaEffectCloud", string -> DSL.optionalFields((String)"Particle", (TypeTemplate)DataConverterTypes.y.in(schema)));
        schema.registerSimple((Map)map, "ShulkerBullet");
        schema.registerSimple((Map)map, "DragonFireball");
        schema.registerSimple((Map)map, "Shulker");
        return map;
    }

    public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
        HashMap map = Maps.newHashMap();
        DataConverterSchemaV99.c(schema, map, "Furnace");
        DataConverterSchemaV99.c(schema, map, "Chest");
        schema.registerSimple((Map)map, "EnderChest");
        schema.register((Map)map, "RecordPlayer", string -> DSL.optionalFields((String)"RecordItem", (TypeTemplate)DataConverterTypes.t.in(schema)));
        DataConverterSchemaV99.c(schema, map, "Trap");
        DataConverterSchemaV99.c(schema, map, "Dropper");
        schema.register((Map)map, "Sign", () -> DataConverterSchemaV99.a(schema));
        schema.register((Map)map, "MobSpawner", string -> DataConverterTypes.H.in(schema));
        schema.registerSimple((Map)map, "Music");
        schema.registerSimple((Map)map, "Piston");
        DataConverterSchemaV99.c(schema, map, "Cauldron");
        schema.registerSimple((Map)map, "EnchantTable");
        schema.registerSimple((Map)map, "Airportal");
        schema.register((Map)map, "Control", () -> DSL.optionalFields((String)"LastOutput", (TypeTemplate)DataConverterTypes.z.in(schema)));
        schema.registerSimple((Map)map, "Beacon");
        schema.register((Map)map, "Skull", () -> DSL.optionalFields((String)"custom_name", (TypeTemplate)DataConverterTypes.z.in(schema)));
        schema.registerSimple((Map)map, "DLDetector");
        DataConverterSchemaV99.c(schema, map, "Hopper");
        schema.registerSimple((Map)map, "Comparator");
        schema.register((Map)map, "FlowerPot", string -> DSL.optionalFields((String)"Item", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.F.in(schema))));
        schema.register((Map)map, "Banner", () -> DSL.optionalFields((String)"CustomName", (TypeTemplate)DataConverterTypes.z.in(schema)));
        schema.registerSimple((Map)map, "Structure");
        schema.registerSimple((Map)map, "EndGateway");
        return map;
    }

    public static TypeTemplate a(Schema schema) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"Text1", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"Text2", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"Text3", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"Text4", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"FilteredText1", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"FilteredText2", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"FilteredText3", (Object)DataConverterTypes.z.in(schema)), Pair.of((Object)"FilteredText4", (Object)DataConverterTypes.z.in(schema))});
    }

    public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
        schema.registerType(false, DataConverterTypes.a, () -> DSL.optionalFields((String)"CustomBossEvents", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.z.in(schema)))));
        schema.registerType(false, DataConverterTypes.b, () -> DSL.optionalFields((String)"Inventory", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema)), (String)"EnderItems", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))));
        schema.registerType(false, DataConverterTypes.c, () -> DSL.fields((String)"Level", (TypeTemplate)DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.C.in(schema)), (String)"TileEntities", (TypeTemplate)DSL.list((TypeTemplate)DSL.or((TypeTemplate)DataConverterTypes.s.in(schema), (TypeTemplate)DSL.remainder())), (String)"TileTicks", (TypeTemplate)DSL.list((TypeTemplate)DSL.fields((String)"i", (TypeTemplate)DataConverterTypes.E.in(schema))))));
        schema.registerType(true, DataConverterTypes.s, () -> DSL.optionalFields((String)"components", (TypeTemplate)DataConverterTypes.w.in(schema), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)blockEntityTypes)));
        schema.registerType(true, DataConverterTypes.C, () -> DSL.optionalFields((String)"Riding", (TypeTemplate)DataConverterTypes.C.in(schema), (TypeTemplate)DataConverterTypes.D.in(schema)));
        schema.registerType(false, DataConverterTypes.B, () -> DSL.constType(DataConverterSchemaNamed.a()));
        schema.registerType(true, DataConverterTypes.D, () -> DSL.and((TypeTemplate)DataConverterTypes.A.in(schema), (TypeTemplate)DSL.optionalFields((String)"CustomName", (TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.taggedChoiceLazy((String)"id", (Type)DSL.string(), (Map)entityTypes))));
        schema.registerType(true, DataConverterTypes.t, () -> DSL.hook((TypeTemplate)DSL.optionalFields((String)"id", (TypeTemplate)DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DataConverterTypes.F.in(schema)), (String)"tag", (TypeTemplate)DataConverterSchemaV99.b(schema)), (Hook.HookFunction)b, (Hook.HookFunction)Hook.HookFunction.IDENTITY));
        schema.registerType(false, DataConverterTypes.e, DSL::remainder);
        schema.registerType(false, DataConverterTypes.E, () -> DSL.or((TypeTemplate)DSL.constType((Type)DSL.intType()), (TypeTemplate)DSL.constType(DataConverterSchemaNamed.a())));
        schema.registerType(false, DataConverterTypes.F, () -> DSL.constType(DataConverterSchemaNamed.a()));
        schema.registerType(false, DataConverterTypes.g, DSL::remainder);
        schema.registerType(false, DataConverterTypes.h, DSL::remainder);
        schema.registerType(false, DataConverterTypes.i, DSL::remainder);
        schema.registerType(false, DataConverterTypes.j, () -> DSL.optionalFields((String)"banners", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.z.in(schema)))));
        schema.registerType(false, DataConverterTypes.k, DSL::remainder);
        schema.registerType(false, DataConverterTypes.l, DSL::remainder);
        schema.registerType(false, DataConverterTypes.m, DSL::remainder);
        schema.registerType(false, DataConverterTypes.o, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Objectives", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.J.in(schema)), (String)"Teams", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.K.in(schema)), (String)"PlayerScores", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"display", (TypeTemplate)DataConverterTypes.z.in(schema))))));
        schema.registerType(false, DataConverterTypes.n, () -> DSL.optionalFields((String)"data", (TypeTemplate)DSL.optionalFields((String)"Features", (TypeTemplate)DSL.compoundList((TypeTemplate)DataConverterTypes.I.in(schema)))));
        schema.registerType(false, DataConverterTypes.I, DSL::remainder);
        schema.registerType(false, DataConverterTypes.J, DSL::remainder);
        schema.registerType(false, DataConverterTypes.K, () -> DSL.optionalFields((String)"MemberNamePrefix", (TypeTemplate)DataConverterTypes.z.in(schema), (String)"MemberNameSuffix", (TypeTemplate)DataConverterTypes.z.in(schema), (String)"DisplayName", (TypeTemplate)DataConverterTypes.z.in(schema)));
        schema.registerType(true, DataConverterTypes.H, DSL::remainder);
        schema.registerType(false, DataConverterTypes.q, DSL::remainder);
        schema.registerType(false, DataConverterTypes.O, DSL::remainder);
        schema.registerType(false, DataConverterTypes.r, () -> DSL.optionalFields((String)"Entities", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.C.in(schema))));
        schema.registerType(true, DataConverterTypes.w, DSL::remainder);
        schema.registerType(true, DataConverterTypes.x, () -> DSL.optionalFields((String)"buy", (TypeTemplate)DataConverterTypes.t.in(schema), (String)"buyB", (TypeTemplate)DataConverterTypes.t.in(schema), (String)"sell", (TypeTemplate)DataConverterTypes.t.in(schema)));
        schema.registerType(true, DataConverterTypes.y, () -> DSL.constType((Type)DSL.string()));
        schema.registerType(true, DataConverterTypes.z, () -> DSL.constType((Type)DSL.string()));
        schema.registerType(false, DataConverterTypes.f, () -> DSL.optionalFields((String)"entities", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)DataConverterTypes.C.in(schema))), (String)"blocks", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"nbt", (TypeTemplate)DataConverterTypes.s.in(schema))), (String)"palette", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.u.in(schema))));
        schema.registerType(false, DataConverterTypes.u, DSL::remainder);
        schema.registerType(false, DataConverterTypes.v, DSL::remainder);
        schema.registerType(true, DataConverterTypes.A, () -> DSL.optional((TypeTemplate)DSL.field((String)"Equipment", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema)))));
    }

    public static TypeTemplate b(Schema schema) {
        return DSL.optionalFields((Pair[])new Pair[]{Pair.of((Object)"EntityTag", (Object)DataConverterTypes.C.in(schema)), Pair.of((Object)"BlockEntityTag", (Object)DataConverterTypes.s.in(schema)), Pair.of((Object)"CanDestroy", (Object)DSL.list((TypeTemplate)DataConverterTypes.E.in(schema))), Pair.of((Object)"CanPlaceOn", (Object)DSL.list((TypeTemplate)DataConverterTypes.E.in(schema))), Pair.of((Object)"Items", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))), Pair.of((Object)"ChargedProjectiles", (Object)DSL.list((TypeTemplate)DataConverterTypes.t.in(schema))), Pair.of((Object)"pages", (Object)DSL.list((TypeTemplate)DataConverterTypes.z.in(schema))), Pair.of((Object)"filtered_pages", (Object)DSL.compoundList((TypeTemplate)DataConverterTypes.z.in(schema))), Pair.of((Object)"display", (Object)DSL.optionalFields((String)"Name", (TypeTemplate)DataConverterTypes.z.in(schema), (String)"Lore", (TypeTemplate)DSL.list((TypeTemplate)DataConverterTypes.z.in(schema))))});
    }

    protected static <T> T a(Dynamic<T> tag, Map<String, String> blockEntityRenames, Map<String, String> entityRenames) {
        return tag.update("tag", dynamic -> dynamic.update("BlockEntityTag", dynamic1 -> {
            String string = tag.get("id").asString().result().map(DataConverterSchemaNamed::a).orElse("minecraft:air");
            if (!"minecraft:air".equals(string)) {
                String string1 = (String)blockEntityRenames.get(string);
                if (string1 != null) {
                    return dynamic1.set("id", tag.createString(string1));
                }
                c.warn("Unable to resolve BlockEntity for ItemStack: {}", (Object)string);
            }
            return dynamic1;
        }).update("EntityTag", dynamic1 -> {
            if (dynamic1.get("id").result().isPresent()) {
                return dynamic1;
            }
            String string = DataConverterSchemaNamed.a(tag.get("id").asString(""));
            String string1 = (String)entityRenames.get(string);
            return string1 != null ? dynamic1.set("id", tag.createString(string1)) : dynamic1;
        })).getValue();
    }
}

