/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedRandom2;

public class WeightedList<E> {
    private static final int a = 64;
    private final int b;
    private final List<Weighted<E>> c;
    @Nullable
    private final d<E> d;

    protected WeightedList(List<? extends Weighted<E>> items) {
        this.c = List.copyOf(items);
        this.b = WeightedRandom2.a(items, Weighted::b);
        this.d = this.b == 0 ? null : (this.b < 64 ? new c<E>(this.c, this.b) : new b<E>(this.c));
    }

    public static <E> WeightedList<E> a() {
        return new WeightedList<E>(List.of());
    }

    public static <E> WeightedList<E> a(E element) {
        return new WeightedList<E>(List.of(new Weighted<E>(element, 1)));
    }

    @SafeVarargs
    public static <E> WeightedList<E> a(Weighted<E> ... items) {
        return new WeightedList<E>(List.of(items));
    }

    public static <E> WeightedList<E> a(List<Weighted<E>> items) {
        return new WeightedList<E>(items);
    }

    public static <E> a<E> b() {
        return new a();
    }

    public boolean c() {
        return this.c.isEmpty();
    }

    public <T> WeightedList<T> a(Function<E, T> mapper) {
        return new WeightedList<E>(Lists.transform(this.c, weighted -> weighted.a(mapper)));
    }

    public Optional<E> a(RandomSource random) {
        if (this.d == null) {
            return Optional.empty();
        }
        int randomInt = random.a(this.b);
        return Optional.of(this.d.a(randomInt));
    }

    public E b(RandomSource random) {
        if (this.d == null) {
            throw new IllegalStateException("Weighted list has no elements");
        }
        int randomInt = random.a(this.b);
        return this.d.a(randomInt);
    }

    public List<Weighted<E>> d() {
        return this.c;
    }

    public static <E> Codec<WeightedList<E>> a(Codec<E> elementCodec) {
        return Weighted.a(elementCodec).listOf().xmap(WeightedList::a, WeightedList::d);
    }

    public static <E> Codec<WeightedList<E>> a(MapCodec<E> elementCodec) {
        return Weighted.a(elementCodec).listOf().xmap(WeightedList::a, WeightedList::d);
    }

    public static <E> Codec<WeightedList<E>> b(Codec<E> elementCodec) {
        return ExtraCodecs.b(Weighted.a(elementCodec).listOf()).xmap(WeightedList::a, WeightedList::d);
    }

    public static <E> Codec<WeightedList<E>> b(MapCodec<E> elementCodec) {
        return ExtraCodecs.b(Weighted.a(elementCodec).listOf()).xmap(WeightedList::a, WeightedList::d);
    }

    public boolean b(E element) {
        for (Weighted<E> weighted : this.c) {
            if (!weighted.a().equals(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof WeightedList)) return false;
        WeightedList weightedList = (WeightedList)other;
        if (this.b != weightedList.b) return false;
        if (!Objects.equals(this.c, weightedList.c)) return false;
        return true;
    }

    public int hashCode() {
        int i2 = this.b;
        return 31 * i2 + this.c.hashCode();
    }

    static interface d<E> {
        public E a(int var1);
    }

    static class c<E>
    implements d<E> {
        private final Object[] a;

        c(List<Weighted<E>> entries, int size) {
            this.a = new Object[size];
            int i2 = 0;
            for (Weighted<E> weighted : entries) {
                int weight = weighted.b();
                Arrays.fill(this.a, i2, i2 + weight, weighted.a());
                i2 += weight;
            }
        }

        @Override
        public E a(int index) {
            return (E)this.a[index];
        }
    }

    static class b<E>
    implements d<E> {
        private final Weighted<?>[] a;

        b(List<Weighted<E>> entries) {
            this.a = (Weighted[])entries.toArray(Weighted[]::new);
        }

        @Override
        public E a(int index) {
            for (Weighted<?> weighted : this.a) {
                if ((index -= weighted.b()) >= 0) continue;
                return (E)weighted.a();
            }
            throw new IllegalStateException(index + " exceeded total weight");
        }
    }

    public static class a<E> {
        protected final ImmutableList.Builder<Weighted<E>> a = ImmutableList.builder();

        public a<E> a(E element) {
            return this.a(element, 1);
        }

        public a<E> a(E element, int weight) {
            this.a.add(new Weighted<E>(element, weight));
            return this;
        }

        public WeightedList<E> a() {
            return new WeightedList(this.a.build());
        }
    }
}

