/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class UniformFloat
extends FloatProvider {
    public static final MapCodec<UniformFloat> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(uniformFloat -> Float.valueOf(uniformFloat.b)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(uniformFloat -> Float.valueOf(uniformFloat.d))).apply((Applicative)instance, UniformFloat::new)).validate(uniformFloat -> uniformFloat.d <= uniformFloat.b ? DataResult.error(() -> "Max must be larger than min, min_inclusive: " + uniformFloat.b + ", max_exclusive: " + uniformFloat.d) : DataResult.success((Object)uniformFloat));
    private final float b;
    private final float d;

    private UniformFloat(float minInclusive, float maxExclusive) {
        this.b = minInclusive;
        this.d = maxExclusive;
    }

    public static UniformFloat b(float minInclusive, float maxExclusive) {
        if (maxExclusive <= minInclusive) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(minInclusive, maxExclusive);
    }

    @Override
    public float a(RandomSource random) {
        return MathHelper.b(random, this.b, this.d);
    }

    @Override
    public float a() {
        return this.b;
    }

    @Override
    public float b() {
        return this.d;
    }

    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.b;
    }

    public String toString() {
        return "[" + this.b + "-" + this.d + "]";
    }
}

