/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageSource {
    private final Holder<DamageType> a;
    @Nullable
    private final Entity b;
    @Nullable
    private final Entity c;
    @Nullable
    private final Vec3D d;
    @Nullable
    private EntityDamageEvent.DamageCause knownCause;
    @Nullable
    private Entity eventEntityDamager = null;
    @Nullable
    private Block eventBlockDamager;
    @Nullable
    private BlockState fromBlockSnapshot;
    private boolean critical;

    public DamageSource knownCause(EntityDamageEvent.DamageCause cause) {
        DamageSource damageSource = this.copy();
        damageSource.knownCause = cause;
        return damageSource;
    }

    @Nullable
    public EntityDamageEvent.DamageCause knownCause() {
        return this.knownCause;
    }

    @Nullable
    public Entity eventEntityDamager() {
        return this.eventEntityDamager;
    }

    public DamageSource eventEntityDamager(Entity entity) {
        if (this.c != null) {
            throw new IllegalStateException("Cannot set an event damager when a direct entity is already set (report a bug to Paper)");
        }
        DamageSource damageSource = this.copy();
        damageSource.eventEntityDamager = entity;
        return damageSource;
    }

    @Nullable
    public Block eventBlockDamager() {
        return this.eventBlockDamager;
    }

    public DamageSource eventBlockDamager(GeneratorAccess level, @Nullable BlockPosition pos) {
        if (pos == null) {
            return this;
        }
        DamageSource damageSource = this.copy();
        damageSource.eventBlockDamager = CraftBlock.at(level, pos);
        return damageSource;
    }

    @Nullable
    public BlockState causingBlockSnapshot() {
        return this.fromBlockSnapshot;
    }

    public DamageSource causingBlockSnapshot(BlockState blockState) {
        if (this.eventBlockDamager != null) {
            throw new IllegalStateException("Cannot set a block snapshot when an event block damager is already set (report a bug to Paper)");
        }
        DamageSource damageSource = this.copy();
        damageSource.fromBlockSnapshot = blockState;
        return damageSource;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public DamageSource critical() {
        DamageSource damageSource = this.copy();
        damageSource.critical = true;
        return damageSource;
    }

    private DamageSource copy() {
        DamageSource damageSource = new DamageSource(this.a, this.c, this.b, this.d);
        damageSource.knownCause = this.knownCause;
        damageSource.eventEntityDamager = this.eventEntityDamager;
        damageSource.eventBlockDamager = this.eventBlockDamager;
        damageSource.fromBlockSnapshot = this.fromBlockSnapshot;
        damageSource.critical = this.critical;
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.k().a() + ")";
    }

    public float a() {
        return this.k().c();
    }

    public boolean b() {
        return this.b == this.c;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3D damageSourcePosition) {
        this.a = type;
        this.b = causingEntity;
        this.c = directEntity;
        this.d = damageSourcePosition;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        this(type, directEntity, causingEntity, null);
    }

    public DamageSource(Holder<DamageType> type, Vec3D damageSourcePosition) {
        this(type, null, null, damageSourcePosition);
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity entity) {
        this(type, entity, entity);
    }

    public DamageSource(Holder<DamageType> type) {
        this(type, null, null, null);
    }

    @Nullable
    public Entity c() {
        return this.c;
    }

    @Nullable
    public Entity d() {
        return this.b;
    }

    @Nullable
    public ItemStack e() {
        return this.c != null ? this.c.dZ() : null;
    }

    public IChatBaseComponent a(EntityLiving livingEntity) {
        ItemStack itemStack;
        String string = "death.attack." + this.k().a();
        if (this.b == null && this.c == null) {
            EntityLiving killCredit = livingEntity.eT();
            String string1 = string + ".player";
            return killCredit != null ? IChatBaseComponent.a(string1, livingEntity.P_(), killCredit.P_()) : IChatBaseComponent.a(string, livingEntity.P_());
        }
        IChatBaseComponent component = this.b == null ? this.c.P_() : this.b.P_();
        Entity entity = this.b;
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity1 = (EntityLiving)entity;
            itemStack = livingEntity1.fb();
        } else {
            itemStack = ItemStack.l;
        }
        ItemStack itemStack2 = itemStack;
        return !itemStack2.f() && itemStack2.c(DataComponents.g) ? IChatBaseComponent.a(string + ".item", livingEntity.P_(), component, itemStack2.K()) : IChatBaseComponent.a(string, livingEntity.P_(), component);
    }

    public String f() {
        return this.k().a();
    }

    public boolean g() {
        return switch (this.k().b()) {
            default -> throw new MatchException(null, null);
            case DamageScaling.a -> false;
            case DamageScaling.b -> {
                if (this.b instanceof EntityLiving && !(this.b instanceof EntityHuman)) {
                    yield true;
                }
                yield false;
            }
            case DamageScaling.c -> true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean h() {
        Entity entity = this.d();
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (!player.gk().d) return false;
        return true;
    }

    @Nullable
    public Vec3D i() {
        if (this.d != null) {
            return this.d;
        }
        return this.c != null ? this.c.dt() : null;
    }

    @Nullable
    public Vec3D j() {
        return this.d;
    }

    public boolean a(TagKey<DamageType> damageTypeKey) {
        return this.a.a(damageTypeKey);
    }

    public boolean a(ResourceKey<DamageType> damageTypeKey) {
        return this.a.a(damageTypeKey);
    }

    public DamageType k() {
        return this.a.a();
    }

    public Holder<DamageType> l() {
        return this.a;
    }
}

