/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class MobEffectUtil {
    public static IChatBaseComponent a(MobEffect effect, float durationFactor, float ticksPerSecond) {
        if (effect.b()) {
            return IChatBaseComponent.c("effect.duration.infinite");
        }
        int floor = MathHelper.d((float)effect.d() * durationFactor);
        return IChatBaseComponent.b(UtilColor.a(floor, ticksPerSecond));
    }

    public static boolean a(EntityLiving entity) {
        return entity.b(MobEffects.c) || entity.b(MobEffects.C);
    }

    public static int b(EntityLiving entity) {
        int i2 = 0;
        int i1 = 0;
        if (entity.b(MobEffects.c)) {
            i2 = entity.c(MobEffects.c).e();
        }
        if (entity.b(MobEffects.C)) {
            i1 = entity.c(MobEffects.C).e();
        }
        return Math.max(i2, i1);
    }

    public static boolean c(EntityLiving entity) {
        return entity.b(MobEffects.m) || entity.b(MobEffects.C);
    }

    public static List<EntityPlayer> a(WorldServer level, @Nullable Entity source, Vec3D pos, double radius, MobEffect effect, int duration) {
        return MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, effect, duration, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public static List<EntityPlayer> addEffectToPlayersAround(WorldServer level, @Nullable Entity source, Vec3D pos, double radius, MobEffect effect, int duration, EntityPotionEffectEvent.Cause cause) {
        return MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, effect, duration, cause, null);
    }

    public static List<EntityPlayer> addEffectToPlayersAround(WorldServer level, @Nullable Entity source, Vec3D pos, double radius, MobEffect effect, int duration, EntityPotionEffectEvent.Cause cause, @Nullable Predicate<EntityPlayer> playerPredicate) {
        Holder<MobEffectList> effect1 = effect.c();
        List<EntityPlayer> players = level.a(serverPlayer -> {
            boolean condition;
            boolean bl = condition = !(!serverPlayer.h.d() || source != null && source.s((Entity)serverPlayer) || !pos.a((IPosition)serverPlayer.dt(), radius) || serverPlayer.b(effect1) && serverPlayer.c(effect1).e() >= effect.e() && !serverPlayer.c(effect1).a(duration - 1));
            if (condition) {
                return playerPredicate == null || playerPredicate.test((EntityPlayer)serverPlayer);
            }
            return false;
        });
        players.forEach(serverPlayer -> serverPlayer.addEffect(new MobEffect(effect), source, cause));
        return players;
    }
}

