/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

class WeavingMobEffect
extends MobEffectList {
    private final ToIntFunction<RandomSource> c;

    protected WeavingMobEffect(MobEffectInfo category, int color, ToIntFunction<RandomSource> maxCobwebs) {
        super(category, color, Particles.Y);
        this.c = maxCobwebs;
    }

    @Override
    public void a(WorldServer level, EntityLiving entity, int amplifier, Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.a && (entity instanceof EntityHuman || level.O().c(GameRules.d))) {
            this.spawnCobwebsRandomlyAround(level, entity.dY(), entity.dv(), entity);
        }
    }

    private void spawnCobwebsRandomlyAround(WorldServer level, RandomSource random, BlockPosition pos, EntityLiving entity) {
        HashSet set = Sets.newHashSet();
        int i2 = this.c.applyAsInt(random);
        for (BlockPosition blockPos : BlockPosition.a(random, 15, pos, 1)) {
            BlockPosition blockPos1 = blockPos.e();
            if (set.contains(blockPos) || !level.a_(blockPos).v() || !level.a_(blockPos1).c((IBlockAccess)level, blockPos1, EnumDirection.b)) continue;
            set.add(blockPos.j());
            if (set.size() < i2) continue;
            break;
        }
        for (BlockPosition blockPosx : set) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockPosx, Blocks.bz.m())) continue;
            level.a(blockPosx, Blocks.bz.m(), 3);
            level.c(3018, blockPosx, 0);
        }
    }
}

