/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    public static final int a = -1;
    private static final DataWatcherObject<Integer> p = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> s = DataWatcher.a(Display.class, DataWatcherRegistry.H);
    private static final DataWatcherObject<Vector3f> t = DataWatcher.a(Display.class, DataWatcherRegistry.H);
    private static final DataWatcherObject<Quaternionf> u = DataWatcher.a(Display.class, DataWatcherRegistry.I);
    private static final DataWatcherObject<Quaternionf> ay = DataWatcher.a(Display.class, DataWatcherRegistry.I);
    private static final DataWatcherObject<Byte> az = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aA = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aB = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aC = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aD = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aE = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aF = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aG = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aH = IntSet.of((int[])new int[]{s.a(), t.a(), u.a(), ay.a(), az.a(), aA.a(), aC.a(), aD.a()});
    private static final int aI = 0;
    private static final int aJ = 0;
    private static final int aK = 0;
    private static final float aL = 0.0f;
    private static final float aM = 1.0f;
    private static final float aN = 1.0f;
    private static final float aO = 0.0f;
    private static final float aP = 0.0f;
    private static final int aQ = -1;
    public static final String b = "teleport_duration";
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private long aR = Integer.MIN_VALUE;
    private int aS;
    private float aT;
    private AxisAlignedBB aU;
    private boolean aV = true;
    protected boolean n;
    private boolean aW;
    private boolean aX;
    @Nullable
    private j aY;
    private final InterpolationHandler aZ = new InterpolationHandler((Entity)this, 0);

    public Display(EntityTypes<?> entityType, World level) {
        super(entityType, level);
        this.ad = true;
        this.aU = this.cR();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (aF.equals(key) || aE.equals(key)) {
            this.z();
        }
        if (p.equals(key)) {
            this.aW = true;
        }
        if (r.equals(key)) {
            this.aZ.a(this.n());
        }
        if (q.equals(key)) {
            this.aX = true;
        }
        if (aH.contains(key.a())) {
            this.n = true;
        }
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    public static Transformation a(DataWatcher synchedEntityData) {
        Vector3f vector3f = synchedEntityData.a(s);
        Quaternionf quaternionf = synchedEntityData.a(u);
        Vector3f vector3f1 = synchedEntityData.a(t);
        Quaternionf quaternionf1 = synchedEntityData.a(ay);
        return new Transformation(vector3f, quaternionf, vector3f1, quaternionf1);
    }

    @Override
    public void g() {
        Entity vehicle = this.dk();
        if (vehicle != null && vehicle.dQ()) {
            this.bO();
        }
        if (this.dV().C) {
            if (this.aW) {
                this.aW = false;
                int transformationInterpolationDelay = this.m();
                this.aR = this.af + transformationInterpolationDelay;
            }
            if (this.aX) {
                this.aX = false;
                this.aS = this.l();
            }
            if (this.n) {
                this.n = false;
                boolean flag = this.aS != 0;
                this.aY = flag && this.aY != null ? this.a(this.aY, this.aT) : this.A();
                this.a(flag, this.aT);
            }
            this.aZ.e();
        }
    }

    @Override
    public InterpolationHandler l_() {
        return this.aZ;
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(r, 0);
        builder.a(p, 0);
        builder.a(q, 0);
        builder.a(s, new Vector3f());
        builder.a(t, new Vector3f(1.0f, 1.0f, 1.0f));
        builder.a(ay, new Quaternionf());
        builder.a(u, new Quaternionf());
        builder.a(az, BillboardConstraints.a.a());
        builder.a(aA, -1);
        builder.a(aB, Float.valueOf(1.0f));
        builder.a(aC, Float.valueOf(0.0f));
        builder.a(aD, Float.valueOf(1.0f));
        builder.a(aE, Float.valueOf(0.0f));
        builder.a(aF, Float.valueOf(0.0f));
        builder.a(aG, -1);
    }

    @Override
    protected void a(NBTTagCompound tag) {
        this.a(tag.a(e, Transformation.b).orElse(Transformation.a()));
        this.b(tag.b(c, 0));
        this.c(tag.b(d, 0));
        int intOr = tag.b(b, 0);
        this.d(MathHelper.a(intOr, 0, 59));
        this.a(tag.a(f, BillboardConstraints.e).orElse(BillboardConstraints.a));
        this.b(tag.b(h, 1.0f));
        this.c(tag.b(i, 0.0f));
        this.d(tag.b(j, 1.0f));
        this.y(tag.b(k, 0.0f));
        this.z(tag.b(l, 0.0f));
        this.l(tag.b(m, -1));
        this.a((Brightness)tag.a(g, Brightness.b).orElse(null));
    }

    public void a(Transformation transformation) {
        this.al.a(s, transformation.e());
        this.al.a(u, transformation.f());
        this.al.a(t, transformation.g());
        this.al.a(ay, transformation.h());
    }

    @Override
    protected void b(NBTTagCompound tag) {
        tag.a(e, Transformation.b, Display.a(this.al));
        tag.a(f, BillboardConstraints.e, this.p());
        tag.a(c, this.l());
        tag.a(b, this.n());
        tag.a(h, this.t());
        tag.a(i, this.u());
        tag.a(j, this.v());
        tag.a(k, this.w());
        tag.a(l, this.y());
        tag.a(m, this.x());
        tag.b(g, Brightness.b, this.r());
    }

    public AxisAlignedBB e() {
        return this.aU;
    }

    public boolean f() {
        return !this.aV;
    }

    @Override
    public EnumPistonReaction i_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean n_() {
        return true;
    }

    @Nullable
    public j i() {
        return this.aY;
    }

    public void b(int transformationInterpolationDuration) {
        this.al.a(q, transformationInterpolationDuration);
    }

    public int l() {
        return this.al.a(q);
    }

    public void c(int transformationInterpolationDelay) {
        this.al.a(p, transformationInterpolationDelay, true);
    }

    public int m() {
        return this.al.a(p);
    }

    private void d(int posRotInterpolationDuration) {
        this.al.a(r, posRotInterpolationDuration);
    }

    private int n() {
        return this.al.a(r);
    }

    public void a(BillboardConstraints billboardConstraints) {
        this.al.a(az, billboardConstraints.a());
    }

    public BillboardConstraints p() {
        return BillboardConstraints.f.apply(this.al.a(az).byteValue());
    }

    public void a(@Nullable Brightness brightnessOverride) {
        this.al.a(aA, brightnessOverride != null ? brightnessOverride.a() : -1);
    }

    @Nullable
    public Brightness r() {
        int i2 = this.al.a(aA);
        return i2 != -1 ? Brightness.c(i2) : null;
    }

    private int s() {
        return this.al.a(aA);
    }

    public void b(float viewRange) {
        this.al.a(aB, Float.valueOf(viewRange));
    }

    public float t() {
        return this.al.a(aB).floatValue();
    }

    public void c(float shadowRadius) {
        this.al.a(aC, Float.valueOf(shadowRadius));
    }

    public float u() {
        return this.al.a(aC).floatValue();
    }

    public void d(float shadowStrength) {
        this.al.a(aD, Float.valueOf(shadowStrength));
    }

    public float v() {
        return this.al.a(aD).floatValue();
    }

    public void y(float width) {
        this.al.a(aE, Float.valueOf(width));
    }

    public float w() {
        return this.al.a(aE).floatValue();
    }

    public void z(float height) {
        this.al.a(aF, Float.valueOf(height));
    }

    public int x() {
        return this.al.a(aG);
    }

    public void l(int glowColorOverride) {
        this.al.a(aG, glowColorOverride);
    }

    public float a(float partialTick) {
        float f2;
        int i2 = this.aS;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f3 = (long)this.af - this.aR;
        float f1 = f3 + partialTick;
        this.aT = f2 = MathHelper.a(MathHelper.f(f1, 0.0f, i2), 0.0f, 1.0f);
        return f2;
    }

    public float y() {
        return this.al.a(aF).floatValue();
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        super.a_(x2, y2, z2);
        this.z();
    }

    private void z() {
        float width = this.w();
        float height = this.y();
        this.aV = width == 0.0f || height == 0.0f;
        float f2 = width / 2.0f;
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        this.aU = new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)height, z2 + (double)f2);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.t() * 64.0 * Display.cK());
    }

    @Override
    public int m_() {
        int glowColorOverride = this.x();
        return glowColorOverride != -1 ? glowColorOverride : super.m_();
    }

    private j A() {
        return new j(GenericInterpolator.constant(Display.a(this.al)), this.p(), this.s(), FloatInterpolator.constant(this.u()), FloatInterpolator.constant(this.v()), this.x());
    }

    private j a(j renderState, float partialTick) {
        Transformation transformation = renderState.a.get(partialTick);
        float f2 = renderState.d.get(partialTick);
        float f1 = renderState.e.get(partialTick);
        return new j(new l(transformation, Display.a(this.al)), this.p(), this.s(), new h(f2, this.u()), new h(f1, this.v()), this.x());
    }

    public record j(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte id, String name) {
            this.h = name;
            this.g = id;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return partialTick -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return partialTick -> value;
        }

        public float get(float var1);
    }

    record l(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float partialTick) {
            return (double)partialTick >= 1.0 ? this.b : this.a.a(this.b, partialTick);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float partialTick) {
            return MathHelper.h(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String ay = "line_width";
        private static final String az = "text_opacity";
        private static final String aA = "background";
        private static final String aB = "shadow";
        private static final String aC = "see_through";
        private static final String aD = "default_background";
        private static final String aE = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aF = -1;
        public static final int u = 0x40000000;
        private static final int aG = 200;
        private static final DataWatcherObject<IChatBaseComponent> aH = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aI = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aJ = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aK = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aL = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet aM = IntSet.of((int[])new int[]{aH.a(), aI.a(), aJ.a(), aK.a(), aL.a()});
        @Nullable
        private CachedInfo aN;
        @Nullable
        private e aO;

        public TextDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(aH, IChatBaseComponent.i());
            builder.a(aI, 200);
            builder.a(aJ, 0x40000000);
            builder.a(aK, (byte)-1);
            builder.a(aL, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (aM.contains(key.a())) {
                this.n = true;
            }
        }

        public IChatBaseComponent m() {
            return this.al.a(aH);
        }

        public void a(IChatBaseComponent text) {
            this.al.a(aH, text);
        }

        @Override
        public int n() {
            return this.al.a(aI);
        }

        @Override
        private void b(int lineWidth) {
            this.al.a(aI, lineWidth);
        }

        public byte p() {
            return this.al.a(aK);
        }

        public void c(byte textOpacity) {
            this.al.a(aK, textOpacity);
        }

        public int r() {
            return this.al.a(aJ);
        }

        @Override
        private void c(int backgroundColor) {
            this.al.a(aJ, backgroundColor);
        }

        public byte s() {
            return this.al.a(aL);
        }

        public void d(byte flags) {
            this.al.a(aL, flags);
        }

        private static byte a(byte currentValue, NBTTagCompound tag, String flag, byte mask) {
            return tag.b(flag, false) ? (byte)(currentValue | mask) : currentValue;
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            this.b(tag.b(ay, 200));
            this.c(tag.b(az, (byte)-1));
            this.c(tag.b(aA, 0x40000000));
            byte b2 = TextDisplay.a((byte)0, tag, aB, (byte)1);
            b2 = TextDisplay.a(b2, tag, aC, (byte)2);
            b2 = TextDisplay.a(b2, tag, aD, (byte)4);
            Optional<Align> optional = tag.a(aE, Align.d);
            if (optional.isPresent()) {
                b2 = switch (optional.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> b2;
                    case 1 -> (byte)(b2 | 8);
                    case 2 -> (byte)(b2 | 0x10);
                };
            }
            this.d(b2);
            NBTBase tag1 = tag.a(o);
            if (tag1 != null) {
                RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
                try {
                    World world;
                    IChatBaseComponent component = (IChatBaseComponent)ComponentSerialization.a.parse(registryOps, (Object)tag1).getOrThrow();
                    if (component != null && (world = this.dV()) instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        CommandListenerWrapper commandSourceStack = this.d(serverLevel).a(2);
                        IChatMutableComponent component1 = ChatComponentUtils.a(commandSourceStack, component, (Entity)this, 0);
                        this.a(component1);
                    } else {
                        this.a(IChatBaseComponent.i());
                    }
                }
                catch (Exception var10) {
                    o.warn("Failed to parse display entity text {}", (Object)tag1, (Object)var10);
                }
            }
        }

        private static void b(byte currentValue, NBTTagCompound tag, String flag, byte mask) {
            tag.a(flag, (currentValue & mask) != 0);
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            tag.a(o, ComponentSerialization.a, registryOps, this.m());
            tag.a(ay, this.n());
            tag.a(aA, this.r());
            tag.a(az, this.p());
            byte flags = this.s();
            TextDisplay.b(flags, tag, aB, (byte)1);
            TextDisplay.b(flags, tag, aC, (byte)2);
            TextDisplay.b(flags, tag, aD, (byte)4);
            tag.a(aE, Align.d, TextDisplay.a(flags));
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.aO = interpolate && this.aO != null ? this.a(this.aO, partialTick) : this.t();
            this.aN = null;
        }

        @Nullable
        public e l() {
            return this.aO;
        }

        private e t() {
            return new e(this.m(), this.n(), IntInterpolator.constant(this.p()), IntInterpolator.constant(this.r()), this.s());
        }

        private e a(e renderState, float partialTick) {
            int i2 = renderState.d.get(partialTick);
            int i1 = renderState.c.get(partialTick);
            return new e(this.m(), this.n(), new i(i1, this.p()), new ColorInterpolator(i2, this.r()), this.s());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aN == null) {
                this.aN = this.aO != null ? splitter.split(this.aO.a(), this.aO.b()) : new CachedInfo(List.of(), 0);
            }
            return this.aN;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return MathHelper.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = SlotAccess.a(this::m, this::a);
        @Nullable
        private a t;

        public ItemDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(q, ItemStack.l);
            builder.a(r, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (q.equals(key) || r.equals(key)) {
                this.n = true;
            }
        }

        public ItemStack m() {
            return this.al.a(q);
        }

        public void a(ItemStack itemStack) {
            this.al.a(q, itemStack);
        }

        public void a(ItemDisplayContext itemTransform) {
            this.al.a(r, itemTransform.a());
        }

        public ItemDisplayContext n() {
            return ItemDisplayContext.k.apply(this.al.a(r).byteValue());
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            this.a(tag.a(o, ItemStack.b, (DynamicOps<NBTBase>)registryOps).orElse(ItemStack.l));
            this.a(tag.a(p, ItemDisplayContext.j).orElse(ItemDisplayContext.a));
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            if (!this.m().f()) {
                tag.a(o, ItemStack.b, this.dX().a(DynamicOpsNBT.a), this.m());
            }
            tag.a(p, ItemDisplayContext.j, this.n());
        }

        @Override
        public SlotAccess a_(int slot) {
            return slot == 0 ? this.s : SlotAccess.a;
        }

        @Nullable
        public a l() {
            return this.t;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            ItemStack itemStack = this.m();
            itemStack.a(this);
            this.t = new a(itemStack, this.n());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return partialTick -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return ARGB.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        @Nullable
        private a q;

        public BlockDisplay(EntityTypes<?> entityType, World level) {
            super(entityType, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(p, Blocks.a.m());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (key.equals(p)) {
                this.n = true;
            }
        }

        public IBlockData m() {
            return this.al.a(p);
        }

        public void c(IBlockData blockState) {
            this.al.a(p, blockState);
        }

        @Override
        protected void a(NBTTagCompound tag) {
            super.a(tag);
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            this.c(tag.a(o, IBlockData.a, (DynamicOps<NBTBase>)registryOps).orElse(Blocks.a.m()));
        }

        @Override
        protected void b(NBTTagCompound tag) {
            super.b(tag);
            RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
            tag.a(o, IBlockData.a, registryOps, this.m());
        }

        @Nullable
        public a l() {
            return this.q;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.q = new a(this.m());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }
}

