/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerEntity;
import com.destroystokyo.paper.event.entity.EntityTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.type.number.IntOr;
import io.papermc.paper.entity.activation.ActivationRange;
import io.papermc.paper.entity.activation.ActivationType;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.SizeLimitedSet;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements SyncedDataHolder,
INamableTileEntity,
EntityAccess,
ScoreHolder,
DataComponentGetter,
ChunkSystemEntity,
EntityTrackerEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    @Nullable
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public boolean collisionLoadChunks = false;
    @Nullable
    private CraftEntity bukkitEntity;
    public static final String v = "id";
    public static final String w = "Passengers";
    private static final String b = "data";
    private static final AtomicInteger c = new AtomicInteger();
    public static final int x = 0;
    public static final int y = 60;
    public static final int z = 300;
    public static final int A = 1024;
    private static final Codec<List<String>> d = Codec.STRING.sizeLimitedListOf(1024);
    public static final float B = 0.2f;
    public static final double C = 0.500001;
    public static final double D = 0.999999;
    public static final int E = 140;
    public static final int F = 40;
    public static final int G = 3;
    private static final ImmutableList<EnumDirection.EnumAxis> e = ImmutableList.of((Object)EnumDirection.EnumAxis.b, (Object)EnumDirection.EnumAxis.a, (Object)EnumDirection.EnumAxis.c);
    private static final ImmutableList<EnumDirection.EnumAxis> m = ImmutableList.of((Object)EnumDirection.EnumAxis.b, (Object)EnumDirection.EnumAxis.c, (Object)EnumDirection.EnumAxis.a);
    private static final AxisAlignedBB n = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double o = 0.014;
    private static final double p = 0.007;
    private static final double q = 0.0023333333333333335;
    public static final String H = "UUID";
    private static double r = 1.0;
    private final EntityTypes<?> s;
    private int t = c.incrementAndGet();
    public boolean I;
    public ImmutableList<Entity> u = ImmutableList.of();
    protected int J;
    @Nullable
    private Entity ay;
    private net.minecraft.world.level.World az;
    public double K;
    public double L;
    public double M;
    private Vec3D aA;
    private BlockPosition aB;
    private ChunkCoordIntPair aC;
    private Vec3D aD = Vec3D.c;
    private float aE;
    private float aF;
    public float N;
    public float O;
    private AxisAlignedBB aG = n;
    public boolean aH;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    protected Vec3D U = Vec3D.c;
    @Nullable
    private RemovalReason aI;
    public static final float V = 0.6f;
    public static final float W = 1.8f;
    public float X;
    public float Y;
    public double Z;
    private float aJ = 1.0f;
    public double aa;
    public double ab;
    public double ac;
    public boolean ad;
    public final RandomSource ae = SHARED_RANDOM;
    public int af;
    private int aK = -this.dn();
    public boolean ag;
    protected Object2DoubleMap<TagKey<FluidType>> ah = new Object2DoubleArrayMap(2);
    protected boolean ai;
    private final Set<TagKey<FluidType>> aL = new HashSet<TagKey<FluidType>>();
    public int aj;
    protected boolean ak = true;
    protected final DataWatcher al;
    protected static final DataWatcherObject<Byte> am = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int an = 0;
    private static final int aM = 1;
    private static final int aN = 3;
    private static final int aO = 4;
    public static final int aP = 5;
    protected static final int ao = 6;
    protected static final int ap = 7;
    private static final DataWatcherObject<Integer> aQ = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aR = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aS = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> aq = DataWatcher.a(Entity.class, DataWatcherRegistry.w);
    private static final DataWatcherObject<Integer> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aW = EntityInLevelCallback.a;
    private final VecDeltaCodec aX = new VecDeltaCodec();
    public boolean ar;
    @Nullable
    public PortalProcessor as;
    public int aY;
    private boolean aZ;
    protected UUID at = MathHelper.a(this.ae);
    protected String au = this.at.toString();
    private boolean ba;
    private final Set<String> bb = new SizeLimitedSet(new ObjectOpenHashSet(), 1024);
    private final double[] bc = new double[]{0.0, 0.0, 0.0};
    private long bd;
    private EntitySize be;
    private float bf;
    public boolean av;
    public boolean aw;
    public Optional<BlockPosition> ax = Optional.empty();
    private boolean bg = false;
    private float bh;
    private int bi;
    public boolean bj;
    @Nullable
    private IBlockData bk = null;
    private final List<List<b>> bl = new ObjectArrayList();
    private final List<b> bm = new ObjectArrayList();
    private final LongSet bn = new LongOpenHashSet();
    private final InsideBlockEffectApplier.a bo = new InsideBlockEffectApplier.a();
    private CustomData bp = CustomData.a;
    public boolean forceDrops;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    @Nullable
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public boolean spawnedViaMobSpawner;
    @Nullable
    public Vec3D origin;
    @Nullable
    public UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    private final int despawnTime;
    public int totalEntityAge;
    public final ActivationType activationType = ActivationType.activationTypeFor(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    private final boolean isHardColliding = this.moonrise$isHardCollidingUncached();
    private FullChunkStatus chunkStatus;
    private ChunkData chunkData;
    private int sectionX = Integer.MIN_VALUE;
    private int sectionY = Integer.MIN_VALUE;
    private int sectionZ = Integer.MIN_VALUE;
    private boolean updatingSectionStatus;
    private PlayerChunkMap.EntityTracker trackedEntity;
    public final Object posLock = new Object();
    @Nullable
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return Entity.this.getBukkitEntity();
        }

        @Override
        public boolean x_() {
            return ((WorldServer)Entity.this.dV()).O().c(GameRules.q);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }
    };

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.b("Bukkit.updateLevel", 2) >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.az.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    @Nullable
    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    public void inactiveTick() {
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.be.a(x2, y2, z2);
    }

    @Override
    public final boolean moonrise$isHardColliding() {
        return this.isHardColliding;
    }

    @Override
    public final FullChunkStatus moonrise$getChunkStatus() {
        return this.chunkStatus;
    }

    @Override
    public final void moonrise$setChunkStatus(FullChunkStatus status) {
        this.chunkStatus = status;
    }

    @Override
    public final ChunkData moonrise$getChunkData() {
        return this.chunkData;
    }

    @Override
    public final void moonrise$setChunkData(ChunkData chunkData) {
        this.chunkData = chunkData;
    }

    @Override
    public final int moonrise$getSectionX() {
        return this.sectionX;
    }

    @Override
    public final void moonrise$setSectionX(int x2) {
        this.sectionX = x2;
    }

    @Override
    public final int moonrise$getSectionY() {
        return this.sectionY;
    }

    @Override
    public final void moonrise$setSectionY(int y2) {
        this.sectionY = y2;
    }

    @Override
    public final int moonrise$getSectionZ() {
        return this.sectionZ;
    }

    @Override
    public final void moonrise$setSectionZ(int z2) {
        this.sectionZ = z2;
    }

    @Override
    public final boolean moonrise$isUpdatingSectionStatus() {
        return this.updatingSectionStatus;
    }

    @Override
    public final void moonrise$setUpdatingSectionStatus(boolean to) {
        this.updatingSectionStatus = to;
    }

    @Override
    public final boolean moonrise$hasAnyPlayerPassengers() {
        if (this.u.isEmpty()) {
            return false;
        }
        return this.C().anyMatch(entity -> entity instanceof EntityHuman);
    }

    private static float[] calculateStepHeights(AxisAlignedBB box, List<VoxelShape> voxels, List<AxisAlignedBB> aabbs, float stepHeight, float collidedY) {
        Object shape;
        int i2;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i2 = 0; i2 < len; ++i2) {
            double yUnoffset;
            double y2;
            float step;
            shape = voxels.get(i2);
            double[] yCoords = shape.moonrise$rootCoordinatesY();
            double yOffset = shape.moonrise$offsetY();
            double[] dArray = yCoords;
            int n2 = dArray.length;
            for (int i3 = 0; i3 < n2 && !((step = (float)((y2 = (yUnoffset = dArray[i3]) + yOffset) - box.b)) > stepHeight); ++i3) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i2 = 0; i2 < len; ++i2) {
            shape = aabbs.get(i2);
            float step1 = (float)(((AxisAlignedBB)shape).b - box.b);
            float step2 = (float)(((AxisAlignedBB)shape).e - box.b);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Override
    public final PlayerChunkMap.EntityTracker moonrise$getTrackedEntity() {
        return this.trackedEntity;
    }

    @Override
    public final void moonrise$setTrackedEntity(PlayerChunkMap.EntityTracker trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    private static void collectIndirectPassengers(List<Entity> into, List<Entity> from) {
        for (Entity passenger : from) {
            into.add(passenger);
            Entity.collectIndirectPassengers(into, passenger.u);
        }
    }

    public Entity(EntityTypes<?> entityType, net.minecraft.world.level.World level) {
        this.s = entityType;
        this.az = level;
        this.be = entityType.n();
        this.aA = Vec3D.c;
        this.aB = BlockPosition.c;
        this.aC = ChunkCoordIntPair.e;
        this.defaultActivationState = level != null ? ActivationRange.initializeEntityActivationState(this, level.spigotConfig) : false;
        DataWatcher.a builder = new DataWatcher.a(this);
        builder.a(am, (byte)0);
        builder.a(aQ, this.cr());
        builder.a(aS, false);
        builder.a(aR, Optional.empty());
        builder.a(aT, false);
        builder.a(aU, false);
        builder.a(aq, EntityPose.a);
        builder.a(aV, 0);
        this.a(builder);
        this.al = builder.a();
        this.a_(0.0, 0.0, 0.0);
        this.bf = this.be.c();
        this.despawnTime = level == null || this.s == EntityTypes.bT ? -1 : ((IntOr.Disabled)level.paperConfig().entities.spawning.despawnTime.getOrDefault(this.s, (Object)IntOr.Disabled.DISABLED)).or(-1);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelShape = state.b((IBlockAccess)this.dV(), pos, VoxelShapeCollision.a(this)).a(pos);
        return VoxelShapes.c(voxelShape, VoxelShapes.a(this.cR()), OperatorBoolean.i);
    }

    public int m_() {
        ScoreboardTeam team = this.cq();
        return team != null && ((ScoreboardTeamBase)team).o().f() != null ? ((ScoreboardTeamBase)team).o().f() : 0xFFFFFF;
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public boolean ak() {
        return false;
    }

    public final void al() {
        if (this.bZ()) {
            this.bN();
        }
        if (this.bY()) {
            this.bO();
        }
    }

    public void e(double x2, double y2, double z2) {
        this.aX.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec am() {
        return this.aX;
    }

    public EntityTypes<?> an() {
        return this.s;
    }

    @Override
    public int ao() {
        return this.t;
    }

    public void e(int id) {
        this.t = id;
    }

    public Set<String> ap() {
        return this.bb;
    }

    public boolean a(String tag) {
        return this.bb.add(tag);
    }

    public boolean b(String tag) {
        return this.bb.remove(tag);
    }

    public void c(WorldServer level) {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void aq() {
        this.discard(null);
    }

    public final void discard(@Nullable EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void a(DataWatcher.a var1);

    public DataWatcher ar() {
        return this.al;
    }

    public void refreshEntityData(EntityPlayer to) {
        List<DataWatcher.c<?>> list = this.al.packAll();
        if (to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            to.f.b(new PacketPlayOutEntityMetadata(this.ao(), list));
        }
    }

    public void resendPossiblyDesyncedEntityData(EntityPlayer player) {
        if (player.getBukkitEntity().canSee(this.getBukkitEntity())) {
            PlayerChunkMap.EntityTracker tracker;
            WorldServer world = (WorldServer)this.dV();
            PlayerChunkMap.EntityTracker entityTracker = tracker = world == null ? null : (PlayerChunkMap.EntityTracker)world.m().a.L.get(this.ao());
            if (tracker == null) {
                return;
            }
            EntityTrackerEntry serverEntity = tracker.b;
            ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
            serverEntity.a(player, list::add);
            player.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        }
    }

    public void resendPossiblyDesyncedDataValues(List<DataWatcherObject<?>> keys, EntityPlayer to) {
        if (!to.getBukkitEntity().canSee(this.getBukkitEntity())) {
            return;
        }
        ArrayList values = new ArrayList(keys.size());
        for (DataWatcherObject<?> key : keys) {
            DataWatcher.Item<?> synchedValue = this.al.b(key);
            values.add(synchedValue.e());
        }
        to.f.b(new PacketPlayOutEntityMetadata(this.t, values));
    }

    public boolean equals(Object object) {
        return object instanceof Entity && ((Entity)object).t == this.t;
    }

    public int hashCode() {
        return this.t;
    }

    public void a(RemovalReason reason) {
        this.remove(reason, null);
    }

    public void remove(RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        this.setRemoved(reason, eventCause);
    }

    public void as() {
    }

    public void b(RemovalReason reason) {
    }

    public void b(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.at()) {
            return;
        }
        if (!this.generation) {
            this.az.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        }
        this.al.a(aq, pose);
    }

    public EntityPose at() {
        return this.al.a(aq);
    }

    public boolean c(EntityPose pose) {
        return this.at() == pose;
    }

    public boolean a(Entity entity, double distance) {
        return this.dt().a((IPosition)entity.dt(), distance);
    }

    public boolean a(Entity entity, double horizontalDistance, double verticalDistance) {
        double d2 = entity.dA() - this.dA();
        double d1 = entity.dC() - this.dC();
        double d22 = entity.dG() - this.dG();
        return MathHelper.e(d2, d22) < MathHelper.k(horizontalDistance) && MathHelper.k(d1) < MathHelper.k(verticalDistance);
    }

    public void b(float yRot, float xRot) {
        if (Float.isNaN(yRot)) {
            yRot = 0.0f;
        }
        if (yRot == Float.POSITIVE_INFINITY || yRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.az.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yRot = 0.0f;
        }
        if (Float.isNaN(xRot)) {
            xRot = 0.0f;
        }
        if (xRot == Float.POSITIVE_INFINITY || xRot == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.az.getCraftServer().getLogger().warning(this.cI() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            xRot = 0.0f;
        }
        this.w(yRot % 360.0f);
        this.x(xRot % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.a_(pos.a(), pos.b(), pos.c());
    }

    public void a_(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected final AxisAlignedBB au() {
        return this.c(this.aA);
    }

    protected AxisAlignedBB c(Vec3D position) {
        return this.be.a(position);
    }

    protected void av() {
        this.a_(this.aA.d, this.aA.e, this.aA.f);
    }

    public void b(double yRot, double xRot) {
        float f2 = (float)xRot * 0.15f;
        float f1 = (float)yRot * 0.15f;
        this.x(this.dN() + f2);
        this.w(this.dL() + f1);
        this.x(MathHelper.a(this.dN(), -90.0f, 90.0f));
        this.O += f2;
        this.N += f1;
        this.O = MathHelper.a(this.O, -90.0f, 90.0f);
        if (this.ay != null) {
            this.ay.k(this);
        }
    }

    public void g() {
        if (this.despawnTime >= 0 && this.totalEntityAge >= this.despawnTime) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
        this.aw();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bJ()) {
            this.bV();
        }
    }

    public void aw() {
        Object object;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("entityBaseTick");
        if (this.ak && (object = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)object;
            neutralMob.tickInitialPersistentAnger(this.az);
        }
        this.bk = null;
        if (this.bY() && this.dk().dQ()) {
            this.bO();
        }
        if (this.J > 0) {
            --this.J;
        }
        if (this instanceof EntityPlayer) {
            this.bV();
        }
        if (this.bt()) {
            this.bu();
        }
        this.aw = this.av;
        this.av = false;
        this.bo();
        this.m();
        this.bn();
        object = this.dV();
        if (object instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)object;
            if (this.aK > 0) {
                if (this.bh()) {
                    this.h(this.aK - 4);
                    if (this.aK < 0) {
                        this.aF();
                    }
                } else {
                    if (this.aK % 20 == 0 && !this.bv()) {
                        this.a(serverLevel, this.dW().d(), 1.0f);
                    }
                    this.h(this.aK - 1);
                }
            }
        } else {
            this.aF();
        }
        if (this.bv()) {
            this.Z *= 0.5;
        } else {
            this.lastLavaContact = null;
        }
        this.ax();
        if (!this.dV().C) {
            this.c(this.aK > 0);
        }
        this.ak = false;
        object = this.dV();
        if (object instanceof WorldServer) {
            WorldServer serverLevelx = (WorldServer)object;
            if (this instanceof Leashable) {
                Leashable.a_(serverLevelx, (Entity)((Object)((Leashable)((Object)this))));
            }
        }
        profilerFiller.c();
    }

    public void c(boolean isOnFire) {
        this.b(0, isOnFire || this.bj);
    }

    public void ax() {
        block5: {
            block4: {
                if (!this.az.getWorld().isVoidDamageEnabled()) {
                    return;
                }
                if (this.dC() < (double)this.az.K_() + this.az.getWorld().getVoidDamageMinBuildHeightOffset()) break block4;
                if (this.az.getWorld().getEnvironment() != World.Environment.NETHER || !this.az.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dC() >= (double)v2)) break block5;
                Entity entity = this;
                if (!(entity instanceof EntityHuman)) break block4;
                EntityHuman player = (EntityHuman)entity;
                if (player.gk().a) break block5;
            }
            this.aG();
        }
    }

    public void ay() {
        this.aY = this.bW();
    }

    public void f(int portalCooldown) {
        this.aY = portalCooldown;
    }

    public int az() {
        return this.aY;
    }

    public boolean aA() {
        return this.aY > 0;
    }

    protected void L() {
        if (this.aA()) {
            --this.aY;
        }
    }

    public void aB() {
        this.lavaIgnite(this.lastLavaContact);
    }

    public void lavaIgnite(@Nullable BlockPosition pos) {
        if (!this.bh()) {
            if (this instanceof EntityLiving && this.aK <= 0) {
                CraftEntity damagee;
                CraftBlock damager = pos == null ? null : CraftBlock.at(this.az, pos);
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)(damagee = this.getBukkitEntity()), 15.0f);
                if (combustEvent.callEvent()) {
                    this.igniteForSeconds(combustEvent.getDuration(), false);
                }
            } else {
                this.igniteForSeconds(15.0f, false);
            }
        }
    }

    public void aC() {
        this.lavaHurt(this.lastLavaContact);
    }

    public void lavaHurt(@Nullable BlockPosition pos) {
        WorldServer serverLevel;
        net.minecraft.world.level.World world;
        if (!this.bh() && (world = this.dV()) instanceof WorldServer && this.a(serverLevel = (WorldServer)world, this.dW().e().eventBlockDamager(this.az, pos), 4.0f) && this.aD() && !this.ba()) {
            serverLevel.a(null, this.dA(), this.dC(), this.dG(), SoundEffects.kE, this.dm(), 0.4f, 2.0f + this.ae.i() * 0.4f);
        }
    }

    protected boolean aD() {
        return true;
    }

    public final void e(float seconds) {
        this.igniteForSeconds(seconds, true);
    }

    public final void igniteForSeconds(float seconds, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), seconds);
            if (!event.callEvent()) {
                return;
            }
            seconds = event.getDuration();
        }
        this.g(MathHelper.d(seconds * 20.0f));
    }

    public void g(int ticks) {
        if (this.aK < ticks) {
            this.h(ticks);
        }
        this.ct();
    }

    public void h(int remainingFireTicks) {
        this.aK = remainingFireTicks;
    }

    public int aE() {
        return this.aK;
    }

    public void aF() {
        this.h(0);
    }

    protected void aG() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean f(double x2, double y2, double z2) {
        return this.b(this.cR().d(x2, y2, z2));
    }

    private boolean b(AxisAlignedBB box) {
        return this.dV().a(this, box) && !this.dV().d(box);
    }

    public void d(boolean onGround) {
        this.aH = onGround;
        this.b(onGround, null);
    }

    public void a(boolean onGround, Vec3D movement) {
        this.a(onGround, this.P, movement);
    }

    public void a(boolean onGround, boolean horizontalCollision, Vec3D movement) {
        this.aH = onGround;
        this.P = horizontalCollision;
        this.b(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.ax.isPresent() && this.ax.get().equals(pos);
    }

    protected void b(boolean onGround, @Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB boundingBox = this.cR();
            AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 1.0E-6, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
            Optional<BlockPosition> optional = this.az.h(this, aabb);
            if (optional.isPresent() || this.bg) {
                this.ax = optional;
            } else if (movement != null) {
                AxisAlignedBB aabb1 = aabb.d(-movement.d, 0.0, -movement.f);
                optional = this.az.h(this, aabb1);
                this.ax = optional;
            }
            this.bg = optional.isEmpty();
        } else {
            this.bg = false;
            if (this.ax.isPresent()) {
                this.ax = Optional.empty();
            }
        }
    }

    public boolean aH() {
        return this.aH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType type, Vec3D movement) {
        Vec3D originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dA();
            this.moveStartY = this.dC();
            this.moveStartZ = this.dG();
            this.moveVector = movement;
        }
        try {
            if (this.ad) {
                this.a_(this.dA() + movement.d, this.dC() + movement.e, this.dG() + movement.f);
            } else {
                if (type == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.e(movement)).equals(Vec3D.c)) {
                        return;
                    }
                }
                GameProfilerFiller profilerFiller = Profiler.a();
                profilerFiller.a("move");
                if (this.U.h() > 1.0E-7) {
                    movement = movement.h(this.U);
                    this.U = Vec3D.c;
                    this.i(Vec3D.c);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && movement == this.dy() && type == EnumMoveType.a) {
                    this.i(Vec3D.c);
                    profilerFiller.c();
                    return;
                }
                Vec3D vec3 = this.a(movement = this.a(movement, type));
                double d2 = vec3.h();
                if (d2 > 1.0E-7 || movement.h() - d2 < 1.0E-7) {
                    MovingObjectPositionBlock blockHitResult;
                    if (this.Z != 0.0 && d2 >= 1.0 && (blockHitResult = this.dV().a(new RayTrace(this.dt(), this.dt().e(vec3), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).d() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.j();
                    }
                    Vec3D vec31 = this.dt();
                    ObjectArrayList list = new ObjectArrayList();
                    for (EnumDirection.EnumAxis axis : Entity.k(vec3)) {
                        double d1 = vec3.a(axis);
                        if (d1 == 0.0) continue;
                        Vec3D vec32 = vec31.a(axis.e(), d1);
                        list.add(new b(vec31, vec32));
                        vec31 = vec32;
                    }
                    this.bl.add((List<b>)list);
                    this.b(vec31);
                }
                profilerFiller.c();
                profilerFiller.a("rest");
                boolean flag = !MathHelper.b(movement.d, vec3.d);
                boolean flag1 = !MathHelper.b(movement.f, vec3.f);
                boolean bl = this.P = flag || flag1;
                if (Math.abs(movement.e) > 0.0 || this.dg()) {
                    this.Q = movement.e != vec3.e;
                    this.R = this.Q && movement.e < 0.0;
                    this.a(this.R, this.P, vec3);
                }
                this.S = this.P ? this.d(vec3) : false;
                BlockPosition onPosLegacy = this.aO();
                IBlockData blockState = this.dV().a_(onPosLegacy);
                if (this.dg()) {
                    this.a(vec3.e, this.aH(), blockState, onPosLegacy);
                }
                if (this.dQ()) {
                    profilerFiller.c();
                } else {
                    MovementEmission movementEmission;
                    if (this.P) {
                        Vec3D deltaMovement = this.dy();
                        this.n(flag ? 0.0 : deltaMovement.d, deltaMovement.e, flag1 ? 0.0 : deltaMovement.f);
                    }
                    if (this.di()) {
                        Block block = blockState.b();
                        if (movement.e != vec3.e) {
                            block.a(this.dV(), this);
                        }
                    }
                    if (this.P && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block block = this.az.getWorld().getBlockAt(MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG()));
                        if (movement.d > vec3.d) {
                            block = block.getRelative(BlockFace.EAST);
                        } else if (movement.d < vec3.d) {
                            block = block.getRelative(BlockFace.WEST);
                        } else if (movement.f > vec3.f) {
                            block = block.getRelative(BlockFace.SOUTH);
                        } else if (movement.f < vec3.f) {
                            block = block.getRelative(BlockFace.NORTH);
                        }
                        if (!block.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, block, CraftVector.toBukkit(originalMovement));
                            event.callEvent();
                        }
                    }
                    if ((!this.dV().A_() || this.dg()) && (movementEmission = this.bf()).a() && !this.bY()) {
                        this.a(movementEmission, vec3, onPosLegacy, blockState);
                    }
                    float blockSpeedFactor = this.aS();
                    this.i(this.dy().d(blockSpeedFactor, 1.0, blockSpeedFactor));
                    profilerFiller.c();
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private void a(MovementEmission movementEmission, Vec3D movement, BlockPosition pos, IBlockData state) {
        float f2 = 0.6f;
        float f1 = (float)(movement.g() * (double)0.6f);
        float f22 = (float)(movement.i() * (double)0.6f);
        BlockPosition onPos = this.aQ();
        IBlockData blockState = this.dV().a_(onPos);
        boolean isStateClimbable = this.c(blockState);
        this.X += isStateClimbable ? f1 : f22;
        this.Y += f1;
        if (this.X > this.aJ && !blockState.l()) {
            boolean flag = onPos.equals(pos);
            boolean flag1 = this.a(pos, state, movementEmission.c(), flag, movement);
            if (!flag) {
                flag1 |= this.a(onPos, blockState, false, movementEmission.b(), movement);
            }
            if (flag1) {
                this.aJ = this.aT();
            } else if (this.bi()) {
                this.aJ = this.aT();
                if (movementEmission.c()) {
                    this.aX();
                }
                if (movementEmission.b()) {
                    this.a(GameEvent.Q);
                }
            }
        } else if (blockState.l()) {
            this.aN();
        }
    }

    protected void aI() {
        this.bm.clear();
        this.bl.forEach(this.bm::addAll);
        this.bl.clear();
        if (this.bm.isEmpty()) {
            this.bm.add(new b(this.bA(), this.dt()));
        } else if (this.bm.getLast().b.g(this.dt()) > 9.999999439624929E-11) {
            this.bm.add(new b(this.bm.getLast().b, this.dt()));
        }
        this.b(this.bm);
    }

    public void aJ() {
        if (!this.bl.isEmpty()) {
            this.bl.removeLast();
        }
    }

    public void a(Vec3D oldPosition, Vec3D position) {
        this.b(List.of(new b(oldPosition, position)));
    }

    private void b(List<b> movements) {
        if (this.aK()) {
            if (this.aH()) {
                BlockPosition onPosLegacy = this.aO();
                IBlockData blockState = this.dV().a_(onPosLegacy);
                blockState.b().a(this.dV(), onPosLegacy, blockState, this);
            }
            boolean isOnFire = this.bX();
            boolean isFreezing = this.dK();
            this.a(movements, this.bo);
            this.bo.a(this);
            if (this.isInRain0()) {
                this.aF();
            }
            if (isOnFire && !this.bX() || isFreezing && !this.dK()) {
                this.aL();
            }
            if (isOnFire && !this.bX() && this.aK <= 0) {
                this.h(-this.dn());
            }
        }
    }

    public boolean aK() {
        return !this.dQ() && !this.ad;
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.aS) || state.a(Blocks.rx);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playStepSound, boolean broadcastGameEvent, Vec3D entityPos) {
        if (state.l()) {
            return false;
        }
        boolean isStateClimbable = this.c(state);
        if ((this.aH() || isStateClimbable || this.ch() && entityPos.e == 0.0 || this.cp()) && !this.cj()) {
            if (playStepSound) {
                this.c(pos, state);
            }
            if (broadcastGameEvent) {
                this.dV().a(GameEvent.P, this.dt(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean d(Vec3D deltaMovement) {
        return false;
    }

    protected void aL() {
        if (!this.az.A_()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), SoundEffects.kJ, this.dm(), 0.7f, 1.6f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
    }

    public void aM() {
        if (this.bX()) {
            this.aL();
        }
        this.aF();
    }

    protected void aN() {
        if (this.aZ()) {
            this.aY();
            if (this.bf().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aO() {
        return this.f(0.2f);
    }

    public BlockPosition aP() {
        return this.f(0.500001f);
    }

    public BlockPosition aQ() {
        return this.f(1.0E-5f);
    }

    protected BlockPosition f(float yOffset) {
        if (this.ax.isPresent() && this.dV().getChunkIfLoadedImmediately(this.ax.get()) != null) {
            BlockPosition blockPos = this.ax.get();
            if (!(yOffset > 1.0E-5f)) {
                return blockPos;
            }
            IBlockData blockState = this.dV().a_(blockPos);
            return !((double)yOffset <= 0.5 && blockState.a(TagsBlock.U) || blockState.a(TagsBlock.N) || blockState.b() instanceof BlockFenceGate) ? blockPos.h(MathHelper.a(this.aA.e - (double)yOffset)) : blockPos;
        }
        int floor = MathHelper.a(this.aA.d);
        int floor1 = MathHelper.a(this.aA.e - (double)yOffset);
        int floor2 = MathHelper.a(this.aA.f);
        return new BlockPosition(floor, floor1, floor2);
    }

    protected float aR() {
        float jumpFactor = this.dV().a_(this.dv()).b().j();
        float jumpFactor1 = this.dV().a_(this.aP()).b().j();
        return (double)jumpFactor == 1.0 ? jumpFactor1 : jumpFactor;
    }

    protected float aS() {
        IBlockData blockState = this.dV().a_(this.dv());
        float speedFactor = blockState.b().i();
        if (!blockState.a(Blocks.J) && !blockState.a(Blocks.nJ)) {
            return (double)speedFactor == 1.0 ? this.dV().a_(this.aP()).b().i() : speedFactor;
        }
        return speedFactor;
    }

    protected Vec3D a(Vec3D vec, EnumMoveType mover) {
        return vec;
    }

    protected Vec3D e(Vec3D pos) {
        if (pos.h() <= 1.0E-7) {
            return pos;
        }
        long gameTime = this.dV().ae();
        if (gameTime != this.bd) {
            Arrays.fill(this.bc, 0.0);
            this.bd = gameTime;
        }
        if (pos.d != 0.0) {
            double d2 = this.a(EnumDirection.EnumAxis.a, pos.d);
            return Math.abs(d2) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(d2, 0.0, 0.0);
        }
        if (pos.e != 0.0) {
            double d3 = this.a(EnumDirection.EnumAxis.b, pos.e);
            return Math.abs(d3) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, d3, 0.0);
        }
        if (pos.f != 0.0) {
            double d4 = this.a(EnumDirection.EnumAxis.c, pos.f);
            return Math.abs(d4) <= (double)1.0E-5f ? Vec3D.c : new Vec3D(0.0, 0.0, d4);
        }
        return Vec3D.c;
    }

    private double a(EnumDirection.EnumAxis axis, double distance) {
        int ordinal = axis.ordinal();
        double d2 = MathHelper.a(distance + this.bc[ordinal], -0.51, 0.51);
        distance = d2 - this.bc[ordinal];
        this.bc[ordinal] = d2;
        return distance;
    }

    private Vec3D a(Vec3D movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3D collided;
        ArrayList<AxisAlignedBB> entityAABBs;
        AxisAlignedBB currentBox;
        block7: {
            block6: {
                double d2;
                boolean zZero;
                boolean xZero = movement.d == 0.0;
                boolean yZero = movement.e == 0.0;
                boolean bl = zZero = movement.f == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.cR();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AxisAlignedBB> potentialCollisionsBB = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB initialCollisionBox = xZero & zZero ? (movement.e < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.e) : CollisionUtil.cutUpwards(currentBox, movement.e)) : currentBox.b(movement);
                entityAABBs = new ArrayList<AxisAlignedBB>();
                CollisionUtil.getEntityHardCollisions(this.az, this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.az, this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.d != movement.d;
                boolean collidedY = collided.e != movement.e;
                boolean collidedZ = collided.f != movement.f;
                boolean bl2 = collidedDownwards = collidedY && movement.e < 0.0;
                if (!collidedDownwards && !this.aH || !collidedX && !collidedZ) break block6;
                stepHeight = this.dP();
                if (!(d2 <= 0.0)) break block7;
            }
            return collided;
        }
        AxisAlignedBB collidedYBox = collidedDownwards ? currentBox.d(0.0, collided.e, 0.0) : currentBox;
        AxisAlignedBB stepRetrievalBox = collidedYBox.b(movement.d, stepHeight, movement.f);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.b(0.0, -1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AxisAlignedBB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.az, this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : Entity.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.e)) {
            Vec3D stepResult = CollisionUtil.performCollisions(new Vec3D(movement.d, step, movement.f), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.j() > collided.j())) continue;
            return stepResult.b(0.0, collidedYBox.b - currentBox.b, 0.0);
        }
        return collided;
    }

    private static float[] a(AxisAlignedBB box, List<VoxelShape> colliders, float deltaY, float maxUpStep) {
        FloatArraySet set = new FloatArraySet(4);
        block0: for (VoxelShape voxelShape : colliders) {
            DoubleListIterator doubleListIterator = voxelShape.a(EnumDirection.EnumAxis.b).iterator();
            while (doubleListIterator.hasNext()) {
                double d2 = (Double)doubleListIterator.next();
                float f2 = (float)(d2 - box.b);
                if (f2 < 0.0f || f2 == maxUpStep) continue;
                if (f2 > deltaY) continue block0;
                set.add(f2);
            }
        }
        float[] floats = set.toFloatArray();
        FloatArrays.unstableSort((float[])floats);
        return floats;
    }

    public static Vec3D a(@Nullable Entity entity, Vec3D vec, AxisAlignedBB collisionBox, net.minecraft.world.level.World level, List<VoxelShape> potentialHits) {
        List<VoxelShape> list = Entity.a(entity, level, potentialHits, collisionBox.b(vec));
        return Entity.a(vec, collisionBox, list);
    }

    private static List<VoxelShape> a(@Nullable Entity entity, net.minecraft.world.level.World level, List<VoxelShape> collisions, AxisAlignedBB boundingBox) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldBorder = level.E_();
        boolean bl = flag = entity != null && worldBorder.a(entity, boundingBox);
        if (flag) {
            builder.add((Object)worldBorder.c());
        }
        builder.addAll(level.e(entity, boundingBox));
        return builder.build();
    }

    private static Vec3D a(Vec3D deltaMovement, AxisAlignedBB entityBB, List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return deltaMovement;
        }
        Vec3D vec3 = Vec3D.c;
        for (EnumDirection.EnumAxis axis : Entity.k(deltaMovement)) {
            double d2 = deltaMovement.a(axis);
            if (d2 == 0.0) continue;
            double d1 = VoxelShapes.a(axis, entityBB.c(vec3), shapes, d2);
            vec3 = vec3.a(axis, d1);
        }
        return vec3;
    }

    private static Iterable<EnumDirection.EnumAxis> k(Vec3D deltaMovement) {
        return Math.abs(deltaMovement.d) < Math.abs(deltaMovement.f) ? m : e;
    }

    protected float aT() {
        return (int)this.X + 1;
    }

    public SoundEffect aU() {
        return SoundEffects.kN;
    }

    public SoundEffect aV() {
        return SoundEffects.kM;
    }

    public SoundEffect aW() {
        return SoundEffects.kM;
    }

    private void a(List<b> movements, InsideBlockEffectApplier.a stepBasedCollector) {
        if (this.aK()) {
            LongSet set = this.bn;
            for (b movement : movements) {
                Vec3D vec3 = movement.a();
                Vec3D vec31 = movement.b();
                AxisAlignedBB aabb = this.c(vec31).h(1.0E-5f);
                IBlockAccess.a(vec3, vec31, aabb, (BlockPosition pos, int step) -> {
                    IBlockData blockState;
                    if (this.bJ() && !(blockState = this.dV().a_(pos)).l() && set.add(pos.a())) {
                        boolean flag1;
                        boolean flag;
                        VoxelShape entityInsideCollisionShape = blockState.a((IBlockAccess)this.dV(), pos, this);
                        boolean bl = flag = entityInsideCollisionShape == VoxelShapes.b() || this.a(vec3, vec31, entityInsideCollisionShape.a(new Vec3D(pos)).e());
                        if (flag) {
                            try {
                                stepBasedCollector.advanceStep(step, pos);
                                blockState.a(this.dV(), pos, this, stepBasedCollector);
                                this.a(blockState);
                            }
                            catch (Throwable var14) {
                                CrashReport crashReport = CrashReport.a(var14, "Colliding entity with block");
                                CrashReportSystemDetails crashReportCategory = crashReport.a("Block being collided with");
                                CrashReportSystemDetails.a(crashReportCategory, this.dV(), pos, blockState);
                                CrashReportSystemDetails crashReportCategory1 = crashReport.a("Entity being checked for collision");
                                this.a(crashReportCategory1);
                                throw new ReportedException(crashReport);
                            }
                        }
                        if (flag1 = this.a(blockState.y(), pos, vec3, vec31)) {
                            stepBasedCollector.advanceStep(step, pos);
                            blockState.y().a(this.dV(), pos, this, stepBasedCollector);
                        }
                    }
                });
            }
            set.clear();
        }
    }

    private boolean a(Fluid fluid, BlockPosition pos, Vec3D from, Vec3D to) {
        AxisAlignedBB aabb = fluid.e(this.dV(), pos);
        return aabb != null && this.a(from, to, List.of(aabb));
    }

    private boolean a(Vec3D from, Vec3D to, List<AxisAlignedBB> boxes) {
        AxisAlignedBB aabb = this.c(from);
        Vec3D vec3 = to.d(from);
        return aabb.a(vec3, boxes);
    }

    protected void a(IBlockData state) {
    }

    public BlockPosition a(WorldServer level, BlockPosition pos) {
        BlockPosition sharedSpawnPos = level.aa();
        Vec3D center = sharedSpawnPos.b();
        int i2 = level.m(sharedSpawnPos).a(HeightMap.Type.f, sharedSpawnPos.u(), sharedSpawnPos.w()) + 1;
        return BlockPosition.a(center.d, (double)i2, center.f);
    }

    public void a(Holder<GameEvent> gameEvent, @Nullable Entity entity) {
        this.dV().a(entity, gameEvent, this.aA);
    }

    public void a(Holder<GameEvent> gameEvent) {
        this.a(gameEvent, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.l();
        }
    }

    protected void aX() {
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D deltaMovement = entity.dy();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.d * deltaMovement.d * (double)0.2f + deltaMovement.e * deltaMovement.e + deltaMovement.f * deltaMovement.f * (double)0.2f) * f2);
        this.g(min);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = this.dV().a_(blockPos);
        return !blockState.a(TagsBlock.bq) && !blockState.a(TagsBlock.br) ? pos : blockPos;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundType = primaryState.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.05f, soundType.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundType = state.A();
        this.a(soundType.d(), soundType.a() * 0.15f, soundType.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.bp) && this.af >= this.bi + 20;
    }

    private void l() {
        this.bh *= (float)Math.pow(0.997, this.af - this.bi);
        this.bh = Math.min(1.0f, this.bh + 0.07f);
        float f2 = 0.5f + this.bh * this.ae.i() * 1.2f;
        float f1 = 0.1f + this.bh * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bi = this.af;
    }

    protected void g(float volume) {
        this.a(this.aU(), volume, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
    }

    protected void aY() {
    }

    protected boolean aZ() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.ba()) {
            this.dV().a(null, this.dA(), this.dC(), this.dG(), sound, this.dm(), volume, pitch);
        }
    }

    public void a(SoundEffect sound) {
        if (!this.ba()) {
            this.a(sound, 1.0f, 1.0f);
        }
    }

    public boolean ba() {
        return this.al.a(aT);
    }

    public void e(boolean isSilent) {
        this.al.a(aT, isSilent);
    }

    public boolean bb() {
        return this.al.a(aU);
    }

    public void f(boolean noGravity) {
        this.al.a(aU, noGravity);
    }

    protected double bc() {
        return 0.0;
    }

    public final double bd() {
        return this.bb() ? 0.0 : this.bc();
    }

    protected void be() {
        double gravity = this.bd();
        if (gravity != 0.0) {
            this.i(this.dy().b(0.0, -gravity, 0.0));
        }
    }

    protected MovementEmission bf() {
        return MovementEmission.d;
    }

    public boolean bg() {
        return false;
    }

    public final void a(double x2, double y2, double z2, boolean onGround) {
        if (!this.do()) {
            this.b(onGround, new Vec3D(x2, y2, z2));
            BlockPosition onPosLegacy = this.aO();
            IBlockData blockState = this.dV().a_(onPosLegacy);
            this.a(y2, onGround, blockState, onPosLegacy);
        }
    }

    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (!this.bi() && y2 < 0.0) {
            this.Z -= (double)((float)y2);
        }
        if (onGround) {
            if (this.Z > 0.0) {
                state.b().a(this.dV(), state, pos, this, this.Z);
                this.dV().a(GameEvent.A, this.aA, GameEvent.a.a(this, this.ax.map(supportingPos -> this.dV().a_((BlockPosition)supportingPos)).orElse(state)));
            }
            this.j();
        }
    }

    public boolean bh() {
        return this.an().d();
    }

    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.s.a(TagsEntity.o)) {
            return false;
        }
        this.b(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    protected void b(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.bZ()) {
            for (Entity entity : this.cY()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
    }

    public boolean bi() {
        return this.ag;
    }

    public boolean isInRain0() {
        BlockPosition blockPos = this.dv();
        return this.dV().r(blockPos) || this.dV().r(BlockPosition.a((double)blockPos.u(), this.cR().e, (double)blockPos.w()));
    }

    public boolean bk() {
        return this.bi() || this.isInRain0();
    }

    public boolean bl() {
        return this.bi() || this.bv();
    }

    public boolean bm() {
        return this.ai && this.bi();
    }

    public void bn() {
        if (this.cj()) {
            this.i(this.ci() && this.bi() && !this.bY());
        } else {
            this.i(this.ci() && this.bm() && !this.bY() && this.dV().b_(this.aB).a(TagsFluid.a));
        }
    }

    protected boolean bo() {
        this.ah.clear();
        this.bp();
        double d2 = this.dV().F_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d2);
        return this.bi() || flag;
    }

    void bp() {
        AbstractBoat abstractBoat;
        Entity entity = this.dk();
        if (entity instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).bm()) {
            this.ag = false;
        } else if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ag && !this.ak) {
                this.bq();
            }
            this.j();
            this.ag = true;
        } else {
            this.ag = false;
        }
    }

    private void m() {
        AbstractBoat abstractBoat;
        this.ai = this.a(TagsFluid.a);
        this.aL.clear();
        double eyeY = this.dE();
        Entity entity = this.dk();
        if (!(entity instanceof AbstractBoat) || (abstractBoat = (AbstractBoat)entity).bm() || !(abstractBoat.cR().e >= eyeY) || !(abstractBoat.cR().b <= eyeY)) {
            BlockPosition blockPos = BlockPosition.a(this.dA(), eyeY, this.dG());
            Fluid fluidState = this.dV().b_(blockPos);
            double d2 = (float)blockPos.v() + fluidState.a(this.dV(), blockPos);
            if (d2 > eyeY) {
                fluidState.k().forEach(this.aL::add);
            }
        }
    }

    protected void bq() {
        double d1;
        double d2;
        Entity entity = Objects.requireNonNullElse(this.cW(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D deltaMovement = entity.dy();
        float min = Math.min(1.0f, (float)Math.sqrt(deltaMovement.d * deltaMovement.d * (double)0.2f + deltaMovement.e * deltaMovement.e + deltaMovement.f * deltaMovement.f * (double)0.2f) * f2);
        if (min < 0.25f) {
            this.a(this.aV(), min, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        } else {
            this.a(this.aW(), min, 1.0f + (this.ae.i() - this.ae.i()) * 0.4f);
        }
        float f1 = MathHelper.a(this.dC());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.be.a() * 20.0f) {
            d2 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            this.dV().a(Particles.d, this.dA() + d2, (double)(f1 + 1.0f), this.dG() + d1, deltaMovement.d, deltaMovement.e - this.ae.j() * (double)0.2f, deltaMovement.f);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.be.a() * 20.0f) {
            d2 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            d1 = (this.ae.j() * 2.0 - 1.0) * (double)this.be.a();
            this.dV().a(Particles.ap, this.dA() + d2, (double)(f1 + 1.0f), this.dG() + d1, deltaMovement.d, deltaMovement.e, deltaMovement.f);
            ++i2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData br() {
        return this.dV().a_(this.aO());
    }

    public IBlockData bs() {
        return this.dV().a_(this.aQ());
    }

    public boolean bt() {
        return this.ci() && !this.bi() && !this.ak() && !this.ch() && !this.bv() && this.bJ();
    }

    protected void bu() {
        BlockPosition onPosLegacy = this.aO();
        IBlockData blockState = this.dV().a_(onPosLegacy);
        if (blockState.o() != EnumRenderType.a) {
            Vec3D deltaMovement = this.dy();
            BlockPosition blockPos = this.dv();
            double d2 = this.dA() + (this.ae.j() - 0.5) * (double)this.be.a();
            double d1 = this.dG() + (this.ae.j() - 0.5) * (double)this.be.a();
            if (blockPos.u() != onPosLegacy.u()) {
                d2 = MathHelper.a(d2, (double)onPosLegacy.u(), (double)onPosLegacy.u() + 1.0);
            }
            if (blockPos.w() != onPosLegacy.w()) {
                d1 = MathHelper.a(d1, (double)onPosLegacy.w(), (double)onPosLegacy.w() + 1.0);
            }
            this.dV().a(new ParticleParamBlock(Particles.b, blockState), d2, this.dC() + 0.1, d1, deltaMovement.d * -4.0, 1.5, deltaMovement.f * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aL.contains(fluidTag);
    }

    public boolean bv() {
        return !this.ak && this.ah.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float amount, Vec3D relative) {
        Vec3D inputVector = Entity.a(relative, amount, this.dL());
        this.i(this.dy().e(inputVector));
    }

    protected static Vec3D a(Vec3D relative, float motionScaler, float facing) {
        double d2 = relative.h();
        if (d2 < 1.0E-7) {
            return Vec3D.c;
        }
        Vec3D vec3 = (d2 > 1.0 ? relative.d() : relative).c((double)motionScaler);
        float sin = MathHelper.a(facing * ((float)Math.PI / 180));
        float cos = MathHelper.b(facing * ((float)Math.PI / 180));
        return new Vec3D(vec3.d * (double)cos - vec3.f * (double)sin, vec3.e, vec3.f * (double)cos + vec3.d * (double)sin);
    }

    @Deprecated
    public float bw() {
        return this.dV().f(this.dz(), this.dF()) ? this.dV().y(BlockPosition.a(this.dA(), this.dE(), this.dG())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yRot, float xRot) {
        this.g(x2, y2, z2);
        this.c(yRot, xRot);
    }

    public void c(float yRot, float xRot) {
        this.w(yRot % 360.0f);
        this.x(MathHelper.a(xRot, -90.0f, 90.0f) % 360.0f);
        this.N = this.dL();
        this.O = this.dN();
        this.r(yRot);
    }

    public void g(double x2, double y2, double z2) {
        double d2 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d1 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.K = d2;
        this.L = y2;
        this.M = d1;
        this.a_(d2, y2, d1);
        if (this.valid) {
            this.az.d((int)Math.floor(this.dA()) >> 4, (int)Math.floor(this.dG()) >> 4);
        }
    }

    public void f(Vec3D pos) {
        this.d(pos.d, pos.e, pos.f);
    }

    public void d(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dL(), this.dN());
    }

    public void a(BlockPosition pos, float yRot, float xRot) {
        this.b(pos.c(), yRot, xRot);
    }

    public void b(Vec3D pos, float yRot, float xRot) {
        this.b(pos.d, pos.e, pos.f, yRot, xRot);
    }

    public void b(double x2, double y2, double z2, float yRot, float xRot) {
        if (!this.preserveMotion) {
            this.aD = Vec3D.c;
        } else {
            this.preserveMotion = false;
        }
        this.o(x2, y2, z2);
        this.w(yRot);
        this.x(xRot);
        this.bx();
        this.av();
        this.r(yRot);
    }

    public final void bx() {
        this.by();
        this.bz();
    }

    public final void c(Vec3D pos, float yRot, float xRot) {
        this.l(pos);
        this.f(yRot, xRot);
    }

    protected void by() {
        this.l(this.aA);
    }

    public void bz() {
        this.f(this.dL(), this.dN());
    }

    private void l(Vec3D pos) {
        this.K = this.aa = pos.d;
        this.L = this.ab = pos.e;
        this.M = this.ac = pos.f;
    }

    private void f(float yRot, float xRot) {
        this.N = yRot;
        this.O = xRot;
    }

    public final Vec3D bA() {
        return new Vec3D(this.aa, this.ab, this.ac);
    }

    public float f(Entity entity) {
        float f2 = (float)(this.dA() - entity.dA());
        float f1 = (float)(this.dC() - entity.dC());
        float f22 = (float)(this.dG() - entity.dG());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double h(double x2, double y2, double z2) {
        double d2 = this.dA() - x2;
        double d1 = this.dC() - y2;
        double d22 = this.dG() - z2;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double g(Entity entity) {
        return this.g(entity.dt());
    }

    public double g(Vec3D vec) {
        double d2 = this.dA() - vec.d;
        double d1 = this.dC() - vec.e;
        double d22 = this.dG() - vec.f;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void a_(EntityHuman player) {
    }

    public void h(Entity entity) {
        if (!(this.z(entity) || entity.ad || this.ad)) {
            double d1;
            if (this.az.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d2 = entity.dA() - this.dA();
            double max = MathHelper.a(d2, d1 = entity.dG() - this.dG());
            if (max >= (double)0.01f) {
                max = Math.sqrt(max);
                d2 /= max;
                d1 /= max;
                double d22 = 1.0 / max;
                if (d22 > 1.0) {
                    d22 = 1.0;
                }
                d2 *= d22;
                d1 *= d22;
                d2 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.bZ() && this.bG()) {
                    this.i(-d2, 0.0, -d1);
                }
                if (!entity.bZ() && entity.bG()) {
                    entity.i(d2, 0.0, d1);
                }
            }
        }
    }

    public void h(Vec3D vector) {
        this.i(vector.d, vector.e, vector.f);
    }

    public void i(double x2, double y2, double z2) {
        this.push(x2, y2, z2, null);
    }

    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(x2, y2, z2);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityKnockbackEvent.Cause.PUSH, (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getKnockback();
        }
        this.i(this.dy().b(delta.getX(), delta.getY(), delta.getZ()));
        this.ar = true;
    }

    protected void bB() {
        this.T = true;
    }

    @Deprecated
    public final void a(DamageSource damageSource, float amount) {
        net.minecraft.world.level.World world = this.az;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, damageSource, amount);
        }
    }

    @Deprecated
    public final boolean b(DamageSource damageSource, float amount) {
        boolean bl;
        net.minecraft.world.level.World world = this.az;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            bl = this.a(serverLevel, damageSource, amount);
        } else {
            bl = this.b(damageSource);
        }
        return bl;
    }

    public abstract boolean a(WorldServer var1, DamageSource var2, float var3);

    public boolean b(DamageSource damageSource) {
        return false;
    }

    public final Vec3D h(float partialTicks) {
        return this.d(this.i(partialTicks), this.j(partialTicks));
    }

    public EnumDirection bC() {
        return EnumDirection.a(this.h(1.0f));
    }

    public float i(float partialTicks) {
        return this.k(partialTicks);
    }

    public float j(float partialTick) {
        return this.l(partialTick);
    }

    public float k(float partialTick) {
        return partialTick == 1.0f ? this.dN() : MathHelper.h(partialTick, this.O, this.dN());
    }

    public float l(float partialTick) {
        return partialTick == 1.0f ? this.dL() : MathHelper.i(partialTick, this.N, this.dL());
    }

    public final Vec3D d(float xRot, float yRot) {
        float f2 = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float cos = MathHelper.b(f1);
        float sin = MathHelper.a(f1);
        float cos1 = MathHelper.b(f2);
        float sin1 = MathHelper.a(f2);
        return new Vec3D(sin * cos1, -sin1, cos * cos1);
    }

    public final Vec3D m(float partialTick) {
        return this.e(this.i(partialTick), this.j(partialTick));
    }

    protected final Vec3D e(float xRot, float yRot) {
        return this.d(xRot - 90.0f, yRot);
    }

    public final Vec3D bD() {
        return new Vec3D(this.dA(), this.dE(), this.dG());
    }

    public final Vec3D n(float partialTick) {
        double d2 = MathHelper.d((double)partialTick, this.K, this.dA());
        double d1 = MathHelper.d((double)partialTick, this.L, this.dC()) + (double)this.cS();
        double d22 = MathHelper.d((double)partialTick, this.M, this.dG());
        return new Vec3D(d2, d1, d22);
    }

    public Vec3D o(float partialTicks) {
        return this.n(partialTicks);
    }

    public final Vec3D p(float partialTicks) {
        double d2 = MathHelper.d((double)partialTicks, this.K, this.dA());
        double d1 = MathHelper.d((double)partialTicks, this.L, this.dC());
        double d22 = MathHelper.d((double)partialTicks, this.M, this.dG());
        return new Vec3D(d2, d1, d22);
    }

    public MovingObjectPosition a(double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3D eyePosition = this.n(partialTicks);
        Vec3D viewVector = this.h(partialTicks);
        Vec3D vec3 = eyePosition.b(viewVector.d * hitDistance, viewVector.e * hitDistance, viewVector.f * hitDistance);
        return this.dV().a(new RayTrace(eyePosition, vec3, RayTrace.BlockCollisionOption.b, hitFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bE() {
        return this.bJ() && this.bF();
    }

    public boolean bF() {
        return false;
    }

    public boolean bG() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bG();
    }

    public void a(Entity entity, DamageSource damageSource) {
        if (entity instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entity, this, damageSource);
        }
    }

    public boolean j(double x2, double y2, double z2) {
        double d2 = this.dA() - x2;
        double d1 = this.dC() - y2;
        double d22 = this.dG() - z2;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.a(d3);
    }

    public boolean a(double distance) {
        double size = this.cR().a();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= 64.0 * r) * size;
    }

    public boolean f(NBTTagCompound compound) {
        return this.saveAsPassenger(compound, true, false, false);
    }

    public boolean saveAsPassenger(NBTTagCompound compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        if (this.aI != null && !this.aI.b() && !forceSerialization) {
            return false;
        }
        String encodeId = this.getEncodeId(includeNonSaveable);
        if (!this.persist && !forceSerialization || encodeId == null) {
            return false;
        }
        compound.a(v, encodeId);
        this.saveWithoutId(compound, includeAll, includeNonSaveable, forceSerialization);
        return true;
    }

    public boolean g(NBTTagCompound compound) {
        return !this.bY() && this.f(compound);
    }

    public NBTTagCompound h(NBTTagCompound compound) {
        return this.saveWithoutId(compound, true, false, false);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound compound, boolean includeAll, boolean includeNonSaveable, boolean forceSerialization) {
        try {
            int ticksFrozen;
            if (includeAll) {
                if (this.ay != null) {
                    compound.a("Pos", Vec3D.a, new Vec3D(this.ay.dA(), this.dC(), this.ay.dG()));
                } else {
                    compound.a("Pos", Vec3D.a, this.dt());
                }
            }
            this.i(MCUtil.sanitizeNanInf(this.aD, 0.0));
            compound.a("Motion", Vec3D.a, this.dy());
            if (Float.isNaN(this.aE)) {
                this.aE = 0.0f;
            }
            if (Float.isNaN(this.aF)) {
                this.aF = 0.0f;
            }
            compound.a("Rotation", Vec2F.i, new Vec2F(this.dL(), this.dN()));
            compound.a("fall_distance", this.Z);
            compound.a("Fire", (short)this.aK);
            compound.a("Air", (short)this.cs());
            compound.a("OnGround", this.aH());
            compound.a("Invulnerable", this.aZ);
            compound.a("PortalCooldown", this.aY);
            if (includeAll) {
                compound.a(H, UUIDUtil.a, this.cG());
                compound.a("WorldUUIDLeast", this.az.getWorld().getUID().getLeastSignificantBits());
                compound.a("WorldUUIDMost", this.az.getWorld().getUID().getMostSignificantBits());
            }
            compound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                compound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                compound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                compound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                compound.a("Bukkit.MaxAirSupply", this.cr());
            }
            compound.a("Spigot.ticksLived", this.totalEntityAge);
            IChatBaseComponent customName = this.aj();
            if (customName != null) {
                RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
                compound.a("CustomName", ComponentSerialization.a, registryOps, customName);
            }
            if (this.cL()) {
                compound.a("CustomNameVisible", this.cL());
            }
            if (this.ba()) {
                compound.a("Silent", this.ba());
            }
            if (this.bb()) {
                compound.a("NoGravity", this.bb());
            }
            if (this.ba) {
                compound.a("Glowing", true);
            }
            if ((ticksFrozen = this.cu()) > 0) {
                compound.a("TicksFrozen", this.cu());
            }
            if (this.bj) {
                compound.a("HasVisualFire", this.bj);
            }
            if (!this.bb.isEmpty()) {
                compound.a("Tags", d, List.copyOf(this.bb));
            }
            if (!this.bp.c()) {
                compound.a(b, CustomData.b, this.bp);
            }
            this.addAdditionalSaveData(compound, includeAll);
            if (this.bZ()) {
                NBTTagList listTag = new NBTTagList();
                for (Entity entity : this.cY()) {
                    NBTTagCompound compoundTag;
                    if (!entity.saveAsPassenger(compoundTag = new NBTTagCompound(), includeAll, includeNonSaveable, forceSerialization)) continue;
                    listTag.add(compoundTag);
                }
                if (!listTag.isEmpty()) {
                    compound.a(w, listTag);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(compound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.az != null ? this.az.getWorld().getUID() : null);
                if (originWorld != null) {
                    compound.a("Paper.OriginWorld", UUIDUtil.a, originWorld);
                }
                compound.a("Paper.Origin", Vec3D.a, this.origin);
            }
            if (this.spawnReason != null) {
                compound.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                compound.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                compound.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                compound.a("Paper.FreezeLock", true);
            }
            return compound;
        }
        catch (Throwable var8) {
            CrashReport crashReport = CrashReport.a(var8, "Saving entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being saved");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    public void i(NBTTagCompound compound) {
        try {
            Optional<Vec3D> originVec;
            Vec3D vec3 = compound.a("Pos", Vec3D.a).orElse(Vec3D.c);
            Vec3D vec31 = compound.a("Motion", Vec3D.a).orElse(Vec3D.c);
            vec31 = MCUtil.sanitizeNanInf(vec31, 0.0);
            Vec2F vec2 = compound.a("Rotation", Vec2F.i).orElse(Vec2F.a);
            this.n(Math.abs(vec31.d) > 10.0 ? 0.0 : vec31.d, Math.abs(vec31.e) > 10.0 ? 0.0 : vec31.e, Math.abs(vec31.f) > 10.0 ? 0.0 : vec31.f);
            this.ar = true;
            double d2 = 3.0000512E7;
            this.o(MathHelper.a(vec3.d, -3.0000512E7, 3.0000512E7), MathHelper.a(vec3.e, -2.0E7, 2.0E7), MathHelper.a(vec3.f, -3.0000512E7, 3.0000512E7));
            this.w(vec2.j);
            this.x(vec2.k);
            this.bx();
            this.r(this.dL());
            this.s(this.dL());
            this.Z = compound.b("fall_distance", 0.0);
            this.aK = compound.b("Fire", (short)0);
            this.j(compound.b("Air", this.cr()));
            this.aH = compound.b("OnGround", false);
            this.aZ = compound.b("Invulnerable", false);
            this.aY = compound.b("PortalCooldown", 0);
            compound.a(H, UUIDUtil.a).ifPresent(uuid -> {
                this.at = uuid;
                this.au = this.at.toString();
            });
            if (!(Double.isFinite(this.dA()) && Double.isFinite(this.dC()) && Double.isFinite(this.dG()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (Double.isFinite(this.dL()) && Double.isFinite(this.dN())) {
                this.av();
                this.b(this.dL(), this.dN());
                RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
                this.b((IChatBaseComponent)compound.a("CustomName", ComponentSerialization.a, (DynamicOps<NBTBase>)registryOps).orElse(null));
                this.o(compound.b("CustomNameVisible", false));
                this.e(compound.b("Silent", false));
                this.f(compound.b("NoGravity", false));
                this.j(compound.b("Glowing", false));
                this.k(compound.b("TicksFrozen", 0));
                this.bj = compound.b("HasVisualFire", false);
                this.bp = compound.a(b, CustomData.b).orElse(CustomData.a);
                this.bb.clear();
                compound.a("Tags", d).ifPresent(this.bb::addAll);
                this.a(compound);
                if (this.bH()) {
                    this.av();
                }
            } else {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            if (this instanceof EntityLiving) {
                this.totalEntityAge = compound.b("Spigot.ticksLived", 0);
            }
            this.persist = compound.b("Bukkit.persist", true);
            this.visibleByDefault = compound.b("Bukkit.visibleByDefault", true);
            this.maxAirTicks = compound.b("Bukkit.MaxAirSupply", this.maxAirTicks);
            this.getBukkitEntity().readBukkitValues(compound);
            if (compound.b("Bukkit.invisible")) {
                boolean bukkitInvisible = compound.b("Bukkit.invisible", false);
                this.k(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if ((originVec = compound.a("Paper.Origin", Vec3D.a)).isPresent()) {
                UUID originWorld = null;
                if (compound.b("Paper.OriginWorld")) {
                    originWorld = compound.a("Paper.OriginWorld", UUIDUtil.a).orElse(null);
                } else if (this.az != null) {
                    originWorld = this.az.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = originVec.get();
            }
            this.spawnedViaMobSpawner = compound.b("Paper.FromMobSpawner", false);
            this.fromNetherPortal = compound.b("Paper.FromNetherPortal", false);
            if (compound.b("Paper.SpawnReason")) {
                String spawnReasonName = compound.i("Paper.SpawnReason").orElse(null);
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    LOGGER.error("Unknown SpawnReason " + spawnReasonName + " for " + String.valueOf(this));
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !compound.b("PersistenceRequired", false)) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (compound.b("Paper.FreezeLock")) {
                this.freezeLocked = compound.b("Paper.FreezeLock", false);
            }
        }
        catch (Throwable var8) {
            CrashReport crashReport = CrashReport.a(var8, "Loading entity NBT");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Entity being loaded");
            this.a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean bH() {
        return true;
    }

    @Nullable
    public final String bI() {
        return this.getEncodeId(false);
    }

    @Nullable
    public final String getEncodeId(boolean includeNonSaveable) {
        EntityTypes<?> type = this.an();
        MinecraftKey key = EntityTypes.a(type);
        return (type.b() || includeNonSaveable) && key != null ? key.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound tag, boolean includeAll) {
        this.b(tag);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    @Nullable
    public EntityItem a(WorldServer level, IMaterial item) {
        return this.a(level, item, 0);
    }

    @Nullable
    public EntityItem a(WorldServer level, IMaterial item, int yOffset) {
        return this.a(level, new ItemStack(item), (float)yOffset);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack) {
        return this.a(level, stack, 0.0f);
    }

    @Nullable
    public EntityItem a(WorldServer level, ItemStack stack, float yOffset) {
        return this.spawnAtLocation(level, stack, yOffset, null);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, ItemStack stack, float yOffset, @Nullable Consumer<? super EntityItem> delayedAddConsumer) {
        if (stack.f()) {
            return null;
        }
        if (this instanceof EntityLiving && !this.forceDrops) {
            ((EntityLiving)this).drops.add(new DefaultDrop(stack, itemStack -> {
                EntityItem itemEntity = new EntityItem(this.az, this.dA(), this.dC() + (double)yOffset, this.dG(), (ItemStack)itemStack);
                itemEntity.i();
                this.az.b(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        EntityItem itemEntity = new EntityItem(level, this.dA(), this.dC() + (double)yOffset, this.dG(), stack.v());
        stack.e(0);
        itemEntity.i();
        itemEntity.i();
        return this.spawnAtLocation(level, itemEntity);
    }

    @Nullable
    public EntityItem spawnAtLocation(WorldServer level, EntityItem itemEntity) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        level.b(itemEntity);
        return itemEntity;
    }

    public boolean bJ() {
        return !this.dQ();
    }

    public boolean bK() {
        if (this.ad) {
            return false;
        }
        double reducedWith = this.be.a() * 0.8f;
        AxisAlignedBB boundingBox = AxisAlignedBB.a(this.bD(), reducedWith, 1.0E-6, reducedWith);
        net.minecraft.world.level.World world = this.az;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = MathHelper.a(boundingBox.b);
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.a(boundingBox.d);
        int maxBlockY = MathHelper.a(boundingBox.e);
        int maxBlockZ = MathHelper.a(boundingBox.f);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        IChunkProvider chunkSource = world.S();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, true).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                IBlockData blockState = blocks.a(currX | currZ << 4 | currY << 8);
                                if (blockState.moonrise$emptyCollisionShape() || !blockState.j(world, mutablePos) || (collisionShape = blockState.g(world, mutablePos)).c()) continue;
                                AxisAlignedBB toCollide = boundingBox.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = collisionShape.moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        Entity entity;
        if (this.bJ() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.B() == player) {
                if (!this.dV().A_()) {
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(this, player, hand, !player.fV());
                    if (event.isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.B()));
                        return EnumInteractionResult.e;
                    }
                    if (!event.isDropLeash()) {
                        leashable.y();
                    } else {
                        leashable.x();
                    }
                    this.a(GameEvent.r, (Entity)player);
                }
                return EnumInteractionResult.a.b();
            }
            ItemStack itemInHand = player.b(hand);
            if (itemInHand.a(Items.vV) && leashable.R_()) {
                if (!this.dV().A_()) {
                    if (CraftEventFactory.callPlayerLeashEntityEvent(this, player, player, hand).isCancelled()) {
                        ((EntityPlayer)player).f.b(new PacketPlayOutAttachEntity(this, leashable.B()));
                        player.bR.b();
                        return EnumInteractionResult.e;
                    }
                    leashable.a_(player, true);
                }
                itemInHand.h(1);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }

    public boolean i(Entity entity) {
        return entity.bL() && !this.z(entity);
    }

    public boolean bL() {
        return false;
    }

    public void q() {
        this.i(Vec3D.c);
        this.g();
        if (this.bY()) {
            this.dk().j(this);
        }
    }

    public final void j(Entity passenger) {
        if (this.y(passenger)) {
            this.a(passenger, Entity::a_);
        }
    }

    protected void a(Entity passenger, MoveFunction callback) {
        Vec3D passengerRidingPosition = this.m(passenger);
        Vec3D vehicleAttachmentPoint = passenger.l(this);
        callback.accept(passenger, passengerRidingPosition.d - vehicleAttachmentPoint.d, passengerRidingPosition.e - vehicleAttachmentPoint.e, passengerRidingPosition.f - vehicleAttachmentPoint.f);
    }

    public void k(Entity entityToUpdate) {
    }

    public Vec3D l(Entity entity) {
        return this.ds().b(EntityAttachment.b, 0, this.aE);
    }

    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.be, 1.0f));
    }

    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return Entity.a(this, entity, dimensions.d());
    }

    protected static Vec3D a(Entity vehicle, Entity passenger, EntityAttachments attachments) {
        int index = vehicle.cY().indexOf(passenger);
        return attachments.c(EntityAttachment.a, index, vehicle.aE);
    }

    public boolean n(Entity vehicle) {
        return this.a(vehicle, false);
    }

    public boolean bM() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity vehicle, boolean force) {
        if (vehicle == this.ay || vehicle.az != this.az) {
            return false;
        }
        if (!vehicle.bP()) {
            return false;
        }
        if (!(force || this.dV().A_() || vehicle.s.b())) {
            return false;
        }
        Entity entity = vehicle;
        while (entity.ay != null) {
            if (entity.ay == this) {
                return false;
            }
            entity = entity.ay;
        }
        if (force || this.o(vehicle) && vehicle.r(this)) {
            EntityMountEvent event;
            if (vehicle.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
                event = new VehicleEnterEvent((Vehicle)vehicle.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
                if (this.valid) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return false;
                }
            }
            event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)vehicle.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
            if (this.bY()) {
                this.bO();
            }
            this.b(EntityPose.a);
            this.ay = vehicle;
            this.ay.p(this);
            vehicle.C().filter(passenger -> passenger instanceof EntityPlayer).forEach(passenger -> CriterionTriggers.U.a((EntityPlayer)passenger));
            return true;
        }
        return false;
    }

    protected boolean o(Entity vehicle) {
        return !this.cc() && this.J <= 0;
    }

    public void bN() {
        for (int i2 = this.u.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.u.get(i2)).bO();
        }
    }

    public void aa() {
        this.removeVehicle(false);
    }

    public void removeVehicle(boolean suppressCancellation) {
        if (this.ay != null) {
            Entity entity = this.ay;
            this.ay = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.ay = entity;
            }
        }
    }

    public void bO() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        this.removeVehicle(suppressCancellation);
    }

    protected void p(Entity passenger) {
        if (passenger.dk() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.u.isEmpty()) {
            this.u = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.u);
            if (!this.dV().C && passenger instanceof EntityHuman && !(this.cZ() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.u = ImmutableList.copyOf((Collection)list);
        }
        this.a(GameEvent.s, passenger);
    }

    protected boolean removePassenger(Entity passenger) {
        return this.removePassenger(passenger, false);
    }

    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (passenger.dk() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)passenger.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && passenger.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)passenger.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)passenger.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)passenger.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        this.u = this.u.size() == 1 && this.u.get(0) == passenger ? ImmutableList.of() : (ImmutableList)this.u.stream().filter(entity -> entity != passenger).collect(ImmutableList.toImmutableList());
        passenger.J = 60;
        this.a(GameEvent.q, passenger);
        return true;
    }

    protected boolean r(Entity passenger) {
        return this.u.isEmpty();
    }

    protected boolean bP() {
        return true;
    }

    public final boolean bQ() {
        return this.l_() != null && this.l_().d();
    }

    public final void d(Vec3D pos, float yRot, float xRot) {
        InterpolationHandler interpolation = this.l_();
        if (interpolation != null) {
            interpolation.a(pos, yRot, xRot);
        } else {
            this.b(pos);
            this.b(yRot, xRot);
        }
    }

    @Nullable
    public InterpolationHandler l_() {
        return null;
    }

    public void a(float yaw, int pitch) {
        this.r(yaw);
    }

    public float bR() {
        return 0.0f;
    }

    public Vec3D bS() {
        return this.d(this.dN(), this.dL());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        Entity entity = this;
        if (!(entity instanceof EntityHuman)) {
            return Vec3D.c;
        }
        EntityHuman player = (EntityHuman)entity;
        boolean flag = player.fc().a(item) && !player.fb().a(item);
        EnumMainHand humanoidArm = flag ? player.fy().e() : player.fy();
        return this.d(0.0f, this.dL() + (float)(humanoidArm == EnumMainHand.b ? 80 : -80)).c(0.5);
    }

    public Vec2F bT() {
        return new Vec2F(this.dN(), this.dL());
    }

    public Vec3D bU() {
        return Vec3D.a(this.bT());
    }

    public void a(Portal portal, BlockPosition pos) {
        if (this.aA()) {
            this.ay();
        } else if (this.as == null || !this.as.a(portal)) {
            this.as = new PortalProcessor(portal, pos.j());
        } else if (!this.as.e()) {
            this.as.a(pos.j());
            this.as.a(true);
        }
    }

    protected void bV() {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.L();
            if (this.as != null) {
                if (this.as.a(serverLevel, this, this.n(false))) {
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a("portal");
                    this.ay();
                    TeleportTransition portalDestination = this.as.a(serverLevel, this);
                    if (portalDestination != null) {
                        WorldServer level = portalDestination.b();
                        if (this instanceof EntityPlayer || level != null && (level.aj() == serverLevel.aj() || this.a((net.minecraft.world.level.World)serverLevel, level))) {
                            this.b(portalDestination);
                        }
                    }
                    profilerFiller.c();
                } else if (this.as.b()) {
                    this.as = null;
                }
            }
        }
    }

    public int bW() {
        Entity firstPassenger = this.cZ();
        return firstPassenger instanceof EntityPlayer ? firstPassenger.bW() : 300;
    }

    public void k(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte id) {
        switch (id) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void q(float yaw) {
    }

    public boolean bX() {
        boolean flag = this.dV() != null && this.dV().C;
        return !this.bh() && (this.aK > 0 || flag && this.i(0));
    }

    public boolean bY() {
        return this.dk() != null;
    }

    public boolean bZ() {
        return !this.u.isEmpty();
    }

    public boolean ca() {
        return this.an().a(TagsEntity.p);
    }

    public boolean cb() {
        return !this.an().a(TagsEntity.q);
    }

    public void g(boolean keyDown) {
        this.b(1, keyDown);
    }

    public boolean cc() {
        return this.i(1);
    }

    public boolean cd() {
        return this.cc();
    }

    public boolean ce() {
        return this.cc();
    }

    public boolean cf() {
        return this.cc();
    }

    public boolean cg() {
        return this.cc();
    }

    public boolean ch() {
        return this.c(EntityPose.f);
    }

    public boolean ci() {
        return this.i(3);
    }

    public void h(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean cj() {
        return this.i(4);
    }

    public boolean ck() {
        return this.c(EntityPose.d);
    }

    public boolean cl() {
        return this.ck() && !this.bi();
    }

    public void i(boolean swimming) {
        if (this.valid && this.cj() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean cm() {
        return this.ba;
    }

    public final void j(boolean hasGlowingTag) {
        this.ba = hasGlowingTag;
        this.b(6, this.cn());
    }

    public boolean cn() {
        return this.dV().A_() ? this.i(6) : this.ba;
    }

    public boolean co() {
        return this.i(5);
    }

    public boolean d(EntityHuman player) {
        if (player.ak()) {
            return false;
        }
        ScoreboardTeam team = this.cq();
        return (team == null || player == null || player.cq() != team || !((ScoreboardTeamBase)team).j()) && this.co();
    }

    public boolean cp() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
    }

    @Nullable
    public ScoreboardTeam cq() {
        if (!this.dV().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.dV().R().e(this.cI());
    }

    public final boolean s(@Nullable Entity entity) {
        return entity != null && (this == entity || this.t(entity) || entity.t(this));
    }

    protected boolean t(Entity entity) {
        return this.a(entity.cq());
    }

    public boolean a(@Nullable ScoreboardTeamBase team) {
        return this.cq() != null && this.cq().a(team);
    }

    public void k(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int flag) {
        return (this.al.a(am) & 1 << flag) != 0;
    }

    public void b(int flag, boolean set) {
        byte b2 = this.al.a(am);
        if (set) {
            this.al.a(am, (byte)(b2 | 1 << flag));
        } else {
            this.al.a(am, (byte)(b2 & ~(1 << flag)));
        }
    }

    public int cr() {
        return this.maxAirTicks;
    }

    public int cs() {
        return this.al.a(aQ);
    }

    public void j(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.cs() != air) {
            this.al.markDirty(aQ);
            return;
        }
        this.al.a(aQ, event.getAmount());
    }

    public void ct() {
        if (this.freezeLocked) {
            return;
        }
        this.k(0);
    }

    public int cu() {
        return this.al.a(aV);
    }

    public void k(int ticksFrozen) {
        this.al.a(aV, ticksFrozen);
    }

    public float cv() {
        int ticksRequiredToFreeze = this.cx();
        return (float)Math.min(this.cu(), ticksRequiredToFreeze) / (float)ticksRequiredToFreeze;
    }

    public boolean cw() {
        return this.cu() >= this.cx();
    }

    public int cx() {
        return 140;
    }

    public void a(WorldServer level, EntityLightning lightning) {
        this.h(this.aK + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aK == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8.0f);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.igniteForSeconds(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.aK - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.bh()) {
            return;
        }
        if (!this.a(level, this.dW().c().eventEntityDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void a(boolean downwards, BlockPosition pos) {
        Entity.a(this, downwards, pos);
    }

    protected static void a(Entity entity, boolean downwards, BlockPosition pos) {
        Vec3D deltaMovement = entity.dy();
        double max = downwards ? Math.max(-0.9, deltaMovement.e - 0.03) : Math.min(1.8, deltaMovement.e + 0.1);
        entity.n(deltaMovement.d, max, deltaMovement.f);
        Entity.a(entity.az, pos);
    }

    protected static void a(net.minecraft.world.level.World level, BlockPosition pos) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            for (int i2 = 0; i2 < 2; ++i2) {
                serverLevel.a(Particles.ap, (double)pos.u() + level.A.j(), (double)(pos.v() + 1), (double)pos.w() + level.A.j(), 1, 0.0, 0.0, 0.0, 1.0);
                serverLevel.a(Particles.d, (double)pos.u() + level.A.j(), (double)(pos.v() + 1), (double)pos.w() + level.A.j(), 1, 0.0, 0.01, 0.0, 0.2);
            }
        }
    }

    public void l(boolean downwards) {
        Entity.b(this, downwards);
    }

    protected static void b(Entity entity, boolean downwards) {
        Vec3D deltaMovement = entity.dy();
        double max = downwards ? Math.max(-0.3, deltaMovement.e - 0.03) : Math.min(0.7, deltaMovement.e + 0.06);
        entity.n(deltaMovement.d, max, deltaMovement.f);
        entity.j();
    }

    public boolean a(WorldServer level, EntityLiving entity) {
        return true;
    }

    public void cy() {
        if (this.dy().b() > -0.5 && this.Z > 1.0) {
            this.Z = 1.0;
        }
    }

    public void j() {
        this.Z = 0.0;
    }

    protected void l(double x2, double y2, double z2) {
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        Vec3D vec3 = new Vec3D(x2 - (double)blockPos.u(), y2 - (double)blockPos.v(), z2 - (double)blockPos.w());
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        EnumDirection direction = EnumDirection.b;
        double d2 = Double.MAX_VALUE;
        for (EnumDirection direction1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d22;
            mutableBlockPos.a((BaseBlockPosition)blockPos, direction1);
            if (this.dV().a_(mutableBlockPos).m(this.dV(), mutableBlockPos)) continue;
            double d1 = vec3.a(direction1.o());
            double d3 = d22 = direction1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d1 : d1;
            if (!(d22 < d2)) continue;
            d2 = d22;
            direction = direction1;
        }
        float f2 = this.ae.i() * 0.2f + 0.1f;
        float f1 = direction.f().a();
        Vec3D vec31 = this.dy().c(0.75);
        if (direction.o() == EnumDirection.EnumAxis.a) {
            this.n(f1 * f2, vec31.e, vec31.f);
        } else if (direction.o() == EnumDirection.EnumAxis.b) {
            this.n(vec31.d, f1 * f2, vec31.f);
        } else if (direction.o() == EnumDirection.EnumAxis.c) {
            this.n(vec31.d, vec31.e, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D motionMultiplier) {
        this.j();
        this.U = motionMultiplier;
    }

    private static IChatBaseComponent a(IChatBaseComponent name) {
        IChatMutableComponent mutableComponent = name.e().b(name.a().a((ChatClickable)null));
        for (IChatBaseComponent component : name.c()) {
            mutableComponent.b(Entity.a(component));
        }
        return mutableComponent;
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent customName = this.aj();
        return customName != null ? Entity.a(customName) : this.cz();
    }

    protected IChatBaseComponent cz() {
        return this.s.h();
    }

    public boolean u(Entity entity) {
        return this == entity;
    }

    public float cA() {
        return 0.0f;
    }

    public void r(float yHeadRot) {
    }

    public void s(float yBodyRot) {
    }

    public boolean cB() {
        return true;
    }

    public boolean v(Entity entity) {
        return false;
    }

    public String toString() {
        String string = this.dV() == null ? "~NULL~" : this.dV().toString();
        return this.aI != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.ah().getString(), this.t, this.at, string, this.dA(), this.dC(), this.dG(), this.dx(), this.af, this.valid, this.aI}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.ah().getString(), this.t, this.at, string, this.dA(), this.dC(), this.dG(), this.dx(), this.af, this.valid);
    }

    public final boolean d(DamageSource damageSource) {
        return this.dQ() || this.aZ && !damageSource.a(DamageTypeTags.d) && !damageSource.h() || damageSource.a(DamageTypeTags.i) && this.bh() || damageSource.a(DamageTypeTags.m) && this.an().a(TagsEntity.o);
    }

    public boolean cC() {
        return this.aZ;
    }

    public void m(boolean isInvulnerable) {
        this.aZ = isInvulnerable;
    }

    public void w(Entity entity) {
        this.b(entity.dA(), entity.dC(), entity.dG(), entity.dL(), entity.dN());
    }

    public void x(Entity entity) {
        CraftEntity bukkitEntity = entity.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound compoundTag = entity.h(new NBTTagCompound());
        compoundTag.r("Dimension");
        this.i(compoundTag);
        this.aY = entity.aY;
        this.as = entity.as;
    }

    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        if (!(this.bJ() && this.valid || teleportTransition.b() == this.az)) {
            LOGGER.warn("Illegal Entity Teleport {} to {}:{}", new Object[]{this, teleportTransition.b(), teleportTransition.c(), new Throwable()});
            return null;
        }
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (!this.dQ()) {
                boolean flag;
                EntityTeleportEvent teleEvent;
                TileEntity tileEntity;
                PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTransition), teleportTransition.i());
                Vec3D velocity = absolutePosition.b();
                Location to = CraftLocation.toBukkit(absolutePosition.a(), (World)teleportTransition.b().getWorld(), absolutePosition.c(), absolutePosition.d());
                if (this.as != null && this.as.a((BlockEndGateway)Blocks.ll) && (tileEntity = this.az.c_(this.as.c())) instanceof TileEntityEndGateway) {
                    TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
                    teleEvent = new EntityTeleportEndGatewayEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                    teleEvent.callEvent();
                } else {
                    teleEvent = CraftEventFactory.callEntityTeleportEvent(this, to);
                }
                if (teleEvent.isCancelled() || teleEvent.getTo() == null) {
                    return null;
                }
                if (!to.equals((Object)teleEvent.getTo())) {
                    to = teleEvent.getTo();
                    teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    velocity = Vec3D.c;
                }
                if (this.as != null) {
                    CraftEntity bukkitEntity = this.getBukkitEntity();
                    EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), to.clone(), bukkitEntity.getVelocity(), CraftVector.toBukkit(velocity));
                    event.callEvent();
                    if (!(event.isCancelled() || event.getTo() == null || event.getTo().equals((Object)event.getFrom()) && event.getAfter().equals((Object)event.getBefore()))) {
                        to = event.getTo().clone();
                        velocity = CraftVector.toVec3(event.getAfter());
                        teleportTransition = new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), velocity, to.getYaw(), to.getPitch(), teleportTransition.g(), teleportTransition.h(), Set.of(), teleportTransition.j(), teleportTransition.cause());
                    }
                }
                if (this.dQ()) {
                    return null;
                }
                WorldServer level = teleportTransition.b();
                boolean bl = flag = level.aj() != serverLevel.aj();
                if (!teleportTransition.h()) {
                    this.bO();
                }
                return flag ? this.b(level, teleportTransition) : this.a(serverLevel, teleportTransition);
            }
        }
        return null;
    }

    private Entity a(WorldServer level, TeleportTransition teleportTransition) {
        for (Entity entity : this.cY()) {
            entity.b(this.a(teleportTransition, entity));
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportSameDimension");
        this.a(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (!teleportTransition.h()) {
            this.a(teleportTransition);
        }
        teleportTransition.j().onTransition(this);
        profilerFiller.c();
        return this;
    }

    private Entity b(WorldServer level, TeleportTransition teleportTransition) {
        List<Entity> passengers = this.cY();
        ArrayList<Entity> list = new ArrayList<Entity>(passengers.size());
        this.bN();
        for (Entity entity : passengers) {
            Entity entity1 = entity.b(this.a(teleportTransition, entity));
            if (entity1 == null) continue;
            list.add(entity1);
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("teleportCrossDimension");
        Object entityx = this.an().a(level, EntitySpawnReason.s);
        if (entityx == null) {
            profilerFiller.c();
            return null;
        }
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            leashable.x();
        }
        ((Entity)entityx).x(this);
        this.cD();
        ((Entity)entityx).a(PositionMoveRotation.a(teleportTransition), teleportTransition.i());
        if (this.inWorld) {
            level.d((Entity)entityx);
        }
        for (Entity entity2 : list) {
            entity2.a((Entity)entityx, true);
        }
        level.i();
        teleportTransition.j().onTransition((Entity)entityx);
        profilerFiller.c();
        return entityx;
    }

    private TeleportTransition a(TeleportTransition teleportTransition, Entity entity) {
        float f2 = teleportTransition.e() + (teleportTransition.i().contains((Object)Relative.d) ? 0.0f : entity.dL() - this.dL());
        float f1 = teleportTransition.f() + (teleportTransition.i().contains((Object)Relative.e) ? 0.0f : entity.dN() - this.dN());
        Vec3D vec3 = entity.dt().d(this.dt());
        Vec3D vec31 = teleportTransition.c().b(teleportTransition.i().contains((Object)Relative.a) ? 0.0 : vec3.a(), teleportTransition.i().contains((Object)Relative.b) ? 0.0 : vec3.b(), teleportTransition.i().contains((Object)Relative.c) ? 0.0 : vec3.c());
        return teleportTransition.a(vec31).a(f2, f1).a();
    }

    private void a(TeleportTransition teleportTransition) {
        EntityLiving controllingPassenger = this.cW();
        for (Entity entity : this.dc()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (controllingPassenger != null && serverPlayer.ao() == controllingPassenger.ao()) {
                serverPlayer.f.b(PacketPlayOutEntityTeleport.a(this.ao(), PositionMoveRotation.a(teleportTransition), teleportTransition.i(), this.aH));
                continue;
            }
            serverPlayer.f.b(PacketPlayOutEntityTeleport.a(this.ao(), PositionMoveRotation.a(this), Set.of(), this.aH));
        }
    }

    public void a(PositionMoveRotation positionMovementRotation, Set<Relative> relatives) {
        PositionMoveRotation positionMoveRotation = PositionMoveRotation.a(this);
        PositionMoveRotation positionMoveRotation1 = PositionMoveRotation.a(positionMoveRotation, positionMovementRotation, relatives);
        this.o(positionMoveRotation1.a().d, positionMoveRotation1.a().e, positionMoveRotation1.a().f);
        this.w(positionMoveRotation1.c());
        this.r(positionMoveRotation1.c());
        this.x(positionMoveRotation1.d());
        this.av();
        this.bx();
        this.i(positionMoveRotation1.b());
        this.bl.clear();
    }

    public void a(float yRot, float xRot) {
        this.w(yRot);
        this.r(yRot);
        this.x(xRot);
        this.bz();
    }

    public void f(BlockPosition pos) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.m().a(TicketType.g, new ChunkCoordIntPair(pos), 3);
        }
    }

    protected void cD() {
        Leashable leashable;
        this.setRemoved(RemovalReason.e, null);
        Entity entity = this;
        if (entity instanceof Leashable && (leashable = (Leashable)((Object)entity)).Q_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, false);
            event.callEvent();
            if (!event.isDropLeash()) {
                leashable.y();
            } else {
                leashable.x();
            }
        }
    }

    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return BlockPortalShape.a(portal, axis, this.dt(), this.a(this.at()));
    }

    @Nullable
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> PortalType.END_GATEWAY;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, true, creationRadius, portalType);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bJ()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public boolean n(boolean allowPassengers) {
        return (allowPassengers || !this.bY()) && this.bJ();
    }

    public boolean a(net.minecraft.world.level.World fromLevel, net.minecraft.world.level.World toLevel) {
        if (!this.bJ() || !this.valid) {
            return false;
        }
        if (fromLevel.aj() == net.minecraft.world.level.World.k && toLevel.aj() == net.minecraft.world.level.World.i) {
            for (Entity entity : this.cY()) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                if (serverPlayer.i) continue;
                return false;
            }
        }
        return true;
    }

    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, Fluid fluidState, float explosionPower) {
        return explosionPower;
    }

    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData blockState, float explosionPower) {
        return true;
    }

    public int cE() {
        return 3;
    }

    public boolean n_() {
        return false;
    }

    public void a(CrashReportSystemDetails category) {
        category.a("Entity Type", () -> String.valueOf(EntityTypes.a(this.an())) + " (" + this.getClass().getCanonicalName() + ")");
        category.a("Entity ID", this.t);
        category.a("Entity Name", () -> this.ah().getString());
        category.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dA(), this.dC(), this.dG()));
        category.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dV(), MathHelper.a(this.dA()), MathHelper.a(this.dC()), MathHelper.a(this.dG())));
        Vec3D deltaMovement = this.dy();
        category.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", deltaMovement.d, deltaMovement.e, deltaMovement.f));
        category.a("Entity's Passengers", () -> this.cY().toString());
        category.a("Entity's Vehicle", () -> String.valueOf(this.dk()));
    }

    public boolean cF() {
        return this.bX() && !this.ak();
    }

    public void a_(UUID uniqueId) {
        this.at = uniqueId;
        this.au = this.at.toString();
    }

    @Override
    public UUID cG() {
        return this.at;
    }

    public String cH() {
        return this.au;
    }

    @Override
    public String cI() {
        return this.au;
    }

    public boolean cJ() {
        return true;
    }

    public static double cK() {
        return r;
    }

    public static void b(double renderDistWeight) {
        r = renderDistWeight;
    }

    @Override
    public IChatBaseComponent P_() {
        return ScoreboardTeam.a(this.cq(), this.ah()).a(style -> style.a(this.cQ()).a(this.cH()));
    }

    public void b(@Nullable IChatBaseComponent name) {
        this.al.a(aR, Optional.ofNullable(name));
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.al.a(aR).orElse(null);
    }

    @Override
    public boolean g_() {
        return this.al.a(aR).isPresent();
    }

    public void o(boolean alwaysRenderNameTag) {
        this.al.a(aS, alwaysRenderNameTag);
    }

    public boolean cL() {
        return this.al.a(aS);
    }

    public final boolean a(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera) {
        return this.teleportTo(level, x2, y2, z2, relativeMovements, yaw, pitch, setCamera, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleportTo(WorldServer level, double x2, double y2, double z2, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        Entity entity = this.b(new TeleportTransition(level, new Vec3D(x2, y2, z2), Vec3D.c, yaw, pitch, relativeMovements, TeleportTransition.a, cause));
        return entity != null;
    }

    public void m(double x2, double y2, double z2) {
        this.b(x2, y2, z2);
    }

    public void b(double x2, double y2, double z2) {
        if (this.dV() instanceof WorldServer) {
            this.b(x2, y2, z2, this.dL(), this.dN());
            this.n();
        }
    }

    public void n() {
        this.da().forEach(entity -> {
            for (Entity entity1 : entity.u) {
                entity.a(entity1, Entity::d);
            }
        });
    }

    public void c(double dx, double dy, double dz) {
        this.b(this.dA() + dx, this.dC() + dy, this.dG() + dz);
    }

    public boolean cM() {
        return this.cL();
    }

    @Override
    public void a(List<DataWatcher.c<?>> dataValues) {
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (aq.equals(key)) {
            this.h_();
        }
    }

    @Deprecated
    protected void cN() {
        EntitySize dimensions;
        EntityPose pose = this.at();
        this.be = dimensions = this.a(pose);
        this.bf = dimensions.c();
    }

    public void h_() {
        boolean flag;
        EntitySize dimensions;
        EntitySize entityDimensions = this.be;
        EntityPose pose = this.at();
        this.be = dimensions = this.a(pose);
        this.bf = dimensions.c();
        this.av();
        boolean bl = flag = dimensions.a() <= 4.0f && dimensions.b() <= 4.0f;
        if (!(this.az.C || this.ak || this.ad || !flag || !(dimensions.a() > entityDimensions.a()) && !(dimensions.b() > entityDimensions.b()) || this instanceof EntityHuman)) {
            this.a(entityDimensions);
        }
    }

    public boolean a(EntitySize dimensions) {
        VoxelShape voxelShape1;
        Optional<Vec3D> optional1;
        double d1;
        double d2;
        EntitySize dimensions1 = this.a(this.at());
        Vec3D vec3 = this.dt().b(0.0, (double)dimensions.b() / 2.0, 0.0);
        VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec3, d2 = (double)Math.max(0.0f, dimensions1.a() - dimensions.a()) + 1.0E-6, d1 = (double)Math.max(0.0f, dimensions1.b() - dimensions.b()) + 1.0E-6, d2));
        Optional<Vec3D> optional = this.az.a(this, voxelShape, vec3, (double)dimensions1.a(), (double)dimensions1.b(), (double)dimensions1.a());
        if (optional.isPresent()) {
            this.b(optional.get().b(0.0, (double)(-dimensions1.b()) / 2.0, 0.0));
            return true;
        }
        if (dimensions1.a() > dimensions.a() && dimensions1.b() > dimensions.b() && (optional1 = this.az.a(this, voxelShape1 = VoxelShapes.a(AxisAlignedBB.a(vec3, d2, 1.0E-6, d2)), vec3, (double)dimensions1.a(), (double)dimensions.b(), (double)dimensions1.a())).isPresent()) {
            this.b(optional1.get().b(0.0, (double)(-dimensions.b()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public EnumDirection cO() {
        return EnumDirection.a(this.dL());
    }

    public EnumDirection cP() {
        return this.cO();
    }

    protected ChatHoverable cQ() {
        return new ChatHoverable.c(new ChatHoverable.b(this.an(), this.cG(), this.ah()));
    }

    public boolean a(EntityPlayer player) {
        return true;
    }

    @Override
    public final AxisAlignedBB cR() {
        return this.aG;
    }

    public final void a(AxisAlignedBB bb) {
        double minX = bb.a;
        double minY = bb.b;
        double minZ = bb.c;
        double maxX = bb.d;
        double maxY = bb.e;
        double maxZ = bb.f;
        double len = bb.d - bb.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = bb.e - bb.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = bb.f - bb.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aG = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final float d(EntityPose pose) {
        return this.a(pose).c();
    }

    public final float cS() {
        return this.bf;
    }

    public Vec3D t(float partialTick) {
        return this.cT();
    }

    protected Vec3D cT() {
        return new Vec3D(0.0, this.cS(), this.dq() * 0.4f);
    }

    public SlotAccess a_(int slot) {
        return SlotAccess.a;
    }

    public net.minecraft.world.level.World cU() {
        return this.dV();
    }

    @Nullable
    public MinecraftServer cV() {
        return this.dV().p();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D vec, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void d(EntityPlayer serverPlayer) {
    }

    public void e(EntityPlayer serverPlayer) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation transformRotation) {
        float f2 = MathHelper.h(this.dL());
        switch (transformRotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror transformMirror) {
        float f2 = MathHelper.h(this.dL());
        switch (transformMirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public ProjectileDeflection a(IProjectile projectile) {
        return this.an().a(TagsEntity.r) ? ProjectileDeflection.b : ProjectileDeflection.a;
    }

    @Nullable
    public EntityLiving cW() {
        return null;
    }

    public final boolean cX() {
        return this.cW() != null;
    }

    public final List<Entity> cY() {
        return this.u;
    }

    @Nullable
    public Entity cZ() {
        return this.u.isEmpty() ? null : (Entity)this.u.get(0);
    }

    public boolean y(Entity entity) {
        return this.u.contains((Object)entity);
    }

    public boolean a(Predicate<Entity> predicate) {
        for (Entity entity : this.u) {
            if (!predicate.test(entity)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> C() {
        if (this.u.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.u.stream().flatMap(Entity::da);
    }

    public Stream<Entity> da() {
        if (this.u.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.C());
    }

    public Stream<Entity> db() {
        if (this.u.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.u.stream().flatMap(Entity::db), Stream.of(this));
    }

    public Iterable<Entity> dc() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (this.u.isEmpty()) {
            return ret;
        }
        Entity.collectIndirectPassengers(ret, this.u);
        return ret;
    }

    public int dd() {
        return (int)this.C().filter(passenger -> passenger instanceof EntityHuman).count();
    }

    public boolean de() {
        if (this.u.isEmpty()) {
            return false;
        }
        return this.dd() == 1;
    }

    public Entity df() {
        Entity entity = this;
        while (entity.bY()) {
            entity = entity.dk();
        }
        return entity;
    }

    public boolean z(Entity entity) {
        return this.df() == entity.df();
    }

    public boolean A(Entity entity) {
        if (!entity.bY()) {
            return false;
        }
        Entity vehicle = entity.dk();
        return vehicle == this || this.A(vehicle);
    }

    public final boolean dg() {
        return this.az.A_() ? this.dh() : !this.Z_();
    }

    protected boolean dh() {
        EntityLiving controllingPassenger = this.cW();
        return controllingPassenger != null && controllingPassenger.dh();
    }

    public boolean Z_() {
        EntityLiving controllingPassenger = this.cW();
        return controllingPassenger != null && controllingPassenger.Z_();
    }

    public boolean di() {
        return this.dg();
    }

    public boolean dj() {
        return this.dg();
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float yRot) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f2 = -MathHelper.a(yRot * ((float)Math.PI / 180));
        float cos = MathHelper.b(yRot * ((float)Math.PI / 180));
        float max = Math.max(Math.abs(f2), Math.abs(cos));
        return new Vec3D((double)f2 * d2 / (double)max, 0.0, (double)cos * d2 / (double)max);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dA(), this.cR().e, this.dG());
    }

    @Nullable
    public Entity dk() {
        return this.ay;
    }

    @Nullable
    public Entity dl() {
        return this.ay != null && this.ay.cW() == this ? this.ay : null;
    }

    public EnumPistonReaction i_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory dm() {
        return SoundCategory.g;
    }

    public int dn() {
        return 1;
    }

    public CommandListenerWrapper d(WorldServer level) {
        return new CommandListenerWrapper(this.commandSource, this.dt(), this.bT(), level, 0, this.ah().getString(), this.P_(), level.p(), this);
    }

    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        Vec3D vec3 = anchor.a(this);
        double d2 = target.d - vec3.d;
        double d1 = target.e - vec3.e;
        double d22 = target.f - vec3.f;
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        this.x(MathHelper.h((float)(-(MathHelper.d(d1, squareRoot) * 180.0 / 3.1415927410125732))));
        this.w(MathHelper.h((float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f));
        this.r(this.dL());
        this.O = this.dN();
        this.N = this.dL();
    }

    public float u(float partialTick) {
        return MathHelper.h(partialTick, this.N, this.aE);
    }

    public boolean a(TagKey<FluidType> fluid, double flowScale) {
        if (this.do()) {
            return false;
        }
        AxisAlignedBB boundingBox = this.cR().h(0.001);
        net.minecraft.world.level.World world = this.az;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = MathHelper.a(boundingBox.a);
        int minBlockY = Math.max(minSection << 4, MathHelper.a(boundingBox.b));
        int minBlockZ = MathHelper.a(boundingBox.c);
        int maxBlockX = MathHelper.c(boundingBox.d) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, MathHelper.c(boundingBox.e) - 1);
        int maxBlockZ = MathHelper.c(boundingBox.f) - 1;
        boolean isPushable = this.cJ();
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        Vec3D pushVector = Vec3D.c;
        double totalPushes = 0.0;
        double maxHeightDiff = 0.0;
        boolean inFluid = false;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = world.S();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkSection[] sections = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false).d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                Fluid fluidState = blocks.a(currX | currZ << 4 | currY << 8).y();
                                if (fluidState.c() || !fluidState.a(fluid)) continue;
                                mutablePos.d(currX | currChunkX << 4, currY | currChunkY << 4, currZ | currChunkZ << 4);
                                double height = (float)mutablePos.v() + fluidState.a(world, mutablePos);
                                double diff = height - boundingBox.b;
                                if (diff < 0.0) continue;
                                inFluid = true;
                                maxHeightDiff = Math.max(maxHeightDiff, diff);
                                if (!isPushable) continue;
                                totalPushes += 1.0;
                                Vec3D flow = fluidState.c(world, mutablePos);
                                pushVector = diff < 0.4 ? pushVector.e(flow.c(diff)) : pushVector.e(flow);
                            }
                        }
                    }
                }
            }
        }
        this.ah.put(fluid, maxHeightDiff);
        if (pushVector.h() == 0.0) {
            return inFluid;
        }
        pushVector = pushVector.c(1.0 / totalPushes);
        Vec3D currMovement = this.dy();
        if (!(this instanceof EntityHuman)) {
            pushVector = pushVector.d();
        }
        pushVector = pushVector.c(flowScale);
        if (Math.abs(currMovement.d) < 0.003 && Math.abs(currMovement.f) < 0.003 && pushVector.g() < 0.0045000000000000005) {
            pushVector = pushVector.d().c(0.0045000000000000005);
        }
        this.i(currMovement.e(pushVector));
        return true;
    }

    public boolean do() {
        AxisAlignedBB aabb = this.cR().g(1.0);
        int floor = MathHelper.a(aabb.a);
        int ceil = MathHelper.c(aabb.d);
        int floor1 = MathHelper.a(aabb.c);
        int ceil1 = MathHelper.c(aabb.f);
        return !this.dV().b(floor, floor1, ceil, ceil1);
    }

    public double b(TagKey<FluidType> fluidTag) {
        return this.ah.getDouble(fluidTag);
    }

    public double dp() {
        return (double)this.cS() < 0.4 ? 0.0 : 0.4;
    }

    public final float dq() {
        return this.be.a();
    }

    public final float dr() {
        return this.be.b();
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity(this, entity);
    }

    public EntitySize a(EntityPose pose) {
        return this.s.n();
    }

    public final EntityAttachments ds() {
        return this.be.d();
    }

    public Vec3D dt() {
        return this.aA;
    }

    public Vec3D du() {
        return this.dt();
    }

    @Override
    public BlockPosition dv() {
        return this.aB;
    }

    public IBlockData dw() {
        if (this.bk == null) {
            this.bk = this.dV().a_(this.dv());
        }
        return this.bk;
    }

    public ChunkCoordIntPair dx() {
        return this.aC;
    }

    public Vec3D dy() {
        return this.aD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void i(Vec3D deltaMovement) {
        Object object = this.posLock;
        synchronized (object) {
            this.aD = deltaMovement;
        }
    }

    public void j(Vec3D addend) {
        this.i(this.dy().e(addend));
    }

    public void n(double x2, double y2, double z2) {
        this.i(new Vec3D(x2, y2, z2));
    }

    public final int dz() {
        return this.aB.u();
    }

    public final double dA() {
        return this.aA.d;
    }

    public double c(double scale) {
        return this.aA.d + (double)this.dq() * scale;
    }

    public double d(double scale) {
        return this.c((2.0 * this.ae.j() - 1.0) * scale);
    }

    public final int dB() {
        return this.aB.v();
    }

    public final double dC() {
        return this.aA.e;
    }

    public double e(double scale) {
        return this.aA.e + (double)this.dr() * scale;
    }

    public double dD() {
        return this.e(this.ae.j());
    }

    public double dE() {
        return this.aA.e + (double)this.bf;
    }

    public final int dF() {
        return this.aB.w();
    }

    public final double dG() {
        return this.aA.f;
    }

    public double f(double scale) {
        return this.aA.f + (double)this.dq() * scale;
    }

    public double g(double scale) {
        return this.f((2.0 * this.ae.j() - 1.0) * scale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        LOGGER.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.dt(), entityInfo, new Throwable()});
        return false;
    }

    public final void o(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (this.updatingSectionStatus) {
            LOGGER.error("Refusing to update position for entity " + String.valueOf(this) + " to position " + String.valueOf(new Vec3D(x2, y2, z2)) + " since it is processing a section status update", new Throwable());
            return;
        }
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.aA.d != x2 || this.aA.e != y2 || this.aA.f != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.aA = new Vec3D(x2, y2, z2);
            }
            int floor = MathHelper.a(x2);
            int floor1 = MathHelper.a(y2);
            int floor2 = MathHelper.a(z2);
            if (floor != this.aB.u() || floor1 != this.aB.v() || floor2 != this.aB.w()) {
                this.aB = new BlockPosition(floor, floor1, floor2);
                this.bk = null;
                if (SectionPosition.a(floor) != this.aC.h || SectionPosition.a(floor2) != this.aC.i) {
                    this.aC = new ChunkCoordIntPair(this.aB);
                }
            }
            this.aW.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.aA.d != x2 || this.aA.e != y2 || this.aA.f != z2)) {
            this.a(this.au());
        }
    }

    public void dH() {
    }

    public Vec3D v(float partialTicks) {
        return this.p(partialTicks).b(0.0, (double)this.bf * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int id = packet.b();
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        this.e(x2, y2, z2);
        this.b(x2, y2, z2, packet.n(), packet.m());
        this.e(id);
        this.a_(packet.e());
        Vec3D vec3 = new Vec3D(packet.j(), packet.k(), packet.l());
        this.i(vec3);
    }

    @Nullable
    public ItemStack dI() {
        return null;
    }

    public void p(boolean isInPowderSnow) {
        this.av = isInPowderSnow;
    }

    public boolean dJ() {
        return !this.an().a(TagsEntity.k);
    }

    public boolean dK() {
        return this.cu() > 0;
    }

    public float getBukkitYaw() {
        return this.aE;
    }

    public float dL() {
        return this.aE;
    }

    public float dM() {
        return this.dL();
    }

    public void w(float yRot) {
        if (!Float.isFinite(yRot)) {
            SystemUtils.b("Invalid entity rotation: " + yRot + ", discarding.");
        } else {
            this.aE = yRot;
        }
    }

    public float dN() {
        return this.aF;
    }

    public void x(float xRot) {
        if (!Float.isFinite(xRot)) {
            SystemUtils.b("Invalid entity rotation: " + xRot + ", discarding.");
        } else {
            this.aF = Math.clamp(xRot % 360.0f, -90.0f, 90.0f);
        }
    }

    public boolean dO() {
        return false;
    }

    public float dP() {
        return 0.0f;
    }

    public void b_(@Nullable Entity entity) {
    }

    @Override
    public final boolean dQ() {
        return this.aI != null;
    }

    @Nullable
    public RemovalReason dR() {
        return this.aI;
    }

    @Override
    public final void setRemoved(RemovalReason removalReason, @Nullable EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        if (!this.az.moonrise$getEntityLookup().canRemoveEntity(this)) {
            LOGGER.warn("Entity " + String.valueOf(this) + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.aI != null;
        if (this.aI == null) {
            this.aI = removalReason;
        }
        if (this.aI.a()) {
            this.bO();
        }
        if (this.aI != RemovalReason.c) {
            this.cY().forEach(Entity::bO);
        }
        this.aW.a(removalReason);
        this.b(removalReason);
        if (!(this instanceof EntityPlayer) && removalReason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void dS() {
        this.aI = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void a(EntityInLevelCallback levelCallback) {
        this.aW = levelCallback;
    }

    @Override
    public boolean dT() {
        return !(this.aI != null && !this.aI.b() || this.bY() || this.bZ() && this.moonrise$hasAnyPlayerPassengers());
    }

    @Override
    public boolean dU() {
        return false;
    }

    public boolean c(WorldServer level, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World dV() {
        return this.az;
    }

    public void a(net.minecraft.world.level.World level) {
        this.az = level;
    }

    public DamageSources dW() {
        return this.dV().al();
    }

    public IRegistryCustom dX() {
        return this.dV().J_();
    }

    protected void a(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        double d2 = 1.0 / (double)steps;
        double d1 = MathHelper.d(d2, this.dA(), targetX);
        double d22 = MathHelper.d(d2, this.dC(), targetY);
        double d3 = MathHelper.d(d2, this.dG(), targetZ);
        float f2 = (float)MathHelper.e(d2, (double)this.dL(), targetYRot);
        float f1 = (float)MathHelper.d(d2, (double)this.dN(), targetXRot);
        this.a_(d1, d22, d3);
        this.b(f2, f1);
    }

    public RandomSource dY() {
        return this.ae;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vec3D ad() {
        Vec3D vec3D;
        EntityLiving entityLiving = this.cW();
        if (entityLiving instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entityLiving;
            if (this.bJ()) {
                vec3D = player.ad();
                return vec3D;
            }
        }
        vec3D = this.dy();
        return vec3D;
    }

    @Nullable
    public ItemStack dZ() {
        return null;
    }

    public Optional<ResourceKey<LootTable>> ea() {
        return this.s.j();
    }

    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.g);
        this.a(componentGetter, DataComponents.b);
    }

    public final void c(ItemStack stack) {
        this.a(stack.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.g) {
            return Entity.c(component, this.aj());
        }
        return component == DataComponents.b ? (T)Entity.c(component, this.bp) : null;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    protected static <T> T c(DataComponentType<T> componentType, @Nullable Object value) {
        return (T)value;
    }

    public <T> void d(DataComponentType<T> component, T value) {
        this.b(component, value);
    }

    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.g) {
            this.b(Entity.c(DataComponents.g, value));
            return true;
        }
        if (component == DataComponents.b) {
            this.bp = Entity.c(DataComponents.b, value);
            return true;
        }
        return false;
    }

    protected <T> boolean a(DataComponentGetter componentGetter, DataComponentType<T> component) {
        T object = componentGetter.a(component);
        return object != null && this.b(component, object);
    }

    public static int nextEntityId() {
        return c.incrementAndGet();
    }

    public boolean isTicking() {
        return ((WorldServer)this.dV()).f(this.dv());
    }

    public static final class RemovalReason
    extends Enum<RemovalReason> {
        public static final /* enum */ RemovalReason a = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason b = new RemovalReason(true, false);
        public static final /* enum */ RemovalReason c = new RemovalReason(false, true);
        public static final /* enum */ RemovalReason d = new RemovalReason(false, false);
        public static final /* enum */ RemovalReason e = new RemovalReason(false, false);
        private final boolean f;
        private final boolean g;
        private static final /* synthetic */ RemovalReason[] h;

        public static RemovalReason[] values() {
            return (RemovalReason[])h.clone();
        }

        public static RemovalReason valueOf(String name) {
            return Enum.valueOf(RemovalReason.class, name);
        }

        private RemovalReason(boolean destroy, boolean save) {
            this.f = destroy;
            this.g = save;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }

        private static /* synthetic */ RemovalReason[] c() {
            return new RemovalReason[]{a, b, c, d, e};
        }

        static {
            h = RemovalReason.c();
        }
    }

    record b(Vec3D a, Vec3D b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "from;to", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "from;to", "a", "b"}, this, o2);
        }
    }

    public static final class MovementEmission
    extends Enum<MovementEmission> {
        public static final /* enum */ MovementEmission a = new MovementEmission(false, false);
        public static final /* enum */ MovementEmission b = new MovementEmission(true, false);
        public static final /* enum */ MovementEmission c = new MovementEmission(false, true);
        public static final /* enum */ MovementEmission d = new MovementEmission(true, true);
        final boolean e;
        final boolean f;
        private static final /* synthetic */ MovementEmission[] g;

        public static MovementEmission[] values() {
            return (MovementEmission[])g.clone();
        }

        public static MovementEmission valueOf(String name) {
            return Enum.valueOf(MovementEmission.class, name);
        }

        private MovementEmission(boolean sounds, boolean events) {
            this.e = sounds;
            this.f = events;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }

        private static /* synthetic */ MovementEmission[] d() {
            return new MovementEmission[]{a, b, c, d};
        }

        static {
            g = MovementEmission.d();
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.h(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(Consumer<org.bukkit.inventory.ItemStack> fallback) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallback.accept(this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends ThreadUnsafeRandom {
        private boolean locked = false;

        public RandomRandomSource() {
            this(RandomSupport.a());
        }

        public RandomRandomSource(long seed) {
            super(seed);
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                LOGGER.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.b(seed);
                this.locked = true;
            }
        }
    }
}

