/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public abstract class EntityAgeable
extends EntityCreature {
    private static final DataWatcherObject<Boolean> bI = DataWatcher.a(EntityAgeable.class, DataWatcherRegistry.k);
    public static final int a = -24000;
    private static final int bJ = 40;
    protected static final int b = 0;
    protected static final int c = 0;
    protected int d = 0;
    protected int e = 0;
    protected int f;
    public boolean ageLocked;

    protected EntityAgeable(EntityTypes<? extends EntityAgeable> entityType, World level) {
        super((EntityTypes<? extends EntityCreature>)entityType, level);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        a ageableMobGroupData;
        if (spawnGroupData == null) {
            spawnGroupData = new a(true);
        }
        if ((ageableMobGroupData = (a)spawnGroupData).c() && ageableMobGroupData.a() > 0 && level.G_().i() <= ageableMobGroupData.d()) {
            this.c_(-24000);
        }
        ageableMobGroupData.b();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Nullable
    public abstract EntityAgeable a(WorldServer var1, EntityAgeable var2);

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bI, false);
    }

    public boolean X_() {
        return false;
    }

    public int Y_() {
        if (this.dV().C) {
            return this.al.a(bI) != false ? -1 : 1;
        }
        return this.d;
    }

    public void a(int amount, boolean forced) {
        int age;
        if (this.ageLocked) {
            return;
        }
        int previousAge = age = this.Y_();
        if ((age += amount * 20) > 0) {
            age = 0;
        }
        int i1 = age - previousAge;
        this.c_(age);
        if (forced) {
            this.e += i1;
            if (this.f == 0) {
                this.f = 40;
            }
        }
        if (this.Y_() == 0) {
            this.c_(this.e);
        }
    }

    public void b_(int amount) {
        this.a(amount, false);
    }

    public void c_(int age) {
        int age1 = this.Y_();
        this.d = age;
        if (age1 < 0 && age >= 0 || age1 >= 0 && age < 0) {
            this.al.a(bI, age < 0);
            this.h();
        }
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("Age", this.Y_());
        compound.a("ForcedAge", this.e);
        compound.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        this.c_(compound.b("Age", 0));
        this.e = compound.b("ForcedAge", 0);
        this.ageLocked = compound.b("AgeLocked", false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (bI.equals(key)) {
            this.h_();
        }
        super.a(key);
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.dV().C || this.ageLocked) {
            this.h_();
        } else {
            int age = this.Y_();
            if (age < 0) {
                this.c_(++age);
            } else if (age > 0) {
                this.c_(--age);
            }
        }
    }

    @Override
    public void d_() {
        super.d_();
        if (this.dV().C || this.ageLocked) {
            if (this.f > 0) {
                if (this.f % 4 == 0) {
                    this.dV().a(Particles.Q, this.d(1.0), this.dD() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
                }
                --this.f;
            }
        } else if (this.bJ()) {
            int age = this.Y_();
            if (age < 0) {
                this.c_(++age);
            } else if (age > 0) {
                this.c_(--age);
            }
        }
    }

    protected void h() {
        AbstractBoat abstractBoat;
        Entity entity;
        if (!this.e_() && this.bY() && (entity = this.dk()) instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).b((Entity)this)) {
            this.bO();
        }
    }

    @Override
    public boolean e_() {
        return this.Y_() < 0;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -24000 : 0);
    }

    public static int d_(int ticksUntilAdult) {
        return (int)((float)(ticksUntilAdult / 20) * 0.1f);
    }

    @VisibleForTesting
    public int k() {
        return this.e;
    }

    @VisibleForTesting
    public int l() {
        return this.f;
    }

    public static class a
    implements GroupDataEntity {
        private int a;
        private final boolean b;
        private final float c;

        public a(boolean shouldSpawnBaby, float babySpawnChance) {
            this.b = shouldSpawnBaby;
            this.c = babySpawnChance;
        }

        public a(boolean shouldSpawnBaby) {
            this(shouldSpawnBaby, 0.05f);
        }

        public a(float babySpawnChance) {
            this(true, babySpawnChance);
        }

        public int a() {
            return this.a;
        }

        public void b() {
            ++this.a;
        }

        public boolean c() {
            return this.b;
        }

        public float d() {
            return this.c;
        }
    }
}

