/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final int j = 0;
    private static final int k = 0;
    private static final float l = 0.0f;
    private static final float m = 0.0f;
    private static final float n = 1.0f;
    private static final float o = 0.5f;
    private static final float p = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public static final int c = -1;
    public static final int d = 600;
    private static final int q = 20;
    private static final int r = 20;
    private static final ColorParticleOption s = ColorParticleOption.a(Particles.u, -1);
    public PotionContents t = PotionContents.a;
    private float u = 1.0f;
    private final Map<Entity, Integer> ay = Maps.newHashMap();
    private int az = -1;
    public int aA = 20;
    public int aB = 20;
    public int aC = 0;
    public float aD = 0.0f;
    public float aE = 0.0f;
    @Nullable
    private EntityLiving aF;
    @Nullable
    public UUID aG;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entityType, World level) {
        super(entityType, level);
        this.ad = true;
    }

    public EntityAreaEffectCloud(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.e, level);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, Float.valueOf(3.0f));
        builder.a(g, false);
        builder.a(h, s);
    }

    public void a(float radius) {
        if (!this.dV().C) {
            this.ar().a(f, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void h_() {
        double x2 = this.dA();
        double y2 = this.dC();
        double z2 = this.dG();
        super.h_();
        this.a_(x2, y2, z2);
    }

    public float c() {
        return this.ar().a(f).floatValue();
    }

    public void a(PotionContents potionContents) {
        this.t = potionContents;
        this.r();
    }

    public void b(float potionDurationScale) {
        this.u = potionDurationScale;
    }

    public void r() {
        ParticleParam particleOptions = this.al.a(h);
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption colorParticleOption = (ColorParticleOption)particleOptions;
            int i2 = this.t.equals(PotionContents.a) ? 0 : this.t.b();
            this.al.a(h, ColorParticleOption.a(colorParticleOption.a(), ARGB.f(i2)));
        }
    }

    public void a(MobEffect effectInstance) {
        this.a(this.t.a(effectInstance));
    }

    public ParticleParam e() {
        return this.ar().a(h);
    }

    public void a(ParticleParam particleOption) {
        this.ar().a(h, particleOption);
    }

    protected void a(boolean waiting) {
        this.ar().a(g, waiting);
    }

    public boolean f() {
        return this.ar().a(g);
    }

    public int h() {
        return this.az;
    }

    public void a(int duration) {
        this.az = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.af >= this.aA + this.az) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void g() {
        super.g();
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel);
        } else {
            this.s();
        }
    }

    private void s() {
        boolean isWaiting = this.f();
        float radius = this.c();
        if (!isWaiting || !this.ae.h()) {
            float f2;
            int i2;
            ParticleParam particle = this.e();
            if (isWaiting) {
                i2 = 2;
                f2 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * radius * radius);
                f2 = radius;
            }
            for (int i1 = 0; i1 < i2; ++i1) {
                float f1 = this.ae.i() * ((float)Math.PI * 2);
                float f22 = MathHelper.c(this.ae.i()) * f2;
                double d2 = this.dA() + (double)(MathHelper.b(f1) * f22);
                double y2 = this.dC();
                double d1 = this.dG() + (double)(MathHelper.a(f1) * f22);
                if (particle.a() == Particles.u) {
                    if (isWaiting && this.ae.h()) {
                        this.dV().b(ColorParticleOption.a(Particles.u, -1), d2, y2, d1, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.dV().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                if (isWaiting) {
                    this.dV().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                this.dV().b(particle, d2, y2, d1, (0.5 - this.ae.j()) * 0.15, 0.01f, (0.5 - this.ae.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer level) {
        if (this.az != -1 && this.af >= this.aA + this.az) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag;
            boolean isWaiting = this.f();
            boolean bl = flag = this.af < this.aA;
            if (isWaiting != flag) {
                this.a(flag);
            }
            if (!flag) {
                float radius = this.c();
                if (this.aE != 0.0f) {
                    if ((radius += this.aE) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(radius);
                }
                if (this.af % 5 == 0) {
                    this.ay.entrySet().removeIf(victim -> this.af >= (Integer)victim.getValue());
                    if (!this.t.c()) {
                        this.ay.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        this.t.a(list::add, this.u);
                        List<EntityLiving> entitiesOfClass = this.dV().a(EntityLiving.class, this.cR());
                        if (!entitiesOfClass.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving livingEntity : entitiesOfClass) {
                                double d1;
                                double d2;
                                double d22;
                                if (this.ay.containsKey(livingEntity) || !livingEntity.fL()) continue;
                                if (list.stream().noneMatch(livingEntity::b) || !((d22 = (d2 = livingEntity.dA() - this.dA()) * d2 + (d1 = livingEntity.dG() - this.dG()) * d1) <= (double)(radius * radius))) continue;
                                entities.add((LivingEntity)livingEntity.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving livingEntity = ((CraftLivingEntity)entity).getHandle();
                                    this.ay.put(livingEntity, this.af + this.aB);
                                    for (MobEffect mobEffectInstance : list) {
                                        if (mobEffectInstance.c().a().a()) {
                                            mobEffectInstance.c().a().a(level, this, this.n(), livingEntity, mobEffectInstance.e(), 0.5);
                                            continue;
                                        }
                                        livingEntity.addEffect(new MobEffect(mobEffectInstance), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.aD != 0.0f) {
                                        if ((radius += this.aD) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(radius);
                                    }
                                    if (this.aC == 0 || this.az == -1) continue;
                                    this.az += this.aC;
                                    if (this.az > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.aD;
    }

    public void c(float radiusOnUse) {
        this.aD = radiusOnUse;
    }

    public float k() {
        return this.aE;
    }

    public void d(float radiusPerTick) {
        this.aE = radiusPerTick;
    }

    public int l() {
        return this.aC;
    }

    public void b(int durationOnUse) {
        this.aC = durationOnUse;
    }

    public int m() {
        return this.aA;
    }

    public void c(int waitTime) {
        this.aA = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aF = owner;
        this.aG = owner == null ? null : owner.cG();
    }

    @Nullable
    public EntityLiving n() {
        World world;
        if (this.aF != null && !this.aF.dQ()) {
            return this.aF;
        }
        if (this.aG != null && (world = this.dV()) instanceof WorldServer) {
            EntityLiving livingEntity;
            WorldServer serverLevel = (WorldServer)world;
            Entity entity = serverLevel.b(this.aG);
            this.aF = entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null;
        }
        return this.aF;
    }

    @Override
    protected void a(NBTTagCompound compound) {
        this.af = compound.b("Age", 0);
        this.az = compound.b("Duration", -1);
        this.aA = compound.b("WaitTime", 20);
        this.aB = compound.b("ReapplicationDelay", 20);
        this.aC = compound.b("DurationOnUse", 0);
        this.aD = compound.b("RadiusOnUse", 0.0f);
        this.aE = compound.b("RadiusPerTick", 0.0f);
        this.a(compound.b("Radius", 3.0f));
        this.aG = compound.a("Owner", UUIDUtil.a).orElse(null);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.a(compound.a("Particle", Particles.bk, (DynamicOps<NBTBase>)registryOps).orElse(s));
        this.a(compound.a("potion_contents", PotionContents.c, (DynamicOps<NBTBase>)registryOps).orElse(PotionContents.a));
        this.u = compound.b("potion_duration_scale", 1.0f);
    }

    @Override
    protected void b(NBTTagCompound compound) {
        compound.a("Age", this.af);
        compound.a("Duration", this.az);
        compound.a("WaitTime", this.aA);
        compound.a("ReapplicationDelay", this.aB);
        compound.a("DurationOnUse", this.aC);
        compound.a("RadiusOnUse", this.aD);
        compound.a("RadiusPerTick", this.aE);
        compound.a("Radius", this.c());
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        compound.a("Particle", Particles.bk, registryOps, this.e());
        compound.b("Owner", UUIDUtil.a, this.aG);
        if (!this.t.equals(PotionContents.a)) {
            compound.a("potion_contents", PotionContents.c, registryOps, this.t);
        }
        if (this.u != 1.0f) {
            compound.a("potion_duration_scale", this.u);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (f.equals(key)) {
            this.h_();
        }
        super.a(key);
    }

    @Override
    public EnumPistonReaction i_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.R) {
            return EntityAreaEffectCloud.c(component, this.t);
        }
        return component == DataComponents.S ? EntityAreaEffectCloud.c(component, Float.valueOf(this.u)) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.R);
        this.a(componentGetter, DataComponents.S);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.R) {
            this.a(EntityAreaEffectCloud.c(DataComponents.R, value));
            return true;
        }
        if (component == DataComponents.S) {
            this.b(EntityAreaEffectCloud.c(DataComponents.S, value).floatValue());
            return true;
        }
        return super.b(component, value);
    }
}

