/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.player.PlayerPickupExperienceEvent;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerItemMendEvent;

public class EntityExperienceOrb
extends Entity {
    protected static final DataWatcherObject<Integer> a = DataWatcher.a(EntityExperienceOrb.class, DataWatcherRegistry.b);
    private static final int b = 6000;
    private static final int c = 20;
    private static final int d = 8;
    private static final int e = 40;
    private static final double f = 0.5;
    private static final short g = 5;
    private static final short h = 0;
    private static final short i = 0;
    private static final int j = 1;
    private int k = 0;
    private int l = 5;
    public int m = 1;
    @Nullable
    private EntityHuman n;
    private final InterpolationHandler o = new InterpolationHandler(this);
    @Nullable
    public UUID sourceEntityId;
    @Nullable
    public UUID triggerEntityId;
    public ExperienceOrb.SpawnReason spawnReason = ExperienceOrb.SpawnReason.UNKNOWN;

    private void loadPaperNBT(NBTTagCompound tag) {
        NBTTagCompound expData = tag.n("Paper.ExpData");
        if (expData.j()) {
            return;
        }
        this.sourceEntityId = expData.a("source", UUIDUtil.a).orElse(null);
        this.triggerEntityId = expData.a("trigger", UUIDUtil.a).orElse(null);
        expData.i("reason").ifPresent(reason -> {
            try {
                this.spawnReason = ExperienceOrb.SpawnReason.valueOf((String)reason);
            }
            catch (Exception e2) {
                this.dV().getCraftServer().getLogger().warning("Invalid spawnReason set for experience orb: " + e2.getMessage() + " - " + reason);
            }
        });
    }

    private void savePaperNBT(NBTTagCompound tag) {
        NBTTagCompound expData = new NBTTagCompound();
        expData.b("source", UUIDUtil.a, this.sourceEntityId);
        expData.b("trigger", UUIDUtil.a, this.triggerEntityId);
        if (this.spawnReason != ExperienceOrb.SpawnReason.UNKNOWN) {
            expData.a("reason", this.spawnReason.name());
        }
        tag.a("Paper.ExpData", expData);
    }

    @Deprecated
    @DoNotUse
    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value) {
        this(level, x2, y2, z2, value, null, null);
    }

    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        this(level, x2, y2, z2, value, reason, triggerId, null);
    }

    public EntityExperienceOrb(World level, double x2, double y2, double z2, int value, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        this((EntityTypes<? extends EntityExperienceOrb>)EntityTypes.W, level);
        this.sourceEntityId = sourceId != null ? sourceId.cG() : null;
        this.triggerEntityId = triggerId != null ? triggerId.cG() : null;
        this.spawnReason = reason != null ? reason : ExperienceOrb.SpawnReason.UNKNOWN;
        this.a_(x2, y2, z2);
        if (!this.dV().C) {
            this.w((float)(this.ae.j() * 360.0));
            this.n((this.ae.j() * (double)0.2f - (double)0.1f) * 2.0, this.ae.j() * 0.2 * 2.0, (this.ae.j() * (double)0.2f - (double)0.1f) * 2.0);
        }
        this.c(value);
    }

    public EntityExperienceOrb(EntityTypes<? extends EntityExperienceOrb> entityType, World level) {
        super(entityType, level);
    }

    @Override
    protected Entity.MovementEmission bf() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, 0);
    }

    @Override
    protected double bc() {
        return 0.03;
    }

    @Override
    public void g() {
        this.o.e();
        if (this.ak && this.dV().C) {
            this.ak = false;
        } else {
            boolean flag;
            super.g();
            boolean bl = flag = !this.dV().b(this.cR());
            if (this.a(TagsFluid.a)) {
                this.m();
            } else if (!flag) {
                this.be();
            }
            if (this.dV().b_(this.dv()).a(TagsFluid.b)) {
                this.n((this.ae.i() - this.ae.i()) * 0.2f, 0.2f, (this.ae.i() - this.ae.i()) * 0.2f);
            }
            if (this.af % 20 == 1) {
                this.l();
            }
            this.i();
            if (this.n == null && !this.dV().C && flag) {
                this.l(this.dA(), (this.cR().b + this.cR().e) / 2.0, this.dG());
                this.ar = true;
            }
            double d2 = this.dy().e;
            this.a(EnumMoveType.a, this.dy());
            this.aI();
            float f2 = 0.98f;
            if (this.aH()) {
                f2 = this.dV().a_(this.aP()).b().g() * 0.98f;
            }
            this.i(this.dy().c((double)f2));
            if (this.R && d2 < -this.bd()) {
                this.i(new Vec3D(this.dy().d, -d2 * 0.4, this.dy().f));
            }
            ++this.k;
            if (this.k >= 6000) {
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    private void i() {
        EntityHuman prevTarget = this.n;
        if (this.n == null || this.n.ak() || this.n.g(this) > 64.0) {
            EntityHuman nearestPlayer = this.dV().a((Entity)this, 8.0);
            this.n = nearestPlayer != null && !nearestPlayer.ak() && !nearestPlayer.eH() ? nearestPlayer : null;
        }
        boolean cancelled = false;
        if (this.n != prevTarget) {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(this, this.n, this.n != null ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.FORGOT_TARGET);
            EntityLiving target = event.getTarget() == null ? null : ((CraftLivingEntity)event.getTarget()).getHandle();
            cancelled = event.isCancelled();
            if (cancelled) {
                this.n = prevTarget;
            } else {
                EntityHuman entityHuman = this.n = target instanceof EntityHuman ? (EntityHuman)target : null;
            }
        }
        if (this.n != null && !cancelled) {
            Vec3D vec3 = new Vec3D(this.n.dA() - this.dA(), this.n.dC() + (double)this.n.cS() / 2.0 - this.dC(), this.n.dG() - this.dG());
            double d2 = vec3.h();
            double d1 = 1.0 - Math.sqrt(d2) / 8.0;
            this.i(this.dy().e(vec3.d().c(d1 * d1 * 0.1)));
        }
    }

    @Override
    public BlockPosition aP() {
        return this.f(0.999999f);
    }

    private void l() {
        if (this.dV() instanceof WorldServer) {
            for (EntityExperienceOrb experienceOrb : this.dV().a(EntityTypeTest.a(EntityExperienceOrb.class), this.cR().g(0.5), this::a)) {
                this.b(experienceOrb);
            }
        }
    }

    public static void a(WorldServer level, Vec3D pos, int amount) {
        EntityExperienceOrb.award(level, pos, amount, null, null, null);
    }

    public static void award(WorldServer level, Vec3D pos, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId) {
        EntityExperienceOrb.award(level, pos, amount, reason, triggerId, null);
    }

    public static void award(WorldServer level, Vec3D pos, int amount, @Nullable ExperienceOrb.SpawnReason reason, @Nullable Entity triggerId, @Nullable Entity sourceId) {
        while (amount > 0) {
            int experienceValue = EntityExperienceOrb.b(amount);
            amount -= experienceValue;
            if (EntityExperienceOrb.b(level, pos, experienceValue)) continue;
            level.b(new EntityExperienceOrb(level, pos.a(), pos.b(), pos.c(), experienceValue, reason, triggerId, sourceId));
        }
    }

    private static boolean b(WorldServer level, Vec3D pos, int amount) {
        AxisAlignedBB aabb = AxisAlignedBB.a(pos, 1.0, 1.0, 1.0);
        int randomInt = level.G_().a(GlobalConfiguration.get().misc.xpOrbGroupsPerArea.or(40));
        List<EntityExperienceOrb> entities = level.a(EntityTypeTest.a(EntityExperienceOrb.class), aabb, (? super T orb) -> EntityExperienceOrb.a(orb, randomInt, amount));
        if (!entities.isEmpty()) {
            EntityExperienceOrb experienceOrb = entities.get(0);
            ++experienceOrb.m;
            experienceOrb.k = 0;
            return true;
        }
        return false;
    }

    private boolean a(EntityExperienceOrb orb) {
        return orb != this && EntityExperienceOrb.a(orb, this.ao(), this.e());
    }

    private static boolean a(EntityExperienceOrb orb, int amount, int other) {
        return !orb.dQ() && (orb.ao() - amount) % GlobalConfiguration.get().misc.xpOrbGroupsPerArea.or(40) == 0 && orb.e() == other;
    }

    private void b(EntityExperienceOrb orb) {
        if (!new ExperienceOrbMergeEvent((ExperienceOrb)this.getBukkitEntity(), (ExperienceOrb)orb.getBukkitEntity()).callEvent()) {
            return;
        }
        this.m += orb.m;
        this.k = Math.min(this.k, orb.k);
        orb.discard(EntityRemoveEvent.Cause.MERGE);
    }

    private void m() {
        Vec3D deltaMovement = this.dy();
        this.n(deltaMovement.d * (double)0.99f, Math.min(deltaMovement.e + (double)5.0E-4f, (double)0.06f), deltaMovement.f * (double)0.99f);
    }

    @Override
    protected void bq() {
    }

    @Override
    public final boolean b(DamageSource damageSource) {
        return !this.d(damageSource);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.d(damageSource)) {
            return false;
        }
        this.bB();
        this.l = (int)((float)this.l - amount);
        if (this.l <= 0) {
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound compound) {
        compound.a("Health", (short)this.l);
        compound.a("Age", (short)this.k);
        compound.a("Value", this.e());
        compound.a("Count", this.m);
        this.savePaperNBT(compound);
    }

    @Override
    public void a(NBTTagCompound compound) {
        this.l = compound.b("Health", (short)5);
        this.k = compound.b("Age", (short)0);
        this.c(compound.b("Value", 0));
        this.m = compound.a("Count", ExtraCodecs.m).orElse(1);
        this.loadPaperNBT(compound);
    }

    @Override
    public void a_(EntityHuman entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (entity.bX == 0 && new PlayerPickupExperienceEvent((Player)serverPlayer.getBukkitEntity(), (ExperienceOrb)this.getBukkitEntity()).callEvent()) {
                entity.bX = CraftEventFactory.callPlayerXpCooldownEvent(entity, 2, PlayerExpCooldownChangeEvent.ChangeReason.PICKUP_ORB).getNewCooldown();
                entity.a((Entity)this, 1);
                int i2 = this.a(serverPlayer, this.e());
                if (i2 > 0) {
                    entity.d(CraftEventFactory.callPlayerExpChangeEvent(entity, this).getAmount());
                }
                --this.m;
                if (this.m == 0) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                }
            }
        }
    }

    private int a(EntityPlayer player, int value) {
        Optional<EnchantedItemInUse> randomItemWith = EnchantmentManager.a(EnchantmentEffectComponents.z, (EntityLiving)player, ItemStack::n);
        if (randomItemWith.isPresent()) {
            int i1;
            ItemStack itemStack = randomItemWith.get().a();
            int i2 = EnchantmentManager.c(player.x(), itemStack, value);
            int min = Math.min(i2, itemStack.o());
            int consumedExperience = min > 0 ? min * value / i2 : 0;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(player, this, itemStack, randomItemWith.get().b(), min, consumedExperience);
            min = event.getRepairAmount();
            if (event.isCancelled()) {
                return value;
            }
            itemStack.b(itemStack.o() - min);
            if (min > 0 && (i1 = value - min * value / i2) > 0) {
                return this.a(player, i1);
            }
            return 0;
        }
        return value;
    }

    public int e() {
        return this.al.a(a);
    }

    public void c(int value) {
        this.al.a(a, value);
    }

    public int f() {
        int value = this.e();
        if (value >= 2477) {
            return 10;
        }
        if (value >= 1237) {
            return 9;
        }
        if (value >= 617) {
            return 8;
        }
        if (value >= 307) {
            return 7;
        }
        if (value >= 149) {
            return 6;
        }
        if (value >= 73) {
            return 5;
        }
        if (value >= 37) {
            return 4;
        }
        if (value >= 17) {
            return 3;
        }
        if (value >= 7) {
            return 2;
        }
        return value >= 3 ? 1 : 0;
    }

    public static int b(int expValue) {
        if (expValue > 162670129) {
            return expValue - 100000;
        }
        if (expValue > 81335063) {
            return 81335063;
        }
        if (expValue > 40667527) {
            return 40667527;
        }
        if (expValue > 20333759) {
            return 20333759;
        }
        if (expValue > 10166857) {
            return 10166857;
        }
        if (expValue > 5083423) {
            return 5083423;
        }
        if (expValue > 2541701) {
            return 2541701;
        }
        if (expValue > 1270849) {
            return 1270849;
        }
        if (expValue > 635413) {
            return 635413;
        }
        if (expValue > 317701) {
            return 317701;
        }
        if (expValue > 158849) {
            return 158849;
        }
        if (expValue > 79423) {
            return 79423;
        }
        if (expValue > 39709) {
            return 39709;
        }
        if (expValue > 19853) {
            return 19853;
        }
        if (expValue > 9923) {
            return 9923;
        }
        if (expValue > 4957) {
            return 4957;
        }
        if (expValue >= 2477) {
            return 2477;
        }
        if (expValue >= 1237) {
            return 1237;
        }
        if (expValue >= 617) {
            return 617;
        }
        if (expValue >= 307) {
            return 307;
        }
        if (expValue >= 149) {
            return 149;
        }
        if (expValue >= 73) {
            return 73;
        }
        if (expValue >= 37) {
            return 37;
        }
        if (expValue >= 17) {
            return 17;
        }
        if (expValue >= 7) {
            return 7;
        }
        return expValue >= 3 ? 3 : 1;
    }

    @Override
    public boolean cB() {
        return false;
    }

    @Override
    public SoundCategory dm() {
        return SoundCategory.i;
    }

    @Override
    public InterpolationHandler l_() {
        return this.o;
    }
}

