/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int j = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> bH = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float k = 0.15f;
    public static final float bu = 0.55f;
    public static final float bv = 0.5f;
    public static final float bw = 0.25f;
    public static final int bx = 2;
    private static final double bI = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean bJ = false;
    private static final boolean bK = false;
    private static final boolean bL = false;
    private static final boolean bM = false;
    protected static final MinecraftKey by = MinecraftKey.b("random_spawn_bonus");
    public int bz;
    protected int bA;
    protected ControllerLook bB;
    protected ControllerMove bC;
    protected ControllerJump bD;
    private final EntityAIBodyControl bN;
    protected NavigationAbstract bE;
    public PathfinderGoalSelector bF;
    @Nullable
    public PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector bG;
    @Nullable
    private EntityLiving bO;
    private final EntitySenses bP;
    private DropChances bQ = DropChances.d;
    private boolean bR = false;
    private boolean bS = false;
    private final Map<PathType, Float> bT = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> bU = Optional.empty();
    public long bV;
    @Nullable
    private Leashable.a bW;
    private BlockPosition bX = BlockPosition.c;
    private float bY = -1.0f;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entityType, World level) {
        super((EntityTypes<? extends EntityLiving>)entityType, level);
        this.bF = new PathfinderGoalSelector();
        this.bG = new PathfinderGoalSelector();
        this.bB = new ControllerLook(this);
        this.bC = new ControllerMove(this);
        this.bD = new ControllerJump(this);
        this.bN = this.H();
        this.bE = this.b(level);
        this.bP = new EntitySenses(this);
        if (level instanceof WorldServer) {
            this.C();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.bS = persistenceRequired;
    }

    protected void C() {
    }

    public static AttributeProvider.Builder D() {
        return EntityLiving.ee().a(GenericAttributes.m, 16.0);
    }

    protected NavigationAbstract b(World level) {
        return new Navigation(this, level);
    }

    protected boolean E() {
        return false;
    }

    public float a(PathType pathType) {
        EntityInsentient mob;
        Entity entity = this.dl();
        EntityInsentient mob1 = entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).E() ? mob : this;
        Float _float = mob1.bT.get((Object)pathType);
        return _float == null ? pathType.a() : _float.floatValue();
    }

    public void a(PathType pathType, float malus) {
        this.bT.put(pathType, Float.valueOf(malus));
    }

    public void F() {
    }

    @Override
    public void G() {
    }

    protected EntityAIBodyControl H() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook I() {
        return this.bB;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.bF.inactiveTick()) {
            this.bF.a();
        }
        if (this.bG.inactiveTick()) {
            this.bG.a();
        }
    }

    public ControllerMove K() {
        ControllerMove controllerMove;
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            controllerMove = mob.K();
        } else {
            controllerMove = this.bC;
        }
        return controllerMove;
    }

    public ControllerJump M() {
        return this.bD;
    }

    public NavigationAbstract N() {
        NavigationAbstract navigationAbstract;
        Entity entity = this.dl();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            navigationAbstract = mob.N();
        } else {
            navigationAbstract = this.bE;
        }
        return navigationAbstract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public EntityLiving cW() {
        Entity firstPassenger = this.cZ();
        if (this.gj()) return null;
        if (!(firstPassenger instanceof EntityInsentient)) return null;
        EntityInsentient mob = (EntityInsentient)firstPassenger;
        if (!firstPassenger.cb()) return null;
        EntityInsentient entityInsentient = mob;
        return entityInsentient;
    }

    public EntitySenses O() {
        return this.bP;
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.bO;
    }

    @Nullable
    protected final EntityLiving P() {
        return this.ec().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN);
    }

    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.e() == target) {
            return false;
        }
        if (reason != null) {
            EntityTargetLivingEntityEvent event;
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.e() != null && target == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.e().bJ() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.dV().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (target != null) {
                ctarget = (CraftLivingEntity)target.getBukkitEntity();
            }
            if (!(event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason)).callEvent()) {
                return false;
            }
            target = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.bO = target;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.ae;
    }

    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return false;
    }

    public void Q() {
        ((Entity)this).a(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    public int R() {
        return 80;
    }

    public void S() {
        this.b(this.s());
    }

    @Override
    public void aw() {
        super.aw();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("mobBaseTick");
        if (this.bJ() && this.ae.a(1000) < this.bz++) {
            this.m();
            this.S();
        }
        profilerFiller.c();
    }

    @Override
    protected void h(DamageSource source) {
        this.m();
        super.h(source);
    }

    private void m() {
        this.bz = -this.R();
    }

    @Override
    protected int e(WorldServer level) {
        if (this.bA > 0) {
            int i2 = this.bA;
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                ItemStack itemBySlot;
                if (!equipmentSlot.g() || (itemBySlot = this.a(equipmentSlot)).f() || !(this.bQ.b(equipmentSlot) <= 1.0f)) continue;
                i2 += 1 + this.ae.a(3);
            }
            return i2;
        }
        return this.bA;
    }

    public void T() {
        if (this.dV().C) {
            this.eY();
        } else {
            this.dV().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 20) {
            this.T();
        } else {
            super.b(id);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.dV().C && this.af % 5 == 0) {
            this.U();
        }
    }

    protected void U() {
        boolean flag = !(this.cW() instanceof EntityInsentient);
        boolean flag1 = !(this.dk() instanceof AbstractBoat);
        this.bF.a(PathfinderGoal.Type.a, flag);
        this.bF.a(PathfinderGoal.Type.c, flag && flag1);
        this.bF.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void C(float yBodyRot) {
        this.bN.a();
    }

    @Nullable
    public SoundEffect s() {
        return null;
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        compound.a("CanPickUpLoot", this.fN());
        compound.a("PersistenceRequired", this.bS);
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        if (!this.bQ.equals(DropChances.d)) {
            compound.a("drop_chances", DropChances.e, registryOps, this.bQ);
        }
        this.a(compound, this.bW);
        compound.a("LeftHanded", this.gk());
        this.bU.ifPresent(resourceKey -> compound.a("DeathLootTable", LootTable.a, resourceKey));
        if (this.bV != 0L) {
            compound.a("DeathLootTableSeed", this.bV);
        }
        if (this.gj()) {
            compound.a("NoAI", this.gj());
        }
        compound.a("Bukkit.Aware", this.aware);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        boolean canPickUpLoot = compound.b("CanPickUpLoot", false);
        if (EntityInsentient.isLevelAtLeast(compound, 1) || canPickUpLoot) {
            this.a_(canPickUpLoot);
        }
        boolean persistenceRequired = compound.b("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(compound, 1) || persistenceRequired) {
            this.bS = persistenceRequired;
        }
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        this.bQ = compound.a("drop_chances", DropChances.e, (DynamicOps<NBTBase>)registryOps).orElse(DropChances.d);
        this.c(compound);
        this.u(compound.b("LeftHanded", false));
        this.bU = compound.a("DeathLootTable", LootTable.a);
        this.bV = compound.b("DeathLootTableSeed", 0L);
        this.t(compound.b("NoAI", false));
        this.aware = compound.b("Bukkit.Aware", true);
    }

    @Override
    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        super.b(level, damageSource, playerKill);
        this.bU = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> ea() {
        return this.bU.isPresent() ? this.bU : super.ea();
    }

    @Override
    public long eJ() {
        return this.bV;
    }

    public void G(float amount) {
        this.bi = amount;
    }

    public void H(float amount) {
        this.bh = amount;
    }

    public void I(float amount) {
        this.bg = amount;
    }

    @Override
    public void B(float speed) {
        super.B(speed);
        this.G(speed);
    }

    public void V() {
        this.N().m();
        this.I(0.0f);
        this.H(0.0f);
        this.B(0.0f);
    }

    @Override
    public void d_() {
        super.d_();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("looting");
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.fN() && this.bJ() && !this.bc && serverLevel.O().c(GameRules.d)) {
                BaseBlockPosition pickupReach = this.W();
                for (EntityItem itemEntity : this.dV().a(EntityItem.class, this.cR().c(pickupReach.u(), pickupReach.v(), pickupReach.w()))) {
                    if (itemEntity.dQ() || itemEntity.e().f() || itemEntity.n() || !this.c(serverLevel, itemEntity.e()) || !itemEntity.canMobPickup) continue;
                    this.a(serverLevel, itemEntity);
                }
            }
        }
        profilerFiller.c();
    }

    protected BaseBlockPosition W() {
        return e;
    }

    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        ItemStack itemStack = this.equipItemIfPossible(level, item.v(), entity);
        if (!itemStack.f()) {
            this.a(entity);
            this.a((Entity)entity, itemStack.M());
            item.h(itemStack.M());
            if (item.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer level, ItemStack stack) {
        return this.equipItemIfPossible(level, stack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer level, ItemStack stack, @Nullable EntityItem entity) {
        boolean canPickup;
        EnumItemSlot equipmentSlotForItem = this.f(stack);
        if (!this.a(stack, equipmentSlotForItem)) {
            return ItemStack.l;
        }
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        boolean canReplaceCurrentItem = this.a(stack, itemBySlot, equipmentSlotForItem);
        if (equipmentSlotForItem.f() && !canReplaceCurrentItem) {
            equipmentSlotForItem = EnumItemSlot.a;
            itemBySlot = this.a(equipmentSlotForItem);
            canReplaceCurrentItem = itemBySlot.f();
        }
        boolean bl = canPickup = canReplaceCurrentItem && this.g(stack);
        if (entity != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d2 = this.bQ.b(equipmentSlotForItem);
            if (!itemBySlot.f() && (double)Math.max(this.ae.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            ItemStack itemStack = equipmentSlotForItem.a(stack);
            this.b(equipmentSlotForItem, itemStack);
            return itemStack;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.g(slot);
        this.bS = true;
    }

    public void g(EnumItemSlot slot) {
        this.bQ = this.bQ.a(slot);
    }

    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (currentItem.f()) {
            return true;
        }
        return slot.f() ? this.b(newItem, currentItem, slot) : slot == EnumItemSlot.a && this.c(newItem, currentItem, slot);
    }

    private boolean b(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        double approximateAttributeWith = this.a(newItem, GenericAttributes.a, slot);
        double approximateAttributeWith1 = this.a(currentItem, GenericAttributes.a, slot);
        double approximateAttributeWith2 = this.a(newItem, GenericAttributes.b, slot);
        double approximateAttributeWith3 = this.a(currentItem, GenericAttributes.b, slot);
        if (approximateAttributeWith != approximateAttributeWith1) {
            return approximateAttributeWith > approximateAttributeWith1;
        }
        return approximateAttributeWith2 != approximateAttributeWith3 ? approximateAttributeWith2 > approximateAttributeWith3 : this.b(newItem, currentItem);
    }

    private boolean c(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        double approximateAttributeWith1;
        double approximateAttributeWith;
        TagKey<Item> preferredWeaponType = this.X();
        if (preferredWeaponType != null) {
            if (currentItem.a(preferredWeaponType) && !newItem.a(preferredWeaponType)) {
                return false;
            }
            if (!currentItem.a(preferredWeaponType) && newItem.a(preferredWeaponType)) {
                return true;
            }
        }
        return (approximateAttributeWith = this.a(newItem, GenericAttributes.c, slot)) != (approximateAttributeWith1 = this.a(currentItem, GenericAttributes.c, slot)) ? approximateAttributeWith > approximateAttributeWith1 : this.b(newItem, currentItem);
    }

    private double a(ItemStack item, Holder<AttributeBase> attribute, EnumItemSlot slot) {
        double d2 = this.fa().b(attribute) ? this.i(attribute) : 0.0;
        ItemAttributeModifiers itemAttributeModifiers = item.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemAttributeModifiers.a(d2, slot);
    }

    public boolean b(ItemStack candidate, ItemStack existing) {
        int damageValue1;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = existing.a(DataComponents.l, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = candidate.a(DataComponents.l, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int damageValue = candidate.o();
        return damageValue != (damageValue1 = existing.o()) ? damageValue < damageValue1 : candidate.c(DataComponents.g) && !existing.c(DataComponents.g);
    }

    public boolean g(ItemStack stack) {
        return true;
    }

    public boolean c(WorldServer level, ItemStack stack) {
        return this.g(stack);
    }

    @Nullable
    public TagKey<Item> X() {
        return null;
    }

    public boolean h(double distanceToClosestPlayer) {
        return true;
    }

    public boolean Y() {
        return this.bY();
    }

    protected boolean Z() {
        return false;
    }

    @Override
    public void dH() {
        if (this.dV().an() == EnumDifficulty.a && this.Z()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gd() && !this.Y()) {
            EntityHuman nearestPlayer = this.dV().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (nearestPlayer != null) {
                WorldConfiguration.Entities.Spawning.DespawnRangePair despawnRangePair = this.dV().paperConfig().entities.spawning.despawnRanges.get(this.an().f());
                DespawnRange.Shape shape = this.dV().paperConfig().entities.spawning.despawnRangeShape;
                double dy = Math.abs(nearestPlayer.dC() - this.dC());
                double dySqr = MathHelper.k(dy);
                double dxSqr = MathHelper.k(nearestPlayer.dA() - this.dA());
                double dzSqr = MathHelper.k(nearestPlayer.dG() - this.dG());
                double distanceSquared = dxSqr + dzSqr + dySqr;
                if (despawnRangePair.hard().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy) && this.h(distanceSquared)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                if (despawnRangePair.soft().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy)) {
                    if (this.bd > 600 && this.ae.a(800) == 0 && this.h(distanceSquared)) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    }
                } else {
                    this.bd = 0;
                }
            }
        } else {
            this.bd = 0;
        }
    }

    @Override
    protected final void fu() {
        ++this.bd;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.b()) {
                    this.goalFloat.a();
                }
                this.M().b();
            }
            return;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("sensing");
        this.bP.a();
        profilerFiller.c();
        int i2 = this.af + this.ao();
        if (i2 % 2 != 0 && this.af > 1) {
            profilerFiller.a("targetSelector");
            this.bG.a(false);
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.bF.a(false);
            profilerFiller.c();
        } else {
            profilerFiller.a("targetSelector");
            this.bG.a();
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.bF.a();
            profilerFiller.c();
        }
        profilerFiller.a("navigation");
        this.bE.c();
        profilerFiller.c();
        profilerFiller.a("mob tick");
        this.a((WorldServer)this.dV());
        profilerFiller.c();
        profilerFiller.a("controls");
        profilerFiller.a("move");
        this.bC.a();
        profilerFiller.b("look");
        this.bB.a();
        profilerFiller.b("jump");
        this.bD.b();
        profilerFiller.c();
        profilerFiller.c();
        this.ab();
    }

    protected void ab() {
        PacketDebug.a(this.dV(), this, this.bF);
    }

    protected void a(WorldServer level) {
    }

    public int ac() {
        return 40;
    }

    public int ae() {
        return 75;
    }

    protected void af() {
        float f2 = this.ae();
        float yHeadRot = this.cA();
        float f1 = MathHelper.h(this.aV - yHeadRot);
        float f22 = MathHelper.a(MathHelper.h(this.aV - yHeadRot), -f2, f2);
        float f3 = yHeadRot + f1 - f22;
        this.r(f3);
    }

    public int ag() {
        return 10;
    }

    public void a(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        double d2;
        double d3 = entity.dA() - this.dA();
        double d1 = entity.dG() - this.dG();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            d2 = livingEntity.dE() - this.dE();
        } else {
            d2 = (entity.cR().b + entity.cR().e) / 2.0 - this.dE();
        }
        double squareRoot = Math.sqrt(d3 * d3 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d3) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
        this.x(this.a(this.dN(), f1, maxXRotIncrease));
        this.w(this.a(this.dL(), f2, maxYRotIncrease));
    }

    private float a(float angle, float targetAngle, float maxIncrease) {
        float f2 = MathHelper.h(targetAngle - angle);
        if (f2 > maxIncrease) {
            f2 = maxIncrease;
        }
        if (f2 < -maxIncrease) {
            f2 = -maxIncrease;
        }
        return angle + f2;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos.e();
        return EntitySpawnReason.a(spawnReason) || level.a_(blockPos).a((IBlockAccess)level, blockPos, entityType);
    }

    public boolean a(GeneratorAccess level, EntitySpawnReason spawnReason) {
        return true;
    }

    public boolean a(IWorldReader level) {
        return !level.d(this.cR()) && level.f(this);
    }

    public int fX() {
        return 4;
    }

    public boolean q(int size) {
        return false;
    }

    @Override
    public int cE() {
        if (this.e() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eG() - this.eU() * 0.33f);
        if ((i2 -= (3 - this.dV().an().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack fY() {
        return this.a(EnumItemSlot.g);
    }

    public boolean fZ() {
        return this.d(EnumItemSlot.h);
    }

    public boolean ga() {
        return this.d(EnumItemSlot.g);
    }

    public void h(ItemStack stack) {
        this.b(EnumItemSlot.g, stack);
    }

    public IInventory h(final EnumItemSlot slot) {
        return new ContainerSingleItem(){
            private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();
            private int maxStackSize = 99;

            @Override
            public ItemStack f() {
                return EntityInsentient.this.a(slot);
            }

            @Override
            public void b(ItemStack item) {
                EntityInsentient.this.a(slot, item);
                if (!item.f()) {
                    EntityInsentient.this.g(slot);
                    EntityInsentient.this.gc();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman player) {
                return player.dk() == EntityInsentient.this || player.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public int ak_() {
                return this.maxStackSize;
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.f());
            }

            @Override
            public void onOpen(CraftHumanEntity player) {
                this.viewers.add(player);
            }

            @Override
            public void onClose(CraftHumanEntity player) {
                this.viewers.remove(player);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.viewers;
            }

            @Override
            @Nullable
            public InventoryHolder getOwner() {
                CraftEntity craftEntity = EntityInsentient.this.getBukkitEntity();
                if (craftEntity instanceof InventoryHolder) {
                    InventoryHolder inventoryHolder = (InventoryHolder)craftEntity;
                    return inventoryHolder;
                }
                return null;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStackSize = size;
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (this.shouldSkipLoot(equipmentSlot)) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            float f2 = this.bQ.b(equipmentSlot);
            if (f2 == 0.0f) continue;
            boolean isPreserved = this.bQ.c(equipmentSlot);
            Object object = damageSource.d();
            if (object instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)object;
                object = this.dV();
                if (object instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)object;
                    f2 = EnchantmentManager.a(serverLevel, livingEntity, damageSource, f2);
                }
            }
            if (itemBySlot.f() || EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.D) || !recentlyHit && !isPreserved || !(this.ae.i() < f2)) continue;
            if (!isPreserved && itemBySlot.m()) {
                itemBySlot.b(itemBySlot.p() - this.ae.a(1 + this.ae.a(Math.max(itemBySlot.p() - 3, 1))));
            }
            this.a(level, itemBySlot);
            if (this.clearEquipmentSlots) {
                this.a(equipmentSlot, ItemStack.l);
                continue;
            }
            this.clearedEquipmentSlots.add(equipmentSlot);
        }
    }

    public DropChances gb() {
        return this.bQ;
    }

    public void b(WorldServer level) {
        this.a(level, (ItemStack itemStack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer level, Predicate<ItemStack> filter) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            if (!filter.test(itemBySlot)) {
                set.add(equipmentSlot);
                continue;
            }
            if (!this.bQ.c(equipmentSlot)) continue;
            this.a(equipmentSlot, ItemStack.l);
            this.forceDrops = true;
            this.a(level, itemBySlot);
            this.forceDrops = false;
        }
        return set;
    }

    private LootParams g(WorldServer level) {
        return new LootParams.a(level).a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmentTable) {
        this.a(equipmentTable.a(), equipmentTable.b());
    }

    public void a(ResourceKey<LootTable> equipmentLootTable, Map<EnumItemSlot, Float> slotDropChances) {
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(equipmentLootTable, this.g(serverLevel), slotDropChances);
        }
    }

    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.15f * difficulty.d()) {
            float f2;
            int randomInt = random.a(2);
            float f3 = f2 = this.dV().an() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            if (random.i() < 0.095f) {
                ++randomInt;
            }
            boolean flag = true;
            for (EnumItemSlot equipmentSlot : bH) {
                Item equipmentForSlot;
                ItemStack itemBySlot = this.a(equipmentSlot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemBySlot.f() || (equipmentForSlot = EntityInsentient.a(equipmentSlot, randomInt)) == null) continue;
                this.a(equipmentSlot, new ItemStack(equipmentForSlot));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot slot, int chance) {
        switch (slot) {
            case f: {
                if (chance == 0) {
                    return Items.qm;
                }
                if (chance == 1) {
                    return Items.qC;
                }
                if (chance == 2) {
                    return Items.qq;
                }
                if (chance == 3) {
                    return Items.qu;
                }
                if (chance == 4) {
                    return Items.qy;
                }
            }
            case e: {
                if (chance == 0) {
                    return Items.qn;
                }
                if (chance == 1) {
                    return Items.qD;
                }
                if (chance == 2) {
                    return Items.qr;
                }
                if (chance == 3) {
                    return Items.qv;
                }
                if (chance == 4) {
                    return Items.qz;
                }
            }
            case d: {
                if (chance == 0) {
                    return Items.qo;
                }
                if (chance == 1) {
                    return Items.qE;
                }
                if (chance == 2) {
                    return Items.qs;
                }
                if (chance == 3) {
                    return Items.qw;
                }
                if (chance == 4) {
                    return Items.qA;
                }
            }
            case c: {
                if (chance == 0) {
                    return Items.qp;
                }
                if (chance == 1) {
                    return Items.qF;
                }
                if (chance == 2) {
                    return Items.qt;
                }
                if (chance == 3) {
                    return Items.qx;
                }
                if (chance != 4) break;
                return Items.qB;
            }
        }
        return null;
    }

    protected void a(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.b(level, random, difficulty);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            this.a(level, random, equipmentSlot, difficulty);
        }
    }

    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(level, EnumItemSlot.a, random, 0.25f, difficulty);
    }

    protected void a(WorldAccess level, RandomSource random, EnumItemSlot slot, DifficultyDamageScaler difficulty) {
        this.a(level, slot, random, 0.5f, difficulty);
    }

    private void a(WorldAccess level, EnumItemSlot slot, RandomSource random, float enchantChance, DifficultyDamageScaler difficulty) {
        ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && random.i() < enchantChance * difficulty.d()) {
            EnchantmentManager.a(itemBySlot, level.J_(), VanillaEnchantmentProviders.a, difficulty, random);
            this.a(slot, itemBySlot);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        AttributeModifiable attributeInstance = Objects.requireNonNull(this.g(GenericAttributes.m));
        if (!attributeInstance.b(by)) {
            attributeInstance.d(new AttributeModifier(by, random.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.u(random.i() < 0.05f);
        return spawnGroupData;
    }

    public void gc() {
        this.bS = true;
    }

    @Override
    public void a(EnumItemSlot slot, float chance) {
        this.bQ = this.bQ.a(slot, chance);
    }

    @Override
    public boolean fN() {
        return this.bR;
    }

    public void a_(boolean canPickUpLoot) {
        this.bR = canPickUpLoot;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return this.fN();
    }

    public boolean gd() {
        return this.bS;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.bJ()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult interactionResult = this.c(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        EnumInteractionResult interactionResult1 = super.a(player, hand);
        if (interactionResult1 != EnumInteractionResult.e) {
            return interactionResult1;
        }
        interactionResult = this.b(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.vW) && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        if (itemInHand.h() instanceof ItemMonsterEgg) {
            if (this.dV() instanceof WorldServer) {
                ItemMonsterEgg spawnEggItem = (ItemMonsterEgg)itemInHand.h();
                Optional<EntityInsentient> optional = spawnEggItem.a(player, this, this.an(), (WorldServer)this.dV(), this.dt(), itemInHand);
                optional.ifPresent(mob -> this.a(player, (EntityInsentient)mob));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public boolean ge() {
        return this.a(this.dv());
    }

    public boolean a(BlockPosition pos) {
        return this.bY == -1.0f || this.bX.j(pos) < (double)(this.bY * this.bY);
    }

    public void a(BlockPosition pos, int distance) {
        this.bX = pos;
        this.bY = distance;
    }

    public BlockPosition gf() {
        return this.bX;
    }

    public float gg() {
        return this.bY;
    }

    public void gh() {
        this.bY = -1.0f;
    }

    public boolean gi() {
        return this.bY != -1.0f;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, spawnReason, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, spawnReason, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.CancellingAfterConversion<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        if (this.dQ()) {
            return null;
        }
        EntityInsentient mob = (EntityInsentient)entityType.a(this.dV(), spawnReason);
        if (mob == null) {
            return null;
        }
        conversionParams.a().a(this, mob, conversionParams);
        if (!afterConversion.finalizeConversionOrCancel(mob)) {
            return null;
        }
        if (transformReason == null) {
            return (T)mob;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mob, transformReason).isCancelled()) {
            return null;
        }
        World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.addFreshEntity(mob, creatureSpawnReason);
        }
        if (conversionParams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)mob;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, coversionParams, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.a<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, coversionParams, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entityType, ConversionParams coversionParams, ConversionParams.CancellingAfterConversion<T> afterConversion, @Nullable EntityTransformEvent.TransformReason transformReason, @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return this.convertTo(entityType, coversionParams, EntitySpawnReason.i, afterConversion, transformReason, creatureSpawnReason);
    }

    @Override
    @Nullable
    public Leashable.a S_() {
        return this.bW;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.bW = leashData;
    }

    @Override
    public void z() {
        if (this.S_() == null) {
            this.gh();
        }
    }

    @Override
    public void A() {
        Leashable.super.A();
        this.bF.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean w() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        boolean flag = super.a(entity, force);
        if (flag && this.Q_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag;
            }
            if (event.isDropLeash()) {
                this.x();
            } else {
                this.y();
            }
        }
        return flag;
    }

    @Override
    public boolean di() {
        return super.di() && !this.gj();
    }

    @Override
    public boolean dj() {
        return super.dj() && !this.gj();
    }

    public void t(boolean noAi) {
        byte b2 = this.al.a(a);
        this.al.a(a, noAi ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE));
    }

    public void u(boolean leftHanded) {
        byte b2 = this.al.a(a);
        this.al.a(a, leftHanded ? (byte)(b2 | 2) : (byte)(b2 & 0xFFFFFFFD));
    }

    public void v(boolean aggressive) {
        byte b2 = this.al.a(a);
        this.al.a(a, aggressive ? (byte)(b2 | 4) : (byte)(b2 & 0xFFFFFFFB));
    }

    public boolean gj() {
        return (this.al.a(a) & 1) != 0;
    }

    public boolean gk() {
        return (this.al.a(a) & 2) != 0;
    }

    public boolean gl() {
        return (this.al.a(a) & 4) != 0;
    }

    public void a(boolean baby) {
    }

    @Override
    public EnumMainHand fy() {
        return this.gk() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entity) {
        return this.gm().c(entity.eN());
    }

    protected AxisAlignedBB gm() {
        AxisAlignedBB aabb;
        Entity vehicle = this.dk();
        if (vehicle != null) {
            AxisAlignedBB boundingBox = vehicle.cR();
            AxisAlignedBB boundingBox1 = this.cR();
            aabb = new AxisAlignedBB(Math.min(boundingBox1.a, boundingBox.a), boundingBox1.b, Math.min(boundingBox1.c, boundingBox.c), Math.max(boundingBox1.d, boundingBox.d), boundingBox1.e, Math.max(boundingBox1.f, boundingBox.f));
        } else {
            aabb = this.cR();
        }
        return aabb.c(bI, 0.0, bI);
    }

    @Override
    public boolean c(WorldServer level, Entity source) {
        boolean flag;
        float f2 = (float)this.h(GenericAttributes.c);
        ItemStack weaponItem = this.dZ();
        DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.dW().b(this));
        f2 = EnchantmentManager.a(level, weaponItem, source, damageSource, f2);
        if (flag = source.a(level, damageSource, f2 += weaponItem.h().a(source, f2, damageSource))) {
            EntityLiving livingEntity;
            float knockback = this.b(source, damageSource);
            if (knockback > 0.0f && source instanceof EntityLiving) {
                livingEntity = (EntityLiving)source;
                livingEntity.knockback(knockback * 0.5f, MathHelper.a(this.dL() * ((float)Math.PI / 180)), -MathHelper.b(this.dL() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                this.i(this.dy().d(0.6, 1.0, 0.6));
            }
            if (source instanceof EntityLiving) {
                livingEntity = (EntityLiving)source;
                weaponItem.a(livingEntity, (EntityLiving)this);
            }
            EnchantmentManager.a(level, source, damageSource);
            this.B(source);
            this.gn();
        }
        return flag;
    }

    protected void gn() {
    }

    public boolean go() {
        if (this.dV().V() && !this.dV().C) {
            boolean flag;
            float lightLevelDependentMagicValue = this.bw();
            BlockPosition blockPos = BlockPosition.a(this.dA(), this.dE(), this.dG());
            boolean bl = flag = this.bk() || this.av || this.aw;
            if (lightLevelDependentMagicValue > 0.5f && this.ae.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && !flag && this.dV().h(blockPos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        if (this.N().o()) {
            super.c(fluidTag);
        } else {
            this.i(this.dy().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gp() {
        this.c((PathfinderGoal goal) -> true);
        this.ec().h();
    }

    public void c(Predicate<PathfinderGoal> filter) {
        this.bF.a(filter);
    }

    @Override
    protected void cD() {
        super.cD();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            itemBySlot.e(0);
        }
    }

    @Override
    @Nullable
    public ItemStack dI() {
        ItemMonsterEgg spawnEggItem = ItemMonsterEgg.a(this.an());
        return spawnEggItem == null ? null : new ItemStack(spawnEggItem);
    }

    @Override
    protected void f(Holder<AttributeBase> attribute) {
        super.f(attribute);
        if (attribute.a(GenericAttributes.m) || attribute.a(GenericAttributes.E)) {
            this.N().e();
        }
    }
}

