/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int l = 98;
    public static final int m = 100;
    public static final int n = 105;
    public static final int o = 106;
    public static final int p = 6;
    public static final int q = 100;
    private static final int bu = 40;
    public static final double r = 0.003;
    public static final double s = 0.08;
    public static final int t = 20;
    protected static final float u = 0.98f;
    private static final int bv = 10;
    private static final int bw = 2;
    public static final float ay = 0.42f;
    private static final double bx = 128.0;
    protected static final int az = 1;
    protected static final int aA = 2;
    public static final int aB = 4;
    protected static final DataWatcherObject<Byte> aC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> by = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> bz = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> bA = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> bB = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bC = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> bD = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int bE = 15;
    protected static final EntitySize aD = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float aE = 0.5f;
    public static final float aF = 0.5f;
    public static final String aG = "attributes";
    public static final Predicate<EntityLiving> aH = entity -> {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            ItemStack itemBySlot = player.a(EnumItemSlot.f);
            return !itemBySlot.a(TagsItem.ct);
        }
        return true;
    };
    private final AttributeMapBase bF;
    public CombatTracker bG = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> bH = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> bI = SystemUtils.a(EnumItemSlot.class, (K slot) -> ItemStack.l);
    public boolean aI;
    private boolean bJ = false;
    public EnumHand aJ;
    public int aK;
    public int aL;
    public int aM;
    public int aN;
    public int aO;
    public int aP;
    public float aQ;
    public float aR;
    protected int aS;
    public final WalkAnimationState aT = new WalkAnimationState();
    public int aU = 20;
    public float aV;
    public float aW;
    public float aX;
    public float aY;
    public final ElytraAnimationState aZ = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<EntityHuman> ba;
    public int bb;
    protected boolean bc;
    protected int bd;
    public float be;
    public boolean bf;
    public float bg;
    public float bh;
    public float bi;
    protected InterpolationHandler bj = new InterpolationHandler(this);
    protected double bk;
    protected int bl;
    public boolean bK = true;
    @Nullable
    public EntityReference<EntityLiving> bL;
    public int bM;
    @Nullable
    private EntityLiving bN;
    private int bO;
    private float bP;
    private int bQ;
    private float bR;
    protected ItemStack bm = ItemStack.l;
    public int bn;
    protected int bo;
    private BlockPosition bS;
    private Optional<BlockPosition> bT = Optional.empty();
    @Nullable
    private DamageSource bU;
    private long bV;
    protected int bp;
    protected float bq;
    @Nullable
    protected ItemStack br;
    private float bW;
    private float bX;
    protected BehaviorController<?> bs;
    protected boolean bY;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> bZ = new EnumMap(EnumItemSlot.class);
    protected final EntityEquipment bt;
    public int expToDrop;
    public List<Entity.DefaultDrop> drops = new ArrayList<Entity.DefaultDrop>();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    public int shieldBlockingDelay;
    private boolean isTickingEffects;
    private final List<ProcessableEffect> effectsToProcess;
    protected boolean clearEquipmentSlots;
    protected Set<EnumItemSlot> clearedEquipmentSlots;
    protected long lastJumpTime;
    protected long eatStartTime;
    protected int totalEatTimeTicks;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> entityType, net.minecraft.world.level.World level) {
        super(entityType, level);
        this.shieldBlockingDelay = this.dV().paperConfig().misc.shieldBlockingDelay;
        this.isTickingEffects = false;
        this.effectsToProcess = Lists.newArrayList();
        this.clearEquipmentSlots = true;
        this.clearedEquipmentSlots = new HashSet<EnumItemSlot>();
        this.lastJumpTime = 0L;
        this.bF = new AttributeMapBase(AttributeDefaults.a(entityType));
        this.craftAttributes = new CraftAttributeMap(this.bF);
        this.al.a(by, Float.valueOf(this.eU()));
        this.bt = this.eb();
        this.I = true;
        this.av();
        this.w((float)(Math.random() * 6.2831854820251465));
        this.aX = this.dL();
        DynamicOpsNBT nbtOps = DynamicOpsNBT.a;
        this.bs = this.a(new Dynamic<NBTBase>(nbtOps, (NBTBase)nbtOps.createMap((Map)ImmutableMap.of((Object)nbtOps.a("memories"), (Object)((NBTBase)nbtOps.emptyMap())))));
    }

    @Contract(pure=true)
    protected EntityEquipment eb() {
        return new EntityEquipment();
    }

    public BehaviorController<?> ec() {
        return this.bs;
    }

    protected BehaviorController.b<?> ed() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ed().a(dynamic);
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.dW().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entityType) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(aC, (byte)0);
        builder.a(bz, List.of());
        builder.a(bA, false);
        builder.a(bB, 0);
        builder.a(bC, 0);
        builder.a(by, Float.valueOf(1.0f));
        builder.a(bD, Optional.empty());
    }

    public static AttributeProvider.Builder ee() {
        return AttributeProvider.a().a(GenericAttributes.s).a(GenericAttributes.p).a(GenericAttributes.v).a(GenericAttributes.a).a(GenericAttributes.b).a(GenericAttributes.r).a(GenericAttributes.B).a(GenericAttributes.y).a(GenericAttributes.n).a(GenericAttributes.x).a(GenericAttributes.k).a(GenericAttributes.o).a(GenericAttributes.w).a(GenericAttributes.h).a(GenericAttributes.i).a(GenericAttributes.F).a(GenericAttributes.u).a(GenericAttributes.d);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        net.minecraft.world.level.World world;
        if (!this.bi()) {
            this.bp();
        }
        if ((world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (onGround && this.Z > 0.0) {
                this.b(serverLevel, pos);
                double d2 = Math.max(0, MathHelper.a(this.h(this.Z)));
                if (d2 > 0.0 && !state.l()) {
                    double d1;
                    double x2 = this.dA();
                    double y1 = this.dC();
                    double z2 = this.dG();
                    BlockPosition blockPos = this.dv();
                    if (pos.u() != blockPos.u() || pos.w() != blockPos.w()) {
                        d1 = x2 - (double)pos.u() - 0.5;
                        double d22 = z2 - (double)pos.w() - 0.5;
                        double max = Math.max(Math.abs(d1), Math.abs(d22));
                        x2 = (double)pos.u() + 0.5 + d1 / max * 0.5;
                        z2 = (double)pos.w() + 0.5 + d22 / max * 0.5;
                    }
                    d1 = Math.min((double)0.2f + d2 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d1);
                    if (this instanceof EntityPlayer) {
                        serverLevel.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, state), false, false, x2, y1, z2, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        serverLevel.a(new ParticleParamBlock(Particles.b, state), x2, y1, z2, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(y2, onGround, state, pos);
        if (onGround) {
            this.bT = Optional.empty();
        }
    }

    public final boolean ef() {
        return this.an().a(TagsEntity.m);
    }

    public float a(float partialTicks) {
        return MathHelper.h(partialTicks, this.bX, this.bW);
    }

    public boolean eg() {
        return this.dy().b() < (double)1.0E-5f && this.bl();
    }

    @Override
    public void aw() {
        EntityLiving lastHurtByMob;
        net.minecraft.world.level.World world;
        net.minecraft.world.level.World world2;
        this.aQ = this.aR;
        if (this.ak) {
            this.fP().ifPresent(this::a);
        }
        if ((world2 = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world2;
            EnchantmentManager.b(serverLevel, this);
        }
        super.aw();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("livingEntityBaseTick");
        if (this.bh() || this.dV().C) {
            this.aF();
        }
        if (this.bJ() && (world = this.dV()) instanceof WorldServer) {
            double damagePerBlock;
            double d2;
            WorldServer serverLevel1 = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.bK()) {
                this.a(serverLevel1, this.dW().g(), 1.0f);
            } else if (flag && !serverLevel1.E_().a(this.cR()) && (d2 = serverLevel1.E_().a(this) + serverLevel1.E_().n()) < 0.0 && (damagePerBlock = serverLevel1.E_().o()) > 0.0) {
                this.a(serverLevel1, this.dW().x(), (float)Math.max(1, MathHelper.a(-d2 * damagePerBlock)));
            }
            if (((Entity)this).a(TagsFluid.a) && !serverLevel1.a_(BlockPosition.a(this.dA(), this.dE(), this.dG())).a(Blocks.nJ)) {
                boolean flag1;
                boolean bl = flag1 = !this.ef() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gk().a);
                if (flag1) {
                    this.j(this.l(this.cs()));
                    if (this.cs() == -20) {
                        this.j(0);
                        serverLevel1.a((Entity)this, (byte)67);
                        this.a(serverLevel1, this.dW().i(), 2.0f);
                    }
                } else if (this.cs() < this.cr()) {
                    this.j(this.m(this.cs()));
                }
                if (this.bY() && this.dk() != null && this.dk().ca()) {
                    this.bO();
                }
            } else if (this.cs() < this.cr()) {
                this.j(this.m(this.cs()));
            }
            BlockPosition blockPos = this.dv();
            if (!Objects.equal((Object)this.bS, (Object)blockPos)) {
                this.bS = blockPos;
                this.b(serverLevel1, blockPos);
            }
        }
        if (this.aN > 0) {
            --this.aN;
        }
        if (this.aj > 0 && !(this instanceof EntityPlayer)) {
            --this.aj;
        }
        if (this.eH() && this.dV().h(this)) {
            this.en();
        }
        if (this.bb > 0) {
            --this.bb;
        } else {
            this.ba = null;
        }
        if (this.bN != null && !this.bN.bJ()) {
            this.bN = null;
        }
        if ((lastHurtByMob = this.er()) != null) {
            if (!lastHurtByMob.bJ()) {
                this.a((EntityLiving)null);
            } else if (this.af - this.bM > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.ey();
        this.aY = this.aX;
        this.aW = this.aV;
        this.N = this.dL();
        this.O = this.dN();
        profilerFiller.c();
    }

    @Override
    protected float aS() {
        return MathHelper.h((float)this.h(GenericAttributes.u), super.aS(), 1.0f);
    }

    public float eh() {
        return 0.0f;
    }

    protected void ei() {
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        if (attribute != null && attribute.a(c) != null) {
            attribute.c(c);
        }
    }

    protected void ej() {
        int ticksFrozen;
        if (!this.br().l() && (ticksFrozen = this.cu()) > 0) {
            AttributeModifiable attribute = this.g(GenericAttributes.v);
            if (attribute == null) {
                return;
            }
            float f2 = -0.05f * this.cv();
            attribute.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer level, BlockPosition pos) {
        EnchantmentManager.a(level, this);
    }

    public boolean e_() {
        return false;
    }

    public float ek() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float el() {
        AttributeMapBase attributes = this.fa();
        return attributes == null ? 1.0f : this.b((float)attributes.c(GenericAttributes.y));
    }

    protected float b(float scale) {
        return scale;
    }

    public boolean em() {
        return true;
    }

    protected void en() {
        ++this.aP;
        if (this.aP >= 20 && !this.dV().A_() && !this.dQ()) {
            this.dV().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eo() {
        return !this.e_();
    }

    protected boolean ep() {
        return !this.e_();
    }

    protected int l(int currentAir) {
        AttributeModifiable attribute = this.g(GenericAttributes.w);
        double value = attribute != null ? attribute.g() : 0.0;
        return value > 0.0 && this.ae.j() >= 1.0 / (value + 1.0) ? currentAir : currentAir - 1;
    }

    protected int m(int currentAir) {
        return Math.min(currentAir + 4, this.cr());
    }

    public final int a(WorldServer level, @Nullable Entity killer) {
        return EnchantmentManager.a(level, killer, (Entity)this, this.e(level));
    }

    protected int e(WorldServer level) {
        return 0;
    }

    protected boolean eq() {
        return false;
    }

    @Nullable
    public EntityLiving er() {
        return EntityReference.a(this.bL, this.dV(), EntityLiving.class);
    }

    @Nullable
    public EntityHuman es() {
        return EntityReference.a(this.ba, this.dV(), EntityHuman.class);
    }

    @Override
    public EntityLiving ai() {
        return this.er();
    }

    public int et() {
        return this.bM;
    }

    public void a(EntityHuman player, int memoryTime) {
        this.a(new EntityReference<EntityHuman>(player), memoryTime);
    }

    public void a(UUID uuid, int memoryTime) {
        this.a(new EntityReference<EntityHuman>(uuid), memoryTime);
    }

    private void a(EntityReference<EntityHuman> player, int memoryTime) {
        this.ba = player;
        this.bb = memoryTime;
    }

    public void a(@Nullable EntityLiving livingEntity) {
        this.bL = livingEntity != null ? new EntityReference<EntityLiving>(livingEntity) : null;
        this.bM = this.af;
    }

    @Nullable
    public EntityLiving eu() {
        return this.bN;
    }

    public int ev() {
        return this.bO;
    }

    public void B(Entity entity) {
        this.bN = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.bO = this.af;
    }

    public int ew() {
        return this.bd;
    }

    public void n(int idleTime) {
        this.bd = idleTime;
    }

    public boolean ex() {
        return !this.frictionState.toBooleanOrElse(!this.bJ);
    }

    public void q(boolean discardFriction) {
        this.bJ = discardFriction;
    }

    protected boolean b(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem) {
        this.onEquipItem(slot, oldItem, newItem, false);
    }

    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        if (!(this.dV().A_() || this.ak() || ItemStack.c(oldItem, newItem) || this.ak)) {
            Equippable equippable = newItem.a(DataComponents.D);
            if (!this.ba() && equippable != null && slot == equippable.b() && !silent) {
                this.dV().a(null, this.dA(), this.dC(), this.dG(), this.a(slot, newItem, equippable), this.dm(), 1.0f, 1.0f, this.ae.g());
            }
            if (this.b(slot)) {
                ((Entity)this).a(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        net.minecraft.world.level.World world;
        if ((reason == Entity.RemovalReason.a || reason == Entity.RemovalReason.b) && (world = this.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, reason);
        }
        super.remove(reason, eventCause);
        this.bs.a();
    }

    protected void a(WorldServer level, Entity.RemovalReason removalReason) {
        for (MobEffect mobEffectInstance : this.eD()) {
            mobEffectInstance.a(level, this, removalReason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.bH.clear();
    }

    @Override
    public void b(NBTTagCompound compound) {
        if (this.frictionState != TriState.NOT_SET) {
            compound.a("Paper.FrictionState", this.frictionState.toString());
        }
        compound.a("Health", this.eG());
        compound.a("HurtTime", (short)this.aN);
        compound.a("HurtByTimestamp", this.bM);
        compound.a("DeathTime", (short)this.aP);
        compound.a("AbsorptionAmount", this.fw());
        compound.a(aG, this.fa().d());
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        if (!this.bH.isEmpty()) {
            compound.a(b, MobEffect.d.listOf(), registryOps, List.copyOf(this.bH.values()));
        }
        compound.a("FallFlying", this.fJ());
        this.fP().ifPresent(pos -> compound.a("sleeping_pos", BlockPosition.a, pos));
        DataResult<NBTBase> dataResult = this.bs.a(DynamicOpsNBT.a);
        dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(tag -> compound.a("Brain", (NBTBase)tag));
        if (this.ba != null) {
            this.ba.a(compound, "last_hurt_by_player");
            compound.a("last_hurt_by_player_memory_time", this.bb);
        }
        if (this.bL != null) {
            this.bL.a(compound, "last_hurt_by_mob");
            compound.a("ticks_since_last_hurt_by_mob", this.af - this.bM);
        }
        if (!this.bt.a()) {
            compound.a("equipment", EntityEquipment.a, registryOps, this.bt);
        }
    }

    @Nullable
    public final EntityItem a(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        return this.drop(stack, randomizeMotion, includeThrower, true, null);
    }

    @Nullable
    public EntityItem drop(ItemStack stack, boolean randomizeMotion, boolean includeThrower, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        if (stack.f()) {
            return null;
        }
        if (this.dV().C) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem itemEntity = this.b(stack, randomizeMotion, includeThrower);
        if (itemEntity != null) {
            CraftEntity craftEntity;
            if (entityOperation != null) {
                entityOperation.accept((Item)itemEntity.getBukkitEntity());
            }
            if (callEvent && (craftEntity = this.getBukkitEntity()) instanceof Player) {
                Player player = (Player)craftEntity;
                Item drop = (Item)itemEntity.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack inHandItem = player.getInventory().getItemInMainHand();
                    if (includeThrower && inHandItem.getAmount() == 0) {
                        player.getInventory().setItemInMainHand(drop.getItemStack());
                    } else if (includeThrower && inHandItem.isSimilar(drop.getItemStack()) && inHandItem.getAmount() < inHandItem.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        inHandItem.setAmount(inHandItem.getAmount() + 1);
                        player.getInventory().setItemInMainHand(inHandItem);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.dV().b(itemEntity);
        }
        return itemEntity;
    }

    @Override
    public void a(NBTTagCompound compound) {
        float absorptionAmount = compound.b("AbsorptionAmount", 0.0f);
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.F(absorptionAmount);
        compound.i("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                a.error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.dV() != null && !this.dV().C) {
            compound.o(aG).ifPresent(this.fa()::a);
        }
        RegistryOps<NBTBase> registryOps = this.dX().a(DynamicOpsNBT.a);
        List list = compound.a(b, MobEffect.d.listOf(), (DynamicOps<NBTBase>)registryOps).orElse(List.of());
        this.bH.clear();
        for (MobEffect mobEffectInstance : list) {
            this.bH.put(mobEffectInstance.c(), mobEffectInstance);
        }
        compound.h("Bukkit.MaxHealth").ifPresent(maxHealth -> this.g(GenericAttributes.s).a((double)maxHealth));
        this.d(compound.b("Health", this.eU()));
        this.aN = compound.b("HurtTime", (short)0);
        this.aP = compound.b("DeathTime", (short)0);
        this.bM = compound.b("HurtByTimestamp", 0);
        compound.i("Team").ifPresent(string -> {
            boolean flag;
            Scoreboard scoreboard = this.dV().R();
            ScoreboardTeam playerTeam = scoreboard.b((String)string);
            if (!this.dV().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                playerTeam = null;
            }
            boolean bl = flag = playerTeam != null && scoreboard.a(this.cH(), playerTeam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", string);
            }
        });
        this.b(7, compound.b("FallFlying", false));
        compound.a("sleeping_pos", BlockPosition.a).ifPresentOrElse(blockPos -> {
            if (this.dt().c(blockPos.u(), blockPos.v(), blockPos.w()) < (double)MathHelper.h(16)) {
                this.g((BlockPosition)blockPos);
                this.al.a(Entity.aq, EntityPose.c);
                if (!this.ak) {
                    this.a((BlockPosition)blockPos);
                }
            }
        }, this::fQ);
        compound.m("Brain").ifPresent(compoundTag -> {
            this.bs = this.a(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, (NBTTagCompound)compoundTag));
        });
        this.ba = EntityReference.b(compound, "last_hurt_by_player");
        this.bb = compound.b("last_hurt_by_player_memory_time", 0);
        this.bL = EntityReference.b(compound, "last_hurt_by_mob");
        this.bM = compound.b("ticks_since_last_hurt_by_mob", 0) + this.af;
        this.bt.a(compound.a("equipment", EntityEquipment.a, (DynamicOps<NBTBase>)registryOps).orElseGet(EntityEquipment::new));
    }

    protected void ey() {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Iterator<Object> iterator = this.bH.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder holder = (Holder)iterator.next();
                    MobEffect mobEffectInstance = this.bH.get(holder);
                    if (!mobEffectInstance.a(serverLevel, this, () -> this.a(mobEffectInstance, true, null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobEffectInstance));
                        continue;
                    }
                    if (mobEffectInstance.d() % 600 != 0) continue;
                    this.a(mobEffectInstance, false, null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect effect : this.effectsToProcess) {
                if (effect.effect != null) {
                    this.addEffect(effect.effect, effect.cause);
                    continue;
                }
                this.removeEffect(effect.type, effect.cause);
            }
            this.effectsToProcess.clear();
            if (this.bK) {
                this.J();
                this.s();
                this.bK = false;
            }
        } else {
            for (MobEffect mobEffectInstance1 : this.bH.values()) {
                mobEffectInstance1.i();
            }
            List<ParticleParam> list = this.al.a(bz);
            if (!list.isEmpty()) {
                int i1;
                boolean flag = this.al.a(bA);
                int i2 = this.co() ? 15 : 4;
                int n2 = i1 = flag ? 5 : 1;
                if (this.ae.a(i2 * i1) == 0) {
                    this.dV().a(SystemUtils.a(list, this.ae), this.d(0.5), this.dD(), this.g(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void J() {
        if (this.bH.isEmpty()) {
            this.eB();
            this.k(false);
        } else {
            this.k(this.b(MobEffects.n));
            this.m();
        }
    }

    private void m() {
        List<ParticleParam> list = this.bH.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.al.a(bz, list);
        this.al.a(bA, EntityLiving.d(this.bH.values()));
    }

    private void s() {
        boolean isCurrentlyGlowing = this.cn();
        if (this.i(6) != isCurrentlyGlowing) {
            this.b(6, isCurrentlyGlowing);
        }
    }

    public double C(@Nullable Entity lookingEntity) {
        double d2 = 1.0;
        if (this.cf()) {
            d2 *= 0.8;
        }
        if (this.co()) {
            float armorCoverPercentage = this.fd();
            if (armorCoverPercentage < 0.1f) {
                armorCoverPercentage = 0.1f;
            }
            d2 *= 0.7 * (double)armorCoverPercentage;
        }
        if (lookingEntity != null) {
            ItemStack itemBySlot = this.a(EnumItemSlot.f);
            EntityTypes<?> type = lookingEntity.an();
            if (type == EntityTypes.bg && itemBySlot.a(Items.vv) || type == EntityTypes.bP && itemBySlot.a(Items.vy) || type == EntityTypes.aS && itemBySlot.a(Items.vB) || type == EntityTypes.aT && itemBySlot.a(Items.vB) || type == EntityTypes.F && itemBySlot.a(Items.vz)) {
                d2 *= 0.5;
            }
        }
        return d2;
    }

    public boolean c(EntityLiving target) {
        return (!(target instanceof EntityHuman) || this.dV().an() != EnumDifficulty.a) && target.ez();
    }

    public boolean ez() {
        return !this.cC() && this.eA();
    }

    public boolean eA() {
        return !this.ak() && this.bJ();
    }

    public static boolean d(Collection<MobEffect> potionEffects) {
        for (MobEffect mobEffectInstance : potionEffects) {
            if (!mobEffectInstance.g() || mobEffectInstance.f()) continue;
            return false;
        }
        return true;
    }

    protected void eB() {
        this.al.a(bz, List.of());
    }

    public boolean eC() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.dV().C) {
            return false;
        }
        if (this.bH.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.bH.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eD() {
        return this.bH.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eE() {
        return this.bH;
    }

    public boolean b(Holder<MobEffectList> effect) {
        return this.bH.containsKey(effect);
    }

    @Nullable
    public MobEffect c(Holder<MobEffectList> effect) {
        return this.bH.get(effect);
    }

    public float a(Holder<MobEffectList> effect, float partialTick) {
        MobEffect effect1 = this.c(effect);
        return effect1 != null ? effect1.a(this, partialTick) : 0.0f;
    }

    public final boolean a(MobEffect effectInstance) {
        return this.b(effectInstance, (Entity)null);
    }

    public boolean addEffect(MobEffect effectInstance, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, null, cause);
    }

    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return this.addEffect(effectInstance, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, entity, cause, true);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effectInstance, cause));
            return true;
        }
        if (!this.b(effectInstance)) {
            return false;
        }
        MobEffect mobEffectInstance = this.bH.get(effectInstance.c());
        boolean flag = false;
        boolean override = false;
        if (mobEffectInstance != null) {
            override = new MobEffect(mobEffectInstance).b(effectInstance);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, effectInstance, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobEffectInstance == null) {
            this.bH.put(effectInstance.c(), effectInstance);
            this.a(effectInstance, entity);
            flag = true;
            effectInstance.b(this);
        } else if (override) {
            mobEffectInstance.b(effectInstance);
            this.a(mobEffectInstance, true, entity);
            flag = true;
        }
        effectInstance.a(this);
        return flag;
    }

    public boolean b(MobEffect effectInstance) {
        if (this.an().a(TagsEntity.G)) {
            return !effectInstance.a(MobEffects.M);
        }
        return this.an().a(TagsEntity.F) ? !effectInstance.a(MobEffects.L) : !this.an().a(TagsEntity.w) || !effectInstance.a(MobEffects.j) && !effectInstance.a(MobEffects.s);
    }

    public void c(MobEffect instance, @Nullable Entity entity) {
        if (this.b(instance)) {
            MobEffect mobEffectInstance = this.bH.put(instance.c(), instance);
            if (mobEffectInstance == null) {
                this.a(instance, entity);
            } else {
                instance.d(mobEffectInstance);
                this.a(instance, true, entity);
            }
        }
    }

    public boolean eF() {
        return this.an().a(TagsEntity.x);
    }

    @Nullable
    public final MobEffect d(Holder<MobEffectList> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effect, cause));
            return null;
        }
        MobEffect effectInstance = this.bH.get(effect);
        if (effectInstance == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effectInstance, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.bH.remove(effect);
    }

    public boolean e(Holder<MobEffectList> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobEffectInstance = this.removeEffectNoUpdate(effect, cause);
        if (mobEffectInstance != null) {
            this.c(List.of(mobEffectInstance));
            return true;
        }
        return false;
    }

    protected void a(MobEffect effectInstance, @Nullable Entity entity) {
        if (!this.dV().C) {
            this.bK = true;
            effectInstance.c().a().a(this.fa(), effectInstance.e());
            this.c(effectInstance);
        }
    }

    public void c(MobEffect effectInstance) {
        for (Entity entity : this.cY()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.f.b(new PacketPlayOutEntityEffect(this.ao(), effectInstance, false));
        }
    }

    protected void a(MobEffect effectInstance, boolean forced, @Nullable Entity entity) {
        if (!this.dV().C) {
            this.bK = true;
            if (forced) {
                MobEffectList mobEffect = effectInstance.c().a();
                mobEffect.a(this.fa());
                mobEffect.a(this.fa(), effectInstance.e());
                this.C();
            }
            this.c(effectInstance);
        }
    }

    protected void c(Collection<MobEffect> effects) {
        if (!this.dV().C) {
            this.bK = true;
            for (MobEffect mobEffectInstance : effects) {
                mobEffectInstance.c().a().a(this.fa());
                for (Entity entity : this.cY()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.f.b(new PacketPlayOutRemoveEntityEffect(this.ao(), mobEffectInstance.c()));
                }
            }
            this.C();
        }
    }

    private void C() {
        Set<AttributeModifiable> attributesToUpdate = this.fa().b();
        for (AttributeModifiable attributeInstance : attributesToUpdate) {
            this.f(attributeInstance.a());
        }
        attributesToUpdate.clear();
    }

    protected void f(Holder<AttributeBase> attribute) {
        if (attribute.a(GenericAttributes.s)) {
            float maxHealth = this.eU();
            if (this.eG() > maxHealth) {
                this.d(maxHealth);
            }
        } else if (attribute.a(GenericAttributes.r)) {
            float maxHealth = this.eV();
            if (this.fw() > maxHealth) {
                this.E(maxHealth);
            }
        } else if (attribute.a(GenericAttributes.y)) {
            this.h_();
        }
    }

    public void c(float healAmount) {
        this.heal(healAmount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(healAmount, regainReason, false);
    }

    public void heal(float healAmount, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float health = this.eG();
        if (health > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)healAmount, regainReason, isFastRegen);
            if (this.valid) {
                this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.d((float)((double)this.eG() + event.getAmount()));
            }
        }
    }

    public float eG() {
        EntityLiving entityLiving = this;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
            return (float)serverPlayer.getBukkitEntity().getHealth();
        }
        return this.al.a(by).floatValue();
    }

    public void d(float health) {
        if (Float.isNaN(health)) {
            health = this.eU();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.cI() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.al.a(by, Float.valueOf(MathHelper.a(health, 0.0f, this.eU())));
    }

    public boolean eH() {
        return this.eG() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag2;
        boolean flag;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.dQ() || this.bc || this.eG() <= 0.0f) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.i) && this.b(MobEffects.l)) {
            return false;
        }
        if (this.fR()) {
            this.fS();
        }
        this.bd = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        float originalAmount = amount;
        float f1 = this.applyItemBlocking(level, damageSource, amount, true);
        boolean bl = flag = f1 > 0.0f;
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.aj > (float)this.aU / 2.0f && !damageSource.a(DamageTypeTags.e)) {
            if (amount <= this.be) {
                return false;
            }
            event = this.handleEntityDamage(damageSource, amount, this.be);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.be = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(damageSource, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originalAmount == 0.0f) {
                return false;
            }
            this.be = amount;
            this.aj = this.aU;
            this.aN = this.aO = 10;
        }
        this.f(damageSource);
        this.g(damageSource);
        if (flag1) {
            BlocksAttacks blocksAttacks = this.fB().a(DataComponents.I);
            if (flag && blocksAttacks != null) {
                blocksAttacks.a(level, this);
            } else {
                level.a((Entity)this, damageSource);
            }
            if (!damageSource.a(DamageTypeTags.r) && !flag) {
                this.bB();
            }
            if (!damageSource.a(DamageTypeTags.z)) {
                double d2 = 0.0;
                double d1 = 0.0;
                Entity entity2 = damageSource.c();
                if (entity2 instanceof IProjectile) {
                    IProjectile projectile = (IProjectile)entity2;
                    DoubleDoubleImmutablePair doubleDoubleImmutablePair = projectile.a_(this, damageSource);
                    d2 = -doubleDoubleImmutablePair.leftDouble();
                    d1 = -doubleDoubleImmutablePair.rightDouble();
                } else if (damageSource.i() != null) {
                    d2 = damageSource.i().a() - this.dA();
                    d1 = damageSource.i().c() - this.dG();
                }
                if (Math.abs(d2) > 200.0) {
                    d2 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d2, d1, damageSource.c(), damageSource.c() == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d2, d1);
                }
            }
        }
        if (this.eH()) {
            if (!this.j(damageSource)) {
                this.silentDeath = !flag1;
                this.a(damageSource);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.h(damageSource);
            this.i(damageSource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.bU = damageSource;
            this.bV = this.dV().ae();
            for (MobEffect mobEffectInstance : this.eD()) {
                mobEffectInstance.a(level, this, damageSource, amount);
            }
        }
        if ((entity = this) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            CriterionTriggers.i.a(serverPlayer, damageSource, amount, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                serverPlayer.a(StatisticList.K, Math.round(f1 * 10.0f));
            }
        }
        if ((entity = damageSource.d()) instanceof EntityPlayer) {
            EntityPlayer serverPlayerx = (EntityPlayer)entity;
            CriterionTriggers.h.a(serverPlayerx, this, damageSource, amount, amount, flag);
        }
        return flag2;
    }

    public float b(WorldServer level, DamageSource damageSource, float damageAmount) {
        return this.applyItemBlocking(level, damageSource, damageAmount, false);
    }

    public float applyItemBlocking(WorldServer level, DamageSource damageSource, float damageAmount, boolean dryRun) {
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemBlockingWith = this.fH();
        if (itemBlockingWith == null) {
            return 0.0f;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                double acos;
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                if (entity instanceof EntityArrow && (abstractArrow = (EntityArrow)entity).t() > 0) {
                    return 0.0f;
                }
                Vec3D sourcePosition = damageSource.i();
                if (sourcePosition != null) {
                    Vec3D vec3 = this.d(0.0f, this.cA());
                    Vec3D vec31 = sourcePosition.d(this.dt());
                    vec31 = new Vec3D(vec31.d, 0.0, vec31.f).d();
                    acos = Math.acos(vec31.b(vec3));
                } else {
                    acos = 3.1415927410125732;
                }
                float f2 = blocksAttacks.a(damageSource, damageAmount, acos);
                if (!dryRun) {
                    EntityLiving livingEntity;
                    Entity entity2;
                    blocksAttacks.a(this.dV(), itemBlockingWith, this, this.fA(), f2);
                    if (!damageSource.a(DamageTypeTags.j) && (entity2 = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity2).g(this) <= MathHelper.k(200.0)) {
                        this.b(level, livingEntity);
                    }
                }
                return f2;
            }
        }
        return 0.0f;
    }

    public boolean canBlockAttack(DamageSource damageSource, float damageAmount) {
        if (damageAmount <= 0.0f) {
            return false;
        }
        ItemStack itemBlockingWith = this.fH();
        if (itemBlockingWith == null) {
            return false;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                return !(entity instanceof EntityArrow) || (abstractArrow = (EntityArrow)entity).t() <= 0;
            }
        }
        return false;
    }

    public float resolveBlockedDamage(DamageSource damageSource, float damageAmount) {
        double acos;
        Vec3D sourcePosition = damageSource.i();
        if (sourcePosition != null) {
            Vec3D vec3 = this.d(0.0f, this.cA());
            Vec3D vec31 = sourcePosition.d(this.dt());
            vec31 = new Vec3D(vec31.d, 0.0, vec31.f).d();
            acos = Math.acos(vec31.b(vec3));
        } else {
            acos = 3.1415927410125732;
        }
        BlocksAttacks blocksAttacks = this.fH().a(DataComponents.I);
        return blocksAttacks.a(damageSource, damageAmount, acos);
    }

    public void blockingItemEffects(WorldServer level, DamageSource damageSource, float f2) {
        EntityLiving livingEntity;
        Entity entity;
        ItemStack itemBlockingWith = this.fH();
        if (itemBlockingWith == null) {
            return;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.I);
        if (blocksAttacks == null) {
            return;
        }
        blocksAttacks.a(this.dV(), itemBlockingWith, this, this.fA(), f2);
        if (!damageSource.a(DamageTypeTags.j) && (entity = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity).g(this) <= MathHelper.k(200.0)) {
            this.b(level, livingEntity);
        }
    }

    public void i(DamageSource damageSource) {
        if (damageSource.a(DamageTypes.P)) {
            SoundCategory soundSource = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.dV().a(null, this.dt().d, this.dt().e, this.dt().f, SoundEffects.AB, soundSource);
        }
    }

    protected void f(DamageSource damageSource) {
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (!(damageSource.a(DamageTypeTags.q) || damageSource.a(DamageTypes.I) && this.an().a(TagsEntity.E))) {
                this.a(livingEntity);
            }
        }
    }

    @Nullable
    protected EntityHuman g(DamageSource damageSource) {
        EntityWolf wolf;
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            this.a(player, 100);
        } else if (entity instanceof EntityWolf && (wolf = (EntityWolf)entity).m()) {
            if (wolf.d() != null) {
                this.a(wolf.d().c(), 100);
            } else {
                this.ba = null;
                this.bb = 0;
            }
        }
        return EntityReference.a(this.ba, this.dV(), EntityHuman.class);
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void b(WorldServer level, EntityLiving entity) {
        entity.d(this);
    }

    protected void d(EntityLiving entity) {
        entity.knockback(0.5, entity.dA() - this.dA(), entity.dG() - this.dG(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damageSource) {
        if (damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemStack = null;
        DeathProtection deathProtection = null;
        EnumHand hand = null;
        ItemStack itemInHand = ItemStack.l;
        for (EnumHand interactionHand : EnumHand.values()) {
            itemInHand = this.b(interactionHand);
            deathProtection = itemInHand.a(DataComponents.H);
            if (deathProtection == null) continue;
            hand = interactionHand;
            itemStack = itemInHand.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemStack == null);
        this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            deathProtection = null;
        } else {
            EntityLiving entityLiving;
            if (!itemInHand.f() && itemStack != null) {
                itemInHand.h(1);
            }
            if (deathProtection == null) {
                deathProtection = DeathProtection.c;
            }
            if (itemStack != null && (entityLiving = this) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                serverPlayer.b(StatisticList.c.b(itemStack.h()));
                CriterionTriggers.C.a(serverPlayer, itemStack);
                ((Entity)this).a(GameEvent.C);
            }
            this.d(1.0f);
            deathProtection.a(itemStack, this);
            this.dV().a((Entity)this, (byte)35);
        }
        return deathProtection != null;
    }

    @Nullable
    public DamageSource eI() {
        if (this.dV().ae() - this.bV > 40L) {
            this.bU = null;
        }
        return this.bU;
    }

    protected void h(DamageSource source) {
        this.b(this.e(source));
    }

    public void b(@Nullable SoundEffect sound) {
        if (sound != null) {
            this.a(sound, this.fe(), this.ff());
        }
    }

    private void g(ItemStack stack) {
        if (!stack.f()) {
            Holder<SoundEffect> holder = stack.a(DataComponents.au);
            if (holder != null && !this.ba()) {
                this.dV().a(this.dA(), this.dC(), this.dG(), holder.a(), this.dm(), 0.8f, 0.8f + this.dV().A.i() * 0.4f, false);
            }
            this.b(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.dQ() && !this.bc) {
            Entity entity = damageSource.d();
            EntityLiving killCredit = this.eT();
            this.bc = true;
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                EntityDeathEvent deathEvent = this.dropAllDeathLoot(serverLevel, damageSource);
                if (deathEvent == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.l);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.fR()) {
                        this.fS();
                    }
                    if (!this.dV().C && this.g_() && SpigotConfig.logNamedDeaths) {
                        a.info("Named entity {} died: {}", (Object)this, (Object)this.eS().a().getString());
                    }
                    this.eS().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.dV(), this);
                    }
                    ((Entity)this).a(GameEvent.p);
                } else {
                    this.bc = false;
                    this.d((float)deathEvent.getReviveHealth());
                }
                this.e(killCredit);
            }
            if (this.bc) {
                this.dV().a((Entity)this, (byte)3);
                this.b(EntityPose.h);
            }
        }
    }

    protected void e(@Nullable EntityLiving entitySource) {
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            boolean var6 = false;
            if (this.bc && entitySource instanceof EntityWither) {
                if (serverLevel.O().c(GameRules.d)) {
                    BlockPosition blockPos = this.dv();
                    IBlockData blockState = Blocks.cn.m();
                    if (this.dV().a_(blockPos).l() && blockState.a((IWorldReader)this.dV(), blockPos)) {
                        var6 = CraftEventFactory.handleBlockFormEvent(this.dV(), blockPos, blockState, 3, this);
                    }
                }
                if (!var6) {
                    EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), this.dC(), this.dG(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    if (!event.callEvent()) {
                        return;
                    }
                    this.dV().b(itemEntity);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        boolean flag = this.bb > 0;
        this.f(level);
        if (this.ep() && level.O().c(GameRules.g)) {
            this.b(level, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(level, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            EntityLiving killer = this.eT();
            if (killer != null) {
                killer.a((Entity)this, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList<Entity.DefaultDrop>();
        this.b(level, damageSource.d());
        return deathEvent;
    }

    protected void f(WorldServer level) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(WorldServer level, @Nullable Entity entity) {
        if (!this.eL() && (this.eq() || this.bb > 0 && this.eo() && level.O().c(GameRules.g))) {
            return this.a(level, entity);
        }
        return 0;
    }

    protected void b(WorldServer level, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.award(level, this.dt(), this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, entity, this);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
    }

    public long eJ() {
        return 0L;
    }

    protected float b(Entity attacker, DamageSource damageSource) {
        float f2;
        float f3 = (float)this.h(GenericAttributes.d);
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.dZ(), attacker, damageSource, f3);
        } else {
            f2 = f3;
        }
        return f2;
    }

    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        Optional<ResourceKey<LootTable>> lootTable = this.ea();
        if (!lootTable.isEmpty()) {
            LootTable lootTable1 = level.p().bc().b(lootTable.get());
            LootParams.a builder = new LootParams.a(level).a(LootContextParameters.a, this).a(LootContextParameters.f, this.dt()).a(LootContextParameters.c, damageSource).b(LootContextParameters.d, damageSource.d()).b(LootContextParameters.e, damageSource.c());
            EntityHuman lastHurtByPlayer = this.es();
            if (playerKill && lastHurtByPlayer != null) {
                builder = builder.a(LootContextParameters.b, lastHurtByPlayer).a(lastHurtByPlayer.eh());
            }
            LootParams lootParams = builder.a(LootContextParameterSets.g);
            lootTable1.a(lootParams, this.eJ(), (ItemStack itemStack) -> this.a(level, (ItemStack)itemStack));
        }
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), dropConsumer);
    }

    protected void a(WorldServer level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.f, this.dt()).a(LootContextParameters.a, this).a(LootContextParameters.i, shears).a(LootContextParameterSets.s), dropConsumer);
    }

    protected boolean a(WorldServer level, ResourceKey<LootTable> lootTable, Function<LootParams.a, LootParams> paramsBuilder, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.p().bc().b(lootTable);
        ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams = paramsBuilder.apply(new LootParams.a(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public void p(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause eventCause) {
        strength *= 1.0 - this.h(GenericAttributes.p);
        Vec3D deltaMovement = this.dy();
        while (x2 * x2 + z2 * z2 < (double)1.0E-5f) {
            x2 = (Math.random() - Math.random()) * 0.01;
            z2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3D vec3 = new Vec3D(x2, 0.0, z2).d().c(strength);
        Vec3D finalVelocity = new Vec3D(deltaMovement.d / 2.0 - vec3.d, this.aH() ? Math.min(0.4, deltaMovement.e / 2.0 + strength) : deltaMovement.e, deltaMovement.f / 2.0 - vec3.f);
        Vec3D diff = finalVelocity.d(deltaMovement);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, eventCause, strength, diff);
        if (event.isCancelled()) {
            return;
        }
        this.ar = true;
        this.i(deltaMovement.b(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void a(double xDistance, double zDistance) {
    }

    @Nullable
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.kK;
    }

    @Nullable
    public SoundEffect j_() {
        return SoundEffects.kF;
    }

    public SoundEffect q(int height) {
        return height > 4 ? this.eO().b() : this.eO().a();
    }

    public void eK() {
        this.bY = true;
    }

    public boolean eL() {
        return this.bY;
    }

    public float eM() {
        return 0.0f;
    }

    protected AxisAlignedBB eN() {
        AxisAlignedBB boundingBox = this.cR();
        Entity vehicle = this.dk();
        if (vehicle != null) {
            Vec3D passengerRidingPosition = vehicle.m(this);
            return boundingBox.b(Math.max(passengerRidingPosition.e, boundingBox.b));
        }
        return boundingBox;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot slot) {
        return (Map)this.bZ.computeIfAbsent(slot, equipmentSlot -> new Reference2ObjectArrayMap());
    }

    public a eO() {
        return new a(SoundEffects.kL, SoundEffects.kD);
    }

    public Optional<BlockPosition> eP() {
        return this.bT;
    }

    public boolean k_() {
        if (this.ak()) {
            return false;
        }
        BlockPosition blockPos = this.dv();
        IBlockData inBlockState = this.dw();
        if (inBlockState.a(TagsBlock.aS)) {
            this.bT = Optional.of(blockPos);
            return true;
        }
        if (inBlockState.b() instanceof BlockTrapdoor && this.c(blockPos, inBlockState)) {
            this.bT = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        if (!state.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData blockState = this.dV().a_(pos.e());
        return blockState.a(Blocks.da) && blockState.c(BlockLadder.b) == state.c(BlockFacingHorizontal.e);
    }

    @Override
    public boolean bJ() {
        return !this.dQ() && this.eG() > 0.0f && !this.bc;
    }

    public boolean a(EntityLiving entity, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3D vec3 = entity.h(1.0f).d();
        for (double d2 : yValues) {
            Vec3D vec31 = new Vec3D(this.dA() - entity.dA(), d2 - entity.dE(), this.dG() - entity.dG());
            double len = vec31.g();
            vec31 = vec31.d();
            double d1 = vec3.b(vec31);
            double d3 = scaleByDistance ? len : 1.0;
            if (!(d1 > 1.0 - tolerance / d3) || !entity.a(this, visual ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cE() {
        return this.y(0.0f);
    }

    protected final int y(float health) {
        return MathHelper.d(health + 3.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.a(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.dV(), damageSource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.eQ();
            return true;
        }
        return flag;
    }

    protected int a(double fallDistance, float damageMultiplier) {
        if (this.an().a(TagsEntity.o)) {
            return 0;
        }
        double d2 = this.h(fallDistance);
        return MathHelper.a(d2 * (double)damageMultiplier * this.h(GenericAttributes.k));
    }

    private double h(double fallDistance) {
        return fallDistance + 1.0E-6 - this.h(GenericAttributes.x);
    }

    protected void eQ() {
        if (!this.ba()) {
            int floor = MathHelper.a(this.dA());
            int floor1 = MathHelper.a(this.dC() - (double)0.2f);
            int floor2 = MathHelper.a(this.dG());
            IBlockData blockState = this.dV().a_(new BlockPosition(floor, floor1, floor2));
            if (!blockState.l()) {
                SoundEffectType soundType = blockState.A();
                this.a(soundType.g(), soundType.a() * 0.5f, soundType.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float yaw) {
        this.aN = this.aO = 10;
    }

    public int eR() {
        return MathHelper.a(this.h(GenericAttributes.a));
    }

    protected void c(DamageSource damageSource, float damageAmount) {
    }

    protected void d(DamageSource damageSource, float damageAmount) {
    }

    protected void a(DamageSource damageSource, float damageAmount, EnumItemSlot ... slots) {
        if (!(damageAmount <= 0.0f)) {
            int i2 = (int)Math.max(1.0f, damageAmount / 4.0f);
            for (EnumItemSlot equipmentSlot : slots) {
                ItemStack itemBySlot = this.a(equipmentSlot);
                Equippable equippable = itemBySlot.a(DataComponents.D);
                if (equippable == null || !equippable.i() || !itemBySlot.m() || !itemBySlot.a(damageSource)) continue;
                itemBySlot.a(i2, this, equipmentSlot);
            }
        }
    }

    protected float e(DamageSource damageSource, float damageAmount) {
        if (!damageSource.a(DamageTypeTags.b)) {
            damageAmount = CombatMath.a(this, damageAmount, damageSource, this.eR(), (float)this.h(GenericAttributes.b));
        }
        return damageAmount;
    }

    protected float f(DamageSource damageSource, float damageAmount) {
        float damageProtection;
        if (damageSource.a(DamageTypeTags.f)) {
            return damageAmount;
        }
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.a(DamageTypeTags.h)) {
            return damageAmount;
        }
        net.minecraft.world.level.World world = this.dV();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            damageProtection = EnchantmentManager.b(serverLevel, this, damageSource);
        } else {
            damageProtection = 0.0f;
        }
        if (damageProtection > 0.0f) {
            damageAmount = CombatMath.a(damageAmount, damageProtection);
        }
        return damageAmount;
    }

    private EntityDamageEvent handleEntityDamage(DamageSource damagesource, float amount, float invulnerabilityRelatedLastDamage) {
        float originalDamage = amount;
        com.google.common.base.Function invulnerabilityReductionEquation = mod -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (mod.floatValue() < invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)amount)).floatValue();
        com.google.common.base.Function freezing = mod -> {
            if (damagesource.a(DamageTypeTags.o) && this.an().a(TagsEntity.l)) {
                return -(mod - mod * 5.0);
            }
            return -0.0;
        };
        float freezingModifier = ((Double)freezing.apply((Object)(amount += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function hardHat = mod -> {
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                return -(mod - mod * 0.75);
            }
            return -0.0;
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(amount += freezingModifier))).floatValue();
        com.google.common.base.Function blocking = mod -> {
            if (!this.canBlockAttack(damagesource, mod.floatValue())) {
                return 0.0;
            }
            return -this.resolveBlockedDamage(damagesource, mod.floatValue());
        };
        float blockingModifier = ((Double)blocking.apply((Object)(amount += hardHatModifier))).floatValue();
        com.google.common.base.Function armor = mod -> -(mod - (double)this.e(damagesource, mod.floatValue()));
        float armorModifier = ((Double)armor.apply((Object)(amount += blockingModifier))).floatValue();
        com.google.common.base.Function resistance = mod -> {
            if (!damagesource.a(DamageTypeTags.f) && this.b(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                int i2 = (this.c(MobEffects.k).e() + 1) * 5;
                int j2 = 25 - i2;
                float f1 = mod.floatValue() * (float)j2;
                return -(mod - (double)Math.max(f1 / 25.0f, 0.0f));
            }
            return -0.0;
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(amount += armorModifier))).floatValue();
        com.google.common.base.Function magic = mod -> -(mod - (double)this.f(damagesource, mod.floatValue()));
        float magicModifier = ((Double)magic.apply((Object)(amount += resistanceModifier))).floatValue();
        com.google.common.base.Function absorption = mod -> -Math.max(mod - Math.max(mod - (double)this.fw(), 0.0), 0.0);
        float absorptionModifier = ((Double)absorption.apply((Object)(amount += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, (com.google.common.base.Function<Double, Double>)freezing, (com.google.common.base.Function<Double, Double>)hardHat, (com.google.common.base.Function<Double, Double>)blocking, (com.google.common.base.Function<Double, Double>)armor, (com.google.common.base.Function<Double, Double>)resistance, (com.google.common.base.Function<Double, Double>)magic, (com.google.common.base.Function<Double, Double>)absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.a(level, damageSource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damageSource.d() instanceof EntityHuman) {
                if (damageSource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damageSource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.H(0.0f)).callEvent()) {
                        player.gF();
                    }
                } else {
                    ((EntityHuman)damageSource.d()).gF();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.M, Math.round(f3 * 10.0f));
                } else if (damageSource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damageSource.d()).a(StatisticList.I, Math.round(f3 * 10.0f));
                }
            }
            if (damageSource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                float helmetDamage = (float)event.getDamage();
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                this.d(damageSource, helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING));
            }
            if (!damageSource.a(DamageTypeTags.b)) {
                float armorDamage = (float)event.getDamage();
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
                this.c(damageSource, armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.blockingItemEffects(level, damageSource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.E(Math.max(this.fw() - absorptionModifier, 0.0f));
            float f1 = absorptionModifier;
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = this) instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                player.a(StatisticList.L, Math.round(f1 * 10.0f));
            }
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = damageSource.d()) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                serverPlayer.a(StatisticList.H, Math.round(f1 * 10.0f));
            }
            if (amount > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damageSource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (amount < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.J, Math.round(amount * 10.0f));
                    }
                }
                this.eS().a(damageSource, amount);
                this.d(this.eG() - amount);
                if (!human) {
                    this.E(this.fw() - amount);
                }
                ((Entity)this).a(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damageSource, originalDamage, amount, true);
                    f1 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f1 > 0.0f && f1 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.K, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damageSource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damageSource.d(), this, damageSource, originalDamage, amount, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker eS() {
        return this.bG;
    }

    @Nullable
    public EntityLiving eT() {
        if (this.ba != null) {
            return this.ba.a(this.dV(), EntityHuman.class);
        }
        return this.bL != null ? this.bL.a(this.dV(), EntityLiving.class) : null;
    }

    public final float eU() {
        return (float)this.h(GenericAttributes.s);
    }

    public final float eV() {
        return (float)this.h(GenericAttributes.r);
    }

    public final int eW() {
        return this.al.a(bB);
    }

    public final void o(int count) {
        this.setArrowCount(count, false);
    }

    public final void setArrowCount(int count, boolean reset) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.eW(), count, reset);
        if (event.isCancelled()) {
            return;
        }
        this.al.a(bB, event.getNewAmount());
    }

    public final int eX() {
        return this.al.a(bC);
    }

    public final void p(int stingerCount) {
        this.al.a(bC, stingerCount);
    }

    private int D() {
        if (MobEffectUtil.a(this)) {
            return 6 - (1 + MobEffectUtil.b(this));
        }
        return this.b(MobEffects.d) ? 6 + (1 + this.c(MobEffects.d).e()) * 2 : 6;
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean updateSelf) {
        if (!this.aI || this.aK >= this.D() / 2 || this.aK < 0) {
            this.aK = -1;
            this.aI = true;
            this.aJ = hand;
            if (this.dV() instanceof WorldServer) {
                PacketPlayOutAnimation clientboundAnimatePacket = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkSource = ((WorldServer)this.dV()).m();
                if (updateSelf) {
                    chunkSource.a(this, clientboundAnimatePacket);
                } else {
                    chunkSource.b(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.aT.a(1.5f);
        this.aj = 20;
        this.aN = this.aO = 10;
        SoundEffect hurtSound = this.e(damageSource);
        if (hurtSound != null) {
            this.a(hurtSound, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
        }
        this.bU = damageSource;
        this.bV = this.dV().ae();
    }

    @Override
    public void b(byte id) {
        switch (id) {
            case 3: {
                SoundEffect deathSound = this.j_();
                if (deathSound != null) {
                    this.a(deathSound, this.fe(), (this.ae.i() - this.ae.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.d(0.0f);
                this.a(this.dW().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int i1 = 0; i1 < 128; ++i1) {
                    double d2 = (double)i1 / 127.0;
                    float f2 = (this.ae.i() - 0.5f) * 0.2f;
                    float f1 = (this.ae.i() - 0.5f) * 0.2f;
                    float f22 = (this.ae.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d2, this.K, this.dA()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    double d22 = MathHelper.d(d2, this.L, this.dC()) + this.ae.j() * (double)this.dr();
                    double d3 = MathHelper.d(d2, this.M, this.dG()) + (this.ae.j() - 0.5) * (double)this.dq() * 2.0;
                    this.dV().a(Particles.af, d1, d22, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.F();
                break;
            }
            case 60: {
                this.eY();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.E();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(id);
            }
        }
    }

    public void eY() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            double d3 = 10.0;
            this.dV().a(Particles.ae, this.d(1.0) - d2 * 10.0, this.dD() - d1 * 10.0, this.g(1.0) - d22 * 10.0, d2, d1, d22);
        }
    }

    private void E() {
        Vec3D deltaMovement = this.dy();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d2 = this.ae.a(0.0, 1.0);
            double d1 = this.ae.a(0.0, 1.0);
            double d22 = this.ae.a(0.0, 1.0);
            this.dV().a(Particles.d, this.dA() + d2, this.dC() + d1, this.dG() + d22, deltaMovement.d, deltaMovement.e, deltaMovement.f);
        }
    }

    private void F() {
        ItemStack itemBySlot = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemBySlot);
    }

    @Override
    protected void aG() {
        this.a(this.dW().o(), this.dV().getWorld().getVoidDamageAmount());
    }

    protected void eZ() {
        int currentSwingDuration = this.D();
        if (this.aI) {
            ++this.aK;
            if (this.aK >= currentSwingDuration) {
                this.aK = 0;
                this.aI = false;
            }
        } else {
            this.aK = 0;
        }
        this.aR = (float)this.aK / (float)currentSwingDuration;
    }

    @Nullable
    public AttributeModifiable g(Holder<AttributeBase> attribute) {
        return this.fa().a(attribute);
    }

    public double h(Holder<AttributeBase> attribute) {
        return this.fa().c(attribute);
    }

    public double i(Holder<AttributeBase> attribute) {
        return this.fa().d(attribute);
    }

    public AttributeMapBase fa() {
        return this.bF;
    }

    public ItemStack fb() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fc() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack a(EnumMainHand arm) {
        return this.fy() == arm ? this.fb() : this.fc();
    }

    @Override
    @Nonnull
    public ItemStack dZ() {
        return this.fb();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemStack) -> itemStack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fb()) || predicate.test(this.fc());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean d(EnumItemSlot slot) {
        return !this.a(slot).f();
    }

    public boolean e(EnumItemSlot slot) {
        return true;
    }

    public ItemStack a(EnumItemSlot slot) {
        return this.bt.a(slot);
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.onEquipItem(slot, this.bt.a(slot, stack), stack, silent);
    }

    public float fd() {
        int i2 = 0;
        int i1 = 0;
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (!itemBySlot.f()) {
                ++i1;
            }
            ++i2;
        }
        return i2 > 0 ? (float)i1 / (float)i2 : 0.0f;
    }

    @Override
    public void h(boolean sprinting) {
        super.h(sprinting);
        AttributeModifiable attribute = this.g(GenericAttributes.v);
        attribute.c(e.a());
        if (sprinting) {
            attribute.b(e);
        }
    }

    public float fe() {
        return 1.0f;
    }

    public float ff() {
        return this.e_() ? (this.ae.i() - this.ae.i()) * 0.2f + 1.5f : (this.ae.i() - this.ae.i()) * 0.2f + 1.0f;
    }

    protected boolean fg() {
        return this.eH();
    }

    @Override
    public void h(Entity entity) {
        if (!this.fR()) {
            super.h(entity);
        }
    }

    private void c(Entity vehicle) {
        Vec3D vec3;
        if (this.dQ()) {
            vec3 = this.dt();
        } else if (!vehicle.dQ() && !this.dV().a_(vehicle.dv()).a(TagsBlock.aM)) {
            vec3 = vehicle.b(this);
        } else {
            boolean flag;
            double max = Math.max(this.dC(), vehicle.dC());
            vec3 = new Vec3D(this.dA(), max, this.dG());
            boolean bl = flag = this.dq() <= 4.0f && this.dr() <= 4.0f;
            if (flag) {
                double d2 = (double)this.dr() / 2.0;
                Vec3D vec31 = vec3.b(0.0, d2, 0.0);
                VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec31, this.dq(), this.dr(), this.dq()));
                vec3 = this.dV().a((Entity)this, voxelShape, vec31, (double)this.dq(), (double)this.dr(), (double)this.dq()).map(vec32 -> vec32.b(0.0, -d2, 0.0)).orElse(vec3);
            }
        }
        this.m(vec3.d, vec3.e, vec3.f);
    }

    @Override
    public boolean cM() {
        return this.cL();
    }

    protected float fh() {
        return this.z(1.0f);
    }

    protected float z(float multiplier) {
        return (float)this.h(GenericAttributes.o) * multiplier * this.aR() + this.fi();
    }

    public float fi() {
        return this.b(MobEffects.h) ? 0.1f * ((float)this.c(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void r() {
        float jumpPower = this.fh();
        if (!(jumpPower <= 1.0E-5f)) {
            Vec3D deltaMovement = this.dy();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof EntityHuman) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.n(deltaMovement.d, Math.max((double)jumpPower, deltaMovement.e), deltaMovement.f);
            if (this.ci()) {
                float f2 = this.dL() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.j(new Vec3D((double)(-MathHelper.a(f2)) * 0.2, 0.0, (double)MathHelper.b(f2) * 0.2));
                }
            }
            this.ar = true;
        }
    }

    protected void fj() {
        this.i(this.dy().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluidTag) {
        this.i(this.dy().b(0.0, 0.04f, 0.0));
    }

    protected float fk() {
        return 0.8f;
    }

    public boolean a(Fluid fluidState) {
        return false;
    }

    @Override
    protected double bc() {
        return this.h(GenericAttributes.n);
    }

    protected double fl() {
        boolean flag = this.dy().e <= 0.0;
        return flag && this.b(MobEffects.B) ? Math.min(this.bd(), 0.01) : this.bd();
    }

    public void a_(Vec3D travelVector) {
        Fluid fluidState = this.dV().b_(this.dv());
        if ((this.bi() || this.bv()) && this.em() && !this.a(fluidState)) {
            this.m(travelVector);
        } else if (this.fJ()) {
            this.n(travelVector);
        } else {
            this.l(travelVector);
        }
    }

    private void l(Vec3D travelVector) {
        BlockPosition blockPosBelowThatAffectsMyMovement = this.aP();
        float f2 = this.aH() ? this.dV().a_(blockPosBelowThatAffectsMyMovement).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3 = this.a(travelVector, f2);
        double d2 = vec3.e;
        MobEffect effect = this.c(MobEffects.y);
        d2 = effect != null ? (d2 += (0.05 * (double)(effect.e() + 1) - vec3.e) * 0.2) : (!this.dV().C || this.dV().C(blockPosBelowThatAffectsMyMovement) ? (d2 -= this.fl()) : (this.dC() > (double)this.dV().K_() ? -0.1 : 0.0));
        if (this.ex()) {
            this.n(vec3.d, d2, vec3.f);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.n(vec3.d * (double)f1, d2 * (double)f22, vec3.f * (double)f1);
        }
    }

    private void m(Vec3D travelVector) {
        boolean flag = this.dy().e <= 0.0;
        double y2 = this.dC();
        double effectiveGravity = this.fl();
        if (this.bi()) {
            float f2 = this.ci() ? 0.9f : this.fk();
            float f1 = 0.02f;
            float f22 = (float)this.h(GenericAttributes.F);
            if (!this.aH()) {
                f22 *= 0.5f;
            }
            if (f22 > 0.0f) {
                f2 += (0.54600006f - f2) * f22;
                f1 += (this.fo() - f1) * f22;
            }
            if (this.b(MobEffects.D)) {
                f2 = 0.96f;
            }
            this.a(f1, travelVector);
            this.a(EnumMoveType.a, this.dy());
            Vec3D deltaMovement = this.dy();
            if (this.P && this.k_()) {
                deltaMovement = new Vec3D(deltaMovement.d, 0.2, deltaMovement.f);
            }
            deltaMovement = deltaMovement.d(f2, 0.8f, f2);
            this.i(this.a(effectiveGravity, flag, deltaMovement));
        } else {
            this.a(0.02f, travelVector);
            this.a(EnumMoveType.a, this.dy());
            if (this.b(TagsFluid.b) <= this.dp()) {
                this.i(this.dy().d(0.5, 0.8f, 0.5));
                Vec3D fluidFallingAdjustedMovement = this.a(effectiveGravity, flag, this.dy());
                this.i(fluidFallingAdjustedMovement);
            } else {
                this.i(this.dy().c(0.5));
            }
            if (effectiveGravity != 0.0) {
                this.i(this.dy().b(0.0, -effectiveGravity / 4.0, 0.0));
            }
        }
        Vec3D fluidFallingAdjustedMovement = this.dy();
        if (this.P && this.f(fluidFallingAdjustedMovement.d, fluidFallingAdjustedMovement.e + (double)0.6f - this.dC() + y2, fluidFallingAdjustedMovement.f)) {
            this.n(fluidFallingAdjustedMovement.d, 0.3f, fluidFallingAdjustedMovement.f);
        }
    }

    private void n(Vec3D travelVector) {
        if (this.k_()) {
            this.l(travelVector);
            this.fm();
        } else {
            Vec3D deltaMovement = this.dy();
            double d2 = deltaMovement.i();
            this.i(this.o(deltaMovement));
            this.a(EnumMoveType.a, this.dy());
            if (!this.dV().C) {
                double d1 = this.dy().i();
                this.c(d2, d1);
            }
        }
    }

    public void fm() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    private Vec3D o(Vec3D deltaMovement) {
        double d1;
        Vec3D lookAngle = this.bS();
        float f2 = this.dN() * ((float)Math.PI / 180);
        double squareRoot = Math.sqrt(lookAngle.d * lookAngle.d + lookAngle.f * lookAngle.f);
        double d2 = deltaMovement.i();
        double effectiveGravity = this.fl();
        double squared = MathHelper.k(Math.cos(f2));
        deltaMovement = deltaMovement.b(0.0, effectiveGravity * (-1.0 + squared * 0.75), 0.0);
        if (deltaMovement.e < 0.0 && squareRoot > 0.0) {
            d1 = deltaMovement.e * -0.1 * squared;
            deltaMovement = deltaMovement.b(lookAngle.d * d1 / squareRoot, d1, lookAngle.f * d1 / squareRoot);
        }
        if (f2 < 0.0f && squareRoot > 0.0) {
            d1 = d2 * (double)(-MathHelper.a(f2)) * 0.04;
            deltaMovement = deltaMovement.b(-lookAngle.d * d1 / squareRoot, d1 * 3.2, -lookAngle.f * d1 / squareRoot);
        }
        if (squareRoot > 0.0) {
            deltaMovement = deltaMovement.b((lookAngle.d / squareRoot * d2 - deltaMovement.d) * 0.1, 0.0, (lookAngle.f / squareRoot * d2 - deltaMovement.f) * 0.1);
        }
        return deltaMovement.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double oldSpeed, double newSpeed) {
        double d2;
        float f2;
        if (this.P && (f2 = (float)((d2 = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.dW().n(), f2);
        }
    }

    private void c(EntityHuman player, Vec3D travelVector) {
        Vec3D riddenInput = this.b(player, travelVector);
        this.a(player, riddenInput);
        if (this.di()) {
            this.B(this.c(player));
            this.a_(riddenInput);
        } else {
            this.i(Vec3D.c);
        }
    }

    protected void a(EntityHuman player, Vec3D travelVector) {
    }

    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return travelVector;
    }

    protected float c(EntityHuman player) {
        return this.fo();
    }

    public void r(boolean includeHeight) {
        float f2 = (float)MathHelper.g(this.dA() - this.K, includeHeight ? this.dC() - this.L : 0.0, this.dG() - this.M);
        if (!this.bY() && this.bJ()) {
            this.A(f2);
        } else {
            this.aT.a();
        }
    }

    protected void A(float partialTick) {
        float min = Math.min(partialTick * 4.0f, 1.0f);
        this.aT.a(min, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D a(Vec3D deltaMovement, float friction) {
        this.a(this.G(friction), deltaMovement);
        this.i(this.p(this.dy()));
        this.a(EnumMoveType.a, this.dy());
        Vec3D deltaMovement1 = this.dy();
        if ((this.P || this.bf) && (this.k_() || this.aw && PowderSnowBlock.a(this))) {
            deltaMovement1 = new Vec3D(deltaMovement1.d, 0.2, deltaMovement1.f);
        }
        return deltaMovement1;
    }

    public Vec3D a(double gravity, boolean isFalling, Vec3D deltaMovement) {
        if (gravity != 0.0 && !this.ci()) {
            double d2 = isFalling && Math.abs(deltaMovement.e - 0.005) >= 0.003 && Math.abs(deltaMovement.e - gravity / 16.0) < 0.003 ? -0.003 : deltaMovement.e - gravity / 16.0;
            return new Vec3D(deltaMovement.d, d2, deltaMovement.f);
        }
        return deltaMovement;
    }

    private Vec3D p(Vec3D deltaMovement) {
        if (this.k_()) {
            this.j();
            float f2 = 0.15f;
            double d2 = MathHelper.a(deltaMovement.d, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(deltaMovement.f, (double)-0.15f, (double)0.15f);
            double max = Math.max(deltaMovement.e, (double)-0.15f);
            if (max < 0.0 && !this.dw().a(Blocks.oy) && this.fI() && this instanceof EntityHuman) {
                max = 0.0;
            }
            deltaMovement = new Vec3D(d2, max, d1);
        }
        return deltaMovement;
    }

    private float G(float friction) {
        return this.aH() ? this.fo() * (0.21600002f / (friction * friction * friction)) : this.fn();
    }

    protected float fn() {
        return this.cW() instanceof EntityHuman ? this.fo() * 0.1f : 0.02f;
    }

    public float fo() {
        return this.bP;
    }

    public void B(float speed) {
        this.bP = speed;
    }

    public boolean c(WorldServer level, Entity source) {
        this.B(source);
        return false;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bd;
    }

    @Override
    public void g() {
        super.g();
        this.I();
        this.K();
        if (!this.dV().C) {
            int stingerCount;
            int arrowCount = this.eW();
            if (arrowCount > 0) {
                if (this.aL <= 0) {
                    this.aL = 20 * (30 - arrowCount);
                }
                --this.aL;
                if (this.aL <= 0) {
                    this.o(arrowCount - 1);
                }
            }
            if ((stingerCount = this.eX()) > 0) {
                if (this.aM <= 0) {
                    this.aM = 20 * (30 - stingerCount);
                }
                --this.aM;
                if (this.aM <= 0) {
                    this.p(stingerCount - 1);
                }
            }
            this.G();
            if (this.af % 20 == 0) {
                this.eS().c();
            }
            if (this.fR() && !this.M()) {
                this.fS();
            }
        }
        if (!this.dQ()) {
            this.d_();
        }
        double d2 = this.dA() - this.K;
        double d1 = this.dG() - this.M;
        float f2 = (float)(d2 * d2 + d1 * d1);
        float f1 = this.aV;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d2) * 57.295776f - 90.0f;
            float abs = MathHelper.e(MathHelper.h(this.dL()) - f22);
            f1 = 95.0f < abs && abs < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.aR > 0.0f) {
            f1 = this.dL();
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("headTurn");
        this.C(f1);
        profilerFiller.c();
        profilerFiller.a("rangeChecks");
        this.N += (float)Math.round((this.dL() - this.N) / 360.0f) * 360.0f;
        this.aW += (float)Math.round((this.aV - this.aW) / 360.0f) * 360.0f;
        this.O += (float)Math.round((this.dN() - this.O) / 360.0f) * 360.0f;
        this.aY += (float)Math.round((this.aX - this.aY) / 360.0f) * 360.0f;
        profilerFiller.c();
        this.bo = this.fJ() ? ++this.bo : 0;
        if (this.fR()) {
            this.x(0.0f);
        }
        this.C();
        this.aZ.a();
    }

    public void G() {
        Map<EnumItemSlot, ItemStack> map = this.H();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> H() {
        ItemStack itemBySlot;
        Map map = null;
        EnumMap equipmentChanges = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemStack = this.bI.get(enumItemSlot);
            if (!this.a(itemStack, itemBySlot = this.a(enumItemSlot))) continue;
            org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemStack);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemBySlot);
            if (this instanceof EntityPlayer && enumItemSlot.a() == EnumItemSlot.Function.b) {
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumItemSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
                equipmentChanges = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(enumItemSlot, itemBySlot);
            record EquipmentChangeImpl(org.bukkit.inventory.ItemStack oldItem, org.bukkit.inventory.ItemStack newItem) implements EntityEquipmentChangedEvent.EquipmentChange
            {
                private final org.bukkit.inventory.ItemStack oldItem;
                private final org.bukkit.inventory.ItemStack newItem;

                public org.bukkit.inventory.ItemStack oldItem() {
                    return this.oldItem.clone();
                }

                public org.bukkit.inventory.ItemStack newItem() {
                    return this.newItem.clone();
                }
            }
            equipmentChanges.put(CraftEquipmentSlot.getSlot(enumItemSlot), new EquipmentChangeImpl(oldItem, newItem));
            AttributeMapBase attributes = this.fa();
            if (itemStack.f()) continue;
            this.a(itemStack, enumItemSlot, attributes);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot equipmentSlot1 = (EnumItemSlot)entry.getKey();
                itemBySlot = (ItemStack)entry.getValue();
                if (itemBySlot.f() || itemBySlot.q()) continue;
                itemBySlot.a(equipmentSlot1, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
                    AttributeModifiable instance = this.bF.a((Holder<AttributeBase>)holder);
                    if (instance != null) {
                        instance.c(attributeModifier.a());
                        instance.b((AttributeModifier)attributeModifier);
                    }
                });
                net.minecraft.world.level.World world = this.dV();
                if (!(world instanceof WorldServer)) continue;
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, itemBySlot, this, equipmentSlot1);
            }
            new EntityEquipmentChangedEvent((LivingEntity)this.getBukkitLivingEntity(), equipmentChanges).callEvent();
        }
        return map;
    }

    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !ItemStack.a(newItem, oldItem);
    }

    private void a(Map<EnumItemSlot, ItemStack> hands) {
        ItemStack itemStack = hands.get(EnumItemSlot.a);
        ItemStack itemStack1 = hands.get(EnumItemSlot.b);
        if (itemStack != null && itemStack1 != null && ItemStack.a(itemStack, this.bI.get(EnumItemSlot.b)) && ItemStack.a(itemStack1, this.bI.get(EnumItemSlot.a))) {
            ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityStatus(this, 55));
            hands.remove(EnumItemSlot.a);
            hands.remove(EnumItemSlot.b);
            this.bI.put(EnumItemSlot.a, itemStack.v());
            this.bI.put(EnumItemSlot.b, itemStack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipments) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipments.size());
        equipments.forEach((equipmentSlot, itemStack) -> {
            ItemStack itemStack1 = itemStack.v();
            list.add(Pair.of((Object)equipmentSlot, (Object)itemStack1));
            this.bI.put((EnumItemSlot)equipmentSlot, itemStack1);
        });
        ((WorldServer)this.dV()).m().b(this, new PacketPlayOutEntityEquipment(this.ao(), list, true));
    }

    protected void C(float yBodyRot) {
        float f2 = MathHelper.h(yBodyRot - this.aV);
        this.aV += f2 * 0.3f;
        float f1 = MathHelper.h(this.dL() - this.aV);
        float maxHeadRotationRelativeToBody = this.fp();
        if (Math.abs(f1) > maxHeadRotationRelativeToBody) {
            this.aV += f1 - (float)MathHelper.j((double)f1) * maxHeadRotationRelativeToBody;
        }
    }

    protected float fp() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.bQ > 0) {
            --this.bQ;
        }
        if (this.bQ()) {
            this.l_().e();
        } else if (!this.di()) {
            this.i(this.dy().c(0.98));
        }
        if (this.bl > 0) {
            this.a(this.bl, this.bk);
            --this.bl;
        }
        this.bt.a((Entity)this);
        deltaMovement = this.dy();
        d = deltaMovement.d;
        d1 = deltaMovement.e;
        d2 = deltaMovement.f;
        if (this.an().equals(EntityTypes.bT)) {
            if (deltaMovement.j() < 9.0E-6) {
                d = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(deltaMovement.d) < 0.003) {
                d = 0.0;
            }
            if (Math.abs(deltaMovement.f) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(deltaMovement.e) < 0.003) {
            d1 = 0.0;
        }
        this.n(d, d1, d2);
        profilerFiller = Profiler.a();
        profilerFiller.a("ai");
        this.fq();
        if (this.fg()) {
            this.bf = false;
            this.bg = 0.0f;
            this.bi = 0.0f;
        } else if (this.dj() && !this.dV().C) {
            profilerFiller.a("newAi");
            this.fu();
            profilerFiller.c();
        }
        profilerFiller.c();
        profilerFiller.a("jump");
        if (this.bf && this.em()) {
            fluidHeight = this.bv() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.bi() != false && fluidHeight > 0.0;
            fluidJumpThreshold = this.dp();
            if (!flag || this.aH() && !(fluidHeight > fluidJumpThreshold)) {
                if (!this.bv() || this.aH() && !(fluidHeight > fluidJumpThreshold)) {
                    if ((this.aH() || flag && fluidHeight <= fluidJumpThreshold) && this.bQ == 0) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.r();
                            this.bQ = 10;
                        } else {
                            this.s(false);
                        }
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.bQ = 0;
        }
        profilerFiller.c();
        profilerFiller.a("travel");
        if (this.fJ()) {
            this.fs();
        }
        boundingBox = this.cR();
        vec3 = new Vec3D(this.bg, this.bh, this.bi);
        if (this.b(MobEffects.B) || this.b(MobEffects.y)) {
            this.j();
        }
        if (!((fluidJumpThreshold = this.cW()) instanceof EntityHuman)) ** GOTO lbl-1000
        player = (EntityHuman)fluidJumpThreshold;
        if (this.bJ()) {
            this.c(player, vec3);
        } else if (this.di()) {
            this.a_(vec3);
        }
        if (!this.dV().A_() || this.dg()) {
            this.aI();
        }
        if (this.dV().A_()) {
            this.r(this instanceof EntityBird);
        }
        profilerFiller.c();
        fluidJumpThreshold = this.dV();
        if (fluidJumpThreshold instanceof WorldServer) {
            serverLevel = (WorldServer)fluidJumpThreshold;
            profilerFiller.a("freezing");
            if (!(this.av && this.dJ() || this.freezeLocked)) {
                this.k(Math.max(0, this.cu() - 2));
            }
            this.ei();
            this.ej();
            if (this.af % 40 == 0 && this.cw() && this.dJ()) {
                this.a(serverLevel, this.dW().v(), 1.0f);
            }
            profilerFiller.c();
        }
        profilerFiller.a("push");
        if (this.bp > 0) {
            --this.bp;
            this.a(boundingBox, this.cR());
        }
        this.n();
        profilerFiller.c();
        if (((WorldServer)this.dV()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.K != this.dA() || this.L != this.dC() || this.M != this.dG() || this.N != this.dL() || this.O != this.dN())) {
            from = new Location((World)this.dV().getWorld(), this.K, this.L, this.M, this.N, this.O);
            to = new Location((World)this.dV().getWorld(), this.dA(), this.dC(), this.dG(), this.dL(), this.dN());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if ((var12_14 = this.dV()) instanceof WorldServer) {
            serverLevel = (WorldServer)var12_14;
            if (this.fr() && this.bk()) {
                this.a(serverLevel, this.dW().i(), 1.0f);
            }
        }
    }

    protected void fq() {
        this.bg *= 0.98f;
        this.bi *= 0.98f;
    }

    public boolean fr() {
        return false;
    }

    protected void fs() {
        this.cy();
        if (!this.dV().C) {
            if (!this.ft()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bo + 1;
            if (i2 % 10 == 0) {
                int i1 = i2 / 10;
                if (i1 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(equipmentSlot1 -> EntityLiving.b(this.a((EnumItemSlot)equipmentSlot1), equipmentSlot1)).toList();
                    EnumItemSlot equipmentSlot = SystemUtils.a(list, this.ae);
                    this.a(equipmentSlot).a(1, this, equipmentSlot);
                }
                ((Entity)this).a(GameEvent.n);
            }
        }
    }

    protected boolean ft() {
        if (!(this.aH() || this.bY() || this.b(MobEffects.y))) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(equipmentSlot), equipmentSlot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fu() {
    }

    @Override
    protected void n() {
        if (!this.bG()) {
            return;
        }
        ScoreboardTeam team = this.cq();
        if (team != null && ((ScoreboardTeamBase)team).m() == ScoreboardTeamBase.EnumTeamPush.b) {
            return;
        }
        int _int = ((WorldServer)this.dV()).O().d(GameRules.w);
        if (_int <= 0 && this.dV().paperConfig().collisions.maxEntityCollisions <= 0) {
            return;
        }
        List<Entity> pushableEntities = this.dV().i(this, this.cR());
        if (!pushableEntities.isEmpty()) {
            net.minecraft.world.level.World world = this.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (_int > 0 && pushableEntities.size() > _int - 1 && this.ae.a(4) == 0) {
                    int i2 = 0;
                    for (Entity entity : pushableEntities) {
                        if (entity.bY()) continue;
                        ++i2;
                    }
                    if (i2 > _int - 1) {
                        this.a(serverLevel, this.dW().h(), 6.0f);
                    }
                }
            }
            this.numCollisions = Math.max(0, this.numCollisions - this.dV().paperConfig().collisions.maxEntityCollisions);
            for (Entity entity1 : pushableEntities) {
                if (this.numCollisions >= this.dV().paperConfig().collisions.maxEntityCollisions) break;
                ++entity1.numCollisions;
                ++this.numCollisions;
                this.D(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB boundingBoxBeforeSpin, AxisAlignedBB boundingBoxAfterSpin) {
        AxisAlignedBB aabb = boundingBoxBeforeSpin.b(boundingBoxAfterSpin);
        List<Entity> entities = this.dV().a_(this, aabb);
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLiving)) continue;
                this.f((EntityLiving)entity);
                this.bp = 0;
                this.i(this.dy().c(-0.2));
                break;
            }
        } else if (this.P) {
            this.bp = 0;
        }
        if (!this.dV().C && this.bp <= 0) {
            this.c(4, false);
            this.bq = 0.0f;
            this.br = null;
        }
    }

    protected void D(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving target) {
    }

    public boolean fv() {
        return (this.al.a(aC) & 4) != 0;
    }

    @Override
    public void bO() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity vehicle = this.dk();
        super.stopRiding(suppressCancellation);
        if (vehicle != null && vehicle != this.dk() && !this.dV().C && vehicle.valid) {
            this.c(vehicle);
        }
    }

    @Override
    public void q() {
        super.q();
        this.j();
    }

    @Override
    public InterpolationHandler l_() {
        return this.bj;
    }

    @Override
    public void a(float yaw, int pitch) {
        this.bk = yaw;
        this.bl = pitch;
    }

    public void s(boolean jumping) {
        this.bf = jumping;
    }

    public void a(EntityItem itemEntity) {
        EntityHuman owner;
        EntityHuman entityHuman = owner = itemEntity.n != null ? this.dV().getGlobalPlayerByUUID(itemEntity.n) : null;
        if (owner instanceof EntityPlayer) {
            CriterionTriggers.R.a((EntityPlayer)owner, itemEntity.e(), this);
        }
    }

    public void a(Entity entity, int amount) {
        if (!entity.dQ() && !this.dV().C && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.dV()).m().a(this, new PacketPlayOutCollect(entity.ao(), this.ao(), amount));
        }
    }

    public boolean E(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dE());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption block, RayTrace.FluidCollisionOption fluid, double y2) {
        if (entity.dV() != this.dV()) {
            return false;
        }
        Vec3D vec3 = new Vec3D(this.dA(), this.dE(), this.dG());
        Vec3D vec31 = new Vec3D(entity.dA(), y2, entity.dG());
        return !(vec31.g(vec3) > 16384.0) && this.dV().a(new RayTrace(vec3, vec31, block, fluid, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float partialTicks) {
        return partialTicks == 1.0f ? this.aX : MathHelper.i(partialTicks, this.aY, this.aX);
    }

    public float D(float partialTick) {
        float f2 = this.aR - this.aQ;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        return this.aQ + f2 * partialTick;
    }

    @Override
    public boolean bF() {
        return !this.dQ() && this.collides;
    }

    @Override
    public boolean bG() {
        return this.isCollidable(this.dV().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.bJ() && !this.ak() && (ignoreClimbing || !this.k_()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bG() && this.collides != this.collidableExemptions.contains(entity.cG());
    }

    @Override
    public float cA() {
        return this.aX;
    }

    @Override
    public void r(float rotation) {
        this.aX = rotation;
    }

    @Override
    public void s(float offset) {
        this.aV = offset;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.k(super.a(axis, portal));
    }

    public static Vec3D k(Vec3D relativePortalPosition) {
        return new Vec3D(relativePortalPosition.d, relativePortalPosition.e, 0.0);
    }

    public float fw() {
        return this.bR;
    }

    public final void E(float absorptionAmount) {
        this.F(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.eV()) : 0.0f);
    }

    protected void F(float absorptionAmount) {
        this.bR = absorptionAmount;
    }

    public void f_() {
    }

    public void O_() {
    }

    protected void fx() {
        this.bK = true;
    }

    public abstract EnumMainHand fy();

    public boolean fz() {
        return (this.al.a(aC) & 1) > 0;
    }

    public EnumHand fA() {
        return (this.al.a(aC) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(aC), serverPlayer);
    }

    private void I() {
        if (this.fz()) {
            if (ItemStack.b(this.b(this.fA()), this.bm)) {
                this.bm = this.b(this.fA());
                this.a(this.bm);
            } else {
                this.fF();
            }
        }
    }

    @Nullable
    private EntityItem b(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        if (stack.f()) {
            return null;
        }
        double d2 = this.dE() - (double)0.3f;
        ItemStack tmp = stack.v();
        stack.e(0);
        stack = tmp;
        EntityItem itemEntity = new EntityItem(this.dV(), this.dA(), d2, this.dG(), stack);
        itemEntity.b(40);
        if (includeThrower) {
            itemEntity.b((Entity)this);
        }
        if (randomizeMotion) {
            float f2 = this.ae.i() * 0.5f;
            float f1 = this.ae.i() * ((float)Math.PI * 2);
            itemEntity.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dN() * ((float)Math.PI / 180));
            float cos = MathHelper.b(this.dN() * ((float)Math.PI / 180));
            float sin = MathHelper.a(this.dL() * ((float)Math.PI / 180));
            float cos1 = MathHelper.b(this.dL() * ((float)Math.PI / 180));
            float f2 = this.ae.i() * ((float)Math.PI * 2);
            float f32 = 0.02f * this.ae.i();
            itemEntity.n((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f32, -f1 * 0.3f + 0.1f + (this.ae.i() - this.ae.i()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f32);
        }
        return itemEntity;
    }

    protected void a(ItemStack usingItem) {
        boolean shouldLagCompensate;
        usingItem.b(this.dV(), this, this.fC());
        boolean bl = shouldLagCompensate = this.bm.c(DataComponents.v) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.bn != 0 && !shouldLagCompensate || this.dV().C || usingItem.x())) {
            this.bn = 0;
            this.v();
        }
    }

    private void K() {
        this.bX = this.bW;
        this.bW = this.ck() ? Math.min(1.0f, this.bW + 0.09f) : Math.max(0.0f, this.bW - 0.09f);
    }

    public void c(int key, boolean value) {
        int i2 = this.al.a(aC).byteValue();
        i2 = value ? (i2 |= key) : (i2 &= ~key);
        this.al.a(aC, (byte)i2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemInHand = this.b(hand);
        if (!itemInHand.f() && !this.fz() || forceUpdate) {
            this.bm = itemInHand;
            this.bn = this.totalEatTimeTicks = itemInHand.a(this);
            this.eatStartTime = System.nanoTime();
            if (!this.dV().C) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                ((Entity)this).a(GameEvent.D);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (bD.equals(key)) {
            if (this.dV().C) {
                this.fP().ifPresent(this::a);
            }
        } else if (aC.equals(key) && this.dV().C) {
            if (this.fz() && this.bm.f()) {
                this.bm = this.b(this.fA());
                if (!this.bm.f()) {
                    this.bn = this.bm.a(this);
                }
            } else if (!this.fz() && !this.bm.f()) {
                this.bm = ItemStack.l;
                this.totalEatTimeTicks = 0;
                this.bn = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.aY = this.aX;
        this.aW = this.aV = this.aX;
    }

    @Override
    public float u(float partialTick) {
        return MathHelper.h(partialTick, this.aW, this.aV);
    }

    public void b(ItemStack stack, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            Vec3D vec3 = new Vec3D(((double)this.ae.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.a(-this.dN() * ((float)Math.PI / 180));
            vec3 = vec3.b(-this.dL() * ((float)Math.PI / 180));
            double d2 = (double)(-this.ae.i()) * 0.6 - 0.3;
            Vec3D vec31 = new Vec3D(((double)this.ae.i() - 0.5) * 0.3, d2, 0.6);
            vec31 = vec31.a(-this.dN() * ((float)Math.PI / 180));
            vec31 = vec31.b(-this.dL() * ((float)Math.PI / 180));
            vec31 = vec31.b(this.dA(), this.dE(), this.dG());
            this.dV().a(new ParticleParamItem(Particles.U, stack), vec31.d, vec31.e, vec31.f, vec3.d, vec3.e + 0.05, vec3.f);
        }
    }

    public void v() {
        if (!this.dV().C || this.fz()) {
            EnumHand usedItemHand = this.fA();
            if (!this.bm.equals(this.b(usedItemHand))) {
                this.fE();
            } else if (!this.bm.f() && this.fz()) {
                ItemStack itemStack;
                this.startUsingItem(this.fA(), true);
                PlayerItemConsumeEvent event = null;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bm);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(usedItemHand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.dV().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bm.a(DataComponents.w);
                        if (consumable != null) {
                            consumable.cancelUsingItem(serverPlayer, this.bm);
                        }
                        serverPlayer.bR.b();
                        serverPlayer.getBukkitEntity().updateScaledHealth();
                        this.fF();
                        return;
                    }
                    itemStack = craftItem.equals((Object)event.getItem()) ? this.bm.a(this.dV(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.dV(), this);
                } else {
                    itemStack = this.bm.a(this.dV(), this);
                }
                ItemStack defaultReplacement = itemStack;
                if (event != null && event.getReplacement() != null) {
                    itemStack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemStack != this.bm) {
                    this.a(usedItemHand, itemStack);
                }
                this.fF();
                EntityLiving entityLiving2 = this;
                if (entityLiving2 instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entityLiving2;
                    player.bR.b();
                }
            }
        }
    }

    public void b(ItemStack stack) {
    }

    public ItemStack fB() {
        return this.bm;
    }

    public int fC() {
        return this.bn;
    }

    public int fD() {
        return this.fz() ? this.bm.a(this) - this.fC() : 0;
    }

    public void fE() {
        ItemStack itemInHand = this.b(this.fA());
        if (!this.bm.f() && ItemStack.b(itemInHand, this.bm)) {
            this.bm = itemInHand;
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bm.asBukkitMirror(), this.fD()).callEvent();
            }
            this.bm.a(this.dV(), this, this.fC());
            if (this.bm.x()) {
                this.I();
            }
        }
        this.fF();
    }

    public void fF() {
        if (!this.dV().C) {
            boolean isUsingItem = this.fz();
            this.c(1, false);
            if (isUsingItem) {
                ((Entity)this).a(GameEvent.C);
            }
        }
        this.bm = ItemStack.l;
        this.totalEatTimeTicks = 0;
        this.bn = 0;
        this.eatStartTime = -1L;
    }

    public boolean fG() {
        return this.fH() != null;
    }

    @Nullable
    public ItemStack fH() {
        int i2;
        if (!this.fz()) {
            return null;
        }
        BlocksAttacks blocksAttacks = this.bm.a(DataComponents.I);
        if (blocksAttacks != null && (i2 = this.bm.h().a(this.bm, this) - this.bn) >= blocksAttacks.a()) {
            return this.bm;
        }
        return null;
    }

    @Override
    public float getBukkitYaw() {
        return this.cA();
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dA(), this.dC() + (double)this.cS(), this.dG());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.d + dir.getX(), start.e + dir.getY(), start.f + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.dV().a(raytrace);
    }

    @Nullable
    public MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.n(1.0f);
        Vec3D direction = this.bS();
        Vec3D end = start.b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance);
        List<Entity> entityList = this.dV().a((Entity)this, this.cR().b(direction.d * (double)maxDistance, direction.e * (double)maxDistance, direction.f * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bF));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.bR();
            AxisAlignedBB aabb = entity.cR().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public boolean fI() {
        return this.cc();
    }

    public boolean fJ() {
        return this.i(7);
    }

    @Override
    public boolean ck() {
        return super.ck() || !this.fJ() && this.c(EntityPose.b);
    }

    public int fK() {
        return this.bo;
    }

    public boolean b(double x2, double y2, double z2, boolean broadcastTeleport) {
        return this.randomTeleport(x2, y2, z2, broadcastTeleport, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double x2, double y2, double z2, boolean broadcastTeleport, PlayerTeleportEvent.TeleportCause cause) {
        EntityLiving entityLiving;
        double x1 = this.dA();
        double y1 = this.dC();
        double z1 = this.dG();
        double d2 = y2;
        boolean flag = false;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        net.minecraft.world.level.World level = this.dV();
        if (level.C(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.v() > level.K_()) {
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = level.a_(blockPos1);
                if (blockState.d()) {
                    flag1 = true;
                    continue;
                }
                d2 -= 1.0;
                blockPos = blockPos1;
            }
            if (flag1) {
                this.a_(x2, d2, z2);
                if (level.g(this) && !level.d(this.cR())) {
                    flag = true;
                }
                this.a_(x1, y1, z1);
                if (flag) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.dV().getWorld(), x1, y1, z1), new Location((World)this.dV().getWorld(), x2, d2, z2));
                        this.dV().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).f.teleport(x2, d2, z2, this.dL(), this.dN(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag) {
            return Optional.of(false);
        }
        if (broadcastTeleport) {
            level.a((Entity)this, (byte)46);
        }
        if (!((entityLiving = this) instanceof EntityCreature)) return Optional.of(true);
        EntityCreature pathfinderMob = (EntityCreature)entityLiving;
        pathfinderMob.N().m();
        return Optional.of(true);
    }

    public boolean fL() {
        return !this.eH();
    }

    public boolean fM() {
        return true;
    }

    public void a(BlockPosition jukebox, boolean partyParrot) {
    }

    public boolean fN() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? aD : this.e(pose).a(this.el());
    }

    protected EntitySize e(EntityPose pose) {
        return this.an().n().a(this.ek());
    }

    public ImmutableList<EntityPose> fO() {
        return ImmutableList.of((Object)((Object)EntityPose.a));
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize dimensions = this.a(pose);
        return new AxisAlignedBB(-dimensions.a() / 2.0f, 0.0, -dimensions.a() / 2.0f, dimensions.a() / 2.0f, dimensions.b(), dimensions.a() / 2.0f);
    }

    protected boolean g(EntityPose pose) {
        AxisAlignedBB aabb = this.a(pose).a(this.dt());
        return this.dV().b(this, aabb);
    }

    @Override
    public boolean n(boolean allowPassengers) {
        return super.n(allowPassengers) && !this.fR();
    }

    public Optional<BlockPosition> fP() {
        return this.al.a(bD);
    }

    public void g(BlockPosition pos) {
        this.al.a(bD, Optional.of(pos));
    }

    public void fQ() {
        this.al.a(bD, Optional.empty());
    }

    public boolean fR() {
        return this.fP().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData blockState;
        if (this.bY()) {
            this.bO();
        }
        if ((blockState = this.dV().a_(pos)).b() instanceof BlockBed) {
            this.dV().a(pos, (IBlockData)blockState.b(BlockBed.c, true), 3);
        }
        this.b(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.i(Vec3D.c);
        this.ar = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean M() {
        return this.fP().map(blockPos -> this.dV().a_((BlockPosition)blockPos).b() instanceof BlockBed).orElse(false);
    }

    public void fS() {
        this.fP().filter(this.dV()::C).ifPresent(blockPos -> {
            IBlockData blockState = this.dV().a_((BlockPosition)blockPos);
            if (blockState.b() instanceof BlockBed) {
                EnumDirection direction = blockState.c(BlockFacingHorizontal.e);
                this.dV().a((BlockPosition)blockPos, (IBlockData)blockState.b(BlockBed.c, false), 3);
                Vec3D vec31 = BlockBed.a(this.an(), (ICollisionAccess)this.dV(), blockPos, direction, this.dL()).orElseGet(() -> {
                    BlockPosition blockPos1 = blockPos.d();
                    return new Vec3D((double)blockPos1.u() + 0.5, (double)blockPos1.v() + 0.1, (double)blockPos1.w() + 0.5);
                });
                Vec3D vec32 = Vec3D.c(blockPos).d(vec31).d();
                float f2 = (float)MathHelper.d(MathHelper.d(vec32.f, vec32.d) * 180.0 / 3.1415927410125732 - 90.0);
                this.a_(vec31.d, vec31.e, vec31.f);
                this.w(f2);
                this.x(0.0f);
            }
        });
        Vec3D vec3 = this.dt();
        this.b(EntityPose.a);
        this.a_(vec3.d, vec3.e, vec3.f);
        this.fQ();
    }

    @Nullable
    public EnumDirection fT() {
        BlockPosition blockPos = this.fP().orElse(null);
        return blockPos != null ? BlockBed.a(this.dV(), blockPos) : null;
    }

    @Override
    public boolean bK() {
        return !this.fR() && super.bK();
    }

    public ItemStack d(ItemStack weaponStack) {
        return ItemStack.l;
    }

    public static byte g(EnumItemSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        this.dV().a((Entity)this, EntityLiving.g(slot));
        this.a(this.a(slot), slot, this.bF);
    }

    private void a(ItemStack stack, EnumItemSlot slot, AttributeMapBase attributeMap) {
        stack.a(slot, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
            AttributeModifiable instance = attributeMap.a((Holder<AttributeBase>)holder);
            if (instance != null) {
                instance.e((AttributeModifier)attributeModifier);
            }
        });
        EnchantmentManager.a(stack, this, slot);
    }

    public static EnumItemSlot d(EnumHand hand) {
        return hand == EnumHand.a ? EnumItemSlot.a : EnumItemSlot.b;
    }

    public final boolean e(ItemStack stack) {
        if (this.bJ() && !this.ak()) {
            Equippable equippable = stack.a(DataComponents.D);
            if (equippable != null && equippable.g()) {
                EnumItemSlot equipmentSlot = equippable.b();
                return this.e(equipmentSlot) && equippable.a(this.an()) && this.a(equipmentSlot).f() && this.f(equipmentSlot);
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot slot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack stack) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack stack, EnumItemSlot slot) {
        Equippable equippable = stack.a(DataComponents.D);
        return equippable == null ? slot == EnumItemSlot.a && this.e(EnumItemSlot.a) : slot == equippable.b() && this.e(equippable.b()) && equippable.a(this.an());
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, (ItemStack itemStack) -> itemStack.f() || entity.f((ItemStack)itemStack) == slot) : SlotAccess.a(entity, slot);
    }

    @Nullable
    private static EnumItemSlot r(int index) {
        if (index == 100 + EnumItemSlot.f.b()) {
            return EnumItemSlot.f;
        }
        if (index == 100 + EnumItemSlot.e.b()) {
            return EnumItemSlot.e;
        }
        if (index == 100 + EnumItemSlot.d.b()) {
            return EnumItemSlot.d;
        }
        if (index == 100 + EnumItemSlot.c.b()) {
            return EnumItemSlot.c;
        }
        if (index == 98) {
            return EnumItemSlot.a;
        }
        if (index == 99) {
            return EnumItemSlot.b;
        }
        if (index == 105) {
            return EnumItemSlot.g;
        }
        return index == 106 ? EnumItemSlot.h : null;
    }

    @Override
    public SlotAccess a_(int slot) {
        EnumItemSlot equipmentSlot = EntityLiving.r(slot);
        return equipmentSlot != null ? EntityLiving.a(this, equipmentSlot) : super.a_(slot);
    }

    @Override
    public boolean dJ() {
        if (this.ak()) {
            return false;
        }
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (!this.a(equipmentSlot).a(TagsItem.bs)) continue;
            return false;
        }
        return super.dJ();
    }

    @Override
    public boolean cn() {
        return !this.dV().A_() && this.b(MobEffects.x) || super.cn();
    }

    @Override
    public float dM() {
        return this.aV;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        float yRot = packet.n();
        float xRot = packet.m();
        this.e(x2, y2, z2);
        this.aV = packet.o();
        this.aX = packet.o();
        this.aW = this.aV;
        this.aY = this.aX;
        this.e(packet.b());
        this.a_(packet.e());
        this.a(x2, y2, z2, yRot, xRot);
        this.n(packet.j(), packet.k(), packet.l());
    }

    public float fU() {
        Weapon weapon = this.dZ().a(DataComponents.B);
        return weapon != null ? weapon.b() : 0.0f;
    }

    @Override
    public float dP() {
        float f2 = (float)this.h(GenericAttributes.B);
        return this.cW() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D m(Entity entity) {
        return this.dt().e(this.a(entity, this.a(this.at()), this.el() * this.ek()));
    }

    protected void a(int lerpHeadSteps, double lerpYHeadRot) {
        this.aX = (float)MathHelper.e(1.0 / (double)lerpHeadSteps, (double)this.aX, lerpYHeadRot);
    }

    @Override
    public void g(int ticks) {
        super.g(MathHelper.c((double)ticks * this.h(GenericAttributes.h)));
    }

    public boolean fV() {
        return false;
    }

    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.d(damageSource) || EnchantmentManager.a(level, this, damageSource);
    }

    public static boolean b(ItemStack stack, EnumItemSlot slot) {
        if (!stack.c(DataComponents.F)) {
            return false;
        }
        Equippable equippable = stack.a(DataComponents.D);
        return equippable != null && slot == equippable.b() && !stack.r();
    }

    @VisibleForTesting
    public int fW() {
        return this.bb;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

