/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;

public class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> a = UUIDUtil.a.xmap(EntityReference::new, EntityReference::c);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> b = UUIDUtil.g.a(EntityReference::new, EntityReference::c);
    private Either<UUID, StoredEntityType> c;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> a() {
        return a;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> b() {
        return b;
    }

    public EntityReference(StoredEntityType entity) {
        this.c = Either.right(entity);
    }

    public EntityReference(UUID uuid) {
        this.c = Either.left(uuid);
    }

    public UUID c() {
        return this.c.map(uuid -> uuid, UniquelyIdentifyable::cG);
    }

    @Nullable
    public StoredEntityType a(UUIDLookup<? super StoredEntityType> uuidLookup, Class<StoredEntityType> entityClass) {
        StoredEntityType uniquelyIdentifyable1;
        Optional<UUID> optional1;
        Optional<StoredEntityType> optional = this.c.right();
        if (optional.isPresent()) {
            UniquelyIdentifyable uniquelyIdentifyable = (UniquelyIdentifyable)optional.get();
            if (!uniquelyIdentifyable.dQ()) {
                return (StoredEntityType)uniquelyIdentifyable;
            }
            this.c = Either.left(uniquelyIdentifyable.cG());
        }
        if ((optional1 = this.c.left()).isPresent() && (uniquelyIdentifyable1 = this.a((UniquelyIdentifyable)uuidLookup.c(optional1.get()), entityClass)) != null && !uniquelyIdentifyable1.dQ()) {
            this.c = Either.right(uniquelyIdentifyable1);
            return uniquelyIdentifyable1;
        }
        return null;
    }

    @Nullable
    private StoredEntityType a(@Nullable UniquelyIdentifyable entity, Class<StoredEntityType> entityClass) {
        return (StoredEntityType)(entity != null && entityClass.isAssignableFrom(entity.getClass()) ? (UniquelyIdentifyable)entityClass.cast(entity) : null);
    }

    public boolean a(StoredEntityType entity) {
        return this.c().equals(entity.cG());
    }

    public void a(NBTTagCompound tag, String key) {
        tag.a(key, UUIDUtil.a, this.c());
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> StoredEntityType a(@Nullable EntityReference<StoredEntityType> reference, UUIDLookup<? super StoredEntityType> uuidLookup, Class<StoredEntityType> entityClass) {
        return reference != null ? (StoredEntityType)reference.a(uuidLookup, entityClass) : null;
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> b(NBTTagCompound tag, String key) {
        return tag.a(key, EntityReference.a()).orElse(null);
    }

    @Nullable
    public static <StoredEntityType extends UniquelyIdentifyable> EntityReference<StoredEntityType> a(NBTTagCompound tag, String key, World level) {
        Optional<UUID> optional = tag.a(key, UUIDUtil.a);
        return optional.isPresent() ? new EntityReference(optional.get()) : (EntityReference)tag.i(key).map(string -> NameReferencingFileConverter.a(level.p(), string)).map(EntityReference::new).orElse(null);
    }
}

