/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int bI = 144;
    private static final int bM = 2;
    private static final int bN = 3;
    private static final int bO = 1;
    private static final boolean bP = false;
    protected static final DataWatcherObject<Byte> bJ = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> bK = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.r);
    private boolean bQ = false;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(bJ, (byte)0);
        builder.a(bK, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound compound) {
        super.b(compound);
        EntityReference<EntityLiving> ownerReference = this.d();
        if (ownerReference != null) {
            ownerReference.a(compound, "Owner");
        }
        compound.a("Sitting", this.bQ);
    }

    @Override
    public void a(NBTTagCompound compound) {
        super.a(compound);
        EntityReference withOldOwnerConversion = EntityReference.a(compound, "Owner", this.dV());
        if (withOldOwnerConversion != null) {
            try {
                this.al.a(bK, Optional.of(withOldOwnerConversion));
                this.a(true, false);
            }
            catch (Throwable var4) {
                this.a(false, true);
            }
        } else {
            this.al.a(bK, Optional.empty());
            this.a(false, true);
        }
        this.bQ = compound.b("Sitting", false);
        this.setInSittingPose(this.bQ, false);
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (this.u()) {
            if (distance > (float)this.dV().paperConfig().misc.maxLeashDistance.or(10.0)) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
                if (!event.callEvent()) {
                    return false;
                }
                if (event.isDropLeash()) {
                    this.x();
                } else {
                    this.y();
                }
            }
            return false;
        }
        return super.a(leashHolder, distance);
    }

    protected void w(boolean tamed) {
        ParticleType particleOptions = Particles.S;
        if (!tamed) {
            particleOptions = Particles.ah;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.ae.k() * 0.02;
            double d1 = this.ae.k() * 0.02;
            double d22 = this.ae.k() * 0.02;
            this.dV().a(particleOptions, this.d(1.0), this.dD() + 0.5, this.g(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.w(true);
        } else if (id == 6) {
            this.w(false);
        } else {
            super.b(id);
        }
    }

    public boolean m() {
        return (this.al.a(bJ) & 4) != 0;
    }

    public void a(boolean tame, boolean applyTamingSideEffects) {
        byte b2 = this.al.a(bJ);
        if (tame) {
            this.al.a(bJ, (byte)(b2 | 4));
        } else {
            this.al.a(bJ, (byte)(b2 & 0xFFFFFFFB));
        }
        if (applyTamingSideEffects) {
            this.p();
        }
    }

    protected void p() {
    }

    public boolean u() {
        return (this.al.a(bJ) & 1) != 0;
    }

    public void x(boolean sitting) {
        this.setInSittingPose(sitting, true);
    }

    public void setInSittingPose(boolean sitting, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        byte b2 = this.al.a(bJ);
        if (sitting) {
            this.al.a(bJ, (byte)(b2 | 1));
        } else {
            this.al.a(bJ, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public EntityReference<EntityLiving> d() {
        return this.al.a(bK).orElse(null);
    }

    public void i(@Nullable EntityLiving owner) {
        this.al.a(bK, Optional.ofNullable(owner).map(EntityReference::new));
    }

    public void a(@Nullable EntityReference<EntityLiving> owner) {
        this.al.a(bK, Optional.ofNullable(owner));
    }

    public void a(EntityHuman player) {
        this.a(true, true);
        this.i(player);
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.y.a(serverPlayer, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return !this.j(target) && super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.T_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    @Nullable
    public ScoreboardTeam cq() {
        EntityLiving rootOwner;
        ScoreboardTeam playerTeam = super.cq();
        if (playerTeam != null) {
            return playerTeam;
        }
        if (this.m() && (rootOwner = this.U_()) != null) {
            return rootOwner.cq();
        }
        return null;
    }

    @Override
    protected boolean t(Entity entity) {
        if (this.m()) {
            EntityLiving rootOwner = this.U_();
            if (entity == rootOwner) {
                return true;
            }
            if (rootOwner != null) {
                return rootOwner.t(entity);
            }
        }
        return super.t(entity);
    }

    @Override
    public void a(DamageSource cause) {
        WorldServer serverLevel;
        Object object = this.dV();
        if (object instanceof WorldServer && (serverLevel = (WorldServer)object).O().c(GameRules.o) && (object = this.T_()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)object;
            TameableDeathMessageEvent event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eS().a()));
            if (event.callEvent()) {
                serverPlayer.a(PaperAdventure.asVanilla(event.deathMessage()));
            }
        }
        super.a(cause);
    }

    public boolean gu() {
        return this.bQ;
    }

    public void y(boolean orderedToSit) {
        this.bQ = orderedToSit;
    }

    public void gv() {
        EntityLiving owner = this.T_();
        if (owner != null) {
            this.h(owner.dv());
        }
    }

    public boolean gw() {
        EntityLiving owner = this.T_();
        return owner != null && this.g((Entity)this.T_()) >= 144.0;
    }

    private void h(BlockPosition pos) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int randomInt = this.ae.a(-3, 3);
            int randomInt1 = this.ae.a(-3, 3);
            if (Math.abs(randomInt) < 2 && Math.abs(randomInt1) < 2) continue;
            int randomInt2 = this.ae.a(-1, 1);
            if (!this.a(pos.u() + randomInt, pos.v() + randomInt2, pos.w() + randomInt1)) continue;
            return;
        }
    }

    private boolean a(int x2, int y2, int z2) {
        if (!this.i(new BlockPosition(x2, y2, z2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)x2 + 0.5, y2, (double)z2 + 0.5);
        if (event.isCancelled() || event.getTo() == null) {
            return false;
        }
        Location to = event.getTo();
        this.b(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.bE.m();
        return true;
    }

    private boolean i(BlockPosition pos) {
        PathType pathTypeStatic = PathfinderNormal.b(this, pos);
        if (pathTypeStatic != PathType.c) {
            return false;
        }
        IBlockData blockState = this.dV().a_(pos.e());
        if (!this.gy() && blockState.b() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockPos = pos.b(this.dv());
        return this.dV().a((Entity)this, this.cR().a(blockPos));
    }

    public final boolean gx() {
        return this.gu() || this.bY() || this.o() || this.T_() != null && this.T_().ak();
    }

    protected boolean gy() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double speedModifier, TagKey<DamageType> panicCausingDamageTypes) {
            super((EntityCreature)EntityTameableAnimal.this, speedModifier, panicCausingDamageTypes);
        }

        public a(double speedModifier) {
            super(EntityTameableAnimal.this, speedModifier);
        }

        @Override
        public void a() {
            if (!EntityTameableAnimal.this.gx() && EntityTameableAnimal.this.gw()) {
                EntityTameableAnimal.this.gv();
            }
            super.a();
        }
    }
}

