/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.function.Predicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public final class IEntitySelector {
    public static final Predicate<Entity> a = Entity::bJ;
    public static final Predicate<Entity> b = entity -> entity.bJ() && entity instanceof EntityLiving;
    public static final Predicate<Entity> c = entity -> entity.bJ() && !entity.bZ() && !entity.bY();
    public static final Predicate<Entity> d = entity -> entity instanceof IInventory && entity.bJ();
    public static final Predicate<Entity> e = entity -> {
        if (!(entity instanceof EntityHuman)) return true;
        EntityHuman player = (EntityHuman)entity;
        if (entity.ak()) return false;
        if (!player.gz()) return true;
        return false;
    };
    public static final Predicate<Entity> f = entity -> !entity.ak();
    public static final Predicate<Entity> g = f.and(Entity::bL);
    public static final Predicate<Entity> h = f.and(Entity::bF);
    public static Predicate<EntityHuman> IS_INSOMNIAC = player -> {
        int playerInsomniaTicks = player.dV().paperConfig().entities.behavior.playerInsomniaStartTicks;
        if (playerInsomniaTicks <= 0) {
            return false;
        }
        EntityPlayer serverPlayer = (EntityPlayer)player;
        return MathHelper.a(serverPlayer.H().a(StatisticList.i.b(StatisticList.n)), 1, Integer.MAX_VALUE) >= playerInsomniaTicks;
    };
    public static final Predicate<Entity> PLAYER_AFFECTS_SPAWNING = entity -> {
        if (entity.ak()) return false;
        if (!entity.bJ()) return false;
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (!player.affectsSpawning) return false;
        return true;
    };

    private IEntitySelector() {
    }

    public static Predicate<Entity> a(double x2, double y2, double z2, double range) {
        double d2 = range * range;
        return entity -> entity != null && entity.h(x2, y2, z2) <= d2;
    }

    public static Predicate<Entity> a(Entity entity) {
        return IEntitySelector.pushable(entity, false);
    }

    public static Predicate<Entity> pushable(Entity entity, boolean ignoreClimbing) {
        ScoreboardTeam team = entity.cq();
        ScoreboardTeamBase.EnumTeamPush collisionRule = team == null ? ScoreboardTeamBase.EnumTeamPush.a : ((ScoreboardTeamBase)team).m();
        return collisionRule == ScoreboardTeamBase.EnumTeamPush.b ? Predicates.alwaysFalse() : f.and(pushedEntity -> {
            EntityHuman player;
            if (!(pushedEntity.isCollidable(ignoreClimbing) && pushedEntity.canCollideWithBukkit(entity) && entity.canCollideWithBukkit((Entity)pushedEntity))) {
                return false;
            }
            if (!entity.dV().C || pushedEntity instanceof EntityHuman && (player = (EntityHuman)pushedEntity).gh()) {
                ScoreboardTeamBase.EnumTeamPush collisionRule1;
                ScoreboardTeam team1 = pushedEntity.cq();
                ScoreboardTeamBase.EnumTeamPush enumTeamPush = collisionRule1 = team1 == null ? ScoreboardTeamBase.EnumTeamPush.a : ((ScoreboardTeamBase)team1).m();
                if (collisionRule1 == ScoreboardTeamBase.EnumTeamPush.b || pushedEntity instanceof EntityHuman && !GlobalConfiguration.get().collisions.enablePlayerCollisions) {
                    return false;
                }
                boolean flag = team != null && team.a(team1);
                return (collisionRule != ScoreboardTeamBase.EnumTeamPush.d && collisionRule1 != ScoreboardTeamBase.EnumTeamPush.d || !flag) && (collisionRule != ScoreboardTeamBase.EnumTeamPush.c && collisionRule1 != ScoreboardTeamBase.EnumTeamPush.c || flag);
            }
            return false;
        });
    }

    public static Predicate<Entity> b(Entity entity) {
        return passenger -> {
            while (passenger.bY()) {
                if ((passenger = passenger.dk()) != entity) continue;
                return false;
            }
            return true;
        };
    }
}

