/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import org.bukkit.event.entity.EntityUnleashEvent;

public interface Leashable {
    public static final String o_ = "leash";
    public static final double h = 10.0;
    public static final double i = 6.0;

    @Nullable
    public a S_();

    public void a(@Nullable a var1);

    default public boolean Q_() {
        return this.S_() != null && this.S_().b != null;
    }

    default public boolean o() {
        return this.S_() != null;
    }

    default public boolean R_() {
        return this.w() && !this.Q_();
    }

    default public boolean w() {
        return true;
    }

    default public void e_(int delayedLeashHolderId) {
        this.a(new a(delayedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    default public void c(NBTTagCompound tag) {
        a leashData = tag.a(o_, a.a).orElse(null);
        if (this.S_() != null && leashData == null) {
            this.y();
        }
        this.a(leashData);
    }

    default public void a(NBTTagCompound tag, @Nullable a leashData) {
        if (leashData != null && leashData.b != null && leashData.b.pluginRemoved) {
            return;
        }
        tag.b(o_, a.a, leashData);
    }

    private static <E extends Entity> void a(E entity, a leashData) {
        World world;
        if (leashData.c != null && (world = entity.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<UUID> optional = leashData.c.left();
            Optional<BlockPosition> optional1 = leashData.c.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.b(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, (Entity)EntityLeash.b(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.af > 100) {
                entity.forceDrops = true;
                entity.a(serverLevel, Items.vV);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a((a)null);
            }
        }
    }

    default public void x() {
        Leashable.a((Entity)((Object)this), true, true);
    }

    default public void y() {
        Leashable.a((Entity)((Object)this), true, false);
    }

    default public void z() {
    }

    private static <E extends Entity> void a(E entity, boolean broadcastPacket, boolean dropItem) {
        a leashData = ((Leashable)((Object)entity)).S_();
        if (leashData != null && leashData.b != null) {
            ((Leashable)((Object)entity)).a((a)null);
            ((Leashable)((Object)entity)).z();
            World world = entity.dV();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.a(serverLevel, Items.vV);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.m().b(entity, new PacketPlayOutAttachEntity(entity, null));
                }
            }
        }
    }

    public static <E extends Entity> void a_(WorldServer level, E entity) {
        a leashData = ((Leashable)((Object)entity)).S_();
        if (leashData != null && leashData.c != null) {
            Leashable.a(entity, leashData);
        }
        if (leashData != null && leashData.b != null) {
            Entity leashHolder;
            if (!entity.bJ() || !leashData.b.bJ()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.bJ() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.O().c(GameRules.j) && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).x();
                } else {
                    ((Leashable)((Object)entity)).y();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).B()) != null && leashHolder.dV() == entity.dV()) {
                float f2 = entity.f(leashHolder);
                if (!((Leashable)((Object)entity)).a(leashHolder, f2)) {
                    return;
                }
                if ((double)f2 > entity.dV().paperConfig().misc.maxLeashDistance.or(10.0)) {
                    ((Leashable)((Object)entity)).A();
                } else if ((double)f2 > 6.0) {
                    ((Leashable)((Object)entity)).b(leashHolder, f2);
                    entity.cy();
                } else {
                    ((Leashable)((Object)entity)).a(leashHolder);
                }
            }
        }
    }

    default public boolean a(Entity leashHolder, float distance) {
        return true;
    }

    default public void A() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            dropLeash = event.isDropLeash();
        }
        if (dropLeash) {
            this.x();
        } else {
            this.y();
        }
    }

    default public void a(Entity entity) {
    }

    default public void b(Entity leashHolder, float distance) {
        Leashable.a((Entity)((Object)this), leashHolder, distance);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, float distance) {
        double d2 = (leashHolder.dA() - entity.dA()) / (double)distance;
        double d1 = (leashHolder.dC() - entity.dC()) / (double)distance;
        double d22 = (leashHolder.dG() - entity.dG()) / (double)distance;
        entity.i(entity.dy().b(Math.copySign(d2 * d2 * 0.4, d2), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d22 * d22 * 0.4, d22)));
    }

    default public void a_(Entity leashHolder, boolean broadcastPacket) {
        Leashable.a((Entity)((Object)this), leashHolder, broadcastPacket);
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean broadcastPacket) {
        World world;
        a leashData = ((Leashable)((Object)entity)).S_();
        if (leashData == null) {
            leashData = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashData);
        } else {
            leashData.a(leashHolder);
        }
        if (broadcastPacket && (world = entity.dV()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.m().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.bY()) {
            entity.bO();
        }
    }

    @Nullable
    default public Entity B() {
        return Leashable.b((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity b(E entity) {
        Entity var3;
        a leashData = ((Leashable)((Object)entity)).S_();
        if (leashData == null) {
            return null;
        }
        if (leashData.d != 0 && entity.dV().C && (var3 = entity.dV().a(leashData.d)) instanceof Entity) {
            leashData.a(var3);
        }
        return leashData.b;
    }

    public static final class a {
        public static final Codec<a> a = Codec.xor((Codec)UUIDUtil.a.fieldOf("UUID").codec(), BlockPosition.a).xmap(a::new, leashData -> {
            Entity patt0$temp = leashData.b;
            if (patt0$temp instanceof EntityLeash) {
                EntityLeash leashFenceKnotEntity = (EntityLeash)patt0$temp;
                return Either.right(leashFenceKnotEntity.i());
            }
            return leashData.b != null ? Either.left(leashData.b.cG()) : Objects.requireNonNull(leashData.c, "Invalid LeashData had no attachment");
        });
        int d;
        @Nullable
        public Entity b;
        @Nullable
        public Either<UUID, BlockPosition> c;

        private a(Either<UUID, BlockPosition> delayedLeashInfo) {
            this.c = delayedLeashInfo;
        }

        a(Entity leashHolder) {
            this.b = leashHolder;
        }

        a(int delayedLeashInfoId) {
            this.d = delayedLeashInfoId;
        }

        public void a(Entity leashHolder) {
            this.b = leashHolder;
            this.c = null;
            this.d = 0;
        }
    }
}

