/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeModifiable {
    private static final String c = "base";
    private static final String d = "modifiers";
    public static final String a = "id";
    public static final Codec<Holder<AttributeBase>> b = BuiltInRegistries.s.r();
    private final Holder<AttributeBase> e;
    private final Map<AttributeModifier.Operation, Map<MinecraftKey, AttributeModifier>> f = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<MinecraftKey, AttributeModifier> g = new Object2ObjectArrayMap();
    private final Map<MinecraftKey, AttributeModifier> h = new Object2ObjectArrayMap();
    private double i;
    private boolean j = true;
    private double k;
    private final Consumer<AttributeModifiable> l;

    public AttributeModifiable(Holder<AttributeBase> attribute, Consumer<AttributeModifiable> onDirty) {
        this.e = attribute;
        this.l = onDirty;
        this.i = attribute.a().a();
    }

    public Holder<AttributeBase> a() {
        return this.e;
    }

    public double b() {
        return this.i;
    }

    public void a(double baseValue) {
        if (baseValue != this.i) {
            this.i = baseValue;
            this.e();
        }
    }

    @VisibleForTesting
    Map<MinecraftKey, AttributeModifier> a(AttributeModifier.Operation operation) {
        return this.f.computeIfAbsent(operation, operation1 -> new Object2ObjectOpenHashMap());
    }

    public Set<AttributeModifier> c() {
        return ImmutableSet.copyOf(this.g.values());
    }

    public Set<AttributeModifier> d() {
        return ImmutableSet.copyOf(this.h.values());
    }

    @Nullable
    public AttributeModifier a(MinecraftKey id) {
        return this.g.get(id);
    }

    public boolean b(MinecraftKey id) {
        return this.g.get(id) != null;
    }

    private void f(AttributeModifier modifier) {
        AttributeModifier attributeModifier = this.g.putIfAbsent(modifier.a(), modifier);
        if (attributeModifier != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.a(modifier.c()).put(modifier.a(), modifier);
        this.e();
    }

    public void a(AttributeModifier modifier) {
        AttributeModifier attributeModifier = this.g.put(modifier.a(), modifier);
        if (modifier != attributeModifier) {
            this.a(modifier.c()).put(modifier.a(), modifier);
            this.e();
        }
    }

    public void b(AttributeModifier modifier) {
        this.f(modifier);
    }

    public void c(AttributeModifier modifier) {
        this.c(modifier.a());
        this.f(modifier);
        this.h.put(modifier.a(), modifier);
    }

    public void d(AttributeModifier modifier) {
        this.f(modifier);
        this.h.put(modifier.a(), modifier);
    }

    public void a(Collection<AttributeModifier> modifiers) {
        for (AttributeModifier attributeModifier : modifiers) {
            this.d(attributeModifier);
        }
    }

    protected void e() {
        this.j = true;
        this.l.accept(this);
    }

    public void e(AttributeModifier modifier) {
        this.c(modifier.a());
    }

    public boolean c(MinecraftKey id) {
        AttributeModifier attributeModifier = this.g.remove(id);
        if (attributeModifier == null) {
            return false;
        }
        this.a(attributeModifier.c()).remove(id);
        this.h.remove(id);
        this.e();
        return true;
    }

    public void f() {
        for (AttributeModifier attributeModifier : this.c()) {
            this.e(attributeModifier);
        }
    }

    public double g() {
        if (this.j) {
            this.k = this.i();
            this.j = false;
        }
        return this.k;
    }

    private double i() {
        double baseValue = this.b();
        for (AttributeModifier attributeModifier : this.b(AttributeModifier.Operation.a)) {
            baseValue += attributeModifier.b();
        }
        double d2 = baseValue;
        for (AttributeModifier attributeModifier1 : this.b(AttributeModifier.Operation.b)) {
            d2 += baseValue * attributeModifier1.b();
        }
        for (AttributeModifier attributeModifier1 : this.b(AttributeModifier.Operation.c)) {
            d2 *= 1.0 + attributeModifier1.b();
        }
        return this.e.a().a(d2);
    }

    private Collection<AttributeModifier> b(AttributeModifier.Operation operation) {
        return this.f.getOrDefault(operation, Map.of()).values();
    }

    public void a(AttributeModifiable instance) {
        this.i = instance.i;
        this.g.clear();
        this.g.putAll(instance.g);
        this.h.clear();
        this.h.putAll(instance.h);
        this.f.clear();
        instance.f.forEach((operation, map) -> this.a((AttributeModifier.Operation)operation).putAll((Map<MinecraftKey, AttributeModifier>)map));
        this.e();
    }

    public NBTTagCompound h() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(a, b, this.e);
        compoundTag.a(c, this.i);
        if (!this.h.isEmpty()) {
            compoundTag.a(d, AttributeModifier.b.listOf(), List.copyOf(this.h.values()));
        }
        return compoundTag;
    }

    public void a(NBTTagCompound nbt) {
        this.i = nbt.b(c, 0.0);
        for (AttributeModifier attributeModifier : nbt.a(d, AttributeModifier.b.listOf()).orElse(List.of())) {
            this.g.put(attributeModifier.a(), attributeModifier);
            this.a(attributeModifier.c()).put(attributeModifier.a(), attributeModifier);
            this.h.put(attributeModifier.a(), attributeModifier);
        }
        this.e();
    }
}

