/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BehaviorAttackTargetSet {
    public static <E extends EntityInsentient> BehaviorControl<E> a(b<E> targetFinder) {
        return BehaviorAttackTargetSet.a((WorldServer level, E mob) -> true, targetFinder);
    }

    public static <E extends EntityInsentient> BehaviorControl<E> a(a<E> condition, b<E> targetFinder) {
        return BehaviorBuilder.a((BehaviorBuilder.b<E> instance) -> instance.group(instance.c(MemoryModuleType.p), instance.a(MemoryModuleType.F)).apply((Applicative)instance, (memoryAccessor, memoryAccessor1) -> (level, entity, gameTime) -> {
            if (!condition.test(level, entity)) {
                return false;
            }
            Optional<EntityLiving> optional = targetFinder.get(level, entity);
            if (optional.isEmpty()) {
                return false;
            }
            EntityLiving livingEntity = optional.get();
            if (!entity.c(livingEntity)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, livingEntity, livingEntity instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryAccessor.b();
                return true;
            }
            livingEntity = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryAccessor.a(livingEntity);
            memoryAccessor1.b();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface a<E> {
        public boolean test(WorldServer var1, E var2);
    }

    @FunctionalInterface
    public static interface b<E> {
        public Optional<? extends EntityLiving> get(WorldServer var1, E var2);
    }
}

