/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.phys.Vec3D;

public class RamTarget
extends Behavior<Goat> {
    public static final int c = 200;
    public static final float d = 1.65f;
    private final Function<Goat, UniformInt> e;
    private final PathfinderTargetCondition f;
    private final float g;
    private final ToDoubleFunction<Goat> h;
    private Vec3D i;
    private final Function<Goat, SoundEffect> j;
    private final Function<Goat, SoundEffect> k;

    public RamTarget(Function<Goat, UniformInt> getTimeBetweenRams, PathfinderTargetCondition ramTargeting, float speed, ToDoubleFunction<Goat> getKnockbackForce, Function<Goat, SoundEffect> getImpactSound, Function<Goat, SoundEffect> getHornBreakSound) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.W, (Object)((Object)MemoryStatus.b), MemoryModuleType.X, (Object)((Object)MemoryStatus.a)), 200);
        this.e = getTimeBetweenRams;
        this.f = ramTargeting;
        this.g = speed;
        this.h = getKnockbackForce;
        this.j = getImpactSound;
        this.k = getHornBreakSound;
        this.i = Vec3D.c;
    }

    @Override
    protected boolean a(WorldServer level, Goat owner) {
        return owner.ec().a(MemoryModuleType.X);
    }

    @Override
    protected boolean a(WorldServer level, Goat entity, long gameTime) {
        return entity.ec().a(MemoryModuleType.X);
    }

    @Override
    protected void b(WorldServer level, Goat entity, long gameTime) {
        BlockPosition blockPos = entity.dv();
        BehaviorController<Goat> brain = entity.ec();
        Vec3D vec3 = brain.c(MemoryModuleType.X).get();
        this.i = new Vec3D((double)blockPos.u() - vec3.a(), 0.0, (double)blockPos.w() - vec3.c()).d();
        brain.a(MemoryModuleType.n, new MemoryTarget(vec3, this.g, 0));
    }

    @Override
    protected void c(WorldServer level, Goat owner, long gameTime) {
        List<EntityLiving> nearbyEntities = level.a(EntityLiving.class, this.f, owner, owner.cR());
        BehaviorController<Goat> brain = owner.ec();
        if (!nearbyEntities.isEmpty()) {
            float f2;
            DamageSource damageSource;
            EntityLiving livingEntity = nearbyEntities.get(0);
            if (livingEntity.a(level, damageSource = level.al().c(owner), f2 = (float)owner.h(GenericAttributes.c))) {
                EnchantmentManager.a(level, (Entity)livingEntity, damageSource);
            }
            int i2 = owner.b(MobEffects.a) ? owner.c(MobEffects.a).e() + 1 : 0;
            int i1 = owner.b(MobEffects.b) ? owner.c(MobEffects.b).e() + 1 : 0;
            float f1 = 0.25f * (float)(i2 - i1);
            float f22 = MathHelper.a(owner.fo() * 1.65f, 0.2f, 3.0f) + f1;
            DamageSource damageSource1 = level.al().b(owner);
            float f3 = livingEntity.b(level, damageSource1, f2);
            float f4 = f3 > 0.0f ? 0.5f : 1.0f;
            livingEntity.knockback((double)(f4 * f22) * this.h.applyAsDouble(owner), this.i.a(), this.i.c(), owner, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
            this.b(level, owner);
            level.a(null, owner, this.j.apply(owner), SoundCategory.g, 1.0f, 1.0f);
        } else if (this.c(level, owner)) {
            level.a(null, owner, this.j.apply(owner), SoundCategory.g, 1.0f, 1.0f);
            boolean flag = owner.gw();
            if (flag) {
                level.a(null, owner, this.k.apply(owner), SoundCategory.g, 1.0f, 1.0f);
            }
            this.b(level, owner);
        } else {
            boolean flag1;
            Optional<MemoryTarget> memory = brain.c(MemoryModuleType.n);
            Optional<Vec3D> memory1 = brain.c(MemoryModuleType.X);
            boolean bl = flag1 = memory.isEmpty() || memory1.isEmpty() || memory.get().a().a().a((IPosition)memory1.get(), 0.25);
            if (flag1) {
                this.b(level, owner);
            }
        }
    }

    private boolean c(WorldServer level, Goat owner) {
        Vec3D vec3 = owner.dy().d(1.0, 0.0, 1.0).d();
        BlockPosition blockPos = BlockPosition.a(owner.dt().e(vec3));
        return level.a_(blockPos).a(TagsBlock.cs) || level.a_(blockPos.d()).a(TagsBlock.cs);
    }

    protected void b(WorldServer level, Goat owner) {
        level.a((Entity)owner, (byte)59);
        owner.ec().a(MemoryModuleType.W, Integer.valueOf(this.e.apply(owner).a(level.A)));
        owner.ec().b(MemoryModuleType.X);
    }
}

