/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;

public abstract class NavigationAbstract {
    private static final int p = 20;
    private static final int q = 100;
    private static final float r = 0.25f;
    protected final EntityInsentient a;
    protected final World b;
    @Nullable
    protected PathEntity c;
    protected double d;
    protected int e;
    protected int f;
    protected Vec3D g = Vec3D.c;
    protected BaseBlockPosition h = BaseBlockPosition.i;
    protected long i;
    protected long j;
    protected double k;
    protected float l = 0.5f;
    protected boolean m;
    protected long n;
    protected PathfinderAbstract o;
    @Nullable
    private BlockPosition s;
    private int t;
    private float u = 1.0f;
    public final Pathfinder v;
    private boolean w;
    private float x = 16.0f;
    private int lastFailure = 0;
    private int pathfindFailures = 0;

    public NavigationAbstract(EntityInsentient mob, World level) {
        this.a = mob;
        this.b = level;
        this.v = this.a(MathHelper.a(mob.i(GenericAttributes.m) * 16.0));
    }

    public void e() {
        int floor = MathHelper.d(this.r() * 16.0f);
        this.v.a(floor);
    }

    public void a(float requiredPathLength) {
        this.x = requiredPathLength;
        this.e();
    }

    private float r() {
        return Math.max((float)this.a.h(GenericAttributes.m), this.x);
    }

    public void f() {
        this.u = 1.0f;
    }

    public void b(float multiplier) {
        this.u = multiplier;
    }

    @Nullable
    public BlockPosition g() {
        return this.s;
    }

    protected abstract Pathfinder a(int var1);

    public void a(double speed) {
        this.d = speed;
    }

    public void h() {
        if (this.b.ae() - this.n > 20L) {
            if (this.s != null) {
                this.c = null;
                this.c = this.a(this.s, this.t);
                this.n = this.b.ae();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    @Nullable
    public final PathEntity a(double x2, double y2, double z2, int accuracy) {
        return this.a(BlockPosition.a(x2, y2, z2), accuracy);
    }

    @Nullable
    public PathEntity a(Stream<BlockPosition> targets, int accuracy) {
        return this.a(targets.collect(Collectors.toSet()), 8, false, accuracy);
    }

    @Nullable
    public PathEntity a(Set<BlockPosition> positions, int distance) {
        return this.a(positions, 8, false, distance);
    }

    @Nullable
    public PathEntity a(BlockPosition pos, int accuracy) {
        return this.createPath(pos, null, accuracy);
    }

    @Nullable
    public PathEntity createPath(BlockPosition target, @Nullable Entity entity, int accuracy) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)target), entity, 8, false, accuracy);
    }

    @Nullable
    public PathEntity a(BlockPosition pos, int regionOffset, int accuracy) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)pos), 8, false, regionOffset, accuracy);
    }

    @Nullable
    public PathEntity a(Entity entity, int accuracy) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)entity.dv()), entity, 16, true, accuracy);
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> targets, int regionOffset, boolean offsetUpward, int accuracy) {
        return this.a(targets, regionOffset, offsetUpward, accuracy, this.r());
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        return this.createPath(targets, null, regionOffset, offsetUpward, accuracy, followRange);
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> targets, @Nullable Entity target, int regionOffset, boolean offsetUpward, int accuracy) {
        return this.createPath(targets, target, regionOffset, offsetUpward, accuracy, (float)this.a.h(GenericAttributes.m));
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> targets, @Nullable Entity target, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        if (targets.isEmpty()) {
            return null;
        }
        if (this.a.dC() < (double)this.b.K_()) {
            return null;
        }
        if (!this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && targets.contains(this.s)) {
            return this.c;
        }
        boolean copiedSet = false;
        for (BlockPosition possibleTarget : targets) {
            if (this.a.dV().E_().a(possibleTarget) && new EntityPathfindEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), CraftLocation.toBukkit(possibleTarget, this.a.dV()), (org.bukkit.entity.Entity)(target == null ? null : target.getBukkitEntity())).callEvent()) continue;
            if (!copiedSet) {
                copiedSet = true;
                targets = new HashSet<BlockPosition>(targets);
            }
            targets.remove(possibleTarget);
            if (!targets.isEmpty()) continue;
            return null;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("pathfind");
        BlockPosition blockPos = offsetUpward ? this.a.dv().d() : this.a.dv();
        int i2 = (int)(followRange + (float)regionOffset);
        ChunkCache pathNavigationRegion = new ChunkCache(this.b, blockPos.b(-i2, -i2, -i2), blockPos.b(i2, i2, i2));
        PathEntity path = this.v.a(pathNavigationRegion, this.a, targets, followRange, accuracy, this.u);
        profilerFiller.c();
        if (path != null && path.l() != null) {
            this.s = path.l();
            this.t = accuracy;
            this.t();
        }
        return path;
    }

    public boolean a(double x2, double y2, double z2, double speed) {
        return this.a(this.a(x2, y2, z2, 1), speed);
    }

    public boolean a(double x2, double y2, double z2, int accuracy, double speed) {
        return this.a(this.a(x2, y2, z2, accuracy), speed);
    }

    public boolean a(Entity entity, double speed) {
        if (this.pathfindFailures > 10 && this.c == null && MinecraftServer.currentTick < this.lastFailure + 40) {
            return false;
        }
        PathEntity path = this.a(entity, 1);
        if (path != null && this.a(path, speed)) {
            this.lastFailure = 0;
            this.pathfindFailures = 0;
            return true;
        }
        ++this.pathfindFailures;
        this.lastFailure = MinecraftServer.currentTick;
        return false;
    }

    public boolean a(@Nullable PathEntity pathentity, double speed) {
        if (pathentity == null) {
            this.c = null;
            return false;
        }
        if (!pathentity.a(this.c)) {
            this.c = pathentity;
        }
        if (this.k()) {
            return false;
        }
        this.d();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = speed;
        Vec3D tempMobPos = this.b();
        this.f = this.e;
        this.g = tempMobPos;
        return true;
    }

    @Nullable
    public PathEntity i() {
        return this.c;
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.h();
        }
        if (!this.k()) {
            Vec3D tempMobPos;
            if (this.a()) {
                this.j();
            } else if (this.c != null && !this.c.c()) {
                tempMobPos = this.b();
                Vec3D nextEntityPos = this.c.a(this.a);
                if (tempMobPos.e > nextEntityPos.e && !this.a.aH() && MathHelper.a(tempMobPos.d) == MathHelper.a(nextEntityPos.d) && MathHelper.a(tempMobPos.f) == MathHelper.a(nextEntityPos.f)) {
                    this.c.a();
                }
            }
            PacketDebug.a(this.b, this.a, this.c, this.l);
            if (!this.k()) {
                tempMobPos = this.c.a(this.a);
                this.a.K().a(tempMobPos.d, this.a(tempMobPos), tempMobPos.f, this.d);
            }
        }
    }

    protected double a(Vec3D vec) {
        BlockPosition blockPos = BlockPosition.a(vec);
        return this.b.a_(blockPos.e()).l() ? vec.e : PathfinderNormal.a(this.b, blockPos);
    }

    protected void j() {
        boolean flag;
        Vec3D tempMobPos = this.b();
        this.l = this.a.dq() > 0.75f ? this.a.dq() / 2.0f : 0.75f - this.a.dq() / 2.0f;
        BlockPosition nextNodePos = this.c.g();
        double abs = Math.abs(this.a.dA() - ((double)nextNodePos.u() + 0.5));
        double abs1 = Math.abs(this.a.dC() - (double)nextNodePos.v());
        double abs2 = Math.abs(this.a.dG() - ((double)nextNodePos.w() + 0.5));
        boolean bl = flag = abs < (double)this.l && abs2 < (double)this.l && abs1 < 1.0;
        if (flag || this.b(this.c.h().l) && this.c(tempMobPos)) {
            this.c.a();
        }
        this.b(tempMobPos);
    }

    private boolean c(Vec3D vec) {
        boolean flag1;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D vec3 = Vec3D.c(this.c.g());
        if (!vec.a((IPosition)vec3, 2.0)) {
            return false;
        }
        if (this.a(vec, this.c.a(this.a))) {
            return true;
        }
        Vec3D vec31 = Vec3D.c(this.c.d(this.c.f() + 1));
        Vec3D vec32 = vec3.d(vec);
        Vec3D vec33 = vec31.d(vec);
        double d2 = vec32.h();
        double d1 = vec33.h();
        boolean flag = d1 < d2;
        boolean bl = flag1 = d2 < 0.5;
        if (!flag && !flag1) {
            return false;
        }
        Vec3D vec34 = vec32.d();
        Vec3D vec35 = vec33.d();
        return vec35.b(vec34) < 0.0;
    }

    protected void b(Vec3D positionVec3) {
        if (this.e - this.f > 100) {
            float f2 = this.a.fo() >= 1.0f ? this.a.fo() : this.a.fo() * this.a.fo();
            float f1 = f2 * 100.0f * 0.25f;
            if (positionVec3.g(this.g) < (double)(f1 * f1)) {
                this.w = true;
                this.m();
            } else {
                this.w = false;
            }
            this.f = this.e;
            this.g = positionVec3;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition nextNodePos = this.c.g();
            long gameTime = this.b.ae();
            if (nextNodePos.equals(this.h)) {
                this.i += gameTime - this.j;
            } else {
                this.h = nextNodePos;
                double d2 = positionVec3.f(Vec3D.c(this.h));
                double d3 = this.k = this.a.fo() > 0.0f ? d2 / (double)this.a.fo() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.s();
            }
            this.j = gameTime;
        }
    }

    private void s() {
        this.t();
        this.m();
    }

    private void t() {
        this.h = BaseBlockPosition.i;
        this.i = 0L;
        this.k = 0.0;
        this.w = false;
    }

    public boolean k() {
        return this.c == null || this.c.c();
    }

    public boolean l() {
        return !this.k();
    }

    public void m() {
        this.c = null;
    }

    protected abstract Vec3D b();

    protected abstract boolean a();

    protected void d() {
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.e(); ++i2) {
                PathPoint node = this.c.a(i2);
                PathPoint node1 = i2 + 1 < this.c.e() ? this.c.a(i2 + 1) : null;
                IBlockData blockState = this.b.a_(new BlockPosition(node.a, node.b, node.c));
                if (!blockState.a(TagsBlock.bo)) continue;
                this.c.a(i2, node.a(node.a, node.b + 1, node.c));
                if (node1 == null || node.b < node1.b) continue;
                this.c.a(i2 + 1, node.a(node1.a, node.b + 1, node1.c));
            }
        }
    }

    protected boolean a(Vec3D posVec31, Vec3D posVec32) {
        return false;
    }

    public boolean b(PathType pathType) {
        return pathType != PathType.n && pathType != PathType.p && pathType != PathType.d;
    }

    protected static boolean a(EntityInsentient mob, Vec3D pos1, Vec3D pos2, boolean allowSwimming) {
        Vec3D vec3 = new Vec3D(pos2.d, pos2.e + (double)mob.dr() * 0.5, pos2.f);
        return mob.dV().a(new RayTrace(pos1, vec3, RayTrace.BlockCollisionOption.a, allowSwimming ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, mob)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean a(BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return this.b.a_(blockPos).s();
    }

    public PathfinderAbstract n() {
        return this.o;
    }

    public void a(boolean canSwim) {
        this.o.c(canSwim);
    }

    public boolean o() {
        return this.o.f();
    }

    public boolean b(BlockPosition pos) {
        if (this.m) {
            return false;
        }
        if (this.c != null && !this.c.c() && this.c.e() != 0) {
            PathPoint endNode = this.c.d();
            Vec3D vec3 = new Vec3D(((double)endNode.a + this.a.dA()) / 2.0, ((double)endNode.b + this.a.dC()) / 2.0, ((double)endNode.c + this.a.dG()) / 2.0);
            return pos.a(vec3, (double)(this.c.e() - this.c.f()));
        }
        return false;
    }

    public float p() {
        return this.l;
    }

    public boolean q() {
        return this.w;
    }
}

