/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.PoiAccess;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileSection;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class VillagePlace
extends RegionFileSection<VillagePlaceSection, VillagePlaceSection.a>
implements ChunkSystemPoiManager {
    public static final int a = 6;
    public static final int b = 1;
    private final a d;
    private final LongSet e = new LongOpenHashSet();
    private final WorldServer world;
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    private static final int POI_DATA_SOURCE = 7;

    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    private void updateDistanceTracking(long section) {
        if (this.g(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Override
    public Optional<VillagePlaceSection> c(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        PoiChunk ret = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    @Override
    public Optional<VillagePlaceSection> d(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection(this.world) && chunkY <= WorldUtil.getMaxSection(this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    protected VillagePlaceSection getOrCreate(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final WorldServer moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            long sectionPos = SectionPosition.b(chunkX, sectionY, chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((World)this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            VillagePlaceSection section = poiChunk.getSection(sectionY);
            if (section == null || section.moonrise$isEmpty()) continue;
            this.b(SectionPosition.b(chunkX, sectionY, chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(IChunkAccess chunk) {
        int chunkX = chunk.f().h;
        int chunkZ = chunk.f().i;
        int minY = WorldUtil.getMinSection(chunk);
        int maxY = WorldUtil.getMaxSection(chunk);
        ChunkSection[] sections = chunk.d();
        for (int section = minY; section <= maxY; ++section) {
            this.a(SectionPosition.a(chunkX, section, chunkZ), sections[section - minY]);
        }
    }

    public VillagePlace(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, IRegistryCustom registryAccess, ChunkIOErrorReporter errorReporter, LevelHeightAccessor levelHeightAccessor) {
        super(new SimpleRegionStorage(info, folder, fixerUpper, sync, DataFixTypes.q), VillagePlaceSection.a.a, VillagePlaceSection::a, VillagePlaceSection.a::a, VillagePlaceSection::new, registryAccess, errorReporter, levelHeightAccessor);
        this.d = new a();
        this.world = (WorldServer)levelHeightAccessor;
    }

    public void a(BlockPosition pos, Holder<VillagePlaceType> type) {
        this.getOrCreate(SectionPosition.c(pos)).a(pos, type);
    }

    public void a(BlockPosition pos) {
        this.d(SectionPosition.c(pos)).ifPresent(section -> section.a(pos));
    }

    public long a(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int distance, Occupancy status) {
        return this.c(typePredicate, pos, distance, status).count();
    }

    public boolean a(ResourceKey<VillagePlaceType> type, BlockPosition pos) {
        return this.a(pos, (Holder<VillagePlaceType> holder) -> holder.a(type));
    }

    public Stream<VillagePlaceRecord> b(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int distance, Occupancy status) {
        int i2 = Math.floorDiv(distance, 16) + 1;
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(pos), i2).flatMap(chunkPos -> this.a(typePredicate, (ChunkCoordIntPair)chunkPos, status)).filter(poiRecord -> {
            BlockPosition pos1 = poiRecord.g();
            return Math.abs(pos1.u() - pos.u()) <= distance && Math.abs(pos1.w() - pos.w()) <= distance;
        });
    }

    public Stream<VillagePlaceRecord> c(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int distance, Occupancy status) {
        int i2 = distance * distance;
        return this.b(typePredicate, pos, distance, status).filter(poiRecord -> poiRecord.g().j(pos) <= (double)i2);
    }

    @VisibleForDebug
    public Stream<VillagePlaceRecord> a(Predicate<Holder<VillagePlaceType>> typePredicate, ChunkCoordIntPair posChunk, Occupancy status) {
        return IntStream.rangeClosed(this.c.aq(), this.c.ar()).boxed().map(integer -> this.d(SectionPosition.a(posChunk, (int)integer).s())).filter(Optional::isPresent).flatMap(optional -> ((VillagePlaceSection)optional.get()).a(typePredicate, status));
    }

    public Stream<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int distance, Occupancy status) {
        return this.c(typePredicate, pos, distance, status).map(VillagePlaceRecord::g).filter(posPredicate);
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> b(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int distance, Occupancy status) {
        return this.c(typePredicate, pos, distance, status).filter(poiRecord -> posPredicate.test(poiRecord.g())).map(poiRecord -> Pair.of(poiRecord.h(), (Object)poiRecord.g()));
    }

    public Stream<Pair<Holder<VillagePlaceType>, BlockPosition>> c(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int distance, Occupancy status) {
        return this.b(typePredicate, posPredicate, pos, distance, status).sorted(Comparator.comparingDouble(pair -> ((BlockPosition)pair.getSecond()).j(pos)));
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int distance, Occupancy status) {
        BlockPosition ret = PoiAccess.findAnyPoiPosition(this, typePredicate, posPredicate, pos, distance, status, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPosition> d(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int distance, Occupancy status) {
        BlockPosition closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, null, pos, distance, distance * distance, status, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> e(Predicate<Holder<VillagePlaceType>> typePredicate, BlockPosition pos, int distance, Occupancy status) {
        return Optional.ofNullable(PoiAccess.findClosestPoiDataTypeAndPosition(this, typePredicate, null, pos, distance, distance * distance, status, false));
    }

    public Optional<BlockPosition> e(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int distance, Occupancy status) {
        BlockPosition closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, posPredicate, pos, distance, distance * distance, status, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, BiPredicate<Holder<VillagePlaceType>, BlockPosition> combinedTypePosPredicate, BlockPosition pos, int distance) {
        VillagePlaceRecord closest = PoiAccess.findClosestPoiDataRecord(this, typePredicate, combinedTypePosPredicate, pos, distance, (double)(distance * distance), Occupancy.a, false);
        return Optional.ofNullable(closest).map(poiRecord -> {
            poiRecord.c();
            return poiRecord.g();
        });
    }

    public Optional<BlockPosition> a(Predicate<Holder<VillagePlaceType>> typePredicate, Predicate<BlockPosition> posPredicate, Occupancy status, BlockPosition pos, int distance, RandomSource random) {
        ArrayList<VillagePlaceRecord> list = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findAnyPoiRecords(this, typePredicate, posPredicate, pos, distance, status, false, Integer.MAX_VALUE, list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((VillagePlaceRecord)list.get(random.a(list.size()))).g());
    }

    public boolean b(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSection -> poiSection.c(pos)).orElseThrow(() -> SystemUtils.b(new IllegalStateException("POI never registered at " + String.valueOf(pos))));
    }

    public boolean a(BlockPosition pos, Predicate<Holder<VillagePlaceType>> typePredicate) {
        return this.d(SectionPosition.c(pos)).map(poiSection -> poiSection.a(pos, typePredicate)).orElse(false);
    }

    public Optional<Holder<VillagePlaceType>> c(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).flatMap(poiSection -> poiSection.d(pos));
    }

    @Deprecated
    @VisibleForDebug
    public int d(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSection -> poiSection.b(pos)).orElse(0);
    }

    public int a(SectionPosition sectionPos) {
        this.villageDistanceTracker.propagateUpdates();
        return VillagePlace.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(sectionPos)));
    }

    boolean g(long chunkPos) {
        Optional<VillagePlaceSection> optional = this.c(chunkPos);
        return optional != null && optional.map(poiSection -> poiSection.a((Holder<VillagePlaceType> holder) -> holder.a(PoiTypeTags.b), Occupancy.b).findAny().isPresent()).orElse(false) != false;
    }

    @Override
    public void a(BooleanSupplier aheadOfTime) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Override
    public void a(long sectionPos) {
        int chunkZ;
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(sectionPos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(sectionPos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(sectionPos);
    }

    @Override
    protected void b(long sectionKey) {
        this.updateDistanceTracking(sectionKey);
    }

    public void a(SectionPosition sectionPos, ChunkSection levelChunkSection) {
        SystemUtils.a(this.d(sectionPos.s()), (T poiSection) -> poiSection.a((BiConsumer<BlockPosition, Holder<VillagePlaceType>> biConsumer) -> {
            if (VillagePlace.a(levelChunkSection)) {
                this.a(levelChunkSection, sectionPos, (BiConsumer<BlockPosition, Holder<VillagePlaceType>>)biConsumer);
            }
        }), () -> {
            if (VillagePlace.a(levelChunkSection)) {
                VillagePlaceSection poiSection = this.getOrCreate(sectionPos.s());
                this.a(levelChunkSection, sectionPos, poiSection::a);
            }
        });
    }

    private static boolean a(ChunkSection section) {
        return section.a(PoiTypes::b);
    }

    private void a(ChunkSection section, SectionPosition sectionPos, BiConsumer<BlockPosition, Holder<VillagePlaceType>> posToTypeConsumer) {
        sectionPos.t().forEach(blockPos -> {
            IBlockData blockState = section.a(SectionPosition.b(blockPos.u()), SectionPosition.b(blockPos.v()), SectionPosition.b(blockPos.w()));
            PoiTypes.a(blockState).ifPresent(holder -> posToTypeConsumer.accept((BlockPosition)blockPos, (Holder<VillagePlaceType>)holder));
        });
    }

    public void a(IWorldReader levelReader, BlockPosition pos, int coordinateOffset) {
        SectionPosition.a(new ChunkCoordIntPair(pos), Math.floorDiv(coordinateOffset, 16), this.c.aq(), this.c.ar()).map(sectionPos -> Pair.of((Object)sectionPos, this.d(sectionPos.s()))).filter(pair -> ((Optional)pair.getSecond()).map(VillagePlaceSection::b).orElse(false) == false).map(pair -> ((SectionPosition)pair.getFirst()).r()).forEach(chunkPos -> levelReader.a(chunkPos.h, chunkPos.i, ChunkStatus.c));
    }

    final class a
    extends LightEngineGraphSection {
        private final Long2ByteMap b;

        protected a() {
            super(7, 16, 256);
            this.b = new Long2ByteOpenHashMap();
            this.b.defaultReturnValue((byte)7);
        }

        @Override
        protected int b(long pos) {
            return VillagePlace.this.g(pos) ? 0 : 7;
        }

        @Override
        protected int c(long sectionPos) {
            return this.b.get(sectionPos);
        }

        @Override
        protected void a(long sectionPos, int level) {
            if (level > 6) {
                this.b.remove(sectionPos);
            } else {
                this.b.put(sectionPos, (byte)level);
            }
        }

        public void a() {
            super.b(Integer.MAX_VALUE);
        }
    }

    public static final class Occupancy
    extends Enum<Occupancy> {
        public static final /* enum */ Occupancy a = new Occupancy(VillagePlaceRecord::e);
        public static final /* enum */ Occupancy b = new Occupancy(VillagePlaceRecord::f);
        public static final /* enum */ Occupancy c = new Occupancy(test -> true);
        private final Predicate<? super VillagePlaceRecord> d;
        private static final /* synthetic */ Occupancy[] e;

        public static Occupancy[] values() {
            return (Occupancy[])e.clone();
        }

        public static Occupancy valueOf(String name) {
            return Enum.valueOf(Occupancy.class, name);
        }

        private Occupancy(Predicate<? super VillagePlaceRecord> test) {
            this.d = test;
        }

        public Predicate<? super VillagePlaceRecord> a() {
            return this.d;
        }

        private static /* synthetic */ Occupancy[] b() {
            return new Occupancy[]{a, b, c};
        }

        static {
            e = Occupancy.b();
        }
    }
}

