/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public abstract class AbstractCow
extends EntityAnimal {
    private static final EntitySize bI = EntityTypes.D.n().a(0.5f).b(0.665f);

    public AbstractCow(EntityTypes<? extends AbstractCow> entityType, World level) {
        super((EntityTypes<? extends EntityAnimal>)entityType, level);
    }

    @Override
    protected void C() {
        this.bF.a(0, new PathfinderGoalFloat(this));
        this.bF.a(1, new PathfinderGoalPanic(this, 2.0));
        this.bF.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bF.a(3, new PathfinderGoalTempt(this, 1.25, itemStack -> itemStack.a(TagsItem.af), false));
        this.bF.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bF.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bF.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bF.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.af);
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gz().a(GenericAttributes.s, 10.0).a(GenericAttributes.v, 0.2f);
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.gf;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.gh;
    }

    @Override
    public SoundEffect j_() {
        return SoundEffects.gg;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gj, 0.15f, 1.0f);
    }

    @Override
    public float fe() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.ro) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.dV(), player, this.dv(), this.dv(), null, itemInHand, Items.ru, hand);
            if (event.isCancelled()) {
                player.bR.b();
                return EnumInteractionResult.e;
            }
            player.a(SoundEffects.gi, 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.e_() ? bI : super.e(pose);
    }
}

